DROP VIEW IF EXISTS daftar_kontak;
DROP VIEW IF EXISTS daftar_grup;
DROP VIEW IF EXISTS daftar_anggota_grup;
DROP VIEW IF EXISTS dokumen_hidup;
DROP VIEW IF EXISTS keluarga_aktif;
DROP VIEW IF EXISTS penduduk_hidup;
DROP TABLE IF EXISTS kelompok_anggota;
DROP TABLE IF EXISTS covid19_pantau;
DROP TABLE IF EXISTS covid19_pemudik;
DROP TABLE IF EXISTS syarat_surat;
DROP TABLE IF EXISTS agenda;
DROP TABLE IF EXISTS log_penduduk;
DROP TABLE IF EXISTS setting_aplikasi_options;
DROP TABLE IF EXISTS data_persil;
DROP TABLE IF EXISTS tweb_penduduk_mandiri;
DROP TABLE IF EXISTS disposisi_surat_masuk;
DROP TABLE IF EXISTS mutasi_inventaris_tanah;
DROP TABLE IF EXISTS mutasi_inventaris_peralatan;
DROP TABLE IF EXISTS mutasi_inventaris_jalan;
DROP TABLE IF EXISTS mutasi_inventaris_gedung;
DROP TABLE IF EXISTS mutasi_inventaris_asset;
DROP TABLE IF EXISTS anggota_grup_kontak;
DROP TABLE IF EXISTS kontak;
DROP TABLE IF EXISTS suplemen_terdata;
#
# TABLE STRUCTURE FOR: analisis_indikator
#

DROP TABLE IF EXISTS `analisis_indikator`;

CREATE TABLE `analisis_indikator` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_master` int(11) NOT NULL,
  `nomor` int(3) NOT NULL,
  `pertanyaan` varchar(400) NOT NULL,
  `id_tipe` tinyint(4) NOT NULL DEFAULT '1',
  `bobot` tinyint(4) NOT NULL DEFAULT '0',
  `act_analisis` tinyint(1) NOT NULL DEFAULT '2',
  `id_kategori` int(4) NOT NULL,
  `is_publik` tinyint(1) NOT NULL DEFAULT '0',
  `is_teks` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_master` (`id_master`,`id_tipe`),
  KEY `id_tipe` (`id_tipe`),
  KEY `id_kategori` (`id_kategori`)
) ENGINE=InnoDB AUTO_INCREMENT=111 DEFAULT CHARSET=latin1;

INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (1, 2, 1, 'kepemilikan rumah', 1, 1, 1, 1, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (2, 2, 2, 'penghasilan perbulan', 1, 4, 1, 2, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (3, 3, 1, 'Jumlah Penghasilan Perbulan', 3, 0, 0, 3, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (4, 3, 2, 'Jumlah Pengeluaran Perbulan', 3, 0, 0, 3, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (5, 3, 3, 'Status Kepemilikan Rumah?*', 1, 0, 0, 3, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (6, 3, 4, 'Kategori KK', 1, 0, 0, 3, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (7, 3, 5, 'Penerima Raskin', 1, 0, 0, 3, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (8, 3, 6, 'Penerima BLT/BLSM', 1, 0, 0, 3, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (9, 3, 7, 'Peserta BPJS/Jamkesmas/Jamkesda', 1, 0, 0, 3, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (10, 3, 8, 'Sumber Air Minum?*', 1, 0, 0, 4, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (11, 3, 9, 'Keterangan', 2, 0, 0, 4, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (12, 3, 10, 'Jenis Lahan', 1, 0, 0, 5, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (13, 3, 11, 'Luas Lahan', 1, 0, 0, 5, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (14, 3, 12, 'Jenis Komoditas', 1, 0, 0, 6, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (15, 3, 13, 'Produksi', 3, 0, 0, 6, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (16, 3, 14, 'Satuan', 1, 0, 0, 6, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (17, 3, 15, 'Nilai (Rp)', 3, 0, 0, 6, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (18, 3, 16, 'Pemasaran Hasil', 1, 0, 0, 6, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (19, 3, 17, 'Jenis Komoditas', 1, 0, 0, 7, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (20, 3, 18, 'Jumlah Pohon', 3, 0, 0, 7, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (21, 3, 19, 'Produksi', 3, 0, 0, 7, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (22, 3, 20, 'Satuan', 1, 0, 0, 7, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (23, 3, 21, 'Nilai (Rp)', 3, 0, 0, 7, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (24, 3, 22, 'Pemasaran Hasil', 1, 0, 0, 7, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (25, 3, 23, 'Jenis Komoditas', 1, 0, 0, 8, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (26, 3, 24, 'Produksi', 3, 0, 0, 8, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (27, 3, 25, 'Satuan', 1, 0, 0, 8, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (28, 3, 26, 'Nilai (Rp)', 3, 0, 0, 8, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (29, 3, 27, 'Pemasaran Hasil', 1, 0, 0, 8, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (30, 3, 28, 'Jenis Komoditas', 1, 0, 0, 9, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (31, 3, 29, 'Produksi', 3, 0, 0, 9, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (32, 3, 30, 'Satuan', 1, 0, 0, 9, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (33, 3, 31, 'Nilai (Rp)', 3, 0, 0, 9, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (34, 3, 32, 'Pemasaran Hasil', 1, 0, 0, 9, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (35, 3, 33, 'Jenis Komoditas', 1, 0, 0, 10, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (36, 3, 34, 'Produksi', 3, 0, 0, 10, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (37, 3, 35, 'Satuan', 1, 0, 0, 10, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (38, 3, 36, 'Nilai (Rp)', 3, 0, 0, 10, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (39, 3, 37, 'Pemasaran Hasil', 1, 0, 0, 10, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (40, 3, 38, 'Jenis Komoditas', 1, 0, 0, 11, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (41, 3, 39, 'Produksi', 3, 0, 0, 11, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (42, 3, 40, 'Satuan', 1, 0, 0, 11, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (43, 3, 41, 'Nilai (Rp)', 3, 0, 0, 11, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (44, 3, 42, 'Pemasaran Hasil', 1, 0, 0, 11, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (45, 3, 43, 'Jenis Komoditas', 1, 0, 0, 12, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (46, 3, 44, 'Produksi', 3, 0, 0, 12, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (47, 3, 45, 'Satuan', 1, 0, 0, 12, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (48, 3, 46, 'Nilai (Rp)', 3, 0, 0, 12, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (49, 3, 47, 'Pemasaran Hasil', 1, 0, 0, 12, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (50, 3, 48, 'Jenis Bahan Galian', 1, 0, 0, 13, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (51, 3, 49, 'Milik Perorangan (Ha)', 3, 0, 0, 13, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (52, 3, 50, 'Milik Adat (Ha)', 3, 0, 0, 13, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (53, 3, 51, 'Satuan', 1, 0, 0, 13, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (54, 3, 52, 'Pemasaran', 1, 0, 0, 13, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (55, 3, 53, 'Jenis Komoditas', 1, 0, 0, 14, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (56, 3, 54, 'Produksi', 3, 0, 0, 14, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (57, 3, 55, 'Satuan', 1, 0, 0, 14, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (58, 3, 56, 'Nilai (Rp)', 3, 0, 0, 14, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (59, 3, 57, 'Pemasaran Hasil', 1, 0, 0, 14, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (60, 3, 58, 'Nama Alat', 1, 0, 0, 15, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (61, 3, 59, 'Jumlah', 3, 0, 0, 15, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (62, 3, 60, 'Pemanfaatan Sungai/Waduk DLL', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (63, 3, 61, 'Lembaga Pendidikan', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (64, 3, 62, 'Penguasaan Aset Tanah', 1, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (65, 3, 63, 'Aset Sarana Transportasi Umum', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (66, 3, 64, 'Aset Sarana Produksi', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (67, 3, 65, 'Aset Rumah (Dinding)', 1, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (68, 3, 66, 'Aset Rumah (Lantai)', 1, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (69, 3, 67, 'Aset Rumah (Atap)', 1, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (70, 3, 68, 'Aset Lainnya', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (71, 3, 69, 'Kualitas Ibu Hamil', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (72, 3, 70, 'Kualitas Bayi', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (73, 3, 71, 'Tempat Persalinan', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (74, 3, 72, 'Pertolongan Persalinan', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (75, 3, 73, 'Cakupan Imunisasi', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (76, 3, 74, 'Penderita Sakit Kelainan', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (77, 3, 75, 'Perilaku Hidup Bersih', 1, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (78, 3, 76, 'Pola Makan', 1, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (79, 3, 77, 'Kebiasaan Berobat', 1, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (80, 3, 78, 'Status Gizi Balita', 1, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (81, 3, 79, 'Jenis Penyakit', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (82, 3, 80, 'Kerukunan', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (83, 3, 81, 'Perkelahian', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (84, 3, 82, 'Pencurian', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (85, 3, 83, 'Penjarahan', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (86, 3, 84, 'Perjudian', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (87, 3, 85, 'Pemakaian Miras dan Narkoba', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (88, 3, 86, 'Pembunuhan', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (89, 3, 87, 'Penculikan', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (90, 3, 88, 'Kejahatan Seksual', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (91, 3, 89, 'Kekerasan Dalam Rumah Tangga', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (92, 3, 90, 'Masalah Kesejahteraan Keluarga', 2, 0, 0, 16, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (93, 4, 1, 'Nomor Akte Kelahiran', 4, 0, 0, 17, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (94, 4, 2, 'Hubungan dengan Kepala Keluarga', 1, 0, 0, 17, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (95, 4, 3, 'Status Perkawinan', 1, 0, 0, 17, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (96, 4, 4, 'Agama dan Aliran Kepercayaan', 1, 0, 0, 17, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (97, 4, 5, 'Golongan Darah', 1, 0, 0, 17, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (98, 4, 6, 'Kewarganegaraan', 1, 0, 0, 17, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (99, 4, 7, 'Etnis/Suku', 4, 0, 0, 17, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (100, 4, 8, 'Pendidikan Umum Terakhir', 1, 0, 0, 17, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (101, 4, 9, 'Mata Pencaharian Pokok/Pekerjaan', 1, 0, 0, 17, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (102, 4, 10, 'Nama Bapak Kandung', 4, 0, 0, 17, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (103, 4, 11, 'Nama Ibu Kandung', 4, 0, 0, 17, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (104, 4, 12, 'Akseptor KB', 1, 0, 0, 17, 0, 0);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (105, 4, 13, 'Cacat Fisik', 2, 0, 0, 17, 0, 1);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (106, 4, 14, 'Cacat Mental', 2, 0, 0, 17, 0, 1);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (107, 4, 15, 'Kedudukan Anggota Keluarga sebagai Wajib Pajak dan Retribusi', 2, 0, 0, 17, 0, 1);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (108, 4, 16, 'Lembaga Pemerintahan Yang Diikuti Anggota Keluarga', 2, 0, 0, 17, 0, 1);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (109, 4, 17, 'Lembaga Kemasyarakatan Yang Diikuti Anggota Keluarga', 2, 0, 0, 17, 0, 1);
INSERT INTO `analisis_indikator` (`id`, `id_master`, `nomor`, `pertanyaan`, `id_tipe`, `bobot`, `act_analisis`, `id_kategori`, `is_publik`, `is_teks`) VALUES (110, 4, 18, 'Lembaga Ekonomi Yang Dimiliki Anggota Keluarga', 2, 0, 0, 17, 0, 1);


#
# TABLE STRUCTURE FOR: analisis_kategori_indikator
#

DROP TABLE IF EXISTS `analisis_kategori_indikator`;

CREATE TABLE `analisis_kategori_indikator` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_master` tinyint(4) NOT NULL,
  `kategori` varchar(50) NOT NULL,
  `kategori_kode` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_master` (`id_master`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1;

INSERT INTO `analisis_kategori_indikator` (`id`, `id_master`, `kategori`, `kategori_kode`) VALUES (1, 2, 'Aset', '');
INSERT INTO `analisis_kategori_indikator` (`id`, `id_master`, `kategori`, `kategori_kode`) VALUES (2, 2, 'Penghasilan', '');
INSERT INTO `analisis_kategori_indikator` (`id`, `id_master`, `kategori`, `kategori_kode`) VALUES (3, 3, 'PENGHASILAN DAN PENGELUARAN KELUARGA', '');
INSERT INTO `analisis_kategori_indikator` (`id`, `id_master`, `kategori`, `kategori_kode`) VALUES (4, 3, 'SUMBER AIR MINUM KELUARGA', '');
INSERT INTO `analisis_kategori_indikator` (`id`, `id_master`, `kategori`, `kategori_kode`) VALUES (5, 3, 'KEPEMILIKAN LAHAN KELUARGA', '');
INSERT INTO `analisis_kategori_indikator` (`id`, `id_master`, `kategori`, `kategori_kode`) VALUES (6, 3, 'PRODUKSI TANAMAN PANGAN', '');
INSERT INTO `analisis_kategori_indikator` (`id`, `id_master`, `kategori`, `kategori_kode`) VALUES (7, 3, 'PRODUKSI BUAH-BUAHAN', '');
INSERT INTO `analisis_kategori_indikator` (`id`, `id_master`, `kategori`, `kategori_kode`) VALUES (8, 3, 'PRODUKSI TANAMAN OBAT', '');
INSERT INTO `analisis_kategori_indikator` (`id`, `id_master`, `kategori`, `kategori_kode`) VALUES (9, 3, 'PRODUKSI PERKEBUNAN', '');
INSERT INTO `analisis_kategori_indikator` (`id`, `id_master`, `kategori`, `kategori_kode`) VALUES (10, 3, 'PRODUKSI HASIL HUTAN', '');
INSERT INTO `analisis_kategori_indikator` (`id`, `id_master`, `kategori`, `kategori_kode`) VALUES (11, 3, 'JENIS TERNAK', '');
INSERT INTO `analisis_kategori_indikator` (`id`, `id_master`, `kategori`, `kategori_kode`) VALUES (12, 3, 'PRODUKSI PERIKANAN', '');
INSERT INTO `analisis_kategori_indikator` (`id`, `id_master`, `kategori`, `kategori_kode`) VALUES (13, 3, 'PRODUKSI BAHAN GALIAN', '');
INSERT INTO `analisis_kategori_indikator` (`id`, `id_master`, `kategori`, `kategori_kode`) VALUES (14, 3, 'PENGOLAHAN HASIL TERNAK', '');
INSERT INTO `analisis_kategori_indikator` (`id`, `id_master`, `kategori`, `kategori_kode`) VALUES (15, 3, 'ALAT PRODUKSI PERIKANAN', '');
INSERT INTO `analisis_kategori_indikator` (`id`, `id_master`, `kategori`, `kategori_kode`) VALUES (16, 3, 'PEMANFAATAN AIR, ASET RUMAH DLL', '');
INSERT INTO `analisis_kategori_indikator` (`id`, `id_master`, `kategori`, `kategori_kode`) VALUES (17, 4, 'Data Anggota Keluarga', '');


#
# TABLE STRUCTURE FOR: analisis_klasifikasi
#

DROP TABLE IF EXISTS `analisis_klasifikasi`;

CREATE TABLE `analisis_klasifikasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_master` int(11) NOT NULL,
  `nama` varchar(20) NOT NULL,
  `minval` double(7,2) NOT NULL,
  `maxval` double(7,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_master` (`id_master`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO `analisis_klasifikasi` (`id`, `id_master`, `nama`, `minval`, `maxval`) VALUES (1, 2, 'Miskin', '5.00', '10.00');
INSERT INTO `analisis_klasifikasi` (`id`, `id_master`, `nama`, `minval`, `maxval`) VALUES (2, 2, 'Sedang', '11.00', '20.00');
INSERT INTO `analisis_klasifikasi` (`id`, `id_master`, `nama`, `minval`, `maxval`) VALUES (3, 2, 'Kaya', '21.00', '25.00');


#
# TABLE STRUCTURE FOR: analisis_master
#

DROP TABLE IF EXISTS `analisis_master`;

CREATE TABLE `analisis_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(40) NOT NULL,
  `subjek_tipe` tinyint(4) NOT NULL,
  `lock` tinyint(1) NOT NULL DEFAULT '1',
  `deskripsi` text NOT NULL,
  `kode_analisis` varchar(5) NOT NULL DEFAULT '00000',
  `id_kelompok` int(11) DEFAULT NULL,
  `pembagi` varchar(10) NOT NULL DEFAULT '100',
  `id_child` smallint(4) DEFAULT NULL,
  `format_impor` tinyint(2) DEFAULT NULL,
  `jenis` tinyint(2) NOT NULL DEFAULT '2',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO `analisis_master` (`id`, `nama`, `subjek_tipe`, `lock`, `deskripsi`, `kode_analisis`, `id_kelompok`, `pembagi`, `id_child`, `format_impor`, `jenis`) VALUES (1, 'Analisis Keahlian Individu', 1, 1, '<p>survey</p>', '00000', 0, '1', 0, 0, 2);
INSERT INTO `analisis_master` (`id`, `nama`, `subjek_tipe`, `lock`, `deskripsi`, `kode_analisis`, `id_kelompok`, `pembagi`, `id_child`, `format_impor`, `jenis`) VALUES (2, 'AKP Lombok Tengah', 2, 1, '<p>keterangan</p>', '00000', 0, '1', 0, 0, 2);
INSERT INTO `analisis_master` (`id`, `nama`, `subjek_tipe`, `lock`, `deskripsi`, `kode_analisis`, `id_kelompok`, `pembagi`, `id_child`, `format_impor`, `jenis`) VALUES (3, 'Data Dasar Keluarga (Prodeskel)', 2, 1, 'Pendataan Profil Desa', 'DDK02', 0, '', 0, 0, 1);
INSERT INTO `analisis_master` (`id`, `nama`, `subjek_tipe`, `lock`, `deskripsi`, `kode_analisis`, `id_kelompok`, `pembagi`, `id_child`, `format_impor`, `jenis`) VALUES (4, 'Data Anggota Keluarga (Prodeskel)', 1, 1, 'Pendataan Profil Desa', 'DAK02', 0, '', 0, 0, 1);


#
# TABLE STRUCTURE FOR: analisis_parameter
#

DROP TABLE IF EXISTS `analisis_parameter`;

CREATE TABLE `analisis_parameter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_indikator` int(11) NOT NULL,
  `jawaban` varchar(200) NOT NULL,
  `nilai` int(3) NOT NULL DEFAULT '0',
  `kode_jawaban` int(3) DEFAULT '0',
  `asign` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_indikator` (`id_indikator`)
) ENGINE=InnoDB AUTO_INCREMENT=1052 DEFAULT CHARSET=latin1;

INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1, 1, 'milik sendiri', 5, 1, 0);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (2, 1, 'milik orang tua', 4, 2, 0);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (3, 1, 'kontrak', 1, 3, 0);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (4, 2, '< Rp.500.000,-', 1, 1, 0);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (5, 2, 'Rp 500.000,- sampa Rp 1.000.000,-', 3, 2, 0);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (6, 2, 'diatas Rp 2.000.000,-', 5, 3, 0);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (7, 5, 'Milik Sendiri', 0, 169, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (8, 5, 'Milik Orang Tua', 0, 170, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (9, 5, 'Milik Keluarga', 0, 171, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (10, 5, 'Sewa/Kontrak', 0, 172, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (11, 5, 'Pinjam Pakai', 0, 173, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (12, 6, 'Pra Sejahtera', 0, 0, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (13, 6, 'Sejahtera 1', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (14, 6, 'Sejahtera 2', 0, 2, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (15, 6, 'Sejahtera 3+', 0, 3, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (16, 7, 'Ya', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (17, 7, 'Tidak', 0, 0, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (18, 8, 'Ya', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (19, 8, 'Tidak', 0, 0, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (20, 9, 'Ya', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (21, 9, 'Tidak', 0, 0, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (22, 10, 'Bak penampung air hujan', 0, 503, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (23, 10, 'Beli dari tangki swasta', 0, 504, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (24, 10, 'Depot isi ulang', 0, 505, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (25, 10, 'Embung', 0, 502, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (26, 10, 'Hidran umum', 0, 498, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (27, 10, 'Mata air', 0, 495, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (28, 10, 'PAM', 0, 499, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (29, 10, 'Pipa', 0, 500, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (30, 10, 'Sumber Air Resapan Umum', 0, 1741, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (31, 10, 'Sumur gali', 0, 496, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (32, 10, 'Sumur pompa', 0, 497, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (33, 10, 'Sungai', 0, 501, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (34, 11, 'Baik', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (35, 11, 'Berasa', 0, 2, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (36, 11, 'Berwarna', 0, 3, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (37, 11, 'Berbau', 0, 4, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (38, 12, 'Hutan', 0, 952, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (39, 12, 'Perkebunan', 0, 951, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (40, 12, 'Tanaman Pangan', 0, 950, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (41, 13, 'Memiliki kurang 0,5 ha', 0, 1732, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (42, 13, 'Memiliki 0,5 - 1,0 ha', 0, 1733, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (43, 13, 'Memiliki lebih dari 1,0 ha', 0, 1734, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (44, 13, 'Tidak memiliki', 0, 1735, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (45, 14, 'Bawah Merah', 0, 12, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (46, 14, 'Bawang Putih', 0, 13, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (47, 14, 'Bayam', 0, 22, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (48, 14, 'Brocoli', 0, 20, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (49, 14, 'Buncis', 0, 19, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (50, 14, 'Cabe', 0, 11, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (51, 14, 'Jagung', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (52, 14, 'Jamur', 0, 78, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (53, 14, 'Jeruk Nipis', 0, 48, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (54, 14, 'Kacang Hijau', 0, 253, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (55, 14, 'Kacang Kedelai', 0, 2, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (56, 14, 'Kacang Merah', 0, 6, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (57, 14, 'Kacang Panjang', 0, 4, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (58, 14, 'Kacang Tanah', 0, 3, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (59, 14, 'Kacang Turis', 0, 24, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (60, 14, 'Kangkung', 0, 23, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (61, 14, 'Kemiri', 0, 96, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (62, 14, 'Kentang', 0, 16, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (63, 14, 'Kubis', 0, 17, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (64, 14, 'Mentimun', 0, 18, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (65, 14, 'Padi Ladang', 0, 8, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (66, 14, 'Padi Sawah', 0, 7, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (67, 14, 'Sawi', 0, 15, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (68, 14, 'Selada', 0, 26, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (69, 14, 'Terong', 0, 21, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (70, 14, 'Tomat', 0, 14, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (71, 14, 'Tumpang Sari', 0, 29, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (72, 14, 'Ubi Jalar', 0, 10, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (73, 14, 'Ubi Kayu', 0, 9, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (74, 14, 'Umbi-Umbian Lain', 0, 25, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (75, 14, 'Wortel', 0, 28, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (76, 16, 'BATANG/TH', 0, 1746, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (77, 16, 'BUAH/TH ', 0, 1013, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (78, 16, 'EKOR/TH ', 0, 1745, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (79, 16, 'JENIS/TH', 0, 965, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (80, 16, 'KG/TH', 0, 960, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (81, 16, 'LITER/TH', 0, 962, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (82, 16, 'M/TH', 0, 963, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (83, 16, 'M3/TH', 0, 961, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (84, 16, 'TON/TH', 0, 966, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (85, 16, 'UNIT/TH', 0, 964, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (86, 18, 'Dijual ke Lumbung Pangan Desa/kel', 0, 493, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (87, 18, 'Dijual ke pasar', 0, 489, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (88, 18, 'Dijual langsung ke konsumen', 0, 488, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (89, 18, 'Dijual melalui KUD', 0, 490, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (90, 18, 'Dijual melalui Pengecer', 0, 492, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (91, 18, 'Dijual melalui Tengkulak', 0, 491, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (92, 18, 'Tidak dijual', 0, 494, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (93, 19, 'Alpokat', 0, 31, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (94, 19, 'Anggur', 0, 54, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (95, 19, 'Apel', 0, 36, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (96, 19, 'Belimbing', 0, 38, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (97, 19, 'Duku', 0, 41, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (98, 19, 'Durian', 0, 39, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (99, 19, 'Gandaria', 0, 258, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (100, 19, 'Jambu air', 0, 50, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (101, 19, 'Jambu klutuk', 0, 57, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (102, 19, 'Jambu Mete', 0, 88, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (103, 19, 'Jeruk', 0, 30, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (104, 19, 'Kedondong', 0, 53, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (105, 19, 'Kesemek', 0, 257, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (106, 19, 'Kokosan', 0, 42, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (107, 19, 'Lengkeng', 0, 45, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (108, 19, 'Limau', 0, 47, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (109, 19, 'Mangga', 0, 32, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (110, 19, 'Manggis', 0, 34, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (111, 19, 'Markisa', 0, 44, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (112, 19, 'Matoa', 0, 249, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (113, 19, 'Melinjo', 0, 55, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (114, 19, 'Melon', 0, 49, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (115, 19, 'Murbei', 0, 58, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (116, 19, 'Nangka', 0, 51, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (117, 19, 'Nenas', 0, 56, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (118, 19, 'Pepaya', 0, 37, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (119, 19, 'Pisang', 0, 43, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (120, 19, 'Rambutan', 0, 33, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (121, 19, 'Salak', 0, 35, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (122, 19, 'Sawo', 0, 40, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (123, 19, 'Semangka', 0, 46, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (124, 19, 'Sirsak', 0, 52, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (125, 19, 'Stroberi', 0, 255, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (126, 19, 'Talas', 0, 27, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (127, 22, 'BATANG/TH', 0, 1746, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (128, 22, 'BUAH/TH ', 0, 1013, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (129, 22, 'EKOR/TH ', 0, 1745, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (130, 22, 'JENIS/TH', 0, 965, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (131, 22, 'KG/TH', 0, 960, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (132, 22, 'LITER/TH', 0, 962, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (133, 22, 'M/TH', 0, 963, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (134, 22, 'M3/TH', 0, 961, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (135, 22, 'TON/TH', 0, 966, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (136, 22, 'UNIT/TH', 0, 964, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (137, 24, 'Dijual ke Lumbung Pangan Desa/kel', 0, 493, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (138, 24, 'Dijual ke pasar', 0, 489, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (139, 24, 'Dijual langsung ke konsumen', 0, 488, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (140, 24, 'Dijual melalui KUD', 0, 490, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (141, 24, 'Dijual melalui Pengecer', 0, 492, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (142, 24, 'Dijual melalui Tengkulak', 0, 491, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (143, 24, 'Tidak dijual', 0, 494, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (144, 25, 'Akar Wangi', 0, 76, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (145, 25, 'Buah Merah', 0, 65, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (146, 25, 'Daun Dewa', 0, 63, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (147, 25, 'Daun Sereh', 0, 74, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (148, 25, 'Daun Sirih', 0, 72, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (149, 25, 'Dewi-Dewi', 0, 79, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (150, 25, 'Jahe', 0, 59, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (151, 25, 'Jamur', 0, 252, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (152, 25, 'Kayu Manis', 0, 73, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (153, 25, 'Kencur', 0, 77, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (154, 25, 'Kumis Kucing', 0, 64, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (155, 25, 'Kunyit', 0, 60, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (156, 25, 'Lengkuas', 0, 61, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (157, 25, 'Mahkota Dewa', 0, 75, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (158, 25, 'Mengkudu', 0, 62, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (159, 25, 'Sambiloto', 0, 66, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (160, 25, 'Temu Hitam', 0, 68, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (161, 25, 'Temu Kunci', 0, 71, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (162, 25, 'Temu Putih', 0, 69, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (163, 25, 'Temu Putri', 0, 70, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (164, 25, 'Temulawak', 0, 67, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (165, 27, 'BATANG/TH', 0, 1746, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (166, 27, 'BUAH/TH ', 0, 1013, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (167, 27, 'EKOR/TH ', 0, 1745, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (168, 27, 'JENIS/TH', 0, 965, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (169, 27, 'KG/TH', 0, 960, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (170, 27, 'LITER/TH', 0, 962, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (171, 27, 'M/TH', 0, 963, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (172, 27, 'M3/TH', 0, 961, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (173, 27, 'TON/TH', 0, 966, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (174, 27, 'UNIT/TH', 0, 964, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (175, 29, 'Dijual ke Lumbung Pangan Desa/kel', 0, 493, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (176, 29, 'Dijual ke pasar', 0, 489, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (177, 29, 'Dijual langsung ke konsumen', 0, 488, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (178, 29, 'Dijual melalui KUD', 0, 490, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (179, 29, 'Dijual melalui Pengecer', 0, 492, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (180, 29, 'Dijual melalui Tengkulak', 0, 491, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (181, 29, 'Tidak dijual', 0, 494, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (182, 30, 'Cengkeh', 0, 83, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (183, 30, 'Coklat', 0, 84, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (184, 30, 'Jarak kepyar', 0, 93, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (185, 30, 'Jarak pagar', 0, 92, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (186, 30, 'Kacang mede', 0, 5, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (187, 30, 'Kapuk', 0, 95, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (188, 30, 'Karet', 0, 87, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (189, 30, 'Kelapa', 0, 80, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (190, 30, 'Kelapa sawit', 0, 81, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (191, 30, 'Kemiri', 0, 256, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (192, 30, 'Kopi', 0, 82, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (193, 30, 'Lada', 0, 86, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (194, 30, 'Pala', 0, 90, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (195, 30, 'Pinang', 0, 85, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (196, 30, 'Tebu', 0, 94, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (197, 30, 'Teh', 0, 97, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (198, 30, 'Tembakau', 0, 89, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (199, 30, 'Vanili', 0, 91, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (200, 32, 'BATANG/TH', 0, 1746, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (201, 32, 'BUAH/TH ', 0, 1013, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (202, 32, 'EKOR/TH ', 0, 1745, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (203, 32, 'JENIS/TH', 0, 965, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (204, 32, 'KG/TH', 0, 960, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (205, 32, 'LITER/TH', 0, 962, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (206, 32, 'M/TH', 0, 963, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (207, 32, 'M3/TH', 0, 961, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (208, 32, 'TON/TH', 0, 966, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (209, 32, 'UNIT/TH', 0, 964, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (210, 34, 'Dijual ke Lumbung Pangan Desa/kel', 0, 493, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (211, 34, 'Dijual ke pasar', 0, 489, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (212, 34, 'Dijual langsung ke konsumen', 0, 488, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (213, 34, 'Dijual melalui KUD', 0, 490, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (214, 34, 'Dijual melalui Pengecer', 0, 492, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (215, 34, 'Dijual melalui Tengkulak', 0, 491, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (216, 34, 'Tidak dijual', 0, 494, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (217, 35, 'Arang', 0, 121, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (218, 35, 'Bambu', 0, 102, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (219, 35, 'Cemara', 0, 109, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (220, 35, 'Damar', 0, 101, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (221, 35, 'Enau', 0, 107, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (222, 35, 'Gambir', 0, 117, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (223, 35, 'Gula enau', 0, 119, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (224, 35, 'Gula lontar', 0, 120, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (225, 35, 'Ijuk Enau', 0, 245, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (226, 35, 'Jati', 0, 103, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (227, 35, 'Kayu', 0, 98, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (228, 35, 'Kayu Bakar', 0, 247, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (229, 35, 'Kayu besi', 0, 114, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (230, 35, 'Kayu cendana', 0, 110, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (231, 35, 'Kayu gaharu', 0, 111, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (232, 35, 'Kayu Sengon', 0, 246, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (233, 35, 'Kayu ulin', 0, 115, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (234, 35, 'Kemenyan', 0, 116, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (235, 35, 'Lontar', 0, 105, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (236, 35, 'Madu lebah', 0, 99, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (237, 35, 'Mahoni', 0, 108, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (238, 35, 'Meranti', 0, 113, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (239, 35, 'Minyak kayu putih', 0, 118, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (240, 35, 'Nilam', 0, 104, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (241, 35, 'Rotan', 0, 100, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (242, 35, 'Rumbia', 0, 259, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (243, 35, 'Sagu', 0, 106, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (244, 35, 'Sarang burung', 0, 112, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (245, 37, 'BATANG/TH', 0, 1746, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (246, 37, 'BUAH/TH ', 0, 1013, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (247, 37, 'EKOR/TH ', 0, 1745, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (248, 37, 'JENIS/TH', 0, 965, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (249, 37, 'KG/TH', 0, 960, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (250, 37, 'LITER/TH', 0, 962, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (251, 37, 'M/TH', 0, 963, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (252, 37, 'M3/TH', 0, 961, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (253, 37, 'TON/TH', 0, 966, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (254, 37, 'UNIT/TH', 0, 964, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (255, 39, 'Dijual ke Lumbung Pangan Desa/kel', 0, 493, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (256, 39, 'Dijual ke pasar', 0, 489, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (257, 39, 'Dijual langsung ke konsumen', 0, 488, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (258, 39, 'Dijual melalui KUD', 0, 490, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (259, 39, 'Dijual melalui Pengecer', 0, 492, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (260, 39, 'Dijual melalui Tengkulak', 0, 491, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (261, 39, 'Tidak dijual', 0, 494, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (262, 40, 'Angsa', 0, 131, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (263, 40, 'Anjing', 0, 135, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (264, 40, 'Ayam kampung', 0, 125, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (265, 40, 'Babi', 0, 124, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (266, 40, 'Bebek', 0, 127, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (267, 40, 'Buaya', 0, 145, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (268, 40, 'Burung beo', 0, 142, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (269, 40, 'Burung cendrawasih', 0, 140, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (270, 40, 'Burung kakatua', 0, 141, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (271, 40, 'Burung langka lainnya', 0, 144, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (272, 40, 'Burung merak', 0, 143, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (273, 40, 'Burung Merpati', 0, 244, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (274, 40, 'Burung onta', 0, 138, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (275, 40, 'Burung puyuh', 0, 132, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (276, 40, 'Domba', 0, 130, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (277, 40, 'Jenis ayam broiler', 0, 126, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (278, 40, 'Kambing', 0, 129, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (279, 40, 'Kelinci', 0, 133, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (280, 40, 'Kerbau', 0, 123, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (281, 40, 'Kucing', 0, 136, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (282, 40, 'Kuda', 0, 128, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (283, 40, 'Sapi', 0, 122, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (284, 40, 'Tuna', 0, 146, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (285, 40, 'Ular cobra', 0, 137, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (286, 40, 'Ular pithon', 0, 139, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (287, 42, 'BATANG/TH', 0, 1746, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (288, 42, 'BUAH/TH ', 0, 1013, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (289, 42, 'EKOR/TH ', 0, 1745, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (290, 42, 'JENIS/TH', 0, 965, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (291, 42, 'KG/TH', 0, 960, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (292, 42, 'LITER/TH', 0, 962, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (293, 42, 'M/TH', 0, 963, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (294, 42, 'M3/TH', 0, 961, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (295, 42, 'TON/TH', 0, 966, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (296, 42, 'UNIT/TH', 0, 964, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (297, 44, 'Dijual ke Lumbung Pangan Desa/kel', 0, 493, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (298, 44, 'Dijual ke pasar', 0, 489, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (299, 44, 'Dijual langsung ke konsumen', 0, 488, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (300, 44, 'Dijual melalui KUD', 0, 490, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (301, 44, 'Dijual melalui Pengecer', 0, 492, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (302, 44, 'Dijual melalui Tengkulak', 0, 491, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (303, 44, 'Tidak dijual', 0, 494, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (304, 45, 'Ayam-ayam', 0, 168, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (305, 45, 'Bandeng', 0, 171, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (306, 45, 'Barabara', 0, 165, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (307, 45, 'Baronang', 0, 160, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (308, 45, 'Bawal', 0, 159, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (309, 45, 'Belanak', 0, 155, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (310, 45, 'Belut', 0, 184, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (311, 45, 'Cucut', 0, 166, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (312, 45, 'Cumi', 0, 156, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (313, 45, 'Gabus', 0, 179, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (314, 45, 'Gurame', 0, 183, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (315, 45, 'Gurita', 0, 157, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (316, 45, 'Hiu', 0, 149, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (317, 45, 'Ikan ekor kuning', 0, 162, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (318, 45, 'Jambal', 0, 152, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (319, 45, 'Kakap', 0, 150, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (320, 45, 'Katak', 0, 188, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (321, 45, 'Kembung', 0, 161, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (322, 45, 'Kepiting', 0, 174, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (323, 45, 'Kerang', 0, 173, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (324, 45, 'Sunuk', 0, 163, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (325, 45, 'Kodok', 0, 187, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (326, 45, 'Kulit kerang', 0, 209, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (327, 45, 'Kuwe', 0, 154, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (328, 45, 'Layur', 0, 167, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (329, 45, 'Lele', 0, 178, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (330, 45, 'Mas', 0, 175, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (331, 45, 'Mujair', 0, 177, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (332, 45, 'Nener', 0, 172, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (333, 45, 'Nila', 0, 181, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (334, 45, 'Pari', 0, 153, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (335, 45, 'Patin', 0, 180, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (336, 45, 'Penyu', 0, 185, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (337, 45, 'Rajungan', 0, 176, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (338, 45, 'Rumput laut', 0, 186, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (339, 45, 'Salmon', 0, 147, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (340, 45, 'Sarden', 0, 158, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (341, 45, 'Sepat', 0, 182, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (342, 45, 'Tembang', 0, 170, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (343, 45, 'Tenggiri', 0, 151, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (344, 45, 'Teri', 0, 254, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (345, 45, 'Teripang', 0, 164, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (346, 45, 'Tongkol/cakalang', 0, 148, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (347, 45, 'Tuna', 0, 251, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (348, 45, 'Udang/lobster', 0, 169, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (349, 47, 'BATANG/TH', 0, 1746, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (350, 47, 'BUAH/TH ', 0, 1013, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (351, 47, 'EKOR/TH ', 0, 1745, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (352, 47, 'JENIS/TH', 0, 965, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (353, 47, 'KG/TH', 0, 960, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (354, 47, 'LITER/TH', 0, 962, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (355, 47, 'M/TH', 0, 963, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (356, 47, 'M3/TH', 0, 961, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (357, 47, 'TON/TH', 0, 966, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (358, 47, 'UNIT/TH', 0, 964, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (359, 49, 'Dijual ke Lumbung Pangan Desa/kel', 0, 493, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (360, 49, 'Dijual ke pasar', 0, 489, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (361, 49, 'Dijual langsung ke konsumen', 0, 488, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (362, 49, 'Dijual melalui KUD', 0, 490, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (363, 49, 'Dijual melalui Pengecer', 0, 492, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (364, 49, 'Dijual melalui Tengkulak', 0, 491, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (365, 49, 'Tidak dijual', 0, 494, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (366, 50, 'Aluminium', 0, 189, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (367, 50, 'Batu apung', 0, 190, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (368, 50, 'Batu cadas', 0, 191, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (369, 50, 'Batu Gamping', 0, 192, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (370, 50, 'Batu Gips', 0, 193, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (371, 50, 'Batu Granit', 0, 194, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (372, 50, 'Batu gunung', 0, 195, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (373, 50, 'Batu kali', 0, 196, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (374, 50, 'Batu kapur', 0, 197, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (375, 50, 'Batu marmer', 0, 198, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (376, 50, 'Batu Putih', 0, 199, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (377, 50, 'Batu Trass', 0, 200, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (378, 50, 'Batubara', 0, 201, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (379, 50, 'Belerang', 0, 202, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (380, 50, 'Biji Besi', 0, 203, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (381, 50, 'Bouxit', 0, 204, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (382, 50, 'Emas', 0, 205, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (383, 50, 'Garam', 0, 206, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (384, 50, 'Gas Alam', 0, 207, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (385, 50, 'Gips', 0, 208, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (386, 50, 'Kuningan', 0, 210, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (387, 50, 'Mangan', 0, 212, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (388, 50, 'Minyak', 0, 233, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (389, 50, 'Minyak Bumi', 0, 213, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (390, 50, 'Nikel', 0, 214, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (391, 50, 'Pasir', 0, 215, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (392, 50, 'Pasir Batu', 0, 216, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (393, 50, 'Pasir Besi', 0, 217, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (394, 50, 'Pasir kwarsa', 0, 218, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (395, 50, 'Perak', 0, 219, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (396, 50, 'Perunggu', 0, 220, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (397, 50, 'Tanah Garam', 0, 221, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (398, 50, 'Tanah liat', 0, 222, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (399, 50, 'Tembaga', 0, 223, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (400, 50, 'Timah', 0, 224, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (401, 50, 'Uranium', 0, 225, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (402, 53, 'BATANG/TH', 0, 1746, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (403, 53, 'BUAH/TH ', 0, 1013, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (404, 53, 'EKOR/TH ', 0, 1745, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (405, 53, 'JENIS/TH', 0, 965, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (406, 53, 'KG/TH', 0, 960, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (407, 53, 'LITER/TH', 0, 962, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (408, 53, 'M/TH', 0, 963, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (409, 53, 'M3/TH', 0, 961, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (410, 53, 'TON/TH', 0, 966, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (411, 53, 'UNIT/TH', 0, 964, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (412, 54, 'Dijual ke Lumbung Pangan Desa/kel', 0, 493, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (413, 54, 'Dijual ke pasar', 0, 489, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (414, 54, 'Dijual langsung ke konsumen', 0, 488, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (415, 54, 'Dijual melalui KUD', 0, 490, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (416, 54, 'Dijual melalui Pengecer', 0, 492, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (417, 54, 'Dijual melalui Tengkulak', 0, 491, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (418, 54, 'Tidak dijual', 0, 494, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (419, 55, 'Air liur burung walet', 0, 232, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (420, 55, 'Bulu', 0, 231, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (421, 55, 'Burung walet', 0, 134, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (422, 55, 'Cinderamata', 0, 235, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (423, 55, 'Daging', 0, 229, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (424, 55, 'Hiasan/lukisan', 0, 234, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (425, 55, 'Kerupuk Kulit', 0, 248, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (426, 55, 'Kulit', 0, 227, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (427, 55, 'Madu', 0, 230, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (428, 55, 'Susu', 0, 226, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (429, 55, 'Telur', 0, 228, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (430, 57, 'BATANG/TH', 0, 1746, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (431, 57, 'BUAH/TH ', 0, 1013, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (432, 57, 'EKOR/TH ', 0, 1745, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (433, 57, 'JENIS/TH', 0, 965, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (434, 57, 'KG/TH', 0, 960, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (435, 57, 'LITER/TH', 0, 962, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (436, 57, 'M/TH', 0, 963, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (437, 57, 'M3/TH', 0, 961, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (438, 57, 'TON/TH', 0, 966, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (439, 57, 'UNIT/TH', 0, 964, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (440, 59, 'Dijual ke Lumbung Pangan Desa/kel', 0, 493, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (441, 59, 'Dijual ke pasar', 0, 489, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (442, 59, 'Dijual langsung ke konsumen', 0, 488, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (443, 59, 'Dijual melalui KUD', 0, 490, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (444, 59, 'Dijual melalui Pengecer', 0, 492, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (445, 59, 'Dijual melalui Tengkulak', 0, 491, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (446, 59, 'Tidak dijual', 0, 494, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (447, 60, 'Jala', 0, 405, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (448, 60, 'Jermal', 0, 402, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (449, 60, 'Karamba', 0, 400, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (450, 60, 'Pancing', 0, 403, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (451, 60, 'Pukat', 0, 404, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (452, 60, 'Tambak', 0, 401, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (453, 62, 'Air minum/air baku', 0, 511, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (454, 62, 'Buang air besar', 0, 514, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (455, 62, 'Cuci dan mandi', 0, 512, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (456, 62, 'Irigasi', 0, 513, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (457, 62, 'Pembangkit listrik', 0, 515, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (458, 62, 'Prasarana transportasi', 0, 516, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (459, 62, 'Sumber air panas', 0, 517, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (460, 62, 'Usaha Perikanan', 0, 510, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (461, 63, 'Biara', 0, 687, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (462, 63, 'Kursus Bahasa', 0, 697, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (463, 63, 'Kursus Bela Diri', 0, 703, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (464, 63, 'Kursus Komputer', 0, 700, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (465, 63, 'Kursus Mengemudi', 0, 701, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (466, 63, 'Kursus Menjahit', 0, 698, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (467, 63, 'Kursus Montir', 0, 699, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (468, 63, 'Kursus Satpam', 0, 702, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (469, 63, 'Lembaga Kursus Keterampilan Swasta Katolik', 0, 692, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (470, 63, 'Lembaga Pendidikan Swasta Budha', 0, 695, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (471, 63, 'Lembaga Pendidikan Swasta Hindu', 0, 694, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (472, 63, 'Lembaga Pendidikan Swasta Konghucu', 0, 696, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (473, 63, 'Lembaga Pendidikan Swasta Kristen Protestan', 0, 693, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (474, 63, 'Madrasah Aliyah', 0, 682, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (475, 63, 'Madrasah Ibtidaiyah', 0, 680, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (476, 63, 'Madrasah Tsanawiyah', 0, 681, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (477, 63, 'Perguruan Tinggi', 0, 676, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (478, 63, 'Perguruan Tinggi Swasta Katolik', 0, 688, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (479, 63, 'Pondok Pesantren', 0, 677, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (480, 63, 'Rhaudatul Athfal (Tk)', 0, 679, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (481, 63, 'SD/Sederajat', 0, 673, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (482, 63, 'Sekolah Dasar Swasta Katolik', 0, 689, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (483, 63, 'Sekolah Tinggi Agama Islam', 0, 683, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (484, 63, 'Seminari Menengah', 0, 685, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (485, 63, 'Seminari Tinggi', 0, 686, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (486, 63, 'SLTA Swasta Katolik', 0, 691, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (487, 63, 'SLTP Swasta Katolik', 0, 690, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (488, 63, 'SMA/Sederajat', 0, 675, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (489, 63, 'SMP/Sederajat', 0, 674, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (490, 63, 'Taman Pendidikan Alqur?an', 0, 678, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (491, 63, 'TK/Preschool/Play Group', 0, 672, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (492, 63, 'Universitas Swasta Islam', 0, 684, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (493, 64, 'Tidak memiliki tanah', 0, 704, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (494, 64, 'Memiliki tanah kurang dari 0,1 ha', 0, 1744, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (495, 64, 'Memiliki tanah antara 0,1 - 0,2 ha', 0, 705, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (496, 64, 'Memiliki tanah antara 0,2 - 0,3 ha', 0, 706, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (497, 64, 'Memiliki tanah antara 0,3 - 0,4 ha', 0, 707, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (498, 64, 'Memiliki tanah antara 0,4 - 0,5 ha', 0, 708, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (499, 64, 'Memiliki tanah antara 0,5 - 0,6 ha', 0, 709, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (500, 64, 'Memiliki tanah antara 0,6 - 0,7 ha', 0, 710, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (501, 64, 'Memiliki tanah antara 0,7 - 0,8 ha', 0, 711, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (502, 64, 'Memiliki tanah antara 0,8 - 0,9 ha', 0, 712, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (503, 64, 'Memiliki tanah antara 0,9 - 1,0 ha', 0, 713, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (504, 64, 'Memiliki tanah antara 1,0 - 5,0 ha', 0, 714, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (505, 64, 'Memiliki tanah lebih dari 5,0 ha', 0, 715, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (506, 65, 'Memiiki cidemo/andong/dokar  ', 0, 718, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (507, 65, 'Memiliki bajaj/kancil', 0, 723, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (508, 65, 'Memiliki becak', 0, 717, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (509, 65, 'Memiliki bus penumpang/angkutan orang/barang', 0, 721, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (510, 65, 'Memiliki ojek motor/sepeda motor/bentor', 0, 716, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (511, 65, 'Memiliki perahu tidak bermotor', 0, 719, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (512, 65, 'Memiliki sepeda dayung', 0, 722, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (513, 65, 'Memiliki tongkang', 0, 720, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (514, 66, 'Memiliki alat pengolahan hasil hutan  ', 0, 731, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (515, 66, 'Memiliki alat pengolahan hasil perikanan  ', 0, 728, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (516, 66, 'Memiliki alat pengolahan hasil perkebunan', 0, 730, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (517, 66, 'Memiliki alat pengolahan hasil peternakan  ', 0, 729, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (518, 66, 'Memiliki alat produksi dan pengolah hasil Industri kerajinan keluarga skala kecil dan menengah  ', 0, 733, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (519, 66, 'Memiliki alat produksi dan pengolah hasil pertambangan  ', 0, 732, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (520, 66, 'Memiliki alat produksi dan pengolahan hasil industri bahan bakar dan gas skala keluarga/rumah tangga  ', 0, 734, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (521, 66, 'Memiliki kapal penangkap ikan  ', 0, 727, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (522, 66, 'Memiliki pabrik pengolahan hasil pertanian  ', 0, 726, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (523, 66, 'Memiliki penggilingan padi  ', 0, 724, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (524, 66, 'Memiliki traktor', 0, 725, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (525, 67, 'Bambu', 0, 737, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (526, 67, 'Dedaunan', 0, 740, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (527, 67, 'Kayu', 0, 736, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (528, 67, 'Pelepah kelapa/lontar/gebang  ', 0, 739, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (529, 67, 'Tanah Liat', 0, 738, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (530, 67, 'Tembok', 0, 735, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (531, 68, 'Kayu', 0, 743, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (532, 68, 'Keramik', 0, 741, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (533, 68, 'Semen', 0, 742, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (534, 68, 'Tanah', 0, 744, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (535, 69, 'Asbes', 0, 747, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (536, 69, 'Bambu', 0, 749, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (537, 69, 'Daun ilalang ', 0, 7752, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (538, 69, 'Daun lontar/gebang/enau  ', 0, 751, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (539, 69, 'Genteng', 0, 745, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (540, 69, 'Kayu', 0, 750, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (541, 69, 'Seng', 0, 746, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (542, 70, 'Berlangganan koran/majalah', 0, 787, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (543, 70, 'Memiliki buku surat berharga', 0, 766, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (544, 70, 'Memiliki buku tabungan bank', 0, 765, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (545, 70, 'Memiliki hiasan emas/berlian', 0, 764, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (546, 70, 'Memiliki HP CDMA', 0, 784, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (547, 70, 'Memiliki HP GSM', 0, 783, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (548, 70, 'Memiliki kapal barang', 0, 757, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (549, 70, 'Memiliki kapal penumpang', 0, 758, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (550, 70, 'Memiliki kapal pesiar', 0, 759, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (551, 70, 'Memiliki mobil pribadi dan sejenisnya', 0, 755, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (552, 70, 'Memiliki parabola', 0, 786, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (553, 70, 'Memiliki perahu bermotor', 0, 756, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (554, 70, 'Memiliki perusahaan industri besar', 0, 770, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (555, 70, 'Memiliki perusahaan industri kecil', 0, 772, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (556, 70, 'Memiliki perusahaan industri menengah', 0, 771, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (557, 70, 'Memiliki saham di perusahaan', 0, 781, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (558, 70, 'Memiliki sepeda motor pribadi', 0, 754, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (559, 70, 'Memiliki sertifikat bangunan', 0, 769, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (560, 70, 'Memiliki sertifikat deposito', 0, 767, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (561, 70, 'Memiliki sertifikat tanah', 0, 768, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (562, 70, 'Memiliki ternak besar', 0, 762, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (563, 70, 'Memiliki ternak kecil', 0, 763, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (564, 70, 'Memiliki TV dan elektronik sejenis lainnya', 0, 753, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (565, 70, 'Memiliki usaha di pasar desa', 0, 779, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (566, 70, 'Memiliki usaha di pasar swalayan', 0, 777, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (567, 70, 'Memiliki usaha di pasar tradisional', 0, 778, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (568, 70, 'Memiliki usaha pasar swalayan', 0, 776, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (569, 70, 'Memiliki usaha perikanan', 0, 773, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (570, 70, 'Memiliki usaha perkebunan', 0, 775, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (571, 70, 'Memiliki usaha peternakan', 0, 774, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (572, 70, 'Memiliki usaha transportasi/pengangkutan', 0, 780, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (573, 70, 'Memiliki Usaha Wartel', 0, 785, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (574, 70, 'Memiliki/menyewa helikopter pribadi', 0, 760, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (575, 70, 'Memiliki/menyewa pesawat terbang pribadi', 0, 761, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (576, 70, 'Pelanggan Telkom', 0, 782, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (577, 71, 'Ibu hamil melahirkan', 0, 796, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (578, 71, 'Ibu hamil periksa di Bidan Praktek', 0, 792, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (579, 71, 'Ibu hamil periksa di Dokter Praktek', 0, 791, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (580, 71, 'Ibu hamil periksa di Dukun Terlatih', 0, 793, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (581, 71, 'Ibu hamil periksa di Posyandu', 0, 788, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (582, 71, 'Ibu hamil periksa di Puskesmas', 0, 789, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (583, 71, 'Ibu hamil periksa di Rumah Sakit', 0, 790, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (584, 71, 'Ibu hamil tidak periksa kesehatan', 0, 794, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (585, 71, 'Ibu hamil yang meninggal', 0, 795, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (586, 71, 'Ibu nifas sakit', 0, 797, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (587, 71, 'Ibu nifas sehat', 0, 799, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (588, 71, 'Kematian ibu nifas', 0, 798, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (589, 71, 'Kematian ibu saat melahirkan', 0, 800, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (590, 72, 'Bayi 0-5 tahun hidup yang menderita kelainan organ tubuh, fisik dan mental  ', 0, 807, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (591, 72, 'Bayi lahir berat kurang dari 2,5 kg', 0, 805, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (592, 72, 'Bayi lahir berat lebih dari 4 kg', 0, 806, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (593, 72, 'Bayi lahir hidup cacat', 0, 803, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (594, 72, 'Bayi lahir hidup normal', 0, 802, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (595, 72, 'Bayi lahir mati', 0, 804, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (596, 72, 'Keguguran kandungan', 0, 801, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (597, 73, 'Rumah dukun', 0, 815, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (598, 73, 'Rumah sendiri', 0, 816, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (599, 73, 'Tempat persalinan Balai Kesehatan Ibu Anak', 0, 812, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (600, 73, 'Tempat persalinan Polindes', 0, 811, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (601, 73, 'Tempat persalinan Puskesmas', 0, 810, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (602, 73, 'Tempat persalinan Rumah Bersalin', 0, 809, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (603, 73, 'Tempat persalinan rumah praktek bidan', 0, 813, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (604, 73, 'Tempat persalinan Rumah Sakit Umum', 0, 808, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (605, 73, 'Tempat praktek dokter', 0, 814, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (606, 74, 'Persalinan ditolong bidan', 0, 818, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (607, 74, 'Persalinan ditolong Dokter', 0, 817, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (608, 74, 'Persalinan ditolong dukun bersalin', 0, 820, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (609, 74, 'Persalinan ditolong keluarga', 0, 821, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (610, 74, 'Persalinan ditolong perawat', 0, 819, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (611, 75, 'BCG', 0, 823, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (612, 75, 'Cacar', 0, 830, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (613, 75, 'Campak', 0, 829, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (614, 75, 'DPT-1', 0, 822, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (615, 75, 'DPT-2', 0, 825, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (616, 75, 'DPT-3', 0, 828, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (617, 75, 'Polio -1', 0, 824, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (618, 75, 'Polio-2', 0, 826, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (619, 75, 'Polio-3', 0, 827, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (620, 75, 'Sudah Semua', 0, 831, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (621, 76, 'Busung Lapar', 0, 838, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (622, 76, 'Cikungunya', 0, 836, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (623, 76, 'Demam Berdarah', 0, 833, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (624, 76, 'Flu Burung', 0, 837, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (625, 76, 'Kelainan fisik', 0, 841, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (626, 76, 'Kelainan mental', 0, 842, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (627, 76, 'Kelaparan', 0, 839, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (628, 76, 'Kolera', 0, 834, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (629, 76, 'Kulit Bersisik', 0, 840, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (630, 76, 'Muntaber', 0, 832, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (631, 76, 'Polio', 0, 835, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (632, 77, 'Biasa buang air besar di sungai/parit/kebun/hutan  ', 0, 845, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (633, 77, 'Memiliki WC yang darurat/kurang memenuhi standar kesehatan  ', 0, 844, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (634, 77, 'Memiliki WC yang permanen/semipermanen  ', 0, 843, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (635, 77, 'Menggunakan fasilitas MCK umum  ', 0, 846, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (636, 78, 'Belum tentu sehari makan 1 kali  ', 0, 851, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (637, 78, 'Kebiasaan makan dalam sehari 1 kali  ', 0, 847, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (638, 78, 'Kebiasaan makan sehari 2 kali  ', 0, 848, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (639, 78, 'Kebiasaan makan sehari 3 kali  ', 0, 849, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (640, 78, 'Kebiasaan makan sehari lebih dari 3 kali  ', 0, 850, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (641, 79, 'Dokter/puskesmas/mantri kesehatan/perawat/ bidan/ posyandu  ', 0, 853, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (642, 79, 'Dukun Terlatih  ', 0, 852, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (643, 79, 'Obat tradisional dari dukun pengobatan alternatif  ', 0, 854, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (644, 79, 'Obat tradisional dari keluarga sendiri  ', 0, 856, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (645, 79, 'Paranormal  ', 0, 855, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (646, 79, 'Tidak diobati  ', 0, 857, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (647, 80, 'Balita bergizi baik  ', 0, 859, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (648, 80, 'Balita bergizi buruk  ', 0, 858, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (649, 80, 'Balita bergizi kurang  ', 0, 860, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (650, 80, 'Balita bergizi lebih', 0, 861, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (651, 81, 'Asma', 0, 874, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (652, 81, 'Diabetes Melitus', 0, 867, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (653, 81, 'Gila/stress', 0, 872, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (654, 81, 'Ginjal', 0, 868, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (655, 81, 'HIV/AIDS', 0, 871, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (656, 81, 'Jantung', 0, 862, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (657, 81, 'Kanker', 0, 865, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (658, 81, 'Lepra/Kusta', 0, 870, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (659, 81, 'Lever', 0, 863, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (660, 81, 'Malaria', 0, 869, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (661, 81, 'Paru-paru', 0, 864, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (662, 81, 'Stroke', 0, 866, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (663, 81, 'TBC', 0, 873, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (664, 82, 'Anak yatim/piatu dalam keluarga akibat konflik Sara  ', 0, 878, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (665, 82, 'Janda/duda dalam keluarga akibat konflik Sara  ', 0, 877, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (666, 82, 'Korban luka dalam keluarga akibat konflik Sara  ', 0, 875, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (667, 82, 'Korban meninggal dalam keluarga akibat konflik Sara ', 0, 876, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (668, 83, 'Korban jiwa akibat perkelahian dalam keluarga  ', 0, 879, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (669, 83, 'Korban luka parah akibat perkelahian dalam keluarga ', 0, 880, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (670, 84, 'Korban pencurian, perampokan dalam keluarga  ', 0, 881, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (671, 85, 'Korban penjarahan yang pelakunya anggota keluarga  ', 0, 882, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (672, 85, 'Korban penjarahan yang pelakunya bukan anggota keluarga  ', 0, 883, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (673, 86, 'Anggota keluarga yang memiliki kebiasaan berjudi', 0, 884, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (674, 87, 'Anggota keluarga mengkonsumsi Miras yang dilarang  ', 0, 885, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (675, 87, 'Anggota keluarga yang mengkonsumsi Narkoba ', 0, 886, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (676, 88, 'Korban pembunuhan dalam keluarga yang pelakunya anggota keluarga  ', 0, 887, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (677, 88, 'Korban pembunuhan dalam keluarga yang pelakunya bukan anggota keluarga', 0, 888, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (678, 89, 'Korban penculikan yang pelakunya anggota keluarga  ', 0, 889, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (679, 89, 'Korban penculikan yang pelakunya bukan anggota keluarga  ', 0, 890, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (680, 90, 'Korban kehamilan di luar nikah yang sah menurut hukum adat  ', 0, 893, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (681, 90, 'Korban kehamilan yang tidak dinikahi pelakunya  ', 0, 894, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (682, 90, 'Korban kehamilan yang tidak/belum disahkan secara hukum agama dan hukum negara  ', 0, 895, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (683, 90, 'Korban perkosaan/pelecehan seksual yang pelakunya anggota keluarga  ', 0, 891, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (684, 90, 'Korban perkosaan/pelecehan seksual yang pelakunya bukan anggota keluarga  ', 0, 892, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (685, 91, 'Adanya pemukulan/tindakan fisik antara anak dengan anggota keluarga lain  ', 0, 903, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (686, 91, 'Adanya pemukulan/tindakan fisik antara anak dengan orang tua  ', 0, 901, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (687, 91, 'Adanya pemukulan/tindakan fisik antara anak dengan pembantu  ', 0, 905, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (688, 91, 'Adanya pemukulan/tindakan fisik antara orang tua dengan anak  ', 0, 902, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (689, 91, 'Adanya pemukulan/tindakan fisik antara orang tua dengan orang tua  ', 0, 904, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (690, 91, 'Adanya pemukulan/tindakan fisik antara orang tua dengan pembantu  ', 0, 906, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (691, 91, 'Adanya pertengkaran dalam keluarga antara anak dan anak  ', 0, 897, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (692, 91, 'Adanya pertengkaran dalam keluarga antara anak dan anggota keluarga lain  ', 0, 900, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (693, 91, 'Adanya pertengkaran dalam keluarga antara anak dan orang tua  ', 0, 896, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (694, 91, 'Adanya pertengkaran dalam keluarga antara anak dan pembantu  ', 0, 899, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (695, 91, 'Adanya pertengkaran dalam keluarga antara ayah dan ibu/orang tua ', 0, 898, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (696, 92, 'Ada anak anggota keluarga yang mengemis', 0, 918, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (697, 92, 'Ada anak dan anggota keluarga yang menjadi pengamen', 0, 919, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (698, 92, 'Ada anak yang membantu orang tua mendapatkan penghasilan', 0, 934, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (699, 92, 'Ada anggota keluarga eks narapidana', 0, 936, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (700, 92, 'Ada anggota keluarga yang bermalam/tidur di jalanan/emperan toko/pusat keramaian/kolong jembatan', 0, 916, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (701, 92, 'Ada anggota keluarga yang cacat fisik', 0, 921, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (702, 92, 'Ada anggota keluarga yang cacat mental', 0, 922, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (703, 92, 'Ada anggota keluarga yang gila/stres', 0, 920, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (704, 92, 'Ada anggota keluarga yang kelainan kulit', 0, 923, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (705, 92, 'Ada anggota keluarga yang menganggur', 0, 933, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (706, 92, 'Ada anggota keluarga yang mengemis', 0, 915, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (707, 92, 'Ada anggota keluarga yang menjadi pengamen', 0, 924, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (708, 92, 'Ada anggota keluarga yang termasuk manusia lanjut usia (di atas 60 thn)', 0, 917, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (709, 92, 'Anggota keluarga yatim/piatu', 0, 925, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (710, 92, 'Keluarga duda', 0, 927, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (711, 92, 'Keluarga janda', 0, 926, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (712, 92, 'Kepala keluarga perempuan', 0, 935, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (713, 92, 'Tinggal di bantaran sungai', 0, 928, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (714, 92, 'Tinggal di daerah kawasan kering, tandus dan kritis', 0, 947, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (715, 92, 'Tinggal di daerah rawan bencana tsunami', 0, 938, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (716, 92, 'Tinggal di desa/kelurahan rawan air bersih', 0, 944, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (717, 92, 'Tinggal di desa/kelurahan rawan banjir', 0, 937, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (718, 92, 'Tinggal di desa/kelurahan rawan bencana kekeringan', 0, 945, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (719, 92, 'Tinggal di desa/kelurahan rawan gagal tanam/panen', 0, 946, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (720, 92, 'Tinggal di desa/kelurahan rawan gunung meletus', 0, 939, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (721, 92, 'Tinggal di desa/kelurahan rawan kelaparan', 0, 943, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (722, 92, 'Tinggal di jalur hijau', 0, 929, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (723, 92, 'Tinggal di jalur rawan gempa bumi', 0, 940, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (724, 92, 'Tinggal di kawasan jalur rel kereta api', 0, 930, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (725, 92, 'Tinggal di kawasan jalur sutet', 0, 931, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (726, 92, 'Tinggal di kawasan kumuh dan padat pemukiman', 0, 932, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (727, 92, 'Tinggal di kawasan rawan kebakaran', 0, 942, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (728, 92, 'Tinggal di kawasan rawan tanah longsor', 0, 941, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (729, 94, 'Kepala Keluarga', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (730, 94, 'Suami', 0, 2, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (731, 94, 'Istri', 0, 3, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (732, 94, 'Anak Kandung', 0, 4, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (733, 94, 'Anak Angkat', 0, 5, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (734, 94, 'Ayah', 0, 6, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (735, 94, 'Ibu', 0, 7, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (736, 94, 'Paman', 0, 8, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (737, 94, 'Tante', 0, 9, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (738, 94, 'Kakak', 0, 10, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (739, 94, 'Adik', 0, 11, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (740, 94, 'Kakek', 0, 12, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (741, 94, 'Nenek', 0, 13, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (742, 94, 'Sepupu', 0, 14, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (743, 94, 'Keponakan', 0, 15, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (744, 94, 'Teman', 0, 16, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (745, 94, 'Mertua', 0, 17, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (746, 94, 'Cucu', 0, 18, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (747, 94, 'Famili lain', 0, 19, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (748, 94, 'Menantu', 0, 21, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (749, 94, 'Lainnya', 0, 22, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (750, 94, 'Anak Tiri', 0, 23, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (751, 95, 'Kawin', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (752, 95, 'Belum Kawin', 0, 2, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (753, 95, 'Janda/Duda', 0, 3, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (754, 96, 'Islam', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (755, 96, 'Kristen Protestan', 0, 2, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (756, 96, 'Kristen Katolik', 0, 3, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (757, 96, 'Hindu', 0, 4, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (758, 96, 'Budha', 0, 5, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (759, 96, 'Konghucu', 0, 6, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (760, 96, 'Aliran Kepercayaan Kepada Tuhan YME', 0, 7, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (761, 97, 'O', 0, 0, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (762, 97, 'A', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (763, 97, 'B', 0, 2, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (764, 97, 'AB', 0, 3, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (765, 97, 'Tidak Tahu', 0, 4, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (766, 98, 'Warga Negara Indonesia', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (767, 98, 'Warga Negara Asing', 0, 2, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (768, 98, 'Dwi Kewarganegaraan', 0, 3, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (769, 100, 'Belum masuk TK/Kelompok Bermain', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (770, 100, 'Sedang TK/Kelompok Bermain', 0, 2, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (771, 100, 'Tidak pernah sekolah', 0, 3, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (772, 100, 'Sedang SD/sederajat', 0, 4, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (773, 100, 'Tamat SD/sederajat', 0, 5, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (774, 100, 'Tidak tamat SD/sederajat', 0, 6, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (775, 100, 'Sedang SLTP/Sederajat', 0, 7, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (776, 100, 'Tamat SLTP/sederajat', 0, 8, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (777, 100, 'Sedang SLTA/sederajat', 0, 9, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (778, 100, 'Tamat SLTA/sederajat', 0, 10, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (779, 100, 'Sedang D-1/sederajat', 0, 11, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (780, 100, 'Tamat D-1/sederajat', 0, 12, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (781, 100, 'Sedang D-2/sederajat', 0, 13, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (782, 100, 'Tamat D-2/sederajat', 0, 14, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (783, 100, 'Sedang D-3/sederajat', 0, 15, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (784, 100, 'Tamat D-4/sederajat', 0, 16, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (785, 100, 'Sedang S-1/sederajat', 0, 17, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (786, 100, 'Tamat S-1/sederajat', 0, 18, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (787, 100, 'Sedang S-2/sederajat', 0, 19, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (788, 100, 'Tamat S-2/sederajat', 0, 20, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (789, 100, 'Sedang S-3/sederajat', 0, 21, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (790, 100, 'Tamat S-3/sederajat', 0, 22, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (791, 100, 'Sedang SLB A/sederajat', 0, 23, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (792, 100, 'Tamat SLB A/sederajat', 0, 24, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (793, 100, 'Sedang SLB B/sederajat', 0, 25, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (794, 100, 'Tamat SLB B/sederajat', 0, 26, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (795, 100, 'Sedang SLB C/sederajat', 0, 27, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (796, 100, 'Tamat SLB C/sederajat', 0, 28, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (797, 100, 'Tidak dapat membaca dan menulis huruf Latin/Arab', 0, 29, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (798, 100, 'Tamat D-3/sederajat', 0, 30, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (799, 101, 'Petani', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (800, 101, 'Buruh Tani', 0, 2, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (801, 101, 'Buruh Migran Perempuan', 0, 3, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (802, 101, 'Buruh Migran laki-laki', 0, 4, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (803, 101, 'Pegawai Negeri Sipil', 0, 5, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (804, 101, 'Karyawan Swasta', 0, 6, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (805, 101, 'Pengrajin', 0, 7, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (806, 101, 'Pedagang barang kelontong', 0, 8, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (807, 101, 'Peternak', 0, 9, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (808, 101, 'Nelayan', 0, 10, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (809, 101, 'Montir', 0, 11, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (810, 101, 'Dokter swasta', 0, 12, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (811, 101, 'Perawat swasta', 0, 13, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (812, 101, 'Bidan swasta', 0, 14, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (813, 101, 'Ahli Pengobatan Alternatif', 0, 15, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (814, 101, 'TNI', 0, 16, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (815, 101, 'POLRI', 0, 17, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (816, 101, 'Pengusaha kecil, menengah dan besar', 0, 18, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (817, 101, 'Guru swasta', 0, 19, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (818, 101, 'Dosen swasta', 0, 20, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (819, 101, 'Seniman/artis', 0, 21, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (820, 101, 'Pedagang Keliling', 0, 22, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (821, 101, 'Penambang', 0, 23, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (822, 101, 'Tukang Kayu', 0, 24, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (823, 101, 'Tukang Batu', 0, 25, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (824, 101, 'Tukang cuci', 0, 26, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (825, 101, 'Pembantu rumah tangga', 0, 27, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (826, 101, 'Pengacara', 0, 28, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (827, 101, 'Notaris', 0, 29, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (828, 101, 'Dukun Tradisional', 0, 30, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (829, 101, 'Arsitektur/Desainer', 0, 31, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (830, 101, 'Karyawan Perusahaan Swasta', 0, 32, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (831, 101, 'Karyawan Perusahaan Pemerintah', 0, 33, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (832, 101, 'Wiraswasta', 0, 34, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (833, 101, 'Konsultan Manajemen dan Teknis', 0, 35, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (834, 101, 'Tidak Mempunyai Pekerjaan Tetap', 0, 36, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (835, 101, 'Belum Bekerja', 0, 37, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (836, 101, 'Pelajar', 0, 38, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (837, 101, 'Ibu Rumah Tangga', 0, 39, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (838, 101, 'Purnawirawan/Pensiunan', 0, 40, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (839, 101, 'Perangkat Desa', 0, 41, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (840, 101, 'Buruh Harian Lepas', 0, 42, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (841, 101, 'Pemilik perusahaan', 0, 55, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (842, 101, 'Pengusaha perdagangan hasil bumi', 0, 56, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (843, 101, 'Buruh jasa perdagangan hasil bumi', 0, 57, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (844, 101, 'Pemilik usaha jasa transportasi dan perhubungan', 0, 58, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (845, 101, 'Buruh usaha jasa transportasi dan perhubungan', 0, 59, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (846, 101, 'Pemilik usaha informasi dan komunikasi', 0, 60, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (847, 101, 'Buruh usaha jasa informasi dan komunikasi', 0, 61, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (848, 101, 'Kontraktor', 0, 62, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (849, 101, 'Pemilik usaha jasa hiburan dan pariwisata', 0, 63, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (850, 101, 'Buruh usaha jasa hiburan dan pariwisata', 0, 64, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (851, 101, 'Pemilik usaha hotel dan penginapan lainnya ', 0, 65, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (852, 101, 'Buruh usaha hotel dan penginapan lainnya', 0, 66, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (853, 101, 'Pemilik usaha warung, rumah makan dan restoran', 0, 67, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (854, 101, 'Dukun/paranormal/supranatural', 0, 68, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (855, 101, 'Jasa pengobatan alternatif', 0, 69, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (856, 101, 'Sopir', 0, 70, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (857, 101, 'Usaha jasa pengerah tenaga kerja', 0, 71, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (858, 101, 'Jasa penyewaan peralatan pesta', 0, 74, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (859, 101, 'Pemulung', 0, 75, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (860, 101, 'Pengrajin industri rumah tangga lainnya', 0, 76, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (861, 101, 'Tukang Anyaman', 0, 77, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (862, 101, 'Tukang Jahit', 0, 78, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (863, 101, 'Tukang Kue', 0, 79, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (864, 101, 'Tukang Rias', 0, 80, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (865, 101, 'Tukang Sumur', 0, 81, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (866, 101, 'Jasa Konsultansi Manajemen dan Teknis ', 0, 82, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (867, 101, 'Juru Masak', 0, 83, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (868, 101, 'Karyawan Honorer', 0, 84, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (869, 101, 'Pialang', 0, 85, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (870, 101, 'Pskiater/Psikolog', 0, 86, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (871, 101, 'Wartawan', 0, 87, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (872, 101, 'Tukang Cukur', 0, 88, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (873, 101, 'Tukang Las', 0, 89, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (874, 101, 'Tukang Gigi', 0, 90, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (875, 101, 'Tukang Listrik', 0, 91, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (876, 101, 'Pemuka Agama', 0, 92, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (877, 101, 'Anggota Legislatif', 0, 93, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (878, 101, 'Kepala Daerah', 0, 94, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (879, 101, 'Apoteker', 0, 96, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (880, 101, 'Presiden', 0, 97, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (881, 101, 'Wakil presiden', 0, 98, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (882, 101, 'Anggota Mahkamah Konstitusi', 0, 99, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (883, 101, 'Anggota Kabinet Kementrian', 0, 100, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (884, 101, 'Duta besar', 0, 101, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (885, 101, 'Gubernur', 0, 102, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (886, 101, 'Wakil bupati', 0, 103, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (887, 101, 'Pilot', 0, 104, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (888, 101, 'Penyiar radio', 0, 105, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (889, 101, 'Pelaut', 0, 106, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (890, 101, 'Peneliti', 0, 107, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (891, 101, 'Satpam/Security', 0, 108, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (892, 101, 'Wakil Gubernur', 0, 109, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (893, 101, 'Bupati/Walikota', 0, 110, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (894, 101, 'Akuntan', 0, 112, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (895, 104, 'Menggunakan alat kontrasepsi Suntik', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (896, 104, 'Menggunakan alat kontrasepsi Spiral', 0, 2, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (897, 104, 'Menggunakan alat kontrasepsi Kondom', 0, 3, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (898, 104, 'Menggunakan alat kontrasepsi vasektomi', 0, 4, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (899, 104, 'Menggunakan alat kontrasepsi Tubektomi', 0, 5, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (900, 104, 'Menggunakan alat kontrasepsi Pil', 0, 6, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (901, 104, 'Menggunakan metode KB Alamiah/Kalender', 0, 7, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (902, 104, 'Menggunakan obat tradisional', 0, 8, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (903, 104, 'Tidak Menggunakan alat kontrasepsi /metode KBA', 0, 9, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (904, 104, 'Susuk KB (Implant)', 0, 10, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (905, 104, 'Tidak Menjawab', 0, 11, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (906, 105, 'Tuna Rungu', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (907, 105, 'Tuna Wicara', 0, 2, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (908, 105, 'Tuna Netra', 0, 3, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (909, 105, 'Lumpuh', 0, 4, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (910, 105, 'Sumbing', 0, 5, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (911, 106, 'Idiot', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (912, 106, 'Gila', 0, 2, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (913, 106, 'Stress', 0, 3, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (914, 107, 'Wajib Pajak Bumi dan Bangunan', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (915, 107, 'Wajib Pajak Penghasilan Perorangan', 0, 2, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (916, 107, 'Wajib Pajak Badan/Perusahaan', 0, 3, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (917, 107, 'Wajib Pajak Kendaraan Bermotor', 0, 4, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (918, 107, 'Wajib Retribusi Kebersihan', 0, 5, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (919, 107, 'Wajib Retribusi Keamanan', 0, 6, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (920, 108, 'Kepala Desa/Lurah', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (921, 108, 'Sekretaris Desa/Kelurahan', 0, 2, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (922, 108, 'Kepala Urusan', 0, 3, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (923, 108, 'Kepala Dusun/Lingkungan', 0, 4, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (924, 108, 'Staf Desa/Kelurahan', 0, 5, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (925, 108, 'Ketua BPD', 0, 6, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (926, 108, 'Wakil Ketua BPD', 0, 7, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (927, 108, 'Sekretaris BPD', 0, 8, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (928, 108, 'Anggota BPD', 0, 9, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (929, 109, 'Pengurus RT', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (930, 109, 'Anggota Pengurus RT', 0, 2, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (931, 109, 'Pengurus RW', 0, 3, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (932, 109, 'Anggota Pengurus RW', 0, 4, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (933, 109, 'Pengurus LKMD/K/LPM', 0, 5, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (934, 109, 'Anggota LKMD/K/LPM', 0, 6, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (935, 109, 'Pengurus PKK', 0, 7, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (936, 109, 'Anggota PKK', 0, 8, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (937, 109, 'Pengurus Lembaga Adat', 0, 9, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (938, 109, 'Pengurus Karang Taruna', 0, 10, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (939, 109, 'Anggota Karang Taruna', 0, 11, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (940, 109, 'Pengurus Hansip/Linmas', 0, 12, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (941, 109, 'Pengurus Poskamling', 0, 13, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (942, 109, 'Pengurus Organisasi Perempuan', 0, 14, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (943, 109, 'Anggota Organisasi Perempuan', 0, 15, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (944, 109, 'Pengurus Organisasi Bapak-bapak', 0, 16, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (945, 109, 'Anggota Organisasi Bapak-bapak', 0, 17, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (946, 109, 'Pengurus Organisasi keagamaan', 0, 18, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (947, 109, 'Anggota Organisasi keagamaan', 0, 19, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (948, 109, 'Pengurus Organisasi profesi wartawan', 0, 20, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (949, 109, 'Anggota Organisasi profesi wartawan', 0, 21, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (950, 109, 'Pengurus Posyandu', 0, 22, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (951, 109, 'Pengurus Posyantekdes', 0, 23, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (952, 109, 'Pengurus Organisasi Kelompok Tani/Nelayan', 0, 24, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (953, 109, 'Anggota Organisasi Kelompok Tani/Nelayan', 0, 25, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (954, 109, 'Pengurus Lembaga Gotong royong', 0, 26, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (955, 109, 'Anggota Lembaga Gotong royong', 0, 27, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (956, 109, 'Pengurus Organisasi Profesi guru', 0, 28, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (957, 109, 'Anggota Organisasi Profesi guru', 0, 29, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (958, 109, 'Pengurus Organisasi profesi dokter/tenaga medis', 0, 30, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (959, 109, 'Anggota Organisasi profesi/tenaga medis', 0, 31, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (960, 109, 'Pengurus organisasi pensiunan', 0, 32, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (961, 109, 'Anggota organisasi pensiunan', 0, 33, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (962, 109, 'Pengurus organisasi pemirsa/pendengar', 0, 34, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (963, 109, 'Anggota organisasi pemirsa/pendengar', 0, 35, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (964, 109, 'Pengurus lembaga pencinta alam', 0, 36, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (965, 109, 'Anggota organisasi pencinta alam', 0, 37, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (966, 109, 'Pengurus organisasi pengembangan ilmu pengetahuan', 0, 38, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (967, 109, 'Anggota organisasi pengembangan ilmu pengetaahuan', 0, 39, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (968, 109, 'Pemilik yayasan', 0, 40, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (969, 109, 'Pengurus yayasan', 0, 41, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (970, 109, 'Anggota yayasan', 0, 42, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (971, 109, 'Pengurus Satgas Kebersihan', 0, 43, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (972, 109, 'Anggota Satgas Kebersihan', 0, 44, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (973, 109, 'Pengurus Satgas Kebakaran', 0, 45, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (974, 109, 'Anggota Satgas Kebakaran', 0, 46, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (975, 109, 'Pengurus Posko Penanggulangan Bencana', 0, 47, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (976, 109, 'Anggota Tim Penanggulangan Bencana', 0, 48, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (977, 110, 'Koperasi', 0, 1, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (978, 110, 'Unit Usaha Simpan Pinjam', 0, 2, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (979, 110, 'Industri Kerajinan Tangan', 0, 3, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (980, 110, 'Industri Pakaian', 0, 4, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (981, 110, 'Industri Usaha Makanan', 0, 5, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (982, 110, 'Industri Alat Rumah Tangga', 0, 6, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (983, 110, 'Industri Usaha Bahan Bangunan', 0, 7, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (984, 110, 'Industri Alat Pertanian', 0, 8, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (985, 110, 'Restoran', 0, 9, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (986, 110, 'Toko/ Swalayan', 0, 10, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (987, 110, 'Warung Kelontongan/Kios', 0, 11, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (988, 110, 'Angkutan Darat', 0, 12, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (989, 110, 'Angkutan Sungai', 0, 13, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (990, 110, 'Angkutan Laut', 0, 14, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (991, 110, 'Angkutan Udara', 0, 15, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (992, 110, 'Jasa Ekspedisi/Pengiriman Barang', 0, 16, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (993, 110, 'Tukang Sumur', 0, 17, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (994, 110, 'Usaha Pasar Harian', 0, 18, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (995, 110, 'Usaha Pasar Mingguan', 0, 19, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (996, 110, 'Usaha Pasar Ternak', 0, 20, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (997, 110, 'Usaha Pasar Hasil Bumi Dan Tambang', 0, 21, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (998, 110, 'Usaha Perdagangan Antar Pulau', 0, 22, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (999, 110, 'Pengijon', 0, 23, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1000, 110, 'Pedagang Pengumpul/Tengkulak', 0, 24, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1001, 110, 'Usaha Peternakan', 0, 25, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1002, 110, 'Usaha Perikanan', 0, 26, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1003, 110, 'Usaha Perkebunan', 0, 27, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1004, 110, 'Kelompok Simpan Pinjam', 0, 28, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1005, 110, 'Usaha Minuman', 0, 29, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1006, 110, 'Industri Farmasi', 0, 30, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1007, 110, 'Industri Karoseri', 0, 31, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1008, 110, 'Penitipan Kendaraan Bermotor', 0, 32, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1009, 110, 'Industri Perakitan Elektronik', 0, 33, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1010, 110, 'Pengolahan Kayu', 0, 34, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1011, 110, 'Bioskop', 0, 35, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1012, 110, 'Film Keliling', 0, 36, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1013, 110, 'Sandiwara/Drama', 0, 37, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1014, 110, 'Group Lawak', 0, 38, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1015, 110, 'Jaipongan', 0, 39, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1016, 110, 'Wayang Orang/Golek', 0, 40, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1017, 110, 'Group Musik/Band', 0, 41, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1018, 110, 'Group Vokal/Paduan Suara', 0, 42, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1019, 110, 'Usaha Persewaan Tenaga Listrik', 0, 43, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1020, 110, 'Usaha Pengecer Gas Dan Bahan Bakar Minyak', 0, 44, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1021, 110, 'Usaha Air Minum Dalam Kemasan', 0, 45, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1022, 110, 'Tukang Kayu', 0, 46, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1023, 110, 'Tukang Batu', 0, 47, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1024, 110, 'Tukang Jahit/Bordir', 0, 48, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1025, 110, 'Tukang Cukur', 0, 49, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1026, 110, 'Tukang Service Elektronik', 0, 50, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1027, 110, 'Tukang Besi', 0, 51, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1028, 110, 'Tukang Pijat/Urut', 0, 52, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1029, 110, 'Tukang Sumur', 0, 53, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1030, 110, 'Notaris', 0, 54, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1031, 110, 'Pengacara/Advokat', 0, 55, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1032, 110, 'Konsultan Manajemen', 0, 56, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1033, 110, 'Konsultan Teknis', 0, 57, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1034, 110, 'Pejabat Pembuat Akta Tanah', 0, 58, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1035, 110, 'Losmen', 0, 59, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1036, 110, 'Wisma', 0, 60, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1037, 110, 'Asrama', 0, 61, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1038, 110, 'Persewaan Kamar', 0, 62, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1039, 110, 'Kontrakan Rumah', 0, 63, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1040, 110, 'Mess', 0, 64, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1041, 110, 'Hotel', 0, 65, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1042, 110, 'Home Stay', 0, 66, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1043, 110, 'Villa', 0, 67, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1044, 110, 'Town House', 0, 68, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1045, 110, 'Usaha Asuransi', 0, 69, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1046, 110, 'Lembaga Keuangan Bukan Bank', 0, 70, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1047, 110, 'Lembaga Perkreditan Rakyat', 0, 71, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1048, 110, 'Pegadaian', 0, 72, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1049, 110, 'Bank Perkreditan Rakyat', 0, 73, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1050, 110, 'Usaha Penyewaan Alat Pesta', 0, 74, 1);
INSERT INTO `analisis_parameter` (`id`, `id_indikator`, `jawaban`, `nilai`, `kode_jawaban`, `asign`) VALUES (1051, 110, 'Usaha Pengolahan dan Penjualan Hasil Hutan', 0, 75, 1);


#
# TABLE STRUCTURE FOR: analisis_partisipasi
#

DROP TABLE IF EXISTS `analisis_partisipasi`;

CREATE TABLE `analisis_partisipasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_subjek` int(11) NOT NULL,
  `id_master` int(11) NOT NULL,
  `id_periode` int(11) NOT NULL,
  `id_klassifikasi` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `id_subjek` (`id_subjek`,`id_master`,`id_periode`,`id_klassifikasi`),
  KEY `id_master` (`id_master`),
  KEY `id_periode` (`id_periode`),
  KEY `id_klassifikasi` (`id_klassifikasi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: analisis_periode
#

DROP TABLE IF EXISTS `analisis_periode`;

CREATE TABLE `analisis_periode` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_master` int(11) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `id_state` tinyint(4) NOT NULL DEFAULT '1',
  `aktif` tinyint(1) NOT NULL DEFAULT '0',
  `keterangan` varchar(100) NOT NULL,
  `tahun_pelaksanaan` year(4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_master` (`id_master`),
  KEY `id_state` (`id_state`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO `analisis_periode` (`id`, `id_master`, `nama`, `id_state`, `aktif`, `keterangan`, `tahun_pelaksanaan`) VALUES (1, 2, 'Pendataan 2014', 2, 2, 'ket', '2014');
INSERT INTO `analisis_periode` (`id`, `id_master`, `nama`, `id_state`, `aktif`, `keterangan`, `tahun_pelaksanaan`) VALUES (2, 2, 'Pendataan 2015', 1, 1, 'nnn', '2015');
INSERT INTO `analisis_periode` (`id`, `id_master`, `nama`, `id_state`, `aktif`, `keterangan`, `tahun_pelaksanaan`) VALUES (3, 3, 'Data Dasar Keluarga ', 1, 1, 'Pendataan Profil Desa', '2018');
INSERT INTO `analisis_periode` (`id`, `id_master`, `nama`, `id_state`, `aktif`, `keterangan`, `tahun_pelaksanaan`) VALUES (4, 4, 'Data Anggota Keluarga', 1, 1, 'Pendataan Profil Desa', '2018');


#
# TABLE STRUCTURE FOR: analisis_ref_state
#

DROP TABLE IF EXISTS `analisis_ref_state`;

CREATE TABLE `analisis_ref_state` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `nama` varchar(40) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `analisis_ref_state` (`id`, `nama`) VALUES (1, 'Belum Entri / Pendataan');
INSERT INTO `analisis_ref_state` (`id`, `nama`) VALUES (2, 'Sedang Dalam Pendataan');
INSERT INTO `analisis_ref_state` (`id`, `nama`) VALUES (3, 'Selesai Entri / Pendataan');


#
# TABLE STRUCTURE FOR: analisis_ref_subjek
#

DROP TABLE IF EXISTS `analisis_ref_subjek`;

CREATE TABLE `analisis_ref_subjek` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `subjek` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `analisis_ref_subjek` (`id`, `subjek`) VALUES (1, 'Penduduk');
INSERT INTO `analisis_ref_subjek` (`id`, `subjek`) VALUES (2, 'Keluarga / KK');
INSERT INTO `analisis_ref_subjek` (`id`, `subjek`) VALUES (3, 'Rumah Tangga');
INSERT INTO `analisis_ref_subjek` (`id`, `subjek`) VALUES (4, 'Kelompok');


#
# TABLE STRUCTURE FOR: analisis_respon
#

DROP TABLE IF EXISTS `analisis_respon`;

CREATE TABLE `analisis_respon` (
  `id_indikator` int(11) NOT NULL,
  `id_parameter` int(11) NOT NULL,
  `id_subjek` int(11) NOT NULL,
  `id_periode` int(11) NOT NULL,
  KEY `id_parameter` (`id_parameter`,`id_subjek`),
  KEY `id_periode` (`id_periode`),
  KEY `id_indikator` (`id_indikator`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `analisis_respon` (`id_indikator`, `id_parameter`, `id_subjek`, `id_periode`) VALUES (1, 1, 1, 2);
INSERT INTO `analisis_respon` (`id_indikator`, `id_parameter`, `id_subjek`, `id_periode`) VALUES (2, 6, 1, 2);
INSERT INTO `analisis_respon` (`id_indikator`, `id_parameter`, `id_subjek`, `id_periode`) VALUES (1, 3, 2, 2);
INSERT INTO `analisis_respon` (`id_indikator`, `id_parameter`, `id_subjek`, `id_periode`) VALUES (2, 5, 2, 2);
INSERT INTO `analisis_respon` (`id_indikator`, `id_parameter`, `id_subjek`, `id_periode`) VALUES (1, 2, 3, 2);
INSERT INTO `analisis_respon` (`id_indikator`, `id_parameter`, `id_subjek`, `id_periode`) VALUES (2, 4, 3, 2);
INSERT INTO `analisis_respon` (`id_indikator`, `id_parameter`, `id_subjek`, `id_periode`) VALUES (1, 2, 4, 2);
INSERT INTO `analisis_respon` (`id_indikator`, `id_parameter`, `id_subjek`, `id_periode`) VALUES (2, 4, 4, 2);


#
# TABLE STRUCTURE FOR: analisis_respon_bukti
#

DROP TABLE IF EXISTS `analisis_respon_bukti`;

CREATE TABLE `analisis_respon_bukti` (
  `id_master` tinyint(4) NOT NULL,
  `id_periode` tinyint(4) NOT NULL,
  `id_subjek` int(11) NOT NULL,
  `pengesahan` varchar(100) NOT NULL,
  `tgl_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: analisis_respon_hasil
#

DROP TABLE IF EXISTS `analisis_respon_hasil`;

CREATE TABLE `analisis_respon_hasil` (
  `id_master` tinyint(4) NOT NULL,
  `id_periode` tinyint(4) NOT NULL,
  `id_subjek` int(11) NOT NULL,
  `akumulasi` double(8,3) NOT NULL,
  `tgl_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  UNIQUE KEY `id_master` (`id_master`,`id_periode`,`id_subjek`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `analisis_respon_hasil` (`id_master`, `id_periode`, `id_subjek`, `akumulasi`, `tgl_update`) VALUES (2, 1, 129, '25.000', '2018-08-20 05:13:33');
INSERT INTO `analisis_respon_hasil` (`id_master`, `id_periode`, `id_subjek`, `akumulasi`, `tgl_update`) VALUES (2, 1, 254, '5.000', '2018-08-20 05:13:33');
INSERT INTO `analisis_respon_hasil` (`id_master`, `id_periode`, `id_subjek`, `akumulasi`, `tgl_update`) VALUES (2, 1, 298, '17.000', '2018-08-20 05:13:33');
INSERT INTO `analisis_respon_hasil` (`id_master`, `id_periode`, `id_subjek`, `akumulasi`, `tgl_update`) VALUES (2, 1, 304, '17.000', '2018-08-20 05:13:33');
INSERT INTO `analisis_respon_hasil` (`id_master`, `id_periode`, `id_subjek`, `akumulasi`, `tgl_update`) VALUES (2, 1, 308, '21.000', '2018-08-20 05:13:33');
INSERT INTO `analisis_respon_hasil` (`id_master`, `id_periode`, `id_subjek`, `akumulasi`, `tgl_update`) VALUES (2, 1, 309, '9.000', '2018-08-20 05:13:33');
INSERT INTO `analisis_respon_hasil` (`id_master`, `id_periode`, `id_subjek`, `akumulasi`, `tgl_update`) VALUES (2, 2, 1, '25.000', '2018-08-20 05:15:33');
INSERT INTO `analisis_respon_hasil` (`id_master`, `id_periode`, `id_subjek`, `akumulasi`, `tgl_update`) VALUES (2, 2, 2, '13.000', '2018-08-20 05:15:50');
INSERT INTO `analisis_respon_hasil` (`id_master`, `id_periode`, `id_subjek`, `akumulasi`, `tgl_update`) VALUES (2, 2, 3, '8.000', '2018-08-20 05:16:04');
INSERT INTO `analisis_respon_hasil` (`id_master`, `id_periode`, `id_subjek`, `akumulasi`, `tgl_update`) VALUES (2, 2, 4, '8.000', '2018-08-20 05:16:23');
INSERT INTO `analisis_respon_hasil` (`id_master`, `id_periode`, `id_subjek`, `akumulasi`, `tgl_update`) VALUES (2, 2, 129, '5.000', '2018-08-20 05:14:24');
INSERT INTO `analisis_respon_hasil` (`id_master`, `id_periode`, `id_subjek`, `akumulasi`, `tgl_update`) VALUES (2, 2, 254, '25.000', '2018-08-20 05:14:24');
INSERT INTO `analisis_respon_hasil` (`id_master`, `id_periode`, `id_subjek`, `akumulasi`, `tgl_update`) VALUES (2, 2, 298, '24.000', '2018-08-20 05:14:24');
INSERT INTO `analisis_respon_hasil` (`id_master`, `id_periode`, `id_subjek`, `akumulasi`, `tgl_update`) VALUES (2, 2, 304, '21.000', '2018-08-20 05:14:24');
INSERT INTO `analisis_respon_hasil` (`id_master`, `id_periode`, `id_subjek`, `akumulasi`, `tgl_update`) VALUES (2, 2, 308, '24.000', '2018-08-20 05:14:24');
INSERT INTO `analisis_respon_hasil` (`id_master`, `id_periode`, `id_subjek`, `akumulasi`, `tgl_update`) VALUES (2, 2, 309, '21.000', '2018-08-20 05:14:24');


#
# TABLE STRUCTURE FOR: analisis_tipe_indikator
#

DROP TABLE IF EXISTS `analisis_tipe_indikator`;

CREATE TABLE `analisis_tipe_indikator` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `tipe` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO `analisis_tipe_indikator` (`id`, `tipe`) VALUES (1, 'Pilihan (Tunggal)');
INSERT INTO `analisis_tipe_indikator` (`id`, `tipe`) VALUES (2, 'Pilihan (Multivalue)');
INSERT INTO `analisis_tipe_indikator` (`id`, `tipe`) VALUES (3, 'Isian Angka');
INSERT INTO `analisis_tipe_indikator` (`id`, `tipe`) VALUES (4, 'Isian Tulisan');


#
# TABLE STRUCTURE FOR: area
#

DROP TABLE IF EXISTS `area`;

CREATE TABLE `area` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `nama` varchar(50) NOT NULL,
  `path` text,
  `enabled` int(11) NOT NULL DEFAULT '1',
  `ref_polygon` int(9) NOT NULL,
  `foto` varchar(100) DEFAULT NULL,
  `id_cluster` int(11) DEFAULT NULL,
  `desk` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO `area` (`id`, `nama`, `path`, `enabled`, `ref_polygon`, `foto`, `id_cluster`, `desk`) VALUES (1, 'Area 1', '[[[-8.478525723657054,116.05240345001222],[-8.477591903247376,116.04287624359132],[-8.481412063305804,116.04055881500244],[-8.484553055345845,116.04768276214601]]]', 1, 3, '', 0, 'Area 1');
INSERT INTO `area` (`id`, `nama`, `path`, `enabled`, `ref_polygon`, `foto`, `id_cluster`, `desk`) VALUES (2, 'Area 2', '[[[-8.494865867509324,116.05296134948732],[-8.501487264597221,116.0522747039795],[-8.501147708551757,116.04626655578615],[-8.491130670045568,116.0412883758545]]]', 1, 0, '', 0, 'Area 2');


#
# TABLE STRUCTURE FOR: artikel
#

DROP TABLE IF EXISTS `artikel`;

CREATE TABLE `artikel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gambar` varchar(200) DEFAULT NULL,
  `isi` text NOT NULL,
  `enabled` int(2) NOT NULL DEFAULT '1',
  `tgl_upload` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `id_kategori` int(4) NOT NULL,
  `id_user` int(4) NOT NULL,
  `judul` varchar(100) NOT NULL,
  `headline` int(1) NOT NULL DEFAULT '0',
  `gambar1` varchar(200) DEFAULT NULL,
  `gambar2` varchar(200) DEFAULT NULL,
  `gambar3` varchar(200) DEFAULT NULL,
  `dokumen` varchar(400) DEFAULT NULL,
  `link_dokumen` varchar(200) DEFAULT NULL,
  `boleh_komentar` tinyint(1) NOT NULL DEFAULT '1',
  `slug` varchar(200) DEFAULT NULL,
  `hit` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8;

INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (7, '', '<p><strong>Awal mula SID</strong><br /> \"Awalnya ada keinginan dari pemerintah Desa Balerante yang berharap pelayanan pemerintah desa bisa seperti pengunjung rumah sakit yang ingin mencari data pasien rawat inap, tinggal ketik nama di komputer, maka data tersebut akan keluar\"<br /> (Mart Widarto, pengelola Program Lumbung Komunitas)<br /> Program ini mulai dibuat dari awal 2006: <br /> 1. (2006) komunitas melakukan komunikasi dan diskusi lepas tentang sebuah sistem yang bisa digunakan untuk menyimpan data.<br /> 2. (2008) Rangkaian FDG dengan pemerintah desa membahas tentang tata kelola pendokumentasian di desa<br /> 3. (2009) Ujicoba SID yang sudah dikembangkan di balerante<br /> 4. (2009-2010) Membangun SID (aplikasi) dibeberapa desa yang lain: terong (bantul), Nglegi (Gunungkidul) <br /> 5. (2011) Kandangan (Temanggung) Gilangharjo (bantul) Girikarto (gunungkidul) Talun (klaten) Pager Gunung (magelang) <br /> 6. hingga saat ini 2013 sudah banyak desa pengguna SID.<br /> <br /> <strong>SID sebagai tanggapan atas kebutuhan:</strong><br /> Kalau dulu untuk mencari data penduduk menurut kelompok umur saja kesulitan karena tidak mempunyai databasenya. Dengan adanya SID menjadi lebih mudah.<br /> (Nuryanto, Kabag Pelayanan Pemdes Terong)<br /> <br /> Membangun sebuah sistem bukan hanya membuatkan software dan meninggalkan begitu saja, namun ada upaya untuk memadukan sistem dengan kebutuhan yang ada pada desa. sehingga software dapat memenuhi kebutuhan yang telah ada bukan memaksakan desa untuk mengikuti dan berpindah sistem. inilah yang melatari combine melaksanakan alur pengaplikasian software.<br /> 1. Bentuk tim kerja bersama pemerintah desa<br /> 2. Diskusikan basis data apa saja yang diperlukan untuk warga<br /> 3. Himpun data kependudukan warga dari Kartu Keluarga (KK)<br /> 4. Daftarkan proyek SID dan dapatkan aplikasi softwarenya di http://abcd.lumbungkomunitas.net<br /> 5. Install aplikasi software SID di komputer desa<br /> 6. Entry data penduduk ke SID<br /> 7. Basis data kependudukan sudah bisa dimanfaatkan<br /> 8. Diskusikan rencana pengembangan SID sesuai kebutuhan desa<br /> 9. Sebarluaskan informasi desa melalui beragam media untuk warga<br /> <br /> Pemberdayaan data desa yang dibangun diharapkan dapat menjunjung kesejahteraan masyarakat desa, data-data tersebut dapat diperuntukkan untuk riset lebih lanjut tentang kemiskinan, tanggap bencana, sumberdaya desa yang bisa diekspose keluar dan dengan menghubungkan dari desa ke desa dapat mencontohkan banyak hal dalam keberhasilan pemberdayaannya.<br /> (sumber: Buku Sistem Informasi Desa) <br /> <strong><br /></strong></p>', 1, '2013-03-31 20:31:04', 999, 1, 'Awal mula SID', 0, '', '', '', '', '', 1, 'awal-mula-sid', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (32, '', '<div class=\"contentText\">\r\n<div align=\"justify\">Bagian ini berisi informasi dasar mengenai desa kami. Sila klik pada tautan berikut untuk mendapatkan informasi yang lebih rinci.</div>\r\n<div align=\"justify\">&nbsp;</div>\r\n<div align=\"justify\"><ol>\r\n<li>Sejarah Desa</li>\r\n<li>Profil Wilayah Desa</li>\r\n<li>Profil Masyarakat Desa</li>\r\n<li>Profil Potensi Desa</li>\r\n</ol></div>\r\n</div>', 1, '2013-07-29 17:46:44', 999, 1, 'Profil Desa', 0, '', '', '', '', '', 1, 'profil-desa', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (34, '', '<p style=\"text-align: justify;\"><span style=\"color: #ff0000;\"><strong>Contoh (Sila edit halaman ini sesuai dengan deskripsi desa ini)!</strong></span></p>\r\n<p style=\"text-align: justify;\">Berdasarkan data desa pada bulan Februari 2010, jumlah penduduk Desa Terong sebanyak 6484 orang. Jumlah Kepala Keluarga (KK) sebanyak 1605 KK.</p>\r\n<p style=\"text-align: justify;\">Jumlah penduduk Desa Terong usia produktif pada tahun 2009 adalah 4746 orang. Jumlah angkatan kerja tersebut jika dilihat berdasarkan tingkat pendidikannya adalah sebagai berikut:</p>\r\n<table style=\"width: 100%;\" border=\"1\" cellspacing=\"0\" cellpadding=\"4\">\r\n<tbody>\r\n<tr valign=\"top\">\r\n<td style=\"width: 8%;\">\r\n<p style=\"text-align: center;\"><strong>No.</strong></p>\r\n</td>\r\n<td style=\"width: 42%;\">\r\n<p style=\"text-align: center;\"><strong>Angkatan Kerja</strong></p>\r\n</td>\r\n<td style=\"width: 17%;\">\r\n<p style=\"text-align: center;\"><strong>L</strong></p>\r\n</td>\r\n<td style=\"width: 18%;\">\r\n<p style=\"text-align: center;\"><strong>P</strong></p>\r\n</td>\r\n<td style=\"width: 15%;\">\r\n<p style=\"text-align: center;\"><strong>Jumlah</strong></p>\r\n</td>\r\n</tr>\r\n<tr valign=\"top\">\r\n<td style=\"width: 8%;\">\r\n<p style=\"text-align: center;\">1</p>\r\n</td>\r\n<td style=\"width: 42%;\">Tidak Tamat SD</td>\r\n<td style=\"width: 17%;\">\r\n<p style=\"text-align: center;\">59</p>\r\n</td>\r\n<td style=\"width: 18%;\">\r\n<p style=\"text-align: center;\">56</p>\r\n</td>\r\n<td style=\"width: 15%;\">\r\n<p style=\"text-align: center;\">115</p>\r\n</td>\r\n</tr>\r\n<tr valign=\"top\">\r\n<td style=\"width: 8%;\">\r\n<p style=\"text-align: center;\">2</p>\r\n</td>\r\n<td style=\"width: 42%;\">SD</td>\r\n<td style=\"width: 17%;\">\r\n<p style=\"text-align: center;\">880</p>\r\n</td>\r\n<td style=\"width: 18%;\">\r\n<p style=\"text-align: center;\">792</p>\r\n</td>\r\n<td style=\"width: 15%;\">\r\n<p style=\"text-align: center;\">1672</p>\r\n</td>\r\n</tr>\r\n<tr valign=\"top\">\r\n<td style=\"width: 8%;\">\r\n<p style=\"text-align: center;\">3</p>\r\n</td>\r\n<td style=\"width: 42%;\">SLTP</td>\r\n<td style=\"width: 17%;\">\r\n<p style=\"text-align: center;\">813</p>\r\n</td>\r\n<td style=\"width: 18%;\">\r\n<p style=\"text-align: center;\">683</p>\r\n</td>\r\n<td style=\"width: 15%;\">\r\n<p style=\"text-align: center;\">1496</p>\r\n</td>\r\n</tr>\r\n<tr valign=\"top\">\r\n<td style=\"width: 8%;\">\r\n<p style=\"text-align: center;\">4</p>\r\n</td>\r\n<td style=\"width: 42%;\">SLTA</td>\r\n<td style=\"width: 17%;\">\r\n<p style=\"text-align: center;\">725</p>\r\n</td>\r\n<td style=\"width: 18%;\">\r\n<p style=\"text-align: center;\">673</p>\r\n</td>\r\n<td style=\"width: 15%;\">\r\n<p style=\"text-align: center;\">1398</p>\r\n</td>\r\n</tr>\r\n<tr valign=\"top\">\r\n<td style=\"width: 8%;\">\r\n<p style=\"text-align: center;\">5</p>\r\n</td>\r\n<td style=\"width: 42%;\">Akademi</td>\r\n<td style=\"width: 17%;\">\r\n<p style=\"text-align: center;\">13</p>\r\n</td>\r\n<td style=\"width: 18%;\">\r\n<p style=\"text-align: center;\">11</p>\r\n</td>\r\n<td style=\"width: 15%;\">\r\n<p style=\"text-align: center;\">24</p>\r\n</td>\r\n</tr>\r\n<tr valign=\"top\">\r\n<td style=\"width: 8%;\">\r\n<p style=\"text-align: center;\">6</p>\r\n</td>\r\n<td style=\"width: 42%;\">Perguruan Tinggi</td>\r\n<td style=\"width: 17%;\">\r\n<p style=\"text-align: center;\">23</p>\r\n</td>\r\n<td style=\"width: 18%;\">\r\n<p style=\"text-align: center;\">18</p>\r\n</td>\r\n<td style=\"width: 15%;\">\r\n<p style=\"text-align: center;\">41</p>\r\n</td>\r\n</tr>\r\n<tr valign=\"top\">\r\n<td style=\"width: 50%;\" colspan=\"2\">\r\n<p style=\"text-align: center;\">Jumlah Total</p>\r\n</td>\r\n<td style=\"width: 17%;\">\r\n<p style=\"text-align: center;\">2513</p>\r\n</td>\r\n<td style=\"width: 18%;\">\r\n<p style=\"text-align: center;\">2233</p>\r\n</td>\r\n<td style=\"width: 15%;\">\r\n<p style=\"text-align: center;\">4746</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p style=\"text-align: justify;\">&nbsp;</p>\r\n<p style=\"text-align: justify;\"><strong>Profil sosial masyarakat</strong></p>\r\n<p style=\"text-align: justify;\">Dalam aktivitas keseharian, masyarakat Desa Terong sangat taat dalam menjalankan ibadah keagamaan. Setiap Rukung Tetangga (RT) dan pedukuhan memiliki kelompok-kelompok pengajian. Pada peringatan hari besar Islam, penduduk Desa Terong kerap menggelar acara peringatan dan karnaval budaya dengan tema yang disesuaikan dengan hari besar keagamaan. Sebagian besar warga Desa Terong terafiliasi pada organisasi kemasyarakat Islam Muhammadiyah.</p>\r\n<p style=\"text-align: justify;\">Gelaran perayaan lain selalu dilakukan dalam rangka memperingati Hari Kemerdekaan Republik Indonesia. Setiap pedukuhan akan turut serta dan semangat menampilkan ciri khasnya dalam acara peringatan dan karnaval budaya.</p>\r\n<p style=\"text-align: justify;\">Kelompok pemuda di Desa Terong yang tergabung dalam kelompok pegiat Karang Taruna menjadi aktor utama dalam banyak kegiatan desa. Kelompok ini aktif menggelar program kegiatan untuk isu demokrasi kepada warga, penguatan ekonomi produktif, pelatihan penanggulangan bencana, dan kampanye Gerakan Remaja Sayang Ibu (GEMAS).</p>\r\n<p style=\"text-align: justify;\">Sejumlah penduduk Desa Terong bekerja merantau di daerah di luar Yogyakarta. Namun, ikatan sosial mereka terhadap tanah kelahiran tetap tinggi. Penduduk asli Desa Terong yang tinggal di Jakarta dan sekitarnya misalnya, mereka membentuk paguyuban untuk memelihara silaturahmi antar sesama warga perantauan. Setiap bulan diadakan kegiatan arisan keliling secara bergilir di setiap tempat anggotanya. Setiap dua tahun sekali diadakan pula kegiatan mudik bersama ke kampung halaman di Desa Terong</p>\r\n<p style=\"text-align: justify;\">&nbsp;</p>\r\n<p style=\"text-align: justify;\">&nbsp;</p>\r\n<p style=\"text-align: justify;\"><strong>Profil politik masyarakat</strong></p>\r\n<p style=\"text-align: justify;\">Warga Desa Terong dikenal sebagai kelompok masyarakat yang paling aktif dan memiliki potensi tertinggi untuk berpartisipasi dalam pemberian suara untuk Pemilihan Umum dan Pemilihan Kepala Daerah Langsung. Tingkat partisipasi warga di desa ini terbanyak jika dibandingkan dengan desa lain di Kecamatan Dlingo, Bantul.</p>\r\n<p style=\"text-align: justify;\">Warga Desa Terong sangat aktif dalam mengawal proses penyusunan Rancangan Undang-Undang (RUU) Keistimewaan Yogyakarta. Banyak warga Desa Terong yang tergabung dalam Gerakan Rakyat Yogyakarta (GRY) dan aktif dalam beragam kegiatan serta demontrasi mendukung penetapan keistimewaan Yogyakarta. Kepala Desa Terong Sudirman Alfian merupakan Ketua Paguyuban Lurah dan Pamong Desa Ing Sedya Memetri Asrining Yogyakarta (ISMAYA) se Daerah Istimewa Yogyakarta (DIY). Beliau ditunjuk pula sebagai anggota tim perumus RUU Keistimewaan Yogyakarta bersi masyarakat Yogyakarta. Salah satu hal yang diperjuangkan dalam RUU tersebut adalah tidak adanya pelaksanaan pemilihan kepala daerah langsung dalam pemilihan Gubernur DIY; dengan mempertahankan konsep dwi tunggal Sri Sultan Hamengku Buwono dan Paku Alam sebagai Gubernur dan Wakil Bubernur DIY.</p>\r\n<p style=\"text-align: justify;\">Permasalahan mendasar yang ada di Desa Terong adalah tidak imbangnya jumlah pencari kerja dengan jumlah lapangan kerja yang tersedia. Sekalipun jumlah pengangguran di Desa Terong pada Tahun 2009 hanya orang tetapi kebanyakan mereka bekerja di luar Desa. Jadi, perlu gerakan kembali ke Desa serta menarik sumber-sumber ekonomi ke desa agar pencari kerja tidak banyak tersedot ke luar Desa.</p>\r\n<p style=\"text-align: justify;\">&nbsp;</p>\r\n<p style=\"text-align: justify;\">Sumber:<br />Laporan Pertanggung Jawaban Lurah Desa Terong, Kecamatan Dlingo, Kabupaten Bantul tahun 2009.</p>', 1, '2013-07-29 18:13:36', 999, 1, 'Profil Masyarakat Desa', 0, '', '', '', '', '', 1, 'profil-masyarakat-desa', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (36, '', '<p>Kontak kami berisi cara menghubungi desa, seperti contoh berikut :</p>\r\n<p>Alamat : Jl desa no 01</p>\r\n<p>No Telepon : 081xxxxxxxxx</p>\r\n<p>Email : xx@desa.com</p>', 1, '2013-07-29 18:28:31', 999, 1, 'Kontak Kami', 0, '', '', '', '', '', 1, 'kontak-kami', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (37, '', '<p><span style=\"color: #ff0000;\"><strong>Contoh (Sila edit halaman ini dan sesuaikan dengan deskripsi untuk desa ini)!</strong></span><br /><br />Susunan Organisasi Badan Permusyawaratan Desa:</p>\r\n<p>Ketua</p>\r\n<p>Sekretaris</p>\r\n<p>Anggota</p>', 1, '2013-07-29 18:33:33', 999, 1, 'Badan Permusyawaratan Desa', 0, '', '', '', '', '', 1, 'badan-permusyawaratan-desa', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (38, '', '<p>Berisi data lembaga yang ada di desa beserta deskripsi dan susunan pengurusnya</p>', 1, '2013-07-29 18:38:33', 999, 1, 'Lembaga Kemasyarakatan', 0, '', '', '', '', '', 1, 'lembaga-kemasyarakatan', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (41, '', '<p>Agenda Bulan Agustus :</p>\r\n<p>01/08/2013 : Rapat rutin</p>\r\n<p>04/08/2013 : Pertemuan Pengurus</p>\r\n<p>05/08/2013 : Seminar</p>\r\n<p>&nbsp;</p>', 1, '2013-07-30 14:08:52', 1000, 1, 'Rapat bulanan', 0, '', '', '', '', '', 1, 'agenda', 1);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (42, '', '<p>Daftar Undang Undang Desa</p>\n<p><a href=\"../../../../../../assets/front/dokumen/Profil_SSN_SMP1Kepil.pdf\">1. UU No desa</a></p>\n<p>berisi asf basdaf.</p>\n<p>&nbsp;</p>\n<p><a href=\"kebumenkab.go.id/uu.pdf\">2.UU Perdangangan</a></p>', 1, '2014-04-20 18:21:56', 999, 1, 'Undang Undang', 0, '', '', '', '', '', 1, 'undang-undang', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (43, '', '<p>Isi Peraturan Pemerintah</p>', 1, '2014-04-20 18:24:01', 999, 1, 'Peraturan Pemerintah', 0, '', '', '', '', '', 1, 'peraturan-pemerintah', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (44, '', '<p>Isi Peraturan Desa</p>', 1, '2014-04-20 18:24:35', 999, 1, 'Peraturan Desa', 0, '', '', '', '', '', 1, 'peraturan-desa', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (45, '', '<p>Isi Peraturan Kepala Desa</p>', 1, '2014-04-20 18:25:04', 999, 1, 'Peraturan Kepala Desa', 0, '', '', '', '', '', 1, 'peraturan-kepala-desa', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (46, '', '<p>Isi Keputusan kepala desa</p>', 1, '2014-04-20 18:25:36', 999, 1, 'Keputusan Kepala Desa', 0, '', '', '', '', '', 1, 'keputusan-kepala-desa', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (47, '', '<p>Isi Panduan</p>', 1, '2014-04-20 18:38:10', 999, 1, 'Panduan', 0, '', '', '', '', '', 1, 'panduan', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (51, '', '<p>Wahai masyarakat yang ber,,,,,,,,,,,,,,,,,,,,</p>\n<p>no hp : 097867575</p>\n<p>email: jkgkgkg</p>\n<p>ato komentar di bawah ini :</p>', 1, '2014-04-22 10:11:20', 999, 1, 'Pengaduan', 0, '', '', '', '', '', 1, 'pengaduan', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (59, '', '<ol>\r\n<li><strong>a.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </strong><strong>Jumlah Penduduk</strong></li>\r\n</ol>\r\n<p>&nbsp;</p>\r\n<table style=\"width: 372px;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Jumlah jiwa</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">&nbsp;</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Jumlah laki-laki</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">&nbsp;</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Jumlah perempuan</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">&nbsp;</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Jumlah Kepala Keluarga</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">&nbsp;</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">KK</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>&nbsp;</p>\r\n<ol>\r\n<li><strong>b.&nbsp;&nbsp;&nbsp;&nbsp; </strong><strong>Tingkat Pendidikan</strong></li>\r\n</ol>\r\n<table style=\"width: 373px;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"left\">\r\n<tbody>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Belum sekolah</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"121\">&nbsp;</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Usia 7-45 tahun tidak pernah sekolah</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"121\">&nbsp;</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Pernah sekolah SD tetapi tidak tamat</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"121\">&nbsp;</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">&nbsp;</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"121\">&nbsp;</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">&nbsp;</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Pendidikan terakhir</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"121\">&nbsp;</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Tamat SD/sederajat</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"121\">&nbsp;</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">SLTP/sederajat</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"121\">&nbsp;</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">SLTA/sederajat</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"121\">&nbsp;</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">D-1</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"121\">&nbsp;</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">D-2</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"121\">&nbsp;</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">D-3</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"121\">&nbsp;</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">S-1</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"121\">&nbsp;</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">S-2</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"121\">&nbsp;</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">S-3</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"121\">&nbsp;</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>&nbsp;</p>\r\n<ol>\r\n<li><strong>c.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </strong><strong>Mata Pencaharian</strong></li>\r\n</ol>\r\n<p><strong>&nbsp;</strong></p>\r\n<table style=\"width: 372px;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Petani</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">\r\n<p align=\"right\">246</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Buruh tani</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">\r\n<p align=\"right\">125</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Buruh/swasta</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">\r\n<p align=\"right\">136</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Pegawai Negeri</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">\r\n<p align=\"right\">35</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Pengrajin</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">\r\n<p align=\"right\">&nbsp;</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Pedagang</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">\r\n<p align=\"right\">9</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Peternak</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">\r\n<p align=\"right\">-</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Nelayan</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">\r\n<p align=\"right\">-</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Montir</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">\r\n<p align=\"right\">8</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Dokter</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">\r\n<p align=\"right\">-</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">POLRI/ABRI</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">\r\n<p align=\"right\">1</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Pensiunan</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">\r\n<p align=\"right\">36</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Perangkat Desa</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">\r\n<p align=\"right\">15</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Pembuat Bata</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">\r\n<p align=\"right\">3</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p><strong>&nbsp;</strong></p>\r\n<ol>\r\n<li><strong>d.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </strong><strong>AGAMA</strong></li>\r\n</ol>\r\n<table style=\"width: 372px;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Islam</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">\r\n<p align=\"right\">2215</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Kristen</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">\r\n<p align=\"right\">5</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Katholik</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">\r\n<p align=\"right\">&nbsp;</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Hindu</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">\r\n<p align=\"right\">&nbsp;</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"168\">\r\n<p align=\"right\">Budha</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"120\">\r\n<p align=\"right\">1</p>\r\n</td>\r\n<td valign=\"bottom\" nowrap=\"nowrap\" width=\"84\">\r\n<p align=\"right\">orang</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p><strong>&nbsp;</strong></p>\r\n<p><strong>&nbsp;</strong></p>', 1, '2014-04-30 18:23:24', 999, 1, 'Profil Potensi Desa', 0, '', '', '', '', '', 1, 'profil-potensi-desa', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (62, '', '<p>Lembaga Kemasyarakatan Desa (LKMD) adalah salah satu lembaga kemasyaratan yang berada di desa.</p>\n<p>TUGAS LKMD</p>\n<ol>\n<li>menyusun rencana pembangunan secara partisipatif,</li>\n<li>menggerakkan swadaya gotong royong masyarakat,</li>\n<li>melaksanakan dan</li>\n<li>mengendalikan pembangunan.</li>\n</ol>\n<p align=\"left\">FUNGSI LKMD</p>\n<ol>\n<li>penampungan dan penyaluran aspirasi masyarakat dalam pembangunan;</li>\n<li>penanaman dan pemupukan rasa persatuan dan kesatuan masyarakat dalam kerangka memperkokoh Negara Kesatuan Republik Indonesia;</li>\n<li>peningkatan kualitas dan percepatan pelayanan pemerintah kepada masyarakat;</li>\n<li>penyusunan rencana, pelaksanaan, pelestarian dan pengembangan hasil-hasil pembangunan secara partisipatif;</li>\n<li>penumbuhkembangan dan penggerak prakarsa, partisipasi, serta swadaya gotong royong masyarakat; dan</li>\n<li>penggali, pendayagunaan dan pengembangan potensi sumber daya alam serta keserasian lingkungan hidup.</li>\n</ol>\n<p align=\"center\"><strong>DAFTAR NAMA PENGURUS &hellip;&hellip;&hellip;&hellip;</strong></p>\n<p align=\"center\"><strong>MASA JABATAN &hellip;&hellip;s/d&hellip;&hellip;.</strong></p>\n<p align=\"center\"><strong>DESA &hellip;&hellip;&hellip;&hellip;.. KECAMATAN &hellip;&hellip;&hellip; KABUPATEN &hellip;&hellip;&hellip;..</strong></p>\n<p align=\"center\">Surat Keputusan Kepala Desa &hellip;&hellip;&hellip;&hellip;. Nomor : &hellip;&hellip;&hellip;&hellip;&hellip; tanggal &hellip;&hellip;.. Juni &hellip;.. tentang Penetapan Pengurus Lembaga Kemasyarakatan Desa &hellip;&hellip;&hellip;&hellip;&hellip;.</p>\n<p align=\"center\">&nbsp;</p>\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n<tbody>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\"><strong>No</strong></p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"center\"><strong>Jabatan</strong></p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"center\"><strong>Nama Pengurus</strong></p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"center\"><strong>Alamat</strong></p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n</tbody>\n</table>\n<p align=\"left\">&nbsp;</p>\n<p align=\"left\">&nbsp;</p>\n<p align=\"left\">&nbsp;</p>\n<p>&nbsp;</p>', 1, '2014-04-30 18:39:07', 999, 1, 'LKMD', 0, '', '', '', '', '', 1, 'lkmd', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (63, '', '<p>TUGAS PKK</p>\n<ol>\n<li>menyusun rencana kerja PKK Desa/Kelurahan, sesuai dengan basil Rakerda Kabupaten/Kota;</li>\n<li>melaksanakan kegiatan sesuai jadwal yang disepakati;</li>\n<li>menyuluh dan menggerakkan kelompok-kelompok PKK Dusun/Lingkungan, RW, RT dan dasa wisma agar dapat mewujudkan kegiatan-kegiatan yang telah disusun dan disepakati;</li>\n<li>menggali, menggerakan dan mengembangkan potensi masyarakat, khususnya keluarga untuk meningkatkan kesejahteraan keluarga sesuai dengan kebijaksanaan yang telah ditetapkan;</li>\n<li>melaksanakan kegiatan penyuluhan kepada keluarga-keluarga yang mencakup kegiatan bimbingan dan motivasi dalam upaya mencapai keluarga sejahtera;.</li>\n<li>mengadakan pembinaan dan bimbingan mengenai pelaksanaan program kerja;</li>\n<li>berpartisipasi dalam pelaksanaan program instansi yang berkaitan dengan kesejahteraan keluarga di desa/kelurahan;</li>\n<li>membuat laporan basil kegiatan kepada Tim Penggerak PKK Kecamatan dengan tembusan kepada Ketua Dewan Penyantun Tim Penggerak PKK setempat;</li>\n<li>melaksanakan tertib administrasi; dan</li>\n<li>mengadakan konsultasi dengan Ketua Dewan Penyantun Tim Penggerak PKK setempat.</li>\n</ol>\n<p>&nbsp;</p>\n<p>FUNGSI PKK</p>\n<ol>\n<li>penyuluh, motivator dan penggerak masyarakat agar mau dan mampu melaksanakan program PKK; dan</li>\n<li>fasilitator, perencana, pelaksana, pengendali, pembina dan pembimbing Gerakan PKK.</li>\n</ol>\n<p align=\"center\"><strong>DAFTAR NAMA PENGURUS &hellip;&hellip;&hellip;&hellip;</strong></p>\n<p align=\"center\"><strong>MASA JABATAN &hellip;&hellip;s/d&hellip;&hellip;.</strong></p>\n<p align=\"center\"><strong>DESA &hellip;&hellip;&hellip;&hellip;.. KECAMATAN &hellip;&hellip;&hellip; KABUPATEN &hellip;&hellip;&hellip;..</strong></p>\n<p align=\"center\">Surat Keputusan Kepala Desa &hellip;&hellip;&hellip;&hellip;. Nomor : &hellip;&hellip;&hellip;&hellip;&hellip; tanggal &hellip;&hellip;.. Juni &hellip;.. tentang Penetapan Pengurus Lembaga Kemasyarakatan Desa &hellip;&hellip;&hellip;&hellip;&hellip;.</p>\n<p align=\"center\">&nbsp;</p>\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n<tbody>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\"><strong>No</strong></p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"center\"><strong>Jabatan</strong></p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"center\"><strong>Nama Pengurus</strong></p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"center\"><strong>Alamatn</strong></p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"center\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"center\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"center\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"180\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"241\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n</tbody>\n</table>\n<p align=\"left\">&nbsp;</p>\n<p align=\"left\">&nbsp;</p>\n<p align=\"left\">&nbsp;</p>\n<p>&nbsp;</p>', 2, '2014-04-30 18:41:13', 999, 1, 'PKK', 0, '', '', '', '', '', 1, 'pkk', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (64, '', '<p align=\"left\">TUGAS &nbsp;KARANGTARUNA</p>\n<p align=\"left\">menanggulangi berbagai masalah kesejahteraan sosial terutama yang dihadapi generasi muda, baik yang bersifat preventif, rehabilitatif, maupun pengembangan potensi generasi muda di lingkungannya</p>\n<p align=\"left\">FUNGSI KARANGTAURNA</p>\n<ol>\n<li>penyelenggara usaha kesejahteraan sosial;</li>\n<li>penyelenggara pendidikan dan pelatihan bagi masyarakat;</li>\n<li>penyelenggara pemberdayaan masyarakat terutama generasi muda di lingkungannya secara komprehensif, terpadu dan terarah serta berkesinambungan;</li>\n<li>penyelenggara kegiatan pengembangan jiwa kewirausahaan bagi generasi muda di lingkungannya;</li>\n<li>penanaman pengertian, memupuk dan meningkatkan kesadaran tanggung jawab sosial generasi muda;</li>\n<li>penumbuhan dan pengembangan semangat kebersamaan, jiwa kekeluargaan, kesetiakawanan sosial dan memperkuat nilai-nilai kearifan dalam bingkai Negara Kesatuan Republik Indonesia;</li>\n</ol>\n<p align=\"left\">&nbsp;</p>\n<p align=\"center\"><strong>DAFTAR NAMA PENGURUS &hellip;&hellip;&hellip;&hellip;</strong></p>\n<p align=\"center\"><strong>MASA JABATAN &hellip;&hellip;s/d&hellip;&hellip;.</strong></p>\n<p align=\"center\"><strong>DESA &hellip;&hellip;&hellip;&hellip;.. KECAMATAN &hellip;&hellip;&hellip; KABUPATEN &hellip;&hellip;&hellip;..</strong></p>\n<p align=\"center\">Surat Keputusan Kepala Desa &hellip;&hellip;&hellip;&hellip;. Nomor : &hellip;&hellip;&hellip;&hellip;&hellip; tanggal &hellip;&hellip;.. Juni &hellip;.. tentang Penetapan Pengurus Lembaga Kemasyarakatan Desa &hellip;&hellip;&hellip;&hellip;&hellip;.</p>\n<p align=\"center\">&nbsp;</p>\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n<tbody>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\"><strong>No</strong></p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"center\"><strong>Jabatan</strong></p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"center\"><strong>Nama Pengurus</strong></p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"center\"><strong>Alamat</strong></p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">1</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">2</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">3</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n</tbody>\n</table>\n<p align=\"left\">&nbsp;</p>\n<p align=\"left\">&nbsp;</p>\n<p align=\"left\">&nbsp;</p>\n<p>&nbsp;</p>', 1, '2014-04-30 18:44:28', 999, 1, 'Karang Taruna', 0, '', '', '', '', '', 1, 'karang-taruna', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (65, '', '<p align=\"left\">TUGAS RT/RW</p>\n<p align=\"left\">membantu Pemerintah Desa dan Lurah dalam penyelenggaraan urusan pemerintahan</p>\n<p align=\"left\">FUNGSI PKK</p>\n<ol>\n<li>pendataan kependudukan dan pelayanan administrasi pemerintahan lainnya;</li>\n<li>pemeliharaan keamanan, ketertiban dan kerukunan hidup antar warga;</li>\n<li>pembuatan gagasan dalam pelaksanaan pembangunan dengan mengembangkan aspirasi dan swadaya murni masyarakat; dan</li>\n<li>penggerak swadaya gotong royong dan partisipasi masyarakat di wilayahnya.</li>\n</ol>\n<p align=\"left\">&nbsp;</p>\n<p align=\"center\"><strong>DAFTAR NAMA PENGURUS &hellip;&hellip;&hellip;&hellip;</strong></p>\n<p align=\"center\"><strong>MASA JABATAN &hellip;&hellip;s/d&hellip;&hellip;.</strong></p>\n<p align=\"center\"><strong>DESA &hellip;&hellip;&hellip;&hellip;.. KECAMATAN &hellip;&hellip;&hellip; KABUPATEN &hellip;&hellip;&hellip;..</strong></p>\n<p align=\"center\">Surat Keputusan Kepala Desa &hellip;&hellip;&hellip;&hellip;. Nomor : &hellip;&hellip;&hellip;&hellip;&hellip; tanggal &hellip;&hellip;.. Juni &hellip;.. tentang Penetapan Pengurus Lembaga Kemasyarakatan Desa &hellip;&hellip;&hellip;&hellip;&hellip;.</p>\n<p align=\"center\">&nbsp;</p>\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n<tbody>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\"><strong>No</strong></p>\n</td>\n<td valign=\"top\" width=\"186\">\n<p align=\"left\"><strong>Jabatan</strong></p>\n</td>\n<td valign=\"top\" width=\"204\">\n<p align=\"left\"><strong>Nama Pejabat</strong></p>\n</td>\n<td valign=\"top\" width=\"193\">\n<p align=\"left\"><strong>Alamat</strong></p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">1</p>\n</td>\n<td valign=\"top\" width=\"186\">\n<p align=\"left\">Ketua RW 1</p>\n</td>\n<td valign=\"top\" width=\"204\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"193\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">2</p>\n</td>\n<td valign=\"top\" width=\"186\">\n<p align=\"left\">Ketua RW 1 Rt 01</p>\n</td>\n<td valign=\"top\" width=\"204\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"193\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">3</p>\n</td>\n<td valign=\"top\" width=\"186\">\n<p align=\"left\">Ketua RW 1 Rt 02</p>\n</td>\n<td valign=\"top\" width=\"204\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"193\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"186\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"204\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"193\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"186\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"204\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"193\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"186\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"204\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"193\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"186\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"204\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"193\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"186\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"204\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"193\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"186\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"204\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"193\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"186\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"204\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"193\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"186\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"204\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"193\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"186\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"204\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"193\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"186\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"204\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"193\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"186\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"204\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"193\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n</tbody>\n</table>\n<p align=\"left\">&nbsp;</p>\n<p align=\"left\">&nbsp;</p>\n<p align=\"left\">&nbsp;</p>\n<p>&nbsp;</p>', 1, '2014-04-30 18:45:19', 999, 1, 'RT RW', 0, '', '', '', '', '', 1, 'rt-rw', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (66, '', '<p class=\"Default\">&nbsp;</p>\n<p class=\"Default\">Tim Koordinasi Percepatan Penanggulangan Kemiskinan Desa yang selanjutnya disingkat TKP2KDes adalah wadah koordinasi lintas sektor dan lintas pemangku kepentingan untuk percepatan penanggulangan kemiskinan di desa.</p>\n<p class=\"Default\">TKP2KDes bertugas mengkoordinasikan perencanaan, pengorganisasian, pelaksanaan dan pengendalian program penanggulangan kemiskinan di tingkat Desa.</p>\n<p>( Perda Kabupaten Kebumen Nomor 20 Tahun 2012 Tentang Percepatan Penanggulangan Kemiskinan )</p>\n<p align=\"center\"><strong>DAFTAR NAMA PENGURUS &hellip;&hellip;&hellip;&hellip;</strong></p>\n<p align=\"center\"><strong>MASA JABATAN &hellip;&hellip;s/d&hellip;&hellip;.</strong></p>\n<p align=\"center\"><strong>DESA &hellip;&hellip;&hellip;&hellip;.. KECAMATAN &hellip;&hellip;&hellip; KABUPATEN &hellip;&hellip;&hellip;..</strong></p>\n<p align=\"center\">Surat Keputusan Kepala Desa &hellip; Nomor : &hellip;&hellip;tanggal &hellip;&hellip;.. bulan&hellip;.. tentang &hellip;..</p>\n<p align=\"center\">&nbsp;</p>\n<p align=\"center\">&nbsp;</p>\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n<tbody>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\"><strong>No</strong></p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"center\"><strong>Jabatan</strong></p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"center\"><strong>Nama Pengurus</strong></p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"center\"><strong>Alamat</strong></p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">1</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"center\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"center\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"center\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">2</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">3</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n</tbody>\n</table>\n<p align=\"left\">&nbsp;</p>\n<p align=\"left\">&nbsp;</p>\n<p align=\"left\">&nbsp;</p>\n<p>&nbsp;</p>', 2, '2014-04-30 18:46:01', 999, 1, 'TKP2KDes', 0, '', '', '', '', '', 1, 'tkp2kdes', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (67, '', '<p class=\"Default\">&nbsp;</p>\n<p class=\"Default\">Kelompok Perlindungan Anak Desa atau Kelurahan yang selanjutnya disingkat KPAD atau KPAK adalah lembaga perlindungan anak berbasis masyarakat yang berkedudukan dan melakukan kerja&ndash;kerja perlindungan anak di wilayah desa atau kelurahan tempat anak bertempat tinggal&nbsp;&nbsp;&nbsp;&nbsp; ( Perda Kaupaten Kebumen No 3 Tahun 2013 Tentang Penyelenggaraan Perlindungan Anak&nbsp; )</p>\n<p>TUGAS-TUGAS KPAD</p>\n<p>1.1&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Sosialisasi</p>\n<ol>\n<li>Mensosialisasikan kepada masyarakat tentang hak-hak anak</li>\n<li>Mempromosikan CHILD RIGHTS dan CHILD PROTECTION</li>\n<li>Melakukan upaya pencegahan, respon dan penanganan kasus kasus kekerasan terhadap anak dan masalah anak.</li>\n</ol>\n<p>1.2&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Mediasi</p>\n<ol>\n<li>Mengedepankan upaya musyawarah dan mufakat (Rembug Desa)&nbsp; dalam menyelesaikan masalah &ndash; (Restorative Justive)</li>\n<li>Melakukan koordinasi dengan pihak terkait di level desa, kecamatan dan kabupaten dalam upaya perlindungan anak.</li>\n<li>Melakukan pendampingan kasus (dari pelaporan &ndash; medis &ndash; psikologi - reintegrasi)</li>\n</ol>\n<p>1.3&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Fasilitasi</p>\n<ol>\n<li>Memfasilitasi terbentuknya kelompok anak di desa sebagai media partisipasi anak</li>\n<li>Memfasilitasi partisipasi anak untuk terlibat dalam penyusunan perencanaan pembangunan yang berbasis hak anak (penyusunan RPJMDesa)</li>\n</ol>\n<p>1.4&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Dokumentasi</p>\n<ol>\n<li>Mendokumentasikan semua proses yang dilakukan (Kegiatan Promosi; Penanganan Kasus dan mencatat kasus yang dilaporkan; Perkembangan Kasus, Pertemuan,dll)</li>\n</ol>\n<p>1.5&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Advokasi</p>\n<ol>\n<li>Mendorong adanya kebijakan dan penganggaran untuk perlindungan anak di level desa</li>\n<li>Menerima pengaduan kasus dan konsultasi tentang perlindungan anak</li>\n<li>Berhubungan dengan P2TP2A dan LPA untuk pendampingan hukum kasus anak (korban dan atau pelaku)</li>\n</ol>\n<p class=\"Default\">&nbsp;</p>\n<p class=\"Default\">&nbsp;</p>\n<p align=\"center\"><strong>DAFTAR NAMA PENGURUS &hellip;&hellip;&hellip;&hellip;</strong></p>\n<p align=\"center\"><strong>MASA JABATAN &hellip;&hellip;s/d&hellip;&hellip;.</strong></p>\n<p align=\"center\"><strong>DESA &hellip;&hellip;&hellip;&hellip;.. KECAMATAN &hellip;&hellip;&hellip; KABUPATEN &hellip;&hellip;&hellip;..</strong></p>\n<p align=\"center\">Surat Keputusan Kepala Desa &hellip;&hellip;&hellip;&hellip;. Nomor : &hellip;&hellip;&hellip;&hellip;&hellip; tanggal &hellip;&hellip;.. Juni &hellip;.. tentang Penetapan Pengurus Lembaga Kemasyarakatan Desa &hellip;&hellip;&hellip;&hellip;&hellip;.</p>\n<p align=\"center\">&nbsp;</p>\n<table border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n<tbody>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\"><strong>No</strong></p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\"><strong>Jabatan</strong></p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\"><strong>Nama Pengurus</strong></p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\"><strong>Alamat</strong></p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">1</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">2</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">3</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n</tbody>\n</table>\n<p align=\"left\">&nbsp;</p>\n<p align=\"left\">&nbsp;</p>\n<p align=\"left\">&nbsp;</p>\n<p>&nbsp;</p>', 2, '2014-04-30 18:47:21', 999, 1, 'KPAD', 0, '', '', '', '', '', 1, 'kpad', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (68, '', '<p align=\"center\"><strong>DAFTAR NAMA PENGURUS KELOMPOK TERNAK &hellip;..</strong></p>\n<p align=\"center\"><strong>MASA JABATAN &hellip;&hellip;s/d&hellip;&hellip;.</strong></p>\n<p align=\"center\"><strong>DESA &hellip;&hellip;&hellip;&hellip;.. KECAMATAN &hellip;&hellip;&hellip; KABUPATEN &hellip;&hellip;&hellip;..</strong></p>\n<p align=\"center\">Surat Keputusan Kepala Desa &hellip;&hellip;&hellip;&hellip;. Nomor : &hellip;&hellip;&hellip;&hellip;&hellip; tanggal &hellip;&hellip;.. Juni &hellip;.. tentang</p>\n<p align=\"center\">&hellip;&hellip;&hellip;&hellip;&hellip;.. &hellip;&hellip;&hellip;&hellip;&hellip;.</p>\n<p align=\"center\">&nbsp;</p>\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n<tbody>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\"><strong>No</strong></p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"center\"><strong>Jabatan</strong></p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"center\"><strong>Nama Pengurus</strong></p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"center\"><strong>Alamat</strong></p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">1</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">2</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">3</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n</tbody>\n</table>\n<p align=\"left\">&nbsp;</p>\n<p align=\"center\"><strong>DAFTAR NAMA PENGURUS KELOMPOK WANITA TANI TERNAK&nbsp; &hellip;&hellip;.</strong></p>\n<p align=\"center\"><strong>MASA JABATAN &hellip;&hellip;s/d&hellip;&hellip;.</strong></p>\n<p align=\"center\"><strong>DESA &hellip;&hellip;&hellip;&hellip;.. KECAMATAN &hellip;&hellip;&hellip; KABUPATEN &hellip;&hellip;&hellip;..</strong></p>\n<p align=\"center\">Surat Keputusan Kepala Desa &hellip;&hellip;&hellip;&hellip;. Nomor : &hellip;&hellip;&hellip;&hellip;&hellip; tanggal &hellip;&hellip;.. bulan&hellip;..</p>\n<p align=\"center\">tentang &hellip;&hellip;&hellip;&hellip;&hellip;&hellip;.</p>\n<p align=\"center\">&nbsp;</p>\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n<tbody>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\"><strong>No</strong></p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\"><strong>Jabatan</strong></p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\"><strong>Nama Pengurus</strong></p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\"><strong>Alamat</strong></p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">1</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">2</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">3</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n</tbody>\n</table>\n<p align=\"center\">&nbsp;</p>\n<p align=\"center\">&nbsp;</p>\n<p>&nbsp;</p>', 2, '2014-04-30 18:47:58', 999, 1, 'Kelompok Ternak', 0, '', '', '', '', '', 1, 'kelompok-ternak', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (69, '', '<p align=\"center\"><strong>DAFTAR NAMA PENGURUS GAPOKTAN</strong></p>\n<p align=\"center\"><strong>MASA JABATAN &hellip;&hellip;s/d&hellip;&hellip;.</strong></p>\n<p align=\"center\"><strong>DESA &hellip;&hellip;&hellip;&hellip;.. KECAMATAN &hellip;&hellip;&hellip; KABUPATEN &hellip;&hellip;&hellip;..</strong></p>\n<p align=\"center\">Surat Keputusan Kepala Desa &hellip;&hellip;&hellip;&hellip;. Nomor : &hellip;&hellip;&hellip;&hellip;&hellip; tanggal &hellip;&hellip;.. Juni &hellip;.. tentang</p>\n<p align=\"center\">&hellip;&hellip;&hellip;&hellip;&hellip;.. &hellip;&hellip;&hellip;&hellip;&hellip;.</p>\n<p align=\"center\">&nbsp;</p>\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n<tbody>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\"><strong>No</strong></p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"center\"><strong>Jabatan</strong></p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"center\"><strong>Nama Pengurus</strong></p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"center\"><strong>Alamat</strong></p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">1</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">2</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">3</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n</tbody>\n</table>\n<p align=\"left\">&nbsp;</p>\n<p align=\"center\"><strong>DAFTAR NAMA PENGURUS KELOMPOK TANI &hellip;&hellip;.</strong></p>\n<p align=\"center\"><strong>MASA JABATAN &hellip;&hellip;s/d&hellip;&hellip;.</strong></p>\n<p align=\"center\"><strong>DESA &hellip;&hellip;&hellip;&hellip;.. KECAMATAN &hellip;&hellip;&hellip; KABUPATEN &hellip;&hellip;&hellip;..</strong></p>\n<p align=\"center\">Surat Keputusan Kepala Desa &hellip;&hellip;&hellip;&hellip;. Nomor : &hellip;&hellip;&hellip;&hellip;&hellip; tanggal &hellip;&hellip;.. bulan&hellip;..</p>\n<p align=\"center\">tentang &hellip;&hellip;&hellip;&hellip;&hellip;&hellip;.</p>\n<p align=\"center\">&nbsp;</p>\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n<tbody>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\"><strong>No</strong></p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"center\"><strong>Jabatan</strong></p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"center\"><strong>Nama Pengurus</strong></p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"center\"><strong>Alamat</strong></p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">1</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">2</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">3</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n</tbody>\n</table>\n<p align=\"center\">&nbsp;</p>\n<p align=\"center\">&nbsp;</p>\n<p align=\"center\">&nbsp;</p>\n<p align=\"center\">&nbsp;</p>\n<p align=\"center\">&nbsp;</p>\n<p align=\"center\">&nbsp;</p>\n<p align=\"center\">&nbsp;</p>\n<p align=\"center\"><strong>DAFTAR NAMA PENGURUS KELOMPOK TANI &hellip;&hellip;.</strong></p>\n<p align=\"center\"><strong>MASA JABATAN &hellip;&hellip;s/d&hellip;&hellip;.</strong></p>\n<p align=\"center\"><strong>DESA &hellip;&hellip;&hellip;&hellip;.. KECAMATAN &hellip;&hellip;&hellip; KABUPATEN &hellip;&hellip;&hellip;..</strong></p>\n<p align=\"center\">Surat Keputusan Kepala Desa &hellip;&hellip;&hellip;&hellip;. Nomor : &hellip;&hellip;&hellip;&hellip;&hellip; tanggal &hellip;&hellip;.. bulan&hellip;..</p>\n<p align=\"center\">tentang &hellip;&hellip;&hellip;&hellip;&hellip;&hellip;.</p>\n<p align=\"center\">&nbsp;</p>\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n<tbody>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\"><strong>No</strong></p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"center\"><strong>Jabatan</strong></p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"center\"><strong>Nama Pengurus</strong></p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"center\"><strong>Alamat</strong></p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">1</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">2</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"center\">3</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n<tr>\n<td valign=\"top\" width=\"55\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"162\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"192\">\n<p align=\"left\">&nbsp;</p>\n</td>\n<td valign=\"top\" width=\"229\">\n<p align=\"left\">&nbsp;</p>\n</td>\n</tr>\n</tbody>\n</table>', 1, '2014-04-30 18:48:39', 999, 1, 'Kelompok Tani', 0, '', '', '', '', '', 1, 'kelompok-tani', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (70, '', '<p>Linmas</p>', 1, '2014-04-30 18:53:18', 999, 1, 'LinMas', 0, '', '', '', '', '', 1, 'linmas', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (71, '', '<p>Kelompok Ekonomi Lainya</p>', 2, '2014-04-30 18:54:20', 999, 1, 'Kelompok Ekonomi Lainya', 0, '', '', '', '', '', 1, 'kelompok-ekonomi-lainya', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (83, '', '<p>Tiap hari rapat sampai kumat</p>', 1, '2014-11-06 18:17:52', 1000, 1, 'Rapat Lagi', 0, '', '', '', '', '', 1, 'rapat-lagi', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (85, '1471927406download (1).jpg', '<div class=\"contentText\">\r\n<div align=\"justify\">Bagian ini berisi informasi mengenai PemerintahanDesa. Sila klik pada tautan berikut untuk mendapatkan informasi yang lebih rinci.</div>\r\n<div align=\"justify\">&nbsp;</div>\r\n<ol>\r\n<li>Visi dan Misi</li>\r\n<li>Pemerintah Desa</li>\r\n<li>Badan Permusyawaratan Desa</li>\r\n</ol>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p style=\"text-align: center;\"><strong>VISI dan MISI</strong></p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p style=\"text-align: center;\"><strong>VISI</strong></p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p style=\"text-align: center;\"><strong>\"Senggigi Berseri\"</strong></p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p style=\"text-align: center;\"><strong>(Bersih, Relegius, Sejahtera, Rapi, dan Indah)</strong></p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p style=\"text-align: center;\"><strong>\"Terwujudnya masyarakat Desa Senggigi yang Bersih, Relegius, Sejahtra, Rapi dan Indah melalui Akselerasi Pembangunan yang berbasis Keagamaan, Budaya Hukum dan Berwawasan Lingkungan dengan berorentasi pada peningkatan Kinerja Aparatur dan Pemberdayaan Masyarakat\"</strong></p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p style=\"text-align: center;\"><strong>MISI</strong></p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p style=\"text-align: justify;\"><strong>Misi dan Program Desa Senggigi</strong></p>\r\n<p style=\"text-align: justify;\">Dan untuk melaksanakan visi Desa Senggigi dilaksanakan misi dan program sebagai berikut:</p>\r\n<p style=\"text-align: justify;\">1. Pembangunan Jangka Panjang</p>\r\n<ul>\r\n<li style=\"text-align: justify;\">Melanjutkan Pembangunan Desa yang belum terlaksana</li>\r\n<li style=\"text-align: justify;\">Meningkatkan Kerjasama antara pemerintah Desa dengan Lembaga desa yang ada</li>\r\n<li style=\"text-align: justify;\">Meningkatkan Kesejahtraan Masyarakat desa dengan meningkatkan sarana dan prasarana ekonomi warga.&nbsp;</li>\r\n</ul>\r\n<p style=\"text-align: justify;\">&nbsp;</p>\r\n<p style=\"text-align: justify;\">2. Pembangunan Jangka Pendek &nbsp;</p>\r\n<ul>\r\n<li style=\"text-align: justify;\">Mengembangkan dan Menjaga serta melestarikan ada istiadat desa terutama yang telah mengakar di desa senggigi.&nbsp;</li>\r\n<li style=\"text-align: justify;\">Meningkatkan pelayanan dalam bidang pemerintahan kepada warga masyarakat&nbsp;</li>\r\n<li style=\"text-align: justify;\">Meningkatkan sarana dan prasarana ekonomi warga desa dengan perbaikan prasarana dan sarana ekonomi.</li>\r\n<li style=\"text-align: justify;\">Meningkatkan sarana dan prasarana pendidikan guna peningkatan sumber daya manusia desa senggigi.&nbsp;</li>\r\n</ul>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p style=\"text-align: center;\"><strong>Kepala Desa Senggigi</strong></p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p style=\"text-align: center;\"><strong>Muhammad Ilham</strong></p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n</div>', 1, '2014-11-07 10:53:54', 999, 1, 'Pemerintahan Desa', 0, '', '', '', '', '', 1, 'pemerintahan-desa', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (90, '1471968200IMG-20160823-WA0007.jpg', '', 1, '2016-08-24 00:03:21', 5, 1, 'PERDES PHBS ', 3, '1471968200IMG-20160823-WA0012.jpg', '1471968200', '1471968200', 'PERDES PHBS.docx', 'PERDES PHBS ', 1, 'perdes-phbs', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (92, '1472006396', '<p><strong>Susunan Organisasi Pemerintah Desa Senggigi</strong><br /><br />Kepala Desa: MUHAMMAD ILHAM<br />Sekretaris Desa:&nbsp;<span>MUSTAHIQ, S.Adm</span><br />Kepala Urusan Pemerintahan: SYAFRUDIN<br />Kepala Urusan&nbsp;Pembangunan: SYAFI\'I, SE<br />Kepala Urusan&nbsp;Kesra: HAMIDIAH<br />Kepala Urusan&nbsp;Keuangan: MARDIANA<br />Kepala Urusan&nbsp;Trantib: SUPARDI RUSTAM<br />Kepala Urusan&nbsp;Umum: MAHRUP<br /><br /></p>', 1, '2016-08-24 10:39:56', 999, 1, 'Pemerintah Desa', 0, '1472006396', '1472006396', '1472006396', '', '', 1, 'pemerintah-desa', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (93, '1549419057_visi-850x442.jpg', '<p style=\"text-align: center;\"><strong>VISI dan MISI</strong></p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p style=\"text-align: center;\"><strong>VISI</strong></p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p style=\"text-align: center;\"><strong>\"Senggigi Berseri\"</strong></p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p style=\"text-align: center;\"><strong>(Bersih, Relegius, Sejahtera, Rapi, dan Indah)</strong></p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p style=\"text-align: center;\"><strong>\"Terwujudnya masyarakat Desa Senggigi yang Bersih, Relegius, Sejahtera, Rapi dan Indah melalui Akselerasi Pembangunan yang berbasis Keagamaan, Budaya Hukum dan Berwawasan Lingkungan dengan berorentasi pada peningkatan Kinerja Aparatur dan Pemberdayaan Masyarakat\"</strong></p>\r\n<p>&nbsp;&nbsp;</p>\r\n<p><strong>MISI</strong></p>\r\n<p><strong>Misi dan Program Desa Senggigi</strong></p>\r\n<p>Dan untuk melaksanakan visi Desa Senggigi dilaksanakan misi dan program sebagai berikut:</p>\r\n<p>1. Pembangunan Jangka Panjang</p>\r\n<p>&nbsp; &nbsp; - Melanjutkan pembangunan desa yang belum terlaksana.</p>\r\n<p>&nbsp; &nbsp; - Meningkatkan kerjasama antara pemerintah desa dengan lembaga desa yang ada.</p>\r\n<p>&nbsp; &nbsp; - Meningkatkan kesejahtraan masyarakat desa dengan meningkatkan sarana dan prasarana ekonomi warga.&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>2. Pembangunan Jangka Pendek &nbsp;</p>\r\n<p>&nbsp; &nbsp; - Mengembangkan dan Menjaga serta melestarikan ada istiadat desa terutama yang telah mengakar di desa senggigi.&nbsp;</p>\r\n<p>&nbsp; &nbsp; - Meningkatkan pelayanan dalam bidang pemerintahan kepada warga masyarakat&nbsp;</p>\r\n<p>&nbsp; &nbsp; - Meningkatkan sarana dan prasarana ekonomi warga desa dengan perbaikan prasarana dan sarana ekonomi.</p>\r\n<p>&nbsp; &nbsp; - Meningkatkan sarana dan prasarana pendidikan guna peningkatan sumber daya manusia Desa Senggigi.&nbsp;</p>', 1, '2016-08-24 10:48:28', 999, 1, 'Visi dan Misi', 0, '1472006908', '1472006908', '1472006908', '', '', 1, 'visi-dan-misi', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (94, '1527544437_gotong-royong-pantai.jpeg', '<p style=\"text-align: justify;\">Gotong royong yang dulu digagas pertama kali oleh pendiri bangsa, Ir. Soekarno kian hari semakin terkikis dengan budaya individual ditengah persaingan yang begitu ketat dalam mencapai tujuan tertentu, kenyataan inilah yang membuat nilai-nilai sosial ditatanan masyarakat yang sejak dulu sudah ditanamkan oleh nenek moyang kita luntur seiring dengan perkembangan jaman. padahal untuk mencapai suatu tujuan dan cita-cita bersama seharusnya dikerjakan secara bersama-sama.&nbsp;</p>\r\n<p style=\"text-align: justify;\">&nbsp;</p>\r\n<p style=\"text-align: justify;\">Maka dengan kenyataan inilah, pemerintah desa senggigi kembali melakukan sebuah inovasi baru dalam merangkul masyarakat agar terus menanamkan kebudayaan \"Gotong Raoyong\". kegitan gotong royong dalam pembangunan jalan desa sedikitnya melibatkan hampir 95% masyarakat senggigi, kebersamaan dan ikatan persaudaraan atas kepentingan bersama menjadi satu ketika semua masyarakat desa terlibat aktif, tanpa harus melihat tatanan dan golongan yang ada. masyarakat saling bahu membahu seiring kegitan gotong royong.&nbsp;</p>\r\n<p style=\"text-align: justify;\">&nbsp;</p>\r\n<p style=\"text-align: justify;\">&nbsp;</p>', 1, '2016-08-24 11:02:44', 1, 1, 'Membangun Desa Lewat Gotong Royong', 3, '1472782825artikel-2-2.jpeg', '1472007764', '1472007764', '', '', 1, 'membangun-desa-lewat-gotong-royong', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (95, '1527540313_kemerdekaan-pantai.jpg', '<p>Desa Senggigi ikut memeriahkan perayaan 17 Agustus 2016 sebagai hari jadi Indonesia yang ke 71 melalui kegiatan Karnaval yang diselenggarakan oleh Camat Batulayar Kabupaten Lombok Barat NTB. Acara karnaval dilaksanakan pada hari Rabu, 17 Agustus 2016 dimulai pukul 15.30 s/d 17.00 wita. Masing-masing desa berkumpul disekitaran kantor Camat Batulayar, dan berjalan menuju Taman Bale Pelangi Desa Sandik sebagai pusat titik kumpul seluruh peserta karnaval.&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>Dalam karnaval ini, Desa Senggigi melibatkan berbagai unsur masyarakat seperti tokoh masyarakat, perempuan, pemuda dan anak-anak dengan menggunakan baju adat dan berbagai macam asesoris hari kemerdekaan, kegitan tersebut adalah salah satu cara bagaimana memupuk semangat bagi setiap warga negara, khususnya kaum muda sebagai harapan bangsa, yang kian hari semakin terkikis dengan pengaruh global saat ini.</p>\r\n<p>&nbsp;</p>\r\n<p>Lewat karang taruna desa senggigi, pemupukan pemberian semangat dalam berpacu memajukan desa dan bangsa terus dilakukan, berbagai macam kegiatan tahapan dalam pelaksanaan hari kemerdekaan terus di lakukan.&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>', 1, '2016-08-24 13:05:21', 1, 1, 'Perayaan Hari Kemerdekaan 2016', 3, '1472782634galeri-1-2.jpeg', '1472015120', '1472015120', '', '', 1, 'perayaan-hari-kemerdekaan-2016', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (96, '1472782915artikel-3-1.jpeg', '<p>Dalam rapat pembahasan komitmen perekrutan karyawan hotel pada tanggal 24 Agustus 2016 di kantor desa sengigi telah menyepakati beberapa komitmen bersama diantaranya sebagai berikut:</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>1. Dalam perekrutan karyawan, pihak hotel harus memprioritaskan masyarakat senggigi minimal 35%</p>\n<p>2. Pihak Hotel harus mengikuti program perencanaan tenaga kerja desa senggigi sesua dengan VISI dan MISI desa</p>\n<p>3. Pihak hotel harus melakukan kordinasi dengan pemerintah desa ketika perekrutan karyawan&nbsp;</p>\n<p>4. Pihak Hotel harus melakukan pelatihan bagi calon karyawan, khususnya karyawan yang berasal dari desa sengggigi</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>Bagi rekan-rekan pemuda dan masyarakat harap melakukan kordinasi dengan pemerintah desa terkait dengan beberapa hasil pertemuan dalam membangun komitme dengan pihak hotel, jika ada hal mendesak terkait beberapa syarat ketentuan perekrutan, rekan-rekan pemuda dan masyarakat bisa menghubungi kami di kantor desa..</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>', 1, '2016-08-24 13:55:10', 4, 1, 'Rapat membangun Komitmen antara Karang Taruna Desa Senggigi dengan Taruna Hotel', 3, '1472018109IMG-20160824-WA0000.jpg', '1472018109', '1472018109', '', '', 1, 'rapat-membangun-komitmen-antara-karang-taruna-desa-senggigi-dengan-taruna-hotel', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (97, '1472019299', '<p>Halaman ini berisi tautan menuju informasi mengenai Basis Data Desa. Ada dua jenis data yang dimuat dalam sistem ini, yakni basis data kependudukan dan basis data sumber daya desa. Sila klik pada tautan berikut untuk mendapatkan tampilan data statistik per kategori.</p>\r\n<ol>\r\n<li>Data Wilayah Administratif&nbsp;&nbsp; &nbsp; &nbsp;&nbsp; &nbsp;</li>\r\n<li>Data Pendidikan&nbsp;&nbsp; &nbsp; &nbsp;&nbsp; &nbsp;</li>\r\n<li>Data Pekerjaan&nbsp;&nbsp; &nbsp; &nbsp;&nbsp; &nbsp;</li>\r\n<li>Data Golongan Darah&nbsp;&nbsp; &nbsp; &nbsp;&nbsp; &nbsp;</li>\r\n<li>Data Agama&nbsp;&nbsp; &nbsp; &nbsp;&nbsp; &nbsp;</li>\r\n<li>Data Jenis Kelamin&nbsp;&nbsp; &nbsp; &nbsp;&nbsp; &nbsp;</li>\r\n<li>Data Kelompok Umur&nbsp;&nbsp; &nbsp; &nbsp;&nbsp; &nbsp;</li>\r\n<li>Data Penerima Raskin&nbsp;&nbsp; &nbsp; &nbsp;&nbsp; &nbsp;</li>\r\n<li>Data Penerima BPJS &nbsp; &nbsp; &nbsp; &nbsp;</li>\r\n<li>Data Warga Negara &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;&nbsp;</li>\r\n</ol>\r\n<p>Data yang tampil adalah statistik yang didapatkan dari proses olah data dasar yang dilakukan secara&nbsp;<em>offline</em>&nbsp;di kantor desa secara rutin/harian. Data dasar di kantor desa diunggah ke dalam sistem&nbsp;<em>online</em>&nbsp;di website ini secara berkala. Sila hubungi kontak pemerintah desa untuk mendapatkan data dan informasi desa termutakhir.</p>', 1, '2016-08-24 14:14:59', 999, 1, 'Data Desa', 0, '1472019299', '1472019299', '1472019299', '', '', 1, 'data-desa', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (98, '1549419108_desa.jpg', '<p>Wilayah desa berisi tentang penjelasan dan deskripsi letak wilayah desa. contohnya sebagai berikut :<br />Batas-batas :<br />Utara&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : Kelurahan a<br />Timur &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;: Desa b<br />Selatan&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : Desa c<br />Barat&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : Kelurahan d dan Desa e<br />Luas Wilayah Desa Penglatan&nbsp;&nbsp; : 186,193 Ha<br />Letak Dan Batas Desa x<br />Desa Penglatan terletak pada posisi 115. 7.20 LS 8. 7.10 BT, dengan ketinggian kurang lebih 250 M diatas permukaan laut.</p>\r\n<p>Peta Desa:</p>\r\n<p><iframe src=\"https://www.google.co.id/maps?f=q&amp;source=s_q&amp;hl=en&amp;geocode=&amp;q=Logandu,+Karanggayam&amp;aq=0&amp;oq=logandu&amp;sll=-2.550221,118.015568&amp;sspn=52.267573,80.332031&amp;t=h&amp;ie=UTF8&amp;hq=&amp;hnear=Logandu,+Karanggayam,+Kebumen,+Central+Java&amp;z=14≪=-7.55854,109.634173&amp;output=embed\" width=\"600\" height=\"450\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe></p>', 1, '2016-08-26 14:28:14', 999, 1, 'Wilayah Desa', 0, '1472192894', '1472192894', '1472192894', '', '', 1, 'wilayah-desa', 0);
INSERT INTO `artikel` (`id`, `gambar`, `isi`, `enabled`, `tgl_upload`, `id_kategori`, `id_user`, `judul`, `headline`, `gambar1`, `gambar2`, `gambar3`, `dokumen`, `link_dokumen`, `boleh_komentar`, `slug`, `hit`) VALUES (99, '1472228892Raja Lombok 1902.jpg', '<p style=\"text-align: justify;\" align=\"center\">Sejarah telah mencatat bahwa Pulau Lombok pernah menjadi wilayah kekuasaan Kerajaan Karang Asem Bali yang berkedudukan di Cakranegara dengan seorang raja bernama Anak Agung Gde Jelantik. Berakhirnya <strong>kekuasaan</strong> Kerajaan Karang Asem Bali di Pulau Lombok setelah datangnya Belanda pada Tahun 1891, dimana Belanda pada waktu itu ingin menguasai Pulau Lombok dengan dalih pura-pura membantu rakyat Lombok yang dianggap tertindas oleh Pemerintahan Raja Lombok yaitu Anak Agung Gede Jelantik.</p>\r\n<p style=\"text-align: justify;\">Pada masa kekuasaan Raja Lombok yaitu Anak Agung Gde Jelantik, wilayah Desa Senggigi ( Dusun Mangsit, Kerandangan, Senggigi dan Dusun Loco) masih bergabung dengan Desa Senteluk yang sekarang menjadi Desa Meninting . Sedangkan pada tahun 1962 Desa Senteluk pecah menjadi 2 (Dua) desa yaitu Desa Meninting dan Desa Batulayar dan Dusun Mangsit,Kerandangan,Senggigi dan Dusun Loco bergabung ke Desa Batulayar.&nbsp;</p>\r\n<p style=\"text-align: justify;\">Pemberian nama Desa Batulayar pada waktu itu yang lazim disebut dengan Pemusungan/Kepala Dea Batulayar berdasarkan hasil musyawarah nama Batulayar diambil dari nama tempat yang amat terkenal yaitu Makam Batulayar yang sampai saat ini banyak dikunjungi oleh masyarakat Pulau Lombok pada khususnya dan Masyarakat Nusa Tenggara Barat pada umumnya.</p>\r\n<p style=\"text-align: justify;\">Pada tahun 2001 Desa Batulayar dimekarkan menjadi 2 (dua) yaitu Desa Batulayar (sebagai Desa Induk) dan Desa Senggigi (sebagai Desa Persiapan) dengan SK.Bupati No : 30 Tahun 2001 tanggal 17 Mei 2001, yang pada waktu itu yang menjadi pejabat Kepala Desa Senggigi ialah <strong>H. ARIF RAHMAN, S.IP</strong>., dengan jumlah dusun sebanyak 3 dusun, yaitu :</p>\r\n<p>1. Dusun Senggigi</p>\r\n<p>2. Dusun Kerandangan</p>\r\n<p>3. Dusun Mangsit</p>\r\n<p>Selanjutnya pada tanggal 30 Juli 2003 Pejabat Kepala Desa Senggigi dari <strong>H. ARIF RAHMAN, S.IP</strong> diganti oleh Saudara<strong> ARIFIN</strong> dengan SK. Bupati Lombok Barat No : 409/66/pem/2003. Berhubung Desa Senggigi masih bersifat Desa Persiapan, maka berdasarkan hasil musyawarah desa, tertanggal 15 Desember 2003 , maka pada tanggal 22 Desember 2003 Desa Senggigi mengadakan Pemilihan Kepala Desa devinitif yang pertama kali dipimpin oleh&nbsp;<strong>HAJI JUNAIDI</strong>&nbsp;terpilih&nbsp;dengan SK. Bupati Lombok Barat No :01/01/Pem/2004 tertanggal 2 Januari 2004&nbsp;sampai pada tahun 2008.&nbsp;</p>\r\n<p style=\"text-align: justify;\">Selanjutnya pada tahun 2008, Desa Senggigi mengadakan pemilihan Kepala Desa Senggigi yang kedua dan dimenangkan oleh Bapak <strong>H. MUTAKIR AHMAD</strong>&nbsp;dengan&nbsp;SK. Bupati Lombok Barat No :1320/48/Pem./2008 tertanggal 23 Desember 2008, Periode 2008-2014. &nbsp;Kemudian Kepala desa terpilih Periode 2015 s/d 2021&nbsp;adalah <strong>MUHAMMAD ILHAM</strong>&nbsp;dengan SK. Bupati Lombok Barat No : 160/04/BPMPD/15 tanggal 27 Januari 2015 kini baru menjabat 2 (dua) bulan.</p>\r\n<p style=\"text-align: justify;\">Demikian selanyang pandang atau sejarah singkat Desa Senggigi yang dapat kami sampaikan kepada para pegiat Medsos, semoga dapat bermanfaat untuk kita semua, terima kasih.</p>\r\n<p style=\"text-align: justify;\" align=\"center\">&nbsp;</p>\r\n<p style=\"text-align: justify;\" align=\"center\">&nbsp;</p>', 1, '2016-08-26 15:38:09', 999, 1, 'Sejarah Desa', 3, '1472229325490125_20121123041539.jpg', '1472197089', '1472197089', '', '', 1, 'sejarah-desa', 0);


#
# TABLE STRUCTURE FOR: captcha_codes
#

DROP TABLE IF EXISTS `captcha_codes`;

CREATE TABLE `captcha_codes` (
  `id` varchar(40) NOT NULL,
  `namespace` varchar(32) NOT NULL,
  `code` varchar(32) NOT NULL,
  `code_display` varchar(32) NOT NULL,
  `created` int(11) NOT NULL,
  `audio_data` mediumblob,
  PRIMARY KEY (`id`,`namespace`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `captcha_codes` (`id`, `namespace`, `code`, `code_display`, `created`, `audio_data`) VALUES ('10.0.2.2', 'default', '2ypo6p', '2yPo6P', 1527544062, NULL);
INSERT INTO `captcha_codes` (`id`, `namespace`, `code`, `code_display`, `created`, `audio_data`) VALUES ('192.168.33.1', 'default', 'uzn728', 'uzN728', 1583017284, NULL);


#
# TABLE STRUCTURE FOR: cdesa
#

DROP TABLE IF EXISTS `cdesa`;

CREATE TABLE `cdesa` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `nomor` varchar(20) NOT NULL,
  `nama_kepemilikan` varchar(100) NOT NULL,
  `jenis_pemilik` tinyint(1) NOT NULL DEFAULT '0',
  `nama_pemilik_luar` varchar(100) DEFAULT NULL,
  `alamat_pemilik_luar` varchar(200) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int(11) NOT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_by` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nomor` (`nomor`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: cdesa_penduduk
#

DROP TABLE IF EXISTS `cdesa_penduduk`;

CREATE TABLE `cdesa_penduduk` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_cdesa` int(5) unsigned NOT NULL,
  `id_pend` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_cdesa` (`id_cdesa`),
  CONSTRAINT `cdesa_penduduk_fk` FOREIGN KEY (`id_cdesa`) REFERENCES `cdesa` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: config
#

DROP TABLE IF EXISTS `config`;

CREATE TABLE `config` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `nama_desa` varchar(100) NOT NULL,
  `kode_desa` varchar(100) NOT NULL,
  `nama_kepala_desa` varchar(100) NOT NULL,
  `nip_kepala_desa` varchar(100) NOT NULL,
  `kode_pos` varchar(6) NOT NULL,
  `nama_kecamatan` varchar(100) NOT NULL,
  `kode_kecamatan` varchar(100) NOT NULL,
  `nama_kepala_camat` varchar(100) NOT NULL,
  `nip_kepala_camat` varchar(100) NOT NULL,
  `nama_kabupaten` varchar(100) NOT NULL,
  `kode_kabupaten` varchar(100) NOT NULL,
  `nama_propinsi` varchar(100) NOT NULL,
  `kode_propinsi` varchar(100) NOT NULL,
  `logo` varchar(100) DEFAULT NULL,
  `lat` varchar(20) DEFAULT NULL,
  `lng` varchar(20) DEFAULT NULL,
  `zoom` tinyint(4) DEFAULT NULL,
  `map_tipe` varchar(20) DEFAULT NULL,
  `path` text,
  `alamat_kantor` varchar(200) DEFAULT NULL,
  `email_desa` varchar(50) DEFAULT NULL,
  `telepon` varchar(50) DEFAULT NULL,
  `website` varchar(100) DEFAULT NULL,
  `kantor_desa` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `config` (`id`, `nama_desa`, `kode_desa`, `nama_kepala_desa`, `nip_kepala_desa`, `kode_pos`, `nama_kecamatan`, `kode_kecamatan`, `nama_kepala_camat`, `nip_kepala_camat`, `nama_kabupaten`, `kode_kabupaten`, `nama_propinsi`, `kode_propinsi`, `logo`, `lat`, `lng`, `zoom`, `map_tipe`, `path`, `alamat_kantor`, `email_desa`, `telepon`, `website`, `kantor_desa`) VALUES (1, 'Senggig1 ', '5201142005', 'Muhammad Ilham ', '--', '83355', 'Batulay4r ', '520114', 'Bambang Budi Sanyoto, S. H', '-', 'Lombok Bart ', '5201', 'Nusa Tenggara Barat', '52', 'opensid_logo__sid__bXziTU1.png', '-8.483832804795249', '116.08523368835449', 14, 'HYBRID', '[[[-8.470247273601585,116.03699684143068],[-8.470993084228864,116.03974342346193],[-8.471775371367853,116.04249000549318],[-8.474831548688417,116.04557991027833],[-8.47754813036,116.04334831237793],[-8.478736628804842,116.0522747039795],[-8.48688623339785,116.04712486267091],[-8.492319207044495,116.04626655578615],[-8.492319207044495,116.04866981506349],[-8.490281850938663,116.05433464050294],[-8.499110315926593,116.06446266174318],[-8.507429260374638,116.06068611145021],[-8.509466525358253,116.05605125427248],[-8.501656950751967,116.04969978332521],[-8.501656950751967,116.046781539917],[-8.503694246430312,116.04454994201662],[-8.496820982890759,116.0453224182129],[-8.494953428786745,116.03931427001955],[-8.48986005320605,116.0365676879883],[-8.48493639256516,116.03364944458009],[-8.47975533883251,116.03768348693849]]]', 'Jl. Raya Senggigi Km 10 Kerandangan ', '', '', '', NULL);


#
# TABLE STRUCTURE FOR: detail_log_penduduk
#

DROP TABLE IF EXISTS `detail_log_penduduk`;

CREATE TABLE `detail_log_penduduk` (
  `id` int(10) NOT NULL,
  `nama` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: dokumen
#

DROP TABLE IF EXISTS `dokumen`;

CREATE TABLE `dokumen` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `satuan` varchar(200) NOT NULL,
  `nama` varchar(200) NOT NULL,
  `enabled` int(2) NOT NULL DEFAULT '1',
  `tgl_upload` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `id_pend` int(11) NOT NULL DEFAULT '0',
  `kategori` tinyint(3) NOT NULL DEFAULT '1',
  `attr` text NOT NULL,
  `tahun` int(4) DEFAULT NULL,
  `kategori_info_publik` tinyint(4) DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `id_syarat` int(11) DEFAULT NULL,
  `id_parent` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` varchar(16) DEFAULT NULL,
  `updated_by` varchar(16) DEFAULT NULL,
  `dok_warga` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `dokumen` (`id`, `satuan`, `nama`, `enabled`, `tgl_upload`, `id_pend`, `kategori`, `attr`, `tahun`, `kategori_info_publik`, `updated_at`, `deleted`, `id_syarat`, `id_parent`, `created_at`, `created_by`, `updated_by`, `dok_warga`) VALUES (2, 'SK+TIM+Penyusun+RPJMDes+Tahun+2017_uwdc6N_grafik-statistik-ada-jumlah.png', 'SK TIM Penyusun RPJMDes Tahun 2017', 1, '2018-05-28 06:49:28', 0, 2, '{\"uraian\":\"SK TIM Penyusun RPJMDes Tahun 2017\",\"no_kep_kades\":\"1\",\"tgl_kep_kades\":\"13-01-2017\",\"no_lapor\":\"1\",\"tgl_lapor\":\"13-01-2017\",\"keterangan\":\"Sudah Terbit\"}', 2017, 3, '2019-11-30 22:01:57', 0, NULL, NULL, '2020-07-30 03:35:14', NULL, NULL, 0);
INSERT INTO `dokumen` (`id`, `satuan`, `nama`, `enabled`, `tgl_upload`, `id_pend`, `kategori`, `attr`, `tahun`, `kategori_info_publik`, `updated_at`, `deleted`, `id_syarat`, `id_parent`, `created_at`, `created_by`, `updated_by`, `dok_warga`) VALUES (3, 'SK+Pengangkatan+RT+dan+Pemberentian+RT+Baru_OzjhwE_surat-kk-peraturan.jpg', 'SK Pengangkatan RT dan Pemberentian RT Baru', 1, '2018-05-28 06:51:53', 0, 2, '{\"uraian\":\"SK Pengangkatan RT dan Pemberentian RT Baru\",\"no_kep_kades\":\"2\",\"tgl_kep_kades\":\"14-01-2017\",\"no_lapor\":\"2\",\"tgl_lapor\":\"14-01-2017\",\"keterangan\":\"Sudah Terbit\"}', 2017, 3, '2019-11-30 22:01:57', 0, NULL, NULL, '2020-07-30 03:35:14', NULL, NULL, 0);
INSERT INTO `dokumen` (`id`, `satuan`, `nama`, `enabled`, `tgl_upload`, `id_pend`, `kategori`, `attr`, `tahun`, `kategori_info_publik`, `updated_at`, `deleted`, `id_syarat`, `id_parent`, `created_at`, `created_by`, `updated_by`, `dok_warga`) VALUES (4, 'Perdes+SPJ+Tentang+Keuang+Desa+Tahun+2016_cXJUfP_user-setting-pengaturan.png', 'Perdes SPJ Tentang Keuang Desa Tahun 2016', 1, '2018-05-28 06:57:37', 0, 3, '{\"uraian\":\"Perdes SPJ Tentang Keuang Desa Tahun 2016\",\"jenis_peraturan\":\"Perdes SPJ Tahun 2016\",\"no_ditetapkan\":\"1\",\"tgl_ditetapkan\":\"09-01-2016\",\"tgl_kesepakatan\":\"05-01-2016\",\"no_lapor\":\"1\",\"tgl_lapor\":\"05-01-2016\",\"no_lembaran_desa\":\"1\",\"tgl_lembaran_desa\":\"05-01-2017\",\"no_berita_desa\":\"1\",\"tgl_berita_desa\":\"05-01-2017\",\"keterangan\":\"Sudah Terbit\"}', 2016, 3, '2019-11-30 22:01:57', 0, NULL, NULL, '2020-07-30 03:35:14', NULL, NULL, 0);
INSERT INTO `dokumen` (`id`, `satuan`, `nama`, `enabled`, `tgl_upload`, `id_pend`, `kategori`, `attr`, `tahun`, `kategori_info_publik`, `updated_at`, `deleted`, `id_syarat`, `id_parent`, `created_at`, `created_by`, `updated_by`, `dok_warga`) VALUES (5, 'RPJMDes+Miau+Merah+Tahun+2016+s%2Fd+2022_fMaZGt_cetak-log-penduduk.png', 'RPJMDes Miau Merah Tahun 2016 s/d 2022', 1, '2018-05-28 07:09:56', 0, 3, '{\"uraian\":\"Rencana Pembangunan Jangka Menengah Desa\",\"jenis_peraturan\":\"RPJMDes\",\"no_ditetapkan\":\"2\",\"tgl_ditetapkan\":\"13-01-2017\",\"tgl_kesepakatan\":\"13-01-2017\",\"no_lapor\":\"2\",\"tgl_lapor\":\"13-01-2017\",\"no_lembaran_desa\":\"2\",\"tgl_lembaran_desa\":\"14-01-2017\",\"no_berita_desa\":\"2\",\"tgl_berita_desa\":\"14-01-2017\",\"keterangan\":\"Sudah Terbit\"}', 2017, 3, '2019-11-30 22:01:57', 0, NULL, NULL, '2020-07-30 03:35:14', NULL, NULL, 0);
INSERT INTO `dokumen` (`id`, `satuan`, `nama`, `enabled`, `tgl_upload`, `id_pend`, `kategori`, `attr`, `tahun`, `kategori_info_publik`, `updated_at`, `deleted`, `id_syarat`, `id_parent`, `created_at`, `created_by`, `updated_by`, `dok_warga`) VALUES (6, 'formulir-pengajuan-keberatan-informasi-od5ryq-ammar-alifian-fahdan-1-jpg.jpg', 'Formulir Pengajuan Keberatan Informasi', 1, '2019-10-31 22:20:48', 0, 1, '[]', 2019, 1, '2019-11-30 22:01:57', 0, NULL, NULL, '2020-07-30 03:35:14', NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: gambar_gallery
#

DROP TABLE IF EXISTS `gambar_gallery`;

CREATE TABLE `gambar_gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parrent` int(4) DEFAULT '0',
  `gambar` varchar(200) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `enabled` int(2) NOT NULL DEFAULT '1',
  `tgl_upload` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tipe` int(4) DEFAULT '0',
  `slider` tinyint(1) DEFAULT NULL,
  `urut` int(5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `parrent` (`parrent`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8;

INSERT INTO `gambar_gallery` (`id`, `parrent`, `gambar`, `nama`, `enabled`, `tgl_upload`, `tipe`, `slider`, `urut`) VALUES (28, 0, 'galeri-1-1.jpg', 'Karnaval Hari Kemerdekaan ', 1, '2016-08-26 14:53:51', 0, NULL, NULL);
INSERT INTO `gambar_gallery` (`id`, `parrent`, `gambar`, `nama`, `enabled`, `tgl_upload`, `tipe`, `slider`, `urut`) VALUES (29, 0, '', 'Panorama Wisata ', 1, '2016-08-26 14:55:31', 0, NULL, NULL);
INSERT INTO `gambar_gallery` (`id`, `parrent`, `gambar`, `nama`, `enabled`, `tgl_upload`, `tipe`, `slider`, `urut`) VALUES (30, 28, 'IMG-20160823-WA0116.jpg', 'Karnaval baju adat', 1, '2016-08-26 14:57:10', 2, NULL, NULL);
INSERT INTO `gambar_gallery` (`id`, `parrent`, `gambar`, `nama`, `enabled`, `tgl_upload`, `tipe`, `slider`, `urut`) VALUES (31, 28, 'galeri-1-2.jpeg', 'Kemeriahan Karnaval', 2, '2016-08-26 14:58:16', 2, NULL, NULL);
INSERT INTO `gambar_gallery` (`id`, `parrent`, `gambar`, `nama`, `enabled`, `tgl_upload`, `tipe`, `slider`, `urut`) VALUES (32, 29, 'galeri-2-2.jpeg', 'Pantai indah', 1, '2016-09-02 02:14:06', 2, NULL, NULL);
INSERT INTO `gambar_gallery` (`id`, `parrent`, `gambar`, `nama`, `enabled`, `tgl_upload`, `tipe`, `slider`, `urut`) VALUES (33, 29, 'galeri-2-3.jpeg', 'Kolam renang impian', 1, '2016-09-02 02:14:28', 2, NULL, NULL);
INSERT INTO `gambar_gallery` (`id`, `parrent`, `gambar`, `nama`, `enabled`, `tgl_upload`, `tipe`, `slider`, `urut`) VALUES (34, 0, '', 'Kegiatan Kantor Desa', 2, '2016-09-02 06:24:59', 0, NULL, NULL);
INSERT INTO `gambar_gallery` (`id`, `parrent`, `gambar`, `nama`, `enabled`, `tgl_upload`, `tipe`, `slider`, `urut`) VALUES (35, 28, '', 'Tarian adat', 1, '2016-09-02 07:32:55', 2, NULL, NULL);


#
# TABLE STRUCTURE FOR: garis
#

DROP TABLE IF EXISTS `garis`;

CREATE TABLE `garis` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `nama` varchar(50) NOT NULL,
  `path` text,
  `enabled` int(11) NOT NULL DEFAULT '1',
  `ref_line` int(9) NOT NULL,
  `foto` varchar(100) DEFAULT NULL,
  `desk` text,
  `id_cluster` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `garis` (`id`, `nama`, `path`, `enabled`, `ref_line`, `foto`, `desk`, `id_cluster`) VALUES (1, 'Jalan 1', '', 1, 1, '', '', 0);


#
# TABLE STRUCTURE FOR: gis_simbol
#

DROP TABLE IF EXISTS `gis_simbol`;

CREATE TABLE `gis_simbol` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `simbol` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `simbol` (`simbol`),
  UNIQUE KEY `simbol_2` (`simbol`),
  UNIQUE KEY `simbol_3` (`simbol`),
  UNIQUE KEY `simbol_4` (`simbol`),
  UNIQUE KEY `simbol_5` (`simbol`),
  UNIQUE KEY `simbol_6` (`simbol`)
) ENGINE=InnoDB AUTO_INCREMENT=639 DEFAULT CHARSET=utf8;

INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (611, 'aa_bni.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (612, 'aa_bri.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (613, 'aa_btn.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (614, 'aa_btp.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (615, 'aa_pajak.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (616, 'aa_pdam.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (617, 'aa_pgadai.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (618, 'aa_pln.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (619, 'aa_pmi.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (620, 'aa_polisi.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (621, 'aa_prtmn.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (622, 'aa_pskms.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (623, 'aa_ptrns.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (624, 'aa_pwbdh.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (625, 'aa_pwhnd.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (626, 'aa_pwisl.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (627, 'aa_pwkhc.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (628, 'aa_pwkrs.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (629, 'aa_sk.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (630, 'aa_skagm.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (631, 'aa_skint.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (632, 'aa_sksd.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (633, 'aa_sksma.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (634, 'aa_sksmp.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (635, 'aa_sktk.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (636, 'aa_tniad.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (637, 'aa_tnial.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (638, 'aa_tniau.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (1, 'accident.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (2, 'accident_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (3, 'administration.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (4, 'administration_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (5, 'aestheticscenter.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (6, 'agriculture.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (7, 'agriculture2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (8, 'agriculture3.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (9, 'agriculture4.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (10, 'aircraft-small.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (11, 'airplane-sport.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (12, 'airplane-tourism.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (13, 'airport-apron.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (14, 'airport-runway.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (15, 'airport-terminal.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (16, 'airport.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (17, 'airport_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (18, 'amphitheater-tourism.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (19, 'amphitheater.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (20, 'ancientmonument.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (21, 'ancienttemple.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (22, 'ancienttempleruin.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (23, 'animals.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (24, 'animals_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (25, 'anniversary.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (26, 'apartment.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (27, 'apartment_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (28, 'aquarium.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (29, 'arch.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (30, 'archery.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (31, 'artgallery.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (32, 'atm.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (33, 'atv.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (34, 'audio.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (35, 'australianfootball.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (36, 'bags.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (37, 'bank.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (39, 'bankeuro.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (40, 'bankpound.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (38, 'bank_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (41, 'bar.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (42, 'bar_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (43, 'baseball.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (44, 'basketball.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (45, 'baskteball2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (46, 'beach.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (47, 'beach_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (48, 'beautiful.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (49, 'beautiful_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (50, 'bench.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (51, 'biblio.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (52, 'bicycleparking.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (53, 'bigcity.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (54, 'billiard.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (55, 'bobsleigh.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (56, 'bomb.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (57, 'bookstore.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (58, 'bowling.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (59, 'bowling_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (60, 'boxing.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (61, 'bread.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (62, 'bread_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (63, 'bridge.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (64, 'bridgemodern.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (65, 'bullfight.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (66, 'bungalow.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (67, 'bus.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (68, 'bus_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (69, 'butcher.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (70, 'cabin.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (71, 'cablecar.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (72, 'camping.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (74, 'campingsite.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (73, 'camping_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (75, 'canoe.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (76, 'car.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (78, 'carrental.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (79, 'carrepair.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (80, 'carrepair_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (81, 'carwash.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (77, 'car_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (82, 'casino.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (83, 'casino_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (84, 'castle.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (85, 'cathedral.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (86, 'cathedral2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (87, 'cave.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (88, 'cemetary.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (89, 'chapel.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (90, 'church.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (91, 'church2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (92, 'church_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (93, 'cinema.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (94, 'cinema_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (95, 'circus.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (96, 'citysquare.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (97, 'climbing.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (98, 'clothes-female.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (99, 'clothes-male.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (100, 'clothes.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (101, 'clothes_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (102, 'clouds.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (104, 'cloudsun.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (105, 'cloudsun_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (103, 'clouds_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (106, 'club.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (107, 'club_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (108, 'cluster.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (109, 'cluster2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (110, 'cluster3.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (111, 'cluster4.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (112, 'cluster5.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (113, 'cocktail.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (114, 'coffee.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (115, 'coffee_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (116, 'communitycentre.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (117, 'company.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (118, 'company_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (119, 'computer.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (120, 'computer_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (121, 'concessionaire.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (122, 'conference.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (123, 'construction.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (124, 'convenience.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (125, 'convent.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (126, 'corral.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (127, 'country.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (128, 'court.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (129, 'cricket.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (130, 'cross.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (131, 'crossingguard.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (132, 'cruise.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (133, 'currencyexchange.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (134, 'customs.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (135, 'cycling.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (137, 'cyclingfeedarea.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (138, 'cyclingmountain1.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (139, 'cyclingmountain2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (140, 'cyclingmountain3.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (141, 'cyclingmountain4.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (142, 'cyclingmountainnotrated.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (143, 'cyclingsport.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (144, 'cyclingsprint.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (145, 'cyclinguncategorized.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (136, 'cycling_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (146, 'dam.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (147, 'dancinghall.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (148, 'dates.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (149, 'dates_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (150, 'daycare.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (151, 'days-dim.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (152, 'days-dom.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (153, 'days-jeu.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (154, 'days-jue.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (155, 'days-lun.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (156, 'days-mar.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (157, 'days-mer.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (158, 'days-mie.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (159, 'days-qua.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (160, 'days-qui.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (161, 'days-sab.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (162, 'days-sam.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (163, 'days-seg.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (164, 'days-sex.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (165, 'days-ter.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (166, 'days-ven.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (167, 'days-vie.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (168, 'default.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (169, 'dentist.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (170, 'deptstore.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (171, 'disability.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (172, 'disability_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (173, 'disabledparking.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (174, 'diving.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (175, 'doctor.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (176, 'doctor_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (177, 'dog-leash.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (178, 'dog-offleash.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (179, 'door.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (180, 'down.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (181, 'downleft.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (182, 'downright.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (183, 'downthenleft.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (184, 'downthenright.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (185, 'drinkingfountain.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (186, 'drinkingwater.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (187, 'drugs.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (188, 'drugs_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (189, 'elevator.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (190, 'embassy.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (191, 'emblem-art.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (192, 'emblem-photos.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (193, 'entrance.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (194, 'escalator-down.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (195, 'escalator-up.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (196, 'exit.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (197, 'expert.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (198, 'explosion.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (199, 'face-devilish.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (200, 'face-embarrassed.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (201, 'factory.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (202, 'factory_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (203, 'fallingrocks.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (204, 'family.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (205, 'farm.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (206, 'farm_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (207, 'fastfood.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (208, 'fastfood_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (209, 'festival-itinerant.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (210, 'festival.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (211, 'findajob.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (212, 'findjob.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (213, 'findjob_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (214, 'fire-extinguisher.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (215, 'fire.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (216, 'firemen.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (217, 'firemen_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (218, 'fireworks.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (219, 'firstaid.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (220, 'fishing.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (222, 'fishingshop.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (221, 'fishing_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (223, 'fitnesscenter.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (224, 'fjord.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (225, 'flood.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (226, 'flowers.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (227, 'flowers_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (228, 'followpath.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (229, 'foodtruck.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (230, 'forest.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (231, 'fortress.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (232, 'fossils.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (233, 'fountain.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (234, 'friday.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (235, 'friday_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (236, 'friends.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (237, 'friends_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (238, 'garden.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (239, 'gateswalls.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (240, 'gazstation.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (241, 'gazstation_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (242, 'geyser.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (243, 'gifts.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (244, 'girlfriend.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (245, 'girlfriend_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (246, 'glacier.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (247, 'golf.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (248, 'golf_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (249, 'gondola.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (250, 'gourmet.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (251, 'grocery.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (252, 'gun.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (253, 'gym.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (254, 'hairsalon.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (255, 'handball.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (256, 'hanggliding.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (257, 'hats.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (258, 'headstone.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (259, 'headstonejewish.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (260, 'helicopter.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (261, 'highway.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (262, 'highway_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (263, 'hiking-tourism.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (264, 'hiking.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (265, 'hiking_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (266, 'historicalquarter.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (267, 'home.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (268, 'home_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (269, 'horseriding.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (270, 'horseriding_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (271, 'hospital.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (272, 'hospital_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (273, 'hostel.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (274, 'hotairballoon.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (275, 'hotel.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (276, 'hotel1star.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (277, 'hotel2stars.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (278, 'hotel3stars.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (279, 'hotel4stars.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (280, 'hotel5stars.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (281, 'hotel_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (282, 'house.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (283, 'hunting.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (284, 'icecream.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (285, 'icehockey.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (286, 'iceskating.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (287, 'im-user.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (288, 'index.html');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (289, 'info.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (290, 'info_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (291, 'jewelry.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (292, 'jewishquarter.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (293, 'jogging.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (294, 'judo.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (295, 'justice.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (296, 'justice_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (297, 'karate.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (298, 'karting.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (299, 'kayak.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (300, 'laboratory.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (301, 'lake.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (302, 'laundromat.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (303, 'left.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (304, 'leftthendown.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (305, 'leftthenup.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (306, 'library.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (307, 'library_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (308, 'lighthouse.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (309, 'liquor.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (310, 'lock.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (311, 'lockerrental.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (312, 'magicshow.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (313, 'mainroad.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (314, 'massage.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (315, 'military.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (316, 'military_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (317, 'mine.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (318, 'mobilephonetower.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (319, 'modernmonument.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (320, 'moderntower.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (321, 'monastery.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (322, 'monday.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (323, 'monday_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (324, 'monument.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (325, 'mosque.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (326, 'motorbike.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (327, 'motorcycle.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (328, 'movierental.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (329, 'museum-archeological.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (330, 'museum-art.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (331, 'museum-crafts.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (332, 'museum-historical.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (333, 'museum-naval.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (334, 'museum-science.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (335, 'museum-war.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (336, 'museum.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (337, 'museum_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (338, 'music-classical.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (339, 'music-hiphop.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (340, 'music-live.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (341, 'music-rock.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (342, 'music.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (343, 'music_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (344, 'nanny.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (345, 'newsagent.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (346, 'nordicski.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (347, 'nursery.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (348, 'observatory.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (349, 'oilpumpjack.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (350, 'olympicsite.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (351, 'ophthalmologist.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (352, 'pagoda.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (353, 'paint.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (354, 'palace.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (355, 'panoramic.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (356, 'panoramic180.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (357, 'park-urban.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (358, 'park.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (360, 'parkandride.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (361, 'parking.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (362, 'parking_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (359, 'park_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (363, 'party.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (364, 'patisserie.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (365, 'pedestriancrossing.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (366, 'pend.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (367, 'pens.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (368, 'perfumery.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (369, 'personal.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (370, 'personalwatercraft.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (371, 'petroglyphs.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (372, 'pets.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (373, 'phones.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (374, 'photo.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (375, 'photodown.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (376, 'photodownleft.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (377, 'photodownright.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (378, 'photography.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (379, 'photoleft.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (380, 'photoright.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (381, 'photoup.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (382, 'photoupleft.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (383, 'photoupright.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (384, 'picnic.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (385, 'pizza.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (386, 'pizza_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (387, 'places-unvisited.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (388, 'places-visited.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (389, 'planecrash.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (390, 'playground.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (391, 'playground_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (392, 'poker.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (393, 'poker_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (394, 'police.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (395, 'police2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (396, 'police_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (397, 'pool-indoor.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (398, 'pool.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (399, 'pool_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (400, 'port.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (401, 'port_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (402, 'postal.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (403, 'postal_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (404, 'powerlinepole.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (405, 'powerplant.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (406, 'powersubstation.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (407, 'prison.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (408, 'publicart.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (409, 'racing.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (410, 'radiation.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (411, 'rain_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (412, 'rain_3.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (413, 'rattlesnake.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (414, 'realestate.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (415, 'realestate_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (416, 'recycle.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (417, 'recycle_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (418, 'recycle_3.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (419, 'regroup.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (420, 'regulier.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (421, 'resort.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (422, 'restaurant-barbecue.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (423, 'restaurant-buffet.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (424, 'restaurant-fish.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (425, 'restaurant-romantic.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (426, 'restaurant.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (428, 'restaurantafrican.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (429, 'restaurantchinese.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (430, 'restaurantchinese_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (431, 'restaurantfishchips.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (432, 'restaurantgourmet.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (433, 'restaurantgreek.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (434, 'restaurantindian.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (435, 'restaurantitalian.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (436, 'restaurantjapanese.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (437, 'restaurantjapanese_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (438, 'restaurantkebab.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (439, 'restaurantkorean.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (440, 'restaurantmediterranean.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (441, 'restaurantmexican.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (442, 'restaurantthai.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (443, 'restaurantturkish.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (427, 'restaurant_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (444, 'revolution.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (445, 'right.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (446, 'rightthendown.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (447, 'rightthenup.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (448, 'riparian.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (449, 'ropescourse.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (450, 'rowboat.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (451, 'rugby.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (452, 'ruins.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (453, 'sailboat-sport.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (454, 'sailboat-tourism.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (455, 'sailboat.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (456, 'salle-fete.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (457, 'satursday.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (458, 'satursday_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (459, 'sauna.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (460, 'school.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (461, 'school_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (462, 'schrink.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (463, 'schrink_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (464, 'sciencecenter.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (465, 'seals.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (466, 'seniorsite.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (467, 'shadow.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (468, 'shelter-picnic.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (469, 'shelter-sleeping.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (470, 'shoes.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (471, 'shoes_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (472, 'shoppingmall.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (473, 'shore.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (474, 'shower.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (475, 'sight.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (476, 'skateboarding.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (477, 'skiing.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (478, 'skiing_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (479, 'skijump.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (480, 'skilift.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (481, 'smallcity.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (482, 'smokingarea.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (483, 'sneakers.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (484, 'snow.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (485, 'snowboarding.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (486, 'snowmobiling.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (487, 'snowshoeing.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (488, 'soccer.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (489, 'soccer2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (490, 'soccer_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (491, 'spaceport.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (492, 'spectacle.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (493, 'speed100.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (494, 'speed110.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (495, 'speed120.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (496, 'speed130.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (497, 'speed20.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (498, 'speed30.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (499, 'speed40.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (500, 'speed50.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (501, 'speed60.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (502, 'speed70.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (503, 'speed80.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (504, 'speed90.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (505, 'speedhump.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (506, 'spelunking.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (507, 'stadium.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (508, 'statue.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (509, 'steamtrain.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (510, 'stop.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (511, 'stoplight.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (512, 'stoplight_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (513, 'strike.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (514, 'strike1.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (515, 'subway.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (516, 'sun.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (518, 'sunday.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (519, 'sunday_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (517, 'sun_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (520, 'supermarket.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (521, 'supermarket_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (522, 'surfing.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (523, 'suv.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (524, 'synagogue.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (525, 'tailor.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (526, 'tapas.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (527, 'taxi.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (529, 'taxiway.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (528, 'taxi_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (530, 'teahouse.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (531, 'telephone.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (532, 'templehindu.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (533, 'tennis.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (534, 'tennis2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (535, 'tennis_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (536, 'tent.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (537, 'terrace.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (538, 'text.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (539, 'textiles.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (540, 'theater.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (541, 'theater_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (542, 'themepark.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (543, 'thunder.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (544, 'thunder_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (545, 'thursday.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (546, 'thursday_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (547, 'toilets.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (548, 'toilets_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (549, 'tollstation.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (550, 'tools.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (551, 'tower.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (552, 'toys.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (553, 'toys_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (554, 'trafficenforcementcamera.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (555, 'train.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (556, 'train_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (557, 'tram.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (558, 'trash.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (559, 'truck.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (560, 'truck_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (561, 'tuesday.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (562, 'tuesday_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (563, 'tunnel.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (564, 'turnleft.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (565, 'turnright.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (566, 'university.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (567, 'university_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (568, 'unnamed.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (569, 'up.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (570, 'upleft.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (571, 'upright.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (572, 'upthenleft.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (573, 'upthenright.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (574, 'usfootball.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (575, 'vespa.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (576, 'vet.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (577, 'video.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (578, 'videogames.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (579, 'videogames_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (580, 'villa.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (581, 'waitingroom.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (582, 'water.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (583, 'waterfall.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (584, 'watermill.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (585, 'waterpark.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (586, 'waterskiing.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (587, 'watertower.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (588, 'waterwell.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (589, 'waterwellpump.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (590, 'wedding.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (591, 'wednesday.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (592, 'wednesday_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (593, 'wetland.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (594, 'white1.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (595, 'white20.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (596, 'wifi.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (597, 'wifi_2.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (598, 'windmill.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (599, 'windsurfing.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (600, 'windturbine.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (601, 'winery.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (602, 'wineyard.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (603, 'workoffice.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (604, 'world.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (605, 'worldheritagesite.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (606, 'yoga.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (607, 'youthhostel.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (608, 'zipline.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (609, 'zoo.png');
INSERT INTO `gis_simbol` (`id`, `simbol`) VALUES (610, 'zoo_2.png');


#
# TABLE STRUCTURE FOR: inbox
#

DROP TABLE IF EXISTS `inbox`;

CREATE TABLE `inbox` (
  `UpdatedInDB` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ReceivingDateTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Text` text NOT NULL,
  `SenderNumber` varchar(20) NOT NULL DEFAULT '',
  `Coding` enum('Default_No_Compression','Unicode_No_Compression','8bit','Default_Compression','Unicode_Compression') NOT NULL DEFAULT 'Default_No_Compression',
  `UDH` text NOT NULL,
  `SMSCNumber` varchar(20) NOT NULL DEFAULT '',
  `Class` int(11) NOT NULL DEFAULT '-1',
  `TextDecoded` text NOT NULL,
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `RecipientID` text NOT NULL,
  `Processed` enum('false','true') NOT NULL DEFAULT 'false',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: inventaris_asset
#

DROP TABLE IF EXISTS `inventaris_asset`;

CREATE TABLE `inventaris_asset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama_barang` varchar(255) NOT NULL,
  `kode_barang` varchar(64) NOT NULL,
  `register` varchar(64) NOT NULL,
  `jenis` varchar(255) NOT NULL,
  `judul_buku` varchar(255) DEFAULT NULL,
  `spesifikasi_buku` varchar(255) DEFAULT NULL,
  `asal_daerah` varchar(255) DEFAULT NULL,
  `pencipta` varchar(255) DEFAULT NULL,
  `bahan` varchar(255) DEFAULT NULL,
  `jenis_hewan` varchar(255) DEFAULT NULL,
  `ukuran_hewan` varchar(255) DEFAULT NULL,
  `jenis_tumbuhan` varchar(255) DEFAULT NULL,
  `ukuran_tumbuhan` varchar(255) DEFAULT NULL,
  `jumlah` int(64) NOT NULL,
  `tahun_pengadaan` year(4) NOT NULL,
  `asal` varchar(255) NOT NULL,
  `harga` double NOT NULL,
  `keterangan` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int(11) NOT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_by` int(11) NOT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  `visible` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: inventaris_gedung
#

DROP TABLE IF EXISTS `inventaris_gedung`;

CREATE TABLE `inventaris_gedung` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama_barang` varchar(255) NOT NULL,
  `kode_barang` varchar(64) NOT NULL,
  `register` varchar(64) NOT NULL,
  `kondisi_bangunan` varchar(255) NOT NULL,
  `kontruksi_bertingkat` varchar(255) NOT NULL,
  `kontruksi_beton` int(1) NOT NULL,
  `luas_bangunan` int(64) NOT NULL,
  `letak` varchar(255) NOT NULL,
  `tanggal_dokument` date DEFAULT NULL,
  `no_dokument` varchar(255) DEFAULT NULL,
  `luas` int(64) DEFAULT NULL,
  `status_tanah` varchar(255) DEFAULT NULL,
  `kode_tanah` varchar(255) DEFAULT NULL,
  `asal` varchar(255) NOT NULL,
  `harga` double NOT NULL,
  `keterangan` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int(11) NOT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_by` int(11) NOT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  `visible` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: inventaris_jalan
#

DROP TABLE IF EXISTS `inventaris_jalan`;

CREATE TABLE `inventaris_jalan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama_barang` varchar(255) NOT NULL,
  `kode_barang` varchar(64) NOT NULL,
  `register` varchar(64) NOT NULL,
  `kontruksi` varchar(255) NOT NULL,
  `panjang` int(64) NOT NULL,
  `lebar` int(64) NOT NULL,
  `luas` int(64) NOT NULL,
  `letak` text,
  `tanggal_dokument` date NOT NULL,
  `no_dokument` varchar(255) DEFAULT NULL,
  `status_tanah` varchar(255) DEFAULT NULL,
  `kode_tanah` varchar(255) DEFAULT NULL,
  `kondisi` varchar(255) NOT NULL,
  `asal` varchar(255) NOT NULL,
  `harga` double NOT NULL,
  `keterangan` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int(11) NOT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_by` int(11) NOT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  `visible` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: inventaris_kontruksi
#

DROP TABLE IF EXISTS `inventaris_kontruksi`;

CREATE TABLE `inventaris_kontruksi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama_barang` varchar(255) NOT NULL,
  `kondisi_bangunan` varchar(255) NOT NULL,
  `kontruksi_bertingkat` varchar(255) NOT NULL,
  `kontruksi_beton` tinyint(1) DEFAULT '0',
  `luas_bangunan` int(64) NOT NULL,
  `letak` varchar(255) NOT NULL,
  `tanggal_dokument` date DEFAULT NULL,
  `no_dokument` varchar(255) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `status_tanah` varchar(255) DEFAULT NULL,
  `kode_tanah` varchar(255) DEFAULT NULL,
  `asal` varchar(255) NOT NULL,
  `harga` double NOT NULL,
  `keterangan` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int(11) NOT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_by` int(11) NOT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  `visible` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: inventaris_peralatan
#

DROP TABLE IF EXISTS `inventaris_peralatan`;

CREATE TABLE `inventaris_peralatan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama_barang` varchar(255) NOT NULL,
  `kode_barang` varchar(64) NOT NULL,
  `register` varchar(64) NOT NULL,
  `merk` varchar(255) NOT NULL,
  `ukuran` text NOT NULL,
  `bahan` text NOT NULL,
  `tahun_pengadaan` year(4) NOT NULL,
  `no_pabrik` varchar(255) DEFAULT NULL,
  `no_rangka` varchar(255) DEFAULT NULL,
  `no_mesin` varchar(255) DEFAULT NULL,
  `no_polisi` varchar(255) DEFAULT NULL,
  `no_bpkb` varchar(255) DEFAULT NULL,
  `asal` varchar(255) NOT NULL,
  `harga` double NOT NULL,
  `keterangan` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int(11) NOT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_by` int(11) NOT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  `visible` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: inventaris_tanah
#

DROP TABLE IF EXISTS `inventaris_tanah`;

CREATE TABLE `inventaris_tanah` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama_barang` varchar(255) NOT NULL,
  `kode_barang` varchar(64) NOT NULL,
  `register` varchar(64) NOT NULL,
  `luas` int(64) NOT NULL,
  `tahun_pengadaan` year(4) NOT NULL,
  `letak` varchar(255) NOT NULL,
  `hak` varchar(255) NOT NULL,
  `no_sertifikat` varchar(255) NOT NULL,
  `tanggal_sertifikat` date NOT NULL,
  `penggunaan` varchar(255) NOT NULL,
  `asal` varchar(255) NOT NULL,
  `harga` double NOT NULL,
  `keterangan` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int(11) NOT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_by` int(11) NOT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  `visible` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: kategori
#

DROP TABLE IF EXISTS `kategori`;

CREATE TABLE `kategori` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(100) NOT NULL,
  `tipe` int(4) NOT NULL DEFAULT '1',
  `urut` tinyint(4) NOT NULL,
  `enabled` tinyint(4) NOT NULL,
  `parrent` tinyint(4) NOT NULL DEFAULT '0',
  `slug` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;

INSERT INTO `kategori` (`id`, `kategori`, `tipe`, `urut`, `enabled`, `parrent`, `slug`) VALUES (1, 'Berita Desa', 1, 1, 1, 0, 'berita-desa');
INSERT INTO `kategori` (`id`, `kategori`, `tipe`, `urut`, `enabled`, `parrent`, `slug`) VALUES (2, 'Produk Desa', 1, 3, 2, 0, 'produk-desa');
INSERT INTO `kategori` (`id`, `kategori`, `tipe`, `urut`, `enabled`, `parrent`, `slug`) VALUES (4, 'Program Kerja', 2, 2, 1, 0, 'program-kerja');
INSERT INTO `kategori` (`id`, `kategori`, `tipe`, `urut`, `enabled`, `parrent`, `slug`) VALUES (5, 'Peraturan Desa', 2, 5, 1, 0, 'peraturan-desa');
INSERT INTO `kategori` (`id`, `kategori`, `tipe`, `urut`, `enabled`, `parrent`, `slug`) VALUES (6, 'Laporan Desa', 2, 6, 2, 0, 'laporan-desa');
INSERT INTO `kategori` (`id`, `kategori`, `tipe`, `urut`, `enabled`, `parrent`, `slug`) VALUES (8, 'Panduan Layanan Desa', 2, 3, 2, 0, 'panduan-layanan-desa');
INSERT INTO `kategori` (`id`, `kategori`, `tipe`, `urut`, `enabled`, `parrent`, `slug`) VALUES (17, 'Peraturan Kebersihan Desa', 1, 0, 2, 5, 'peraturan-kebersihan-desa');
INSERT INTO `kategori` (`id`, `kategori`, `tipe`, `urut`, `enabled`, `parrent`, `slug`) VALUES (20, 'Berita Lokal', 1, 0, 2, 1, 'berita-lokal');
INSERT INTO `kategori` (`id`, `kategori`, `tipe`, `urut`, `enabled`, `parrent`, `slug`) VALUES (21, 'Berita Kriminal', 1, 0, 2, 1, 'berita-kriminal');


#
# TABLE STRUCTURE FOR: kelompok
#

DROP TABLE IF EXISTS `kelompok`;

CREATE TABLE `kelompok` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_master` int(11) NOT NULL,
  `id_ketua` int(11) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `keterangan` varchar(100) NOT NULL,
  `kode` varchar(16) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_ketua` (`id_ketua`),
  KEY `id_master` (`id_master`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: kelompok_master
#

DROP TABLE IF EXISTS `kelompok_master`;

CREATE TABLE `kelompok_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kelompok` varchar(50) NOT NULL,
  `deskripsi` varchar(400) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `kelompok_master` (`id`, `kelompok`, `deskripsi`) VALUES (1, 'Kelompok Ternak', '<p>Kelompok yang memelihara ternak</p>');


#
# TABLE STRUCTURE FOR: keuangan_manual_ref_bidang
#

DROP TABLE IF EXISTS `keuangan_manual_ref_bidang`;

CREATE TABLE `keuangan_manual_ref_bidang` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Kd_Bid` varchar(50) NOT NULL,
  `Nama_Bidang` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO `keuangan_manual_ref_bidang` (`id`, `Kd_Bid`, `Nama_Bidang`) VALUES (1, '00.0000.01', 'BIDANG PENYELENGGARAN PEMERINTAHAN DESA');
INSERT INTO `keuangan_manual_ref_bidang` (`id`, `Kd_Bid`, `Nama_Bidang`) VALUES (2, '00.0000.02', 'BIDANG PELAKSANAAN PEMBANGUNAN DESA');
INSERT INTO `keuangan_manual_ref_bidang` (`id`, `Kd_Bid`, `Nama_Bidang`) VALUES (3, '00.0000.03', 'BIDANG PEMBINAAN KEMASYARAKATAN');
INSERT INTO `keuangan_manual_ref_bidang` (`id`, `Kd_Bid`, `Nama_Bidang`) VALUES (4, '00.0000.04', 'BIDANG PEMBERDAYAAN MASYARAKAT');
INSERT INTO `keuangan_manual_ref_bidang` (`id`, `Kd_Bid`, `Nama_Bidang`) VALUES (5, '00.0000.05', 'BIDANG PENANGGULANGAN BENCANA, DARURAT DAN MENDESAK DESA');


#
# TABLE STRUCTURE FOR: keuangan_manual_ref_kegiatan
#

DROP TABLE IF EXISTS `keuangan_manual_ref_kegiatan`;

CREATE TABLE `keuangan_manual_ref_kegiatan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ID_Keg` varchar(100) NOT NULL,
  `Nama_Kegiatan` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=240 DEFAULT CHARSET=latin1;

INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (1, '01.01.01.', 'Penyediaan Penghasilan Tetap dan Tunjangan Kepala Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (2, '01.01.02.', 'Penyediaan Penghasilan Tetap dan Tunjangan Perangkat Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (3, '01.01.03.', 'Penyediaan Jaminan Sosial bagi Kepala Desa dan Perangkat Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (4, '01.01.04.', 'Penyediaan Operasional Pemerintah Desa (ATK, Honor PKPKD dan PPKD dll)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (5, '01.01.05.', 'Penyediaan Tunjangan BPD');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (6, '01.01.06.', 'Penyediaan Operasional BPD (rapat, ATK, Makan Minum, Pakaian Seragam, Listrik dll)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (7, '01.01.07.', 'Penyediaan Insentif/Operasional RT/RW');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (8, '01.01.92', 'Lain-lain Sub Bidang Siltap dan Operasional Pemerintahan Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (9, '01.02.01.', 'Penyediaan Sarana (Aset Tetap) Perkantoran/Pemerintahan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (10, '01.02.02.', 'Pemeliharaan Gedung/Prasarana Kantor Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (11, '01.02.03.', 'Pembangunan/Rehabilitasi/Peningkatan Gedung/Prasarana Kantor Desa **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (12, '01.02.90', 'Lain-lain Sub Bidang Sarana Prasarana Pemerintahan Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (13, '01.03.01.', 'Pelayanan Administrasi Umum dan  Kependudukan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (14, '01.03.02.', 'Penyusunan, Pendataan, dan Pemutakhiran Profil Desa **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (15, '01.03.03.', 'Pengelolaan Adminstrasi dan Kearsipan Pemerintahan Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (16, '01.03.04.', 'Penyuluhan dan Penyadaran Masyarakat tentang Kependudukan dan Capil');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (17, '01.03.05.', 'Pemetaan dan Analisis Kemiskinan Desa secara Partisipatif');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (18, '01.03.90', 'Lain-lain Sub Bidang Administrasi Kependudukan, Capil, Statistik dan Kearsipan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (19, '01.04.01.', 'Penyelenggaraan Musyawarah Perencanaan Desa/Pembahasan APBDes (Reguler)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (20, '01.04.02.', 'Penyelenggaraan Musyawaran Desa Lainnya (Musdus, rembug desa Non Reguler)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (21, '01.04.03.', 'Penyusunan Dokumen Perencanaan Desa (RPJMDesa/RKPDesa dll)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (22, '01.04.04.', 'Penyusunan Dokumen Keuangan Desa (APBDes, APBDes Perubahan, LPJ dll)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (23, '01.04.05.', 'Pengelolaan Administrasi/ Inventarisasi/Penilaian Aset Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (24, '01.04.06.', 'Penyusunan Kebijakan Desa (Perdes/Perkades selain Perencanaan/Keuangan)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (25, '01.04.07.', 'Penyusunan Laporan Kepala Desa, LPPDesa dan Informasi Kepada Masyarakat');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (26, '01.04.08.', 'Pengembangan Sistem Informasi Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (27, '01.04.09.', 'Koordinasi/Kerjasama Penyelenggaraan Pemerintahan & Pembangunan Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (28, '01.04.10.', 'Dukungan & Sosialisasi Pelaksanaan Pilkades, Pemilihan Ka. Kewilayahan & BPD');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (29, '01.04.11.', 'Penyelenggaran Lomba antar Kewilayahan & Pengiriman Kontingen dlm Lomdes');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (30, '01.04.97', 'Lain-lain Sub Bidang Tata Praja Pemerintahan, Perencanaan, Keuangan & Pelaporan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (31, '01.05.01.', 'Sertifikasi Tanah Kas Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (32, '01.05.02.', 'Administrasi Pertanahan (Pendaftaran Tanah dan Pemberian Registrasi Agenda Pertanahan)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (33, '01.05.03.', 'Fasilitasi Sertifikasi Tanah untuk Masyarakat Miskin');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (34, '01.05.04.', 'Kegiatan Mediasi Konflik Pertanahan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (35, '01.05.05.', 'Kegiatan Penyuluhan Pertanahan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (36, '01.05.06.', 'Adminstrasi Pajak Bumi dan Bangunan (PBB)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (37, '01.05.07.', 'Penentuan/Penegasan Batas/patok Tanah Kas Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (38, '01.05.94', 'Lain-lain Sub Bidang Pertanahan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (39, '02.01.01', 'Penyelenggaran PAUD/TK/TPA/TKA/TPQ/Madrasah NonFormal Milik Desa (Honor, Pakaian dll)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (40, '02.01.02.', 'Dukungan Penyelenggaran PAUD (APE, Sarana PAUD dst)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (41, '02.01.03.', 'Penyuluhan dan Pelatihan Pendidikan Bagi Masyarakat');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (42, '02.01.04.', 'Pemeliharaan Sarana Prasarana Perpustakaan/Taman Bacaan/Sanggar Belajar Milik Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (43, '02.01.05.', 'Pemeliharaan Sarana Prasarana PAUD/TK/TPA/TKA/TPQ/Madrasah Nonformal Milik Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (44, '02.01.08.', 'Pengelolaan Perpustakaan Milik Desa (Pengadaan Buku, Honor, Taman Baca)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (45, '02.01.09.', 'Pengembangan dan Pembinaan Sanggar Seni dan Belajar');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (46, '02.01.10.', 'Dukungan Pendidikan bagi Siswa Miskin/Berprestasi');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (47, '02.01.92', 'Lain-lain Kegiatan Sub Bidang Pendidikan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (48, '02.02.01.', 'Penyelenggaraan Pos Kesehatan Desa/Polindes Milik Desa (obat, Insentif, KB, dsb)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (49, '02.02.02.', 'Penyelenggaraan Posyandu (Mkn Tambahan, Kls Bumil, Lamsia, Insentif)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (50, '02.02.03.', 'Penyuluhan dan Pelatihan Bidang Kesehatan (Untuk Masy, Tenaga dan Kader Kesehatan dll)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (51, '02.02.04.', 'Penyelenggaraan Desa Siaga Kesehatan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (52, '02.02.05.', 'Pembinaan Palang Merah Remaja (PMR) Tingkat Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (53, '02.02.06.', 'Pengasuhan Bersama atau Bina Keluarga Balita (BKB)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (54, '02.02.07.', 'Pembinaan dan Pengawasan Upaya Kesehatan Tradisional');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (55, '02.02.08.', 'Pemeliharaan Sarana Prasarana Posyandu/Polindes/PKD');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (56, '02.03.01.', 'Pemeliharaan Jalan Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (57, '02.03.02.', 'Pemeliharaan Jalan Lingkungan Pemukiman/Gang');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (58, '02.03.03.', 'Pemeliharaan Jalan Usaha Tani');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (59, '02.03.04.', 'Pemeliharaan Jembatan Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (60, '02.03.05.', 'Pemeliharaan Prasarana Jalan Desa (Gorong-gorong/Selokan/Parit/Drainase dll)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (61, '02.03.06.', 'Pemeliharaan Gedung/Prasarana Balai Desa/Balai Kemasyarakatan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (62, '02.03.07.', 'Pemeliharaan Pemakaman /Situs Bersejarah/Petilasan Milik Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (63, '02.03.08.', 'Pemeliharaan Embung Milik Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (64, '02.03.09.', 'Pemelharaan Monumen/Gapura/Batas Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (65, '02.03.10.', 'Pembangunan/Rehabilitas/Peningkatan/Pengerasan Jalan Desa **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (66, '02.03.12.', 'Pembangunan/Rehabilitasi/Peningkatan/Pengerasan Jalan Usaha Tani **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (67, '02.03.13.', 'Pembangunan/Rehabilitasi/Peningkatan/Pengerasan Jembatan Milik Desa **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (68, '02.03.14.', 'Pembangunan/Rehabilitasi/Peningkatan Prasarana Jalan Desa (Gorong, selokan dll)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (69, '02.03.15.', 'Pembangunan/Rehabilitasi/Peningkatan Balai Desa/Balai Kemasyarakatan **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (70, '02.03.17.', 'Pembuatan/Pemutakhiran Peta Wilayah dan Sosial Desa **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (71, '02.03.18.', 'Penyusunan Dokumen Perencanaan Tata Ruang Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (72, '02.03.19.', 'Pembangunan/Rehabilitasi/Peningkatan Embung Desa **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (73, '02.03.20.', 'Pembangunan/Rehabilitasi/Peningkatan Monumen/Gapura/Batas Desa **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (74, '02.04.01.', 'Dukungan Pelaksanaan Program Pembangunan/Rehab Rumah Tidak Layak Huni GAKIN');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (75, '02.04.90', 'Dukungan Pelaksanaan Program Jambanisasi untuk Keluarga Miskin');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (76, '02.04.02.', 'Pemeliharaan Sumur Resapan Milik Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (77, '02.04.03.', 'Pemeliharaan Sumber Air Bersih Milik Desa (Mata Air, Penampung Air, Sumur Bor dll)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (78, '02.04.04.', 'Pemeliharaan Sambungan Air Bersih ke Rumah Tangga (Pipanisasi dll)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (79, '02.04.05.', 'Pemeliharaan Sanitasi Pemukiman (Gorong-gorong, Selokan, Parit diluar Prasarana Jalan))');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (80, '02.04.06.', 'Pemeliharaan Fasilitas Jamban Umum/MCK Umum dll');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (81, '02.04.08.', 'Pemeliharaan Sistem Pembuangan Air Limbah (Drainase, Air limbah Rumah Tangga)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (82, '02.04.09.', 'Pemeliharaan Taman/Taman Bermain Anak Milik Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (83, '02.04.10.', 'Pembangunan/Rehabilitasi/Peningkatan Sumur Resapan **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (84, '02.04.11.', 'Pembangunan/Rehabilitasi/Peningkatan Sumber Air Bersih Milik Desa **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (85, '02.04.12.', 'Pembangunan/Rehabilitasi/Peningkatan Sambungan Air Bersih ke Rumah Tangga **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (86, '02.04.13.', 'Pembangunan/Rehabilitasi/Peningkatan Sanitasi Permukiman **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (87, '02.04.14.', 'Pembangunan/Rehabilitas/Peningkatan Fasilitas Jamban Umum/MCK umum, dll **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (88, '02.04.15.', 'Pembangunan/Rehabilitasi/Peningkatan Fasilitas Pengelolaan Sampah **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (89, '02.04.16.', 'Pembangunan/Rehabilitasi/Peningkatan Sistem Pembuangan Air Limbah **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (90, '02.04.17.', 'Pembangunan/Rehabilitasi/Peningkatan Taman/Taman Bermain Anak Milik Desa **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (91, '02.04.94', 'Lain-lain Kegiatan Sub Bidang Perumahan Rakyat dan Kawasan Pemukiman');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (92, '02.05.01.', 'Pengelolaan Hutan Milik Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (93, '02.05.02.', 'Pengelolaan Lingkungan Hidup Milik Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (94, '02.05.92', 'Lain-lain Kegiatan Sub Bidang Kehutanan dan Lingkungan Hidup');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (95, '02.06.01.', 'Pembuatan Rambu-rambu di Jalan Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (96, '02.06.02.', 'Penyelenggaraan Informasi Publik Desa (Poster, Baliho Dll)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (97, '02.06.03.', 'Pembuatan dan Pengelolaan Jaringan/Instalasi Komunikasi dan Informasi Lokal Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (98, '02.06.92', 'Lain-lain Kegiatan Sub Bidang Perhubungan, Komunikasi dan Informatika');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (99, '02.07.01.', 'Pemeiliharaan Sarana dan Prasarana Energi Alternatif Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (100, '02.07.02.', 'Pembangunan/Rehabilitasi/Peningkatan Sarana & Prasarana Energi Alternatif Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (101, '02.07.93', 'Pembangunan/pengadaan instalasi biogas/mesin pakan ternak/kandang ternak**');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (102, '02.08.01.', 'Pemeliharaan Sarana dan Prasarana Pariwisata Milik Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (103, '02.08.02.', 'Pembangunan/Rehabilitasi/Peningkatan Sarana dan Prasarana Pariwisata Milik **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (104, '02.08.03.', 'Pengembangan Pariwisata Tingkat Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (105, '02.08.91', 'Lain-Lain Kegiatan Sub Bidang Pariwisata');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (106, '03.01.01.', 'Pengadaan/Penyelenggaran Pos Keamanan Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (107, '03.01.02.', 'Penguatan & Peningkatan Kapasitas Tenaga Keamanan/Ketertiban oleh Pemdes');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (108, '03.01.03.', 'Koordinasi Pembinaan Keamanan, Ketertiban & Perlindungan Masy. Skala Lokal Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (109, '03.01.04.', 'Persiapan Kesiapsiagaan/Tanggap Bencana Skala Lokal Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (110, '03.01.05.', 'Penyediaan Pos Kesiapsiagaan Bencana Skala Lokal Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (111, '03.01.06.', 'Bantuan Hukum Untuk Aparatur Desa dan Masyarakat Miskin');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (112, '03.01.92', 'Lain-lain Kegiatan Sub Bidang Ketenteraman, Ketertiban Umum dan Perlindungan Masyarakat');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (113, '03.02.01.', 'Pembinaan Group Kesenian dan Kebudayaan Tingkat Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (114, '03.02.02.', 'Pengiriman Kontingen Group Kesenian & Kebudayaan (Wakil Desa tkt. Kec/Kab/Kot)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (115, '03.02.03.', 'Penyelenggaran Festival Kesenian, Adat/Kebudayaan, dan Kegamaan (HUT RI, Raya Keagamaan dll)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (116, '03.02.04.', 'Pemeliharaan Sarana Prasarana Kebudayaan, Rumah Adat dan Kegamaan Milik Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (117, '03.02.05.', 'Pembangunan/Rehabilitasi Sarana Prasarana Kebudayaan/Rumah Adat/Kegamaan Milik Desa **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (118, '03.02.95', 'Lain-lain Kegiatan Sub Bidang Kebudayaan dan Keagamaan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (119, '03.03.01.', 'Pengiriman Kontingen Kepemudaan & Olahraga Sebagai Wakil Desa tkt Kec/Kab/Kota');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (120, '03.03.02.', 'Penyelenggaraan Pelatihan Kepemudaan Tingkat Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (121, '03.03.03.', 'Penyelenggaraan Festival/Lomba Kepemudaan dan Olaraga Tingkat Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (122, '03.03.04.', 'Pemeliharaan Sarana dan Prasarana Kepemudaan dan Olahraga Milik Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (123, '03.03.05.', 'Pembangunan/Rehabilitasi/Peningkatan Sarana dan Prasarana Kepemudaan & Olahraga Milik Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (124, '03.03.06.', 'Pembinaan Karangtaruna/Klub Kepemudaan/Olahraga Tingkat Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (125, '03.03.90', 'Lain-lain Kegiatan Sub Bidang Kepemudaan dan Olahraga');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (126, '03.04.01.', 'Pembinaan Lembaga Adat');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (127, '03.04.02.', 'Pembinaan LKMD/LPM/LPMD');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (128, '03.04.03.', 'Pembinaan PKK');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (129, '03.04.04.', 'Pelatihan Pembinaan Lembaga Kemasyarakatan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (130, '03.04.92', 'Lain-lain Sub Bidang Kelembagaan Masyarakat');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (131, '04.01.01.', 'Pemeliharaan Karamba/Kolam Perikanan Darat Milik Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (132, '04.01.02.', 'Pemeliharaan Pelabuhan Perikanan Sungai/Kecil Milik Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (133, '04.01.03.', 'Pembangunan/Rehabilitasi/Peningkatan Karamba/Kolam Perikanan Darat Milik Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (134, '04.01.04.', 'Pembangunan/Rehabilitasi/Peningkatan Pelabuhan Perikanan Sungai/Kecil Milik Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (135, '04.01.05.', 'Bantuan Perikanan (Bibit/Pakan/dll)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (136, '04.01.06.', 'Bimtek/Pelatihan/Pengenalan TTG untuk Perikanan Darat/Nelayan **)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (137, '04.01.94', 'Lain-lain Kegiatan Sub Bidang Kelautan dan Perikanan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (138, '04.02.01.', 'Peningkatan Produksi Tanaman Pangan (alat produksi/pengelolaan/penggilingan)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (139, '04.02.02.', 'Peningkatan Produksi Peternakan  (alat produksi/pengelolaan/kandang)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (140, '04.02.03.', 'Penguatan Ketahanan Pangan Tingkat Desa (Lumbung Desa dll)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (141, '04.02.04.', 'Pemeliharaan Saluran Irigasi Tersier/Sederhana');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (142, '04.02.05.', 'Pelatihan/Bimtek/Pengenalan Tekonologi Tepat Guna untuk Pertanian/Peternakan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (143, '04.02.06', 'Pembangunan Saluran Irigasi Tersier/Sederhana');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (144, '04.02.94', 'Lain-lain Kegiatan Sub Bidang Pertanian dan Peternakan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (145, '04.03.01.', 'Peningkatan Kapasitas Kepala Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (146, '04.03.02.', 'Peningkatan Kapatitas Perangkat Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (147, '04.03.03.', 'Peningkatan Kapasitas BPD');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (148, '04.03.90', 'Lain-lain Kegiatan Sub Bidang Peningkatan Kapasitas Aparatur Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (149, '04.04.01.', 'Pelatihan dan Penyuluhan Pemberdayaan Perempuan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (150, '04.04.02.', 'Pelatihan dan Penyuluhan Perlindungan Anak');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (151, '04.04.03.', 'Pelatihan dan Penguatan Penyandang Difable (Penyandang Disabilitas)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (152, '04.04.94', 'Lain-lain Kegiatan Sub Bidang Pemberdayaan Perempuan, Perlindungan Anak dan Keluarga');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (153, '04.05.01.', 'Pelatihan Manajemen Koperasi/KUD/UMKM');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (154, '04.05.02.', 'Pengembangan Sarana Prasarana Usaha Mikro, Kecil, Menengah dan Koperasi');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (155, '04.05.03.', 'Pengadaan Teknologi Tepat Guna Untuk Pengembangan Ekonomi Pedesaan Non Pertanian');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (156, '04.05.93', 'Lain-lain Sub Bidang Koperasi, Usaha Micro Kecil dan Menengah (UMKM)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (157, '04.06.01.', 'Pembentukan BUM Desa (Persiapan dan Pembentukan Awal BUMDesa)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (158, '04.06.02.', 'Pelatihan Pengelolaan BUM Desa (Pelatihan yg dilaksanakan oleh Pemdes)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (159, '04.06.92', 'Lain-lain Kegiatan Sub Bidang Dukungan Penanaman Modal');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (160, '04.07.01.', 'Pemeliharaan Pasar Desa/Kios Milik Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (161, '04.07.02.', 'Pembangunan/Rehab Pasar Desa/Kios Milik Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (162, '04.07.03.', 'Pengembangan Industri Kecil Tingkat Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (163, '04.07.04.', 'Pembentukan/Fasilitasi/Pelatihan/Pendampingan kelompok usaha ekonomi produktif');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (164, '04.07.92', 'Lain-lain Sub Bidang Perdagangan dan Perindustrian');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (165, '05.01.01.', 'Kegiatan Penanggulanan Bencana');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (166, '05.02.01.', 'Penanganan Keadaan Darurat');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (167, '05.03.01.', 'Penanganan Keadaan Mendesak');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (168, '01.01.90', 'Penyediaan Tali Asih Kepala Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (169, '01.01.91', 'Penyediaan Tali Asih Perangkat Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (170, '01.04.90', 'Penyusunan dan Penetapan Standar Satuan Harga Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (171, '01.04.91', 'Pengisian/Penjaringan/Penyaringan Kepala Desa ');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (172, '01.04.92', 'Pengisian/Penjaringan/Penyaringan BPD**');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (173, '01.04.93', 'Penyelenggaraan Pemilihan Kepala Desa Antar Waktu');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (174, '01.04.94', 'Penyelenggaraan Pengisian Perangkat Desa  ');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (175, '01.04.95', 'Penyelenggaraan Evaluasi Tingkat Perkembangan Desa ');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (176, '01.04.96', 'Sosialisasi berbagai peraturan perundang-undangan di tingkat Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (177, '01.05.90', 'Pengadaan/Pelepasan Tanah Kas Desa**');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (178, '01.05.91', 'Kompensasi/Ganti Rugi Lahan terdampak Pembangunan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (179, '01.05.92', 'Penetapan dan penegasan batas Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (180, '01.05.93', 'Penyusunan tata ruang Desa dan peta Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (181, '02.01.90', 'Pengelolaan dan Pembinaan Anak Sekolah Melalui Pemberian Makanan Tambahan Anak Sekolah (PMTAS)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (182, '02.01.91', 'Dukungan Sarana Prasana Pendidikan PAUD/TK/TPA/TKA/TPQ/Madrasah Non-Formal Bukan Milik Desa (dalam bentuk barang)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (183, '02.02.90', 'Pengadaan/pembangunan/pengembangan/ pemeliharaan Sarana dan Prasarana Kesehatan/ Air Bersih /sanitasi/kebersihan lingkungan/jambanisasi/mandi, cuci, kakus (MCK) **');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (184, '02.02.91', 'Pemantauan dan Pencegahan Penyalahgunaan Narkoba dan Zat Adiktif Di Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (185, '02.02.92', 'Fasilitasi Pelayanan Pencegahan dan Penanggulangan Penyakit Endemik, Menular dan Tidak Menular');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (186, '02.02.93', 'Pembangunan/Pengelolaan/Pemanfaatan Tanaman Obat Keluarga/Apotek Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (187, '02.02.94', 'Fasilitasi Kegiatan Palang Merah Indonesia (PMI)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (188, '02.02.95', 'Pengadaan/pembangunan/pengembangan/ pemeliharaan sarana prasarana alat bantu penyandang disabilitas/panti rehabilitasi penyandang disabilitas**');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (189, '02.02.96', 'Fasilitasi Pelayanan Kesehatan Bagi Masyarakat Miskin');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (190, '02.02.97', 'Penyelenggaraan Promosi Kesehatan dan Gerakan Hidup Bersih dan Sehat');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (191, '02.02.98', 'Pengadaan/pembangunan/pengembangan/pemeliharaan sarana prasarana mobil/kapal motor untuk ambulance Desa**');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (192, '02.02.99', 'Lain-lain Kegiatan Sub Bidang Kesehatan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (193, '02.03.90', 'Pembangunan/pemeliharaan jalan/talud pengaman tebing/saluran irigasi/energi baru dan terbarukan/ pembangkit listrik tenaga mikrohidro/lapangan Desa / taman Desa/lingkungan permukiman masyarakat Desa**');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (194, '02.03.91', 'Pembangunan/Pengadaan/pengembangan/pemeliharaan sarana dan prasarana Jasa dan Industri Kecil/industri rumah tangga/mesin jahit/peralatan bengkel kendaraan bermotor/mesin bubut untuk mebeler; /pemasara');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (195, '02.03.92', 'Pembangunan kolam ikan dan pembenihan ikan/perahu penangkap ikan tempat pelelangan ikan/tempat pendaratan kapal penangkap ikan/cold storage (gudang pendingin)/gudang penyimpan sarana produksi (saprota');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (196, '02.03.93', 'Pembangunan/Rehabilitasi/Pemeliharaan/Peningkatan Sarana Prasarana Olah Raga/ Gedung Serba Guna');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (197, '02.03.94', 'Pembangunan/Rehabilitasi/Peningkatan Gedung/Prasarana Balai Desa/Balai Kemasyarakatan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (198, '02.03.95', 'Pembangunan/pengembangan/pemeliharaan/pengelolaan sarana dan prasarana pasar Desa**');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (199, '02.03.96', 'Lain-lain Kegiatan Sub Bidang Pekerjaan Umum dan Tata Ruang');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (200, '02.04.91', 'Penyediaan Kendaraan Pengangkut Sampah, Gerobak Sampah, Tong Sampah, Mesin Pengolah Sampah');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (201, '02.04.92', 'Pemeliharaan Jaringan Listrik/ Penerangan Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (202, '02.04.93', 'Pembangunan/Rehabilitasi/Peningkatan Jaringan Listrik/ Penerangan Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (203, '02.05.90', 'Pembuatan terasering/pembersihan daerah aliran sungai/plesengan sungai**');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (204, '02.05.91', 'Penanganan kebakaran hutan dan lahan/pencegahan abrasi pantai');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (205, '02.06.90', 'Pembangunan/Pengembangan/pemeliharaan sarana dan prasarana transportasi/informasi/ komunikasi/terminal Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (206, '02.06.91', 'Pengadaan/pembangunan/pengembangan/pemeliharaan jaringan internet untuk warga Desa/website Desa/peralatan pengeras suara (loudspeaker)/telepon umum/ radio Single Side Band (SSB) ');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (207, '02.07.90', 'Pengembangan dan Pengelolaan Sarana dan Prasarana Energi Alternatif tingkat Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (208, '02.07.91', 'Pembangunan sarana dan prasarana Teknologi Tepat Guna');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (209, '02.07.92', 'Pengadaan/pemanfaatan/pemeliharaan penggilingan padi/peraut kelapa/ penepung biji-bijian/pencacah pakan terna/sangrai/ pemotong/pengiris buah dan sayuran/pompa air/traktor mini**');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (210, '02.07.94', 'Lain-lain Kegiatan Sub Bidang Energi dan Sumber Daya Mineral');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (211, '02.08.90', 'Pengadaan/pembangunan/pengembangan/pemeliharaan sarana dan prasarana Desa wisata/ pondok wisata/panggung hiburan/ kios cenderamata/kios warung makan/wahana permainan anak/wahana permainan outbound/ ta');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (212, '03.01.90', 'Dukungan Pembinaan Keamanan, Ketertiban, dan Ketentraman Wilayah dan Masyarakat Desa (Seragam dan Op Linmas, BABINSA, BABINKAMTIBMAS)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (213, '03.01.91', 'Pembentukan tim keamanan Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (214, '03.02.90', 'Melestarikan Dan Mengembangkan Gotong Royong Masyarakat Desa (BBGRM)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (215, '03.02.91', 'Dukungan Pengelolaan Sarana dan Prasarana Kebudayaan/Rumah Adat/Keagamaan di Desa **');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (216, '03.02.92', 'Penyelenggaraan Sedekah Bumi/Sedekah Laut/Apitan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (217, '03.02.93', 'Partisipasi Perayaan Hari Besar Nasional lainnya');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (218, '03.02.94', 'Pembinaan kerukunan umat beragama');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (219, '03.04.90', 'Pembentukan/Pembinaan Lembaga Kemasyarakatan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (220, '03.04.91', 'Pembentukan dan Dukungan Fasilitasi Kader Pembangunan dan Pemberdayaan Masyarakat');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (221, '04.01.90', 'Pelaksanaan Penanggulangan Hama dan Penyakit Secara Terpadu');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (222, '04.01.91', 'Pengelolaan Balai Benih Ikan Milik Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (223, '04.01.92', 'Pemeliharaan Tambatan Perahu/Tempat Pelelangan Ikan (TPI) Milik Desa**');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (224, '04.01.93', 'Pembangunan/Rehabilitasi/Peningkatan Tambatan Perahu/Tempat Pelelangan Ikan (TPI) Milik Desa**');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (225, '04.02.90', 'Peningkatan Produksi Tanaman Perkebunan (Alat Produksi dan pengolahan perkebunan)');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (226, '04.02.91', 'Pembangunan/Rehabilitasi/Peningkatan Balai Pertemuan Kelompok Tani');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (227, '04.02.92', 'Pembangunan/Peningkatan Irigasi Tersier');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (228, '04.02.93', 'Pelatihan kelompok tani');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (229, '04.04.90', 'Fasiilitasi Penguatan Kelembagaan Pengarusutamaan Gender dan Anak');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (230, '04.04.92', 'Peningkatan Kapasitas Kelompok Pemerhati dan Perlindungan Anak');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (231, '04.04.93', 'Fasilitasi terhadap kelompok-kelompok rentan, kelompok masyarakat miskin, perempuan, anak dan difabel/ Pemberian bantuan sosial/pemberian santunan kepada keluarga fakir miskin/analisis kemiskinan seca');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (232, '04.04.91', 'Fasilitasi Upaya Perlindungan Perempuan dan Anak Terhadap Tindakan Kekerasan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (233, '04.05.90', 'Pengembangan/ Promosi Produk Unggulan Desa');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (234, '04.05.91', 'Pembentukan dan pengembangan usaha ekonomi masyarakat dan/atau koperasi');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (235, '04.05.92', 'Bantuan sarana produksi, distribusi dan pemasaran untuk usaha ekonomi masyarakat**');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (236, '04.06.90', 'Pembangunan Kantor BUM Desa/Sarana Prasarana BUM Desa  (menjadi aset desa)**');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (237, '04.06.91', 'Pelaksanaan Audit Keuangan BUM Desa, Evaluasi Perkembangan BUM Desa ');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (238, '04.07.90', 'Pelatihan usaha ekonomi dan Perdagangan');
INSERT INTO `keuangan_manual_ref_kegiatan` (`id`, `ID_Keg`, `Nama_Kegiatan`) VALUES (239, '04.07.91', 'Sosialisasi Teknologi Tepat Guna/Posyantekdes dan/atau antar Desa/percontohan Teknologi Tepat Guna untuk produksi pertanian/pengembangan sumber energi perdesaan/pengemban');


#
# TABLE STRUCTURE FOR: keuangan_manual_ref_rek1
#

DROP TABLE IF EXISTS `keuangan_manual_ref_rek1`;

CREATE TABLE `keuangan_manual_ref_rek1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Akun` varchar(100) NOT NULL,
  `Nama_Akun` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

INSERT INTO `keuangan_manual_ref_rek1` (`id`, `Akun`, `Nama_Akun`) VALUES (1, '1.', 'ASET');
INSERT INTO `keuangan_manual_ref_rek1` (`id`, `Akun`, `Nama_Akun`) VALUES (2, '2.', 'KEWAJIBAN');
INSERT INTO `keuangan_manual_ref_rek1` (`id`, `Akun`, `Nama_Akun`) VALUES (3, '3.', 'EKUITAS');
INSERT INTO `keuangan_manual_ref_rek1` (`id`, `Akun`, `Nama_Akun`) VALUES (4, '4.', 'PENDAPATAN');
INSERT INTO `keuangan_manual_ref_rek1` (`id`, `Akun`, `Nama_Akun`) VALUES (5, '5.', 'BELANJA');
INSERT INTO `keuangan_manual_ref_rek1` (`id`, `Akun`, `Nama_Akun`) VALUES (6, '6.', 'PEMBIAYAAN');
INSERT INTO `keuangan_manual_ref_rek1` (`id`, `Akun`, `Nama_Akun`) VALUES (7, '7.', 'NON ANGGARAN');


#
# TABLE STRUCTURE FOR: keuangan_manual_ref_rek2
#

DROP TABLE IF EXISTS `keuangan_manual_ref_rek2`;

CREATE TABLE `keuangan_manual_ref_rek2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Akun` varchar(100) NOT NULL,
  `Kelompok` varchar(100) NOT NULL,
  `Nama_Kelompok` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1;

INSERT INTO `keuangan_manual_ref_rek2` (`id`, `Akun`, `Kelompok`, `Nama_Kelompok`) VALUES (1, '1.', '1.1.', 'Aset Lancar');
INSERT INTO `keuangan_manual_ref_rek2` (`id`, `Akun`, `Kelompok`, `Nama_Kelompok`) VALUES (2, '1.', '1.2.', 'Investasi');
INSERT INTO `keuangan_manual_ref_rek2` (`id`, `Akun`, `Kelompok`, `Nama_Kelompok`) VALUES (3, '1.', '1.3.', 'Aset Tetap');
INSERT INTO `keuangan_manual_ref_rek2` (`id`, `Akun`, `Kelompok`, `Nama_Kelompok`) VALUES (4, '1.', '1.4.', 'Dana Cadangan');
INSERT INTO `keuangan_manual_ref_rek2` (`id`, `Akun`, `Kelompok`, `Nama_Kelompok`) VALUES (5, '1.', '1.5.', 'Aset Tidak Lancar Lainnya');
INSERT INTO `keuangan_manual_ref_rek2` (`id`, `Akun`, `Kelompok`, `Nama_Kelompok`) VALUES (6, '2.', '2.1.', 'Kewajiban Jangka Pendek');
INSERT INTO `keuangan_manual_ref_rek2` (`id`, `Akun`, `Kelompok`, `Nama_Kelompok`) VALUES (7, '3.', '3.1.', 'Ekuitas');
INSERT INTO `keuangan_manual_ref_rek2` (`id`, `Akun`, `Kelompok`, `Nama_Kelompok`) VALUES (8, '4.', '4.1.', 'Pendapatan Asli Desa');
INSERT INTO `keuangan_manual_ref_rek2` (`id`, `Akun`, `Kelompok`, `Nama_Kelompok`) VALUES (9, '4.', '4.2.', 'Pendapatan Transfer');
INSERT INTO `keuangan_manual_ref_rek2` (`id`, `Akun`, `Kelompok`, `Nama_Kelompok`) VALUES (10, '4.', '4.3.', 'Pendapatan Lain-lain');
INSERT INTO `keuangan_manual_ref_rek2` (`id`, `Akun`, `Kelompok`, `Nama_Kelompok`) VALUES (11, '5.', '5.1.', 'Belanja Pegawai');
INSERT INTO `keuangan_manual_ref_rek2` (`id`, `Akun`, `Kelompok`, `Nama_Kelompok`) VALUES (12, '5.', '5.2.', 'Belanja Barang dan Jasa');
INSERT INTO `keuangan_manual_ref_rek2` (`id`, `Akun`, `Kelompok`, `Nama_Kelompok`) VALUES (13, '5.', '5.3.', 'Belanja Modal');
INSERT INTO `keuangan_manual_ref_rek2` (`id`, `Akun`, `Kelompok`, `Nama_Kelompok`) VALUES (14, '5.', '5.4.', 'Belanja Tidak Terduga');
INSERT INTO `keuangan_manual_ref_rek2` (`id`, `Akun`, `Kelompok`, `Nama_Kelompok`) VALUES (15, '6.', '6.1.', 'Penerimaan Pembiayaan');
INSERT INTO `keuangan_manual_ref_rek2` (`id`, `Akun`, `Kelompok`, `Nama_Kelompok`) VALUES (16, '6.', '6.2.', 'Pengeluaran Pembiayaan');
INSERT INTO `keuangan_manual_ref_rek2` (`id`, `Akun`, `Kelompok`, `Nama_Kelompok`) VALUES (17, '7.', '7.1.', 'Perhitungan Fihak Ketiga');


#
# TABLE STRUCTURE FOR: keuangan_manual_ref_rek3
#

DROP TABLE IF EXISTS `keuangan_manual_ref_rek3`;

CREATE TABLE `keuangan_manual_ref_rek3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Kelompok` varchar(100) NOT NULL,
  `Jenis` varchar(100) NOT NULL,
  `Nama_Jenis` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=latin1;

INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (1, '1.1.', '1.1.1.', 'Kas dan Bank');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (2, '1.1.', '1.1.2.', 'Piutang');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (3, '1.1.', '1.1.3.', 'Persediaan');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (4, '1.2.', '1.2.1.', 'Penyertaan Modal Pemerintah Desa');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (5, '1.3.', '1.3.1.', 'Tanah');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (6, '1.3.', '1.3.2.', 'Peralatan dan Mesin');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (7, '1.3.', '1.3.3.', 'Gedung dan Bangunan');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (8, '1.3.', '1.3.4.', 'Jalan, Irigasi dan Jaringan');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (9, '1.3.', '1.3.5.', 'Aset Tetap Lainnya');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (10, '1.3.', '1.3.6.', 'Konstruksi Dalam Pengerjaan');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (11, '1.3.', '1.3.7.', 'Aset Tak Berwujud');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (12, '1.3.', '1.3.8.', 'Akumulasi Penyusutan Aktiva Tetap');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (13, '1.4.', '1.4.1.', 'Dana Cadangan');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (14, '1.5.', '1.5.1.', 'Tagihan Piutang Penjualan Angsuran');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (15, '1.5.', '1.5.2.', 'Tagihan Tuntutan Ganti Kerugian Daerah');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (16, '1.5.', '1.5.3.', 'Kemitraan dengan Pihak Ketiga');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (17, '1.5.', '1.5.4.', 'Aktiva Tidak Berwujud');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (18, '1.5.', '1.5.5.', 'Aset Lain-lain');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (19, '2.1.', '2.1.1.', 'Hutang Perhitungan Pihak Ketiga');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (20, '2.1.', '2.1.2.', 'Hutang Bunga');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (21, '2.1.', '2.1.3.', 'Hutang Pajak');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (22, '2.1.', '2.1.4.', 'Pendapatan Diterima Dimuka');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (23, '2.1.', '2.1.5.', 'Bagian Lancar Hutang Jangka Panjang');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (24, '2.1.', '2.1.6.', 'Hutang Jangka Pendek Lainnya');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (25, '3.1.', '3.1.1.', 'Ekuitas');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (26, '3.1.', '3.1.2.', 'Ekuitas SAL');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (27, '4.1.', '4.1.1.', 'Hasil Usaha Desa');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (28, '4.1.', '4.1.2.', 'Hasil Aset Desa');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (29, '4.1.', '4.1.3.', 'Swadaya, Partisipasi dan Gotong Royong');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (30, '4.1.', '4.1.4.', 'Lain-Lain Pendapatan Asli Desa');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (31, '4.2.', '4.2.1.', 'Dana Desa');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (32, '4.2.', '4.2.2.', 'Bagi Hasil Pajak dan Retribusi');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (33, '4.2.', '4.2.3.', 'Alokasi Dana Desa');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (34, '4.2.', '4.2.4.', 'Bantuan Keuangan Provinsi');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (35, '4.2.', '4.2.5.', 'Bantuan Keuangan Kabupaten/Kota');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (36, '4.3.', '4.3.1.', 'Penerimaan dari Hasil Kerjasama Antar Desa');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (37, '4.3.', '4.3.2.', 'Penerimaan dari Hasil Kerjasama dengan Pihak Ketiga');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (38, '4.3.', '4.3.3.', 'Penerimaan Bantuan dari Perusahaan yang Berlokasi di Desa');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (39, '4.3.', '4.3.4.', 'Hibah dan Sumbangan dari Pihak Ketiga');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (40, '4.3.', '4.3.5.', 'Koreksi Kesalahan Belanja Tahun-tahun Sebelumnya');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (41, '4.3.', '4.3.6.', 'Bunga Bank');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (42, '4.3.', '4.3.9.', 'Lain-lain Pendapatan Desa Yang Sah');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (43, '5.1.', '5.1.1.', 'Penghasilan Tetap dan Tunjangan Kepala Desa');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (44, '5.1.', '5.1.2.', 'Penghasilan Tetap dan Tunjangan Perangkat Desa');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (45, '5.1.', '5.1.3.', 'Jaminan Sosial Kepala Desa dan Perangkat Desa');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (46, '5.1.', '5.1.4.', 'Tunjangan BPD');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (47, '5.2.', '5.2.1.', 'Belanja Barang Perlengkapan');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (48, '5.2.', '5.2.2.', 'Belanja Jasa Honorarium');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (49, '5.2.', '5.2.3.', 'Belanja Perjalanan Dinas');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (50, '5.2.', '5.2.4.', 'Belanja Jasa Sewa');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (51, '5.2.', '5.2.5.', 'Belanja Operasional Perkantoran');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (52, '5.2.', '5.2.6.', 'Belanja Pemeliharaan');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (53, '5.2.', '5.2.7.', 'Belanja Barang dan Jasa yang Diserahkan kepada Masyarakat');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (54, '5.3.', '5.3.1.', 'Belanja Modal Pengadaan Tanah');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (55, '5.3.', '5.3.2.', 'Belanja Modal Pengadaan Peralatan, Mesin dan Alat Berat');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (56, '5.3.', '5.3.3.', 'Belanja Modal Kendaraan');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (57, '5.3.', '5.3.4.', 'Belanja Modal Gedung, Bangunan dan Taman');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (58, '5.3.', '5.3.5.', 'Belanja Modal Jalan/Prasarana Jalan');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (59, '5.3.', '5.3.6.', 'Belanja Modal Jembatan');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (60, '5.3.', '5.3.7.', 'Belanja Modal Irigasi/Embung/Drainase/Air Limbah/Persampahan');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (61, '5.3.', '5.3.8.', 'Belanja Modal Jaringan/Instalasi');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (62, '5.3.', '5.3.9.', 'Belanja Modal Lainnya');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (63, '5.4.', '5.4.1.', 'Belanja Tidak Terduga');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (64, '6.1.', '6.1.1.', 'SILPA Tahun Sebelumnya');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (65, '6.1.', '6.1.2.', 'Pencairan Dana Cadangan');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (66, '6.1.', '6.1.3.', 'Hasil Penjualan Kekayaan Desa Yang Dipisahkan');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (67, '6.1.', '6.1.9.', 'Penerimaan Pembiayaan Lainnya');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (68, '6.2.', '6.2.1.', 'Pembentukan Dana Cadangan');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (69, '6.2.', '6.2.2.', 'Penyertaan Modal Desa');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (70, '6.2.', '6.2.9.', 'Pengeluaran Pembiayaan Lainnya');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (71, '7.1.', '7.1.1.', 'Perhitungan PFK - Potongan Pajak');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (72, '7.1.', '7.1.2.', 'Perhitungan PFK - Potongan Pajak Daerah');
INSERT INTO `keuangan_manual_ref_rek3` (`id`, `Kelompok`, `Jenis`, `Nama_Jenis`) VALUES (73, '7.1.', '7.1.3.', 'Perhitungan PFK - Uang Muka dan Jaminan');


#
# TABLE STRUCTURE FOR: keuangan_manual_rinci
#

DROP TABLE IF EXISTS `keuangan_manual_rinci`;

CREATE TABLE `keuangan_manual_rinci` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Akun` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Nilai_Anggaran` varchar(100) NOT NULL,
  `Nilai_Realisasi` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_manual_rinci_tpl
#

DROP TABLE IF EXISTS `keuangan_manual_rinci_tpl`;

CREATE TABLE `keuangan_manual_rinci_tpl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Akun` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Nilai_Anggaran` varchar(100) NOT NULL,
  `Nilai_Realisasi` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=latin1;

INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (1, '2020', '4.PENDAPATAN', '', '4.1.1. Hasil Usaha Desa', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (2, '2020', '4.PENDAPATAN', '', '4.1.2. Hasil Aset Desa', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (3, '2020', '4.PENDAPATAN', '', '4.1.3. Swadaya, Partisipasi dan Gotong Royong', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (4, '2020', '4.PENDAPATAN', '', '4.1.4. Lain-Lain Pendapatan Asli Desa', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (5, '2020', '4.PENDAPATAN', '', '4.2.1. Dana Desa', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (6, '2020', '4.PENDAPATAN', '', '4.2.2. Bagi Hasil Pajak dan Retribusi', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (7, '2020', '4.PENDAPATAN', '', '4.2.3. Alokasi Dana Desa', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (8, '2020', '4.PENDAPATAN', '', '4.2.4. Bantuan Keuangan Provinsi', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (9, '2020', '4.PENDAPATAN', '', '4.2.5. Bantuan Keuangan Kabupaten/Kota', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (10, '2020', '4.PENDAPATAN', '', '4.3.1. Penerimaan dari Hasil Kerjasama Antar Desa', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (11, '2020', '4.PENDAPATAN', '', '4.3.2. Penerimaan dari Hasil Kerjasama dengan Pihak Ketiga', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (12, '2020', '4.PENDAPATAN', '', '4.3.3. Penerimaan Bantuan dari Perusahaan yang Berlokasi di Desa', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (13, '2020', '4.PENDAPATAN', '', '4.3.4. Hibah dan Sumbangan dari Pihak Ketiga', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (14, '2020', '4.PENDAPATAN', '', '4.3.5. Koreksi Kesalahan Belanja Tahun-tahun Sebelumnya', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (15, '2020', '4.PENDAPATAN', '', '4.3.6. Bunga Bank', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (16, '2020', '4.PENDAPATAN', '', '4.3.9. Lain-lain Pendapatan Desa Yang Sah', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (17, '2020', '5.BELANJA', '00.0000.01 BIDANG PENYELENGGARAN PEMERINTAHAN DESA', '5.0.0', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (18, '2020', '5.BELANJA', '00.0000.02 BIDANG PELAKSANAAN PEMBANGUNAN DESA', '5.0.0', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (19, '2020', '5.BELANJA', '00.0000.03 BIDANG PEMBINAAN KEMASYARAKATAN', '5.0.0', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (20, '2020', '5.BELANJA', '00.0000.04 BIDANG PEMBERDAYAAN MASYARAKAT', '5.0.0', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (21, '2020', '5.BELANJA', '00.0000.05 BIDANG PENANGGULANGAN BENCANA, DARURAT DAN MENDESAK DESA', '5.0.0', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (22, '2020', '6.PEMBIAYAAN', '', '6.1.1. SILPA Tahun Sebelumnya', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (23, '2020', '6.PEMBIAYAAN', '', '6.1.2. Pencairan Dana Cadangan', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (24, '2020', '6.PEMBIAYAAN', '', '6.1.3. Hasil Penjualan Kekayaan Desa Yang Dipisahkan', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (25, '2020', '6.PEMBIAYAAN', '', '6.1.9. Penerimaan Pembiayaan Lainnya', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (26, '2020', '6.PEMBIAYAAN', '', '6.2.1. Pembentukan Dana Cadangan', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (27, '2020', '6.PEMBIAYAAN', '', '6.2.2. Penyertaan Modal Desa', '0', '0');
INSERT INTO `keuangan_manual_rinci_tpl` (`id`, `Tahun`, `Kd_Akun`, `Kd_Keg`, `Kd_Rincian`, `Nilai_Anggaran`, `Nilai_Realisasi`) VALUES (28, '2020', '6.PEMBIAYAAN', '', '6.2.9. Pengeluaran Pembiayaan Lainnya', '0', '0');


#
# TABLE STRUCTURE FOR: keuangan_master
#

DROP TABLE IF EXISTS `keuangan_master`;

CREATE TABLE `keuangan_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `versi_database` varchar(50) NOT NULL,
  `tahun_anggaran` varchar(250) NOT NULL,
  `aktif` int(2) NOT NULL DEFAULT '1',
  `tanggal_impor` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ref_bank_desa
#

DROP TABLE IF EXISTS `keuangan_ref_bank_desa`;

CREATE TABLE `keuangan_ref_bank_desa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(50) NOT NULL,
  `Kd_Desa` varchar(50) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `NoRek_Bank` varchar(100) NOT NULL,
  `Nama_Bank` varchar(250) NOT NULL,
  `Kantor_Cabang` varchar(100) DEFAULT NULL,
  `Nama_Pemilik` varchar(100) DEFAULT NULL,
  `Alamat_Pemilik` varchar(100) DEFAULT NULL,
  `No_Identitas` varchar(20) DEFAULT NULL,
  `No_Telepon` varchar(20) DEFAULT NULL,
  `ID_Bank` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ref_bank_desa_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ref_bank_desa_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ref_bel_operasional
#

DROP TABLE IF EXISTS `keuangan_ref_bel_operasional`;

CREATE TABLE `keuangan_ref_bel_operasional` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `ID_Keg` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ref_bel_operasional_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ref_bel_operasional_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ref_bidang
#

DROP TABLE IF EXISTS `keuangan_ref_bidang`;

CREATE TABLE `keuangan_ref_bidang` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Kd_Bid` varchar(50) NOT NULL,
  `Nama_Bidang` varchar(250) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ref_bidang_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ref_bidang_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ref_bunga
#

DROP TABLE IF EXISTS `keuangan_ref_bunga`;

CREATE TABLE `keuangan_ref_bunga` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Kd_Bunga` varchar(50) NOT NULL,
  `Kd_Admin` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ref_bunga_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ref_bunga_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ref_desa
#

DROP TABLE IF EXISTS `keuangan_ref_desa`;

CREATE TABLE `keuangan_ref_desa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Kd_Kec` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Nama_Desa` varchar(250) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ref_desa_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ref_desa_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ref_kecamatan
#

DROP TABLE IF EXISTS `keuangan_ref_kecamatan`;

CREATE TABLE `keuangan_ref_kecamatan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Kd_Kec` varchar(100) NOT NULL,
  `Nama_Kecamatan` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ref_kecamatan_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ref_kecamatan_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ref_kegiatan
#

DROP TABLE IF EXISTS `keuangan_ref_kegiatan`;

CREATE TABLE `keuangan_ref_kegiatan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Kd_Bid` varchar(100) DEFAULT NULL,
  `ID_Keg` varchar(100) NOT NULL,
  `Nama_Kegiatan` varchar(250) NOT NULL,
  `Jns_Kegiatan` tinyint(5) DEFAULT NULL,
  `Kd_Sub` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ref_kegiatan_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ref_kegiatan_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ref_korolari
#

DROP TABLE IF EXISTS `keuangan_ref_korolari`;

CREATE TABLE `keuangan_ref_korolari` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Kd_RekDB` varchar(100) NOT NULL,
  `Kd_RekKD` varchar(250) NOT NULL,
  `Jenis` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ref_korolari_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ref_korolari_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ref_neraca_close
#

DROP TABLE IF EXISTS `keuangan_ref_neraca_close`;

CREATE TABLE `keuangan_ref_neraca_close` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Kelompok` varchar(250) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ref_neraca_close_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ref_neraca_close_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ref_perangkat
#

DROP TABLE IF EXISTS `keuangan_ref_perangkat`;

CREATE TABLE `keuangan_ref_perangkat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Kode` varchar(100) NOT NULL,
  `Nama_Perangkat` varchar(250) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ref_perangkat_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ref_perangkat_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ref_potongan
#

DROP TABLE IF EXISTS `keuangan_ref_potongan`;

CREATE TABLE `keuangan_ref_potongan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Kd_Potongan` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ref_potongan_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ref_potongan_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ref_rek1
#

DROP TABLE IF EXISTS `keuangan_ref_rek1`;

CREATE TABLE `keuangan_ref_rek1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Akun` varchar(100) NOT NULL,
  `Nama_Akun` varchar(100) NOT NULL,
  `NoLap` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ref_rek1_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ref_rek1_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ref_rek2
#

DROP TABLE IF EXISTS `keuangan_ref_rek2`;

CREATE TABLE `keuangan_ref_rek2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Akun` varchar(100) NOT NULL,
  `Kelompok` varchar(100) NOT NULL,
  `Nama_Kelompok` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ref_rek2_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ref_rek2_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ref_rek3
#

DROP TABLE IF EXISTS `keuangan_ref_rek3`;

CREATE TABLE `keuangan_ref_rek3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Kelompok` varchar(100) NOT NULL,
  `Jenis` varchar(100) NOT NULL,
  `Nama_Jenis` varchar(100) NOT NULL,
  `Formula` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ref_rek3_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ref_rek3_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ref_rek4
#

DROP TABLE IF EXISTS `keuangan_ref_rek4`;

CREATE TABLE `keuangan_ref_rek4` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Jenis` varchar(100) NOT NULL,
  `Obyek` varchar(100) NOT NULL,
  `Nama_Obyek` varchar(100) NOT NULL,
  `Peraturan` varchar(250) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ref_rek4_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ref_rek4_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ref_sbu
#

DROP TABLE IF EXISTS `keuangan_ref_sbu`;

CREATE TABLE `keuangan_ref_sbu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Kode_SBU` varchar(100) NOT NULL,
  `NoUrut_SBU` varchar(100) NOT NULL,
  `Nama_SBU` varchar(100) NOT NULL,
  `Nilai` varchar(100) NOT NULL,
  `Satuan` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ref_sbu_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ref_sbu_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ref_sumber
#

DROP TABLE IF EXISTS `keuangan_ref_sumber`;

CREATE TABLE `keuangan_ref_sumber` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Kode` varchar(100) NOT NULL,
  `Nama_Sumber` varchar(100) NOT NULL,
  `Urut` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ref_sumber_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ref_sumber_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_anggaran
#

DROP TABLE IF EXISTS `keuangan_ta_anggaran`;

CREATE TABLE `keuangan_ta_anggaran` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `KdPosting` varchar(100) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `KURincianSD` varchar(100) NOT NULL,
  `KD_Rincian` varchar(100) NOT NULL,
  `RincianSD` varchar(100) NOT NULL,
  `Anggaran` varchar(100) NOT NULL,
  `AnggaranPAK` varchar(100) NOT NULL,
  `AnggaranStlhPAK` varchar(100) NOT NULL,
  `Belanja` varchar(100) NOT NULL,
  `Kd_keg` varchar(100) NOT NULL,
  `SumberDana` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `TglPosting` varchar(100) NOT NULL,
  `Kd_SubRinci` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_anggaran_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_anggaran_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_anggaran_log
#

DROP TABLE IF EXISTS `keuangan_ta_anggaran_log`;

CREATE TABLE `keuangan_ta_anggaran_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `KdPosting` varchar(100) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `No_Perdes` varchar(100) NOT NULL,
  `TglPosting` varchar(100) NOT NULL,
  `UserID` varchar(50) NOT NULL,
  `Kunci` varchar(100) NOT NULL,
  `No_Perkades` varchar(100) DEFAULT NULL,
  `Petugas` varchar(80) DEFAULT NULL,
  `Tanggal` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_anggaran_log_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_anggaran_log_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_anggaran_rinci
#

DROP TABLE IF EXISTS `keuangan_ta_anggaran_rinci`;

CREATE TABLE `keuangan_ta_anggaran_rinci` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `KdPosting` varchar(100) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Kd_SubRinci` varchar(100) NOT NULL,
  `No_Urut` varchar(100) NOT NULL,
  `Uraian` varchar(100) NOT NULL,
  `SumberDana` varchar(100) NOT NULL,
  `JmlSatuan` varchar(100) NOT NULL,
  `HrgSatuan` varchar(100) NOT NULL,
  `Satuan` varchar(100) NOT NULL,
  `Anggaran` varchar(100) NOT NULL,
  `JmlSatuanPAK` varchar(100) NOT NULL,
  `HrgSatuanPAK` varchar(100) NOT NULL,
  `AnggaranStlhPAK` varchar(100) NOT NULL,
  `AnggaranPAK` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_anggaran_rinci_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_anggaran_rinci_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_bidang
#

DROP TABLE IF EXISTS `keuangan_ta_bidang`;

CREATE TABLE `keuangan_ta_bidang` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Kd_Bid` varchar(100) NOT NULL,
  `Nama_Bidang` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_bidang_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_bidang_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_desa
#

DROP TABLE IF EXISTS `keuangan_ta_desa`;

CREATE TABLE `keuangan_ta_desa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Nm_Kades` varchar(100) NOT NULL,
  `Jbt_Kades` varchar(100) NOT NULL,
  `Nm_Sekdes` varchar(100) NOT NULL,
  `NIP_Sekdes` varchar(100) NOT NULL,
  `Jbt_Sekdes` varchar(100) NOT NULL,
  `Nm_Kaur_Keu` varchar(100) NOT NULL,
  `Jbt_Kaur_Keu` varchar(100) NOT NULL,
  `Nm_Bendahara` varchar(100) NOT NULL,
  `Jbt_Bendahara` varchar(100) NOT NULL,
  `No_Perdes` varchar(100) NOT NULL,
  `Tgl_Perdes` varchar(100) NOT NULL,
  `No_Perdes_PB` varchar(100) NOT NULL,
  `Tgl_Perdes_PB` varchar(100) NOT NULL,
  `No_Perdes_PJ` varchar(100) NOT NULL,
  `Tgl_Perdes_PJ` varchar(100) NOT NULL,
  `Alamat` varchar(250) NOT NULL,
  `Ibukota` varchar(100) NOT NULL,
  `Status` varchar(100) NOT NULL,
  `NPWP` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_desa_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_desa_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_jurnal_umum
#

DROP TABLE IF EXISTS `keuangan_ta_jurnal_umum`;

CREATE TABLE `keuangan_ta_jurnal_umum` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `KdBuku` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Tanggal` varchar(100) NOT NULL,
  `JnsBukti` varchar(100) NOT NULL,
  `NoBukti` varchar(100) NOT NULL,
  `Keterangan` varchar(100) NOT NULL,
  `DK` varchar(100) NOT NULL,
  `Debet` varchar(100) NOT NULL,
  `Kredit` varchar(100) NOT NULL,
  `Jenis` varchar(100) NOT NULL,
  `Posted` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_jurnal_umum_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_jurnal_umum_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_jurnal_umum_rinci
#

DROP TABLE IF EXISTS `keuangan_ta_jurnal_umum_rinci`;

CREATE TABLE `keuangan_ta_jurnal_umum_rinci` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `NoBukti` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `RincianSD` varchar(100) NOT NULL,
  `NoID` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Akun` varchar(100) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Sumberdana` varchar(100) NOT NULL,
  `DK` varchar(100) NOT NULL,
  `Debet` varchar(100) NOT NULL,
  `Kredit` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_jurnal_umum_rinci_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_jurnal_umum_rinci_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_kegiatan
#

DROP TABLE IF EXISTS `keuangan_ta_kegiatan`;

CREATE TABLE `keuangan_ta_kegiatan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Kd_Bid` varchar(100) DEFAULT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `ID_Keg` varchar(100) NOT NULL,
  `Nama_Kegiatan` varchar(100) NOT NULL,
  `Pagu` varchar(100) NOT NULL,
  `Pagu_PAK` varchar(100) NOT NULL,
  `Nm_PPTKD` varchar(100) NOT NULL,
  `NIP_PPTKD` varchar(100) NOT NULL,
  `Lokasi` varchar(100) NOT NULL,
  `Waktu` varchar(100) NOT NULL,
  `Keluaran` varchar(100) NOT NULL,
  `Sumberdana` varchar(100) NOT NULL,
  `Jbt_PPTKD` varchar(100) DEFAULT NULL,
  `Kd_Sub` varchar(30) DEFAULT NULL,
  `Nilai` bigint(20) unsigned DEFAULT NULL,
  `NilaiPAK` bigint(20) unsigned DEFAULT NULL,
  `Satuan` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_kegiatan_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_kegiatan_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_mutasi
#

DROP TABLE IF EXISTS `keuangan_ta_mutasi`;

CREATE TABLE `keuangan_ta_mutasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `No_Bukti` varchar(100) NOT NULL,
  `Tgl_Bukti` varchar(100) NOT NULL,
  `Keterangan` varchar(200) DEFAULT NULL,
  `Kd_Bank` varchar(100) DEFAULT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `Sumberdana` varchar(100) NOT NULL,
  `Kd_Mutasi` varchar(100) NOT NULL,
  `Nilai` varchar(100) NOT NULL,
  `ID_Bank` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_mutasi_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_mutasi_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_pajak
#

DROP TABLE IF EXISTS `keuangan_ta_pajak`;

CREATE TABLE `keuangan_ta_pajak` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `No_SSP` varchar(100) NOT NULL,
  `Tgl_SSP` varchar(100) NOT NULL,
  `Keterangan` varchar(250) DEFAULT NULL,
  `Nama_WP` varchar(100) NOT NULL,
  `Alamat_WP` varchar(100) NOT NULL,
  `NPWP` varchar(100) NOT NULL,
  `Kd_MAP` varchar(100) NOT NULL,
  `Nm_Penyetor` varchar(100) NOT NULL,
  `Jn_Transaksi` varchar(100) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Jumlah` varchar(100) NOT NULL,
  `KdBayar` varchar(100) NOT NULL,
  `ID_Bank` varchar(10) DEFAULT NULL,
  `NTPN` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_pajak_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_pajak_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_pajak_rinci
#

DROP TABLE IF EXISTS `keuangan_ta_pajak_rinci`;

CREATE TABLE `keuangan_ta_pajak_rinci` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `No_SSP` varchar(100) NOT NULL,
  `No_Bukti` varchar(100) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Nilai` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_pajak_rinci_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_pajak_rinci_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_pemda
#

DROP TABLE IF EXISTS `keuangan_ta_pemda`;

CREATE TABLE `keuangan_ta_pemda` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Prov` varchar(100) NOT NULL,
  `Kd_Kab` varchar(100) NOT NULL,
  `Nama_Pemda` varchar(100) NOT NULL,
  `Nama_Provinsi` varchar(100) NOT NULL,
  `Ibukota` varchar(100) NOT NULL,
  `Alamat` varchar(100) NOT NULL,
  `Nm_Bupati` varchar(100) NOT NULL,
  `Jbt_Bupati` varchar(100) NOT NULL,
  `Logo` mediumblob,
  `C_Kode` varchar(100) NOT NULL,
  `C_Pemda` varchar(100) NOT NULL,
  `C_Data` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_pemda_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_pemda_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_pencairan
#

DROP TABLE IF EXISTS `keuangan_ta_pencairan`;

CREATE TABLE `keuangan_ta_pencairan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `No_Cek` varchar(100) NOT NULL,
  `No_SPP` varchar(100) NOT NULL,
  `Tgl_Cek` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Keterangan` varchar(250) DEFAULT NULL,
  `Jumlah` varchar(100) NOT NULL,
  `Potongan` varchar(100) NOT NULL,
  `KdBayar` varchar(100) NOT NULL,
  `ID_Bank` varchar(10) DEFAULT NULL,
  `Kunci` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_pencairan_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_pencairan_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_perangkat
#

DROP TABLE IF EXISTS `keuangan_ta_perangkat`;

CREATE TABLE `keuangan_ta_perangkat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Kd_Jabatan` varchar(100) NOT NULL,
  `No_ID` varchar(100) NOT NULL,
  `Nama_Perangkat` varchar(100) NOT NULL,
  `Alamat_Perangkat` varchar(100) NOT NULL,
  `Nomor_HP` varchar(100) NOT NULL,
  `Rek_Bank` varchar(100) NOT NULL,
  `Nama_Bank` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_perangkat_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_perangkat_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_rab
#

DROP TABLE IF EXISTS `keuangan_ta_rab`;

CREATE TABLE `keuangan_ta_rab` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Anggaran` varchar(100) NOT NULL,
  `AnggaranPAK` varchar(100) NOT NULL,
  `AnggaranStlhPAK` varchar(100) NOT NULL,
  `Kd_SubRinci` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_rab_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_rab_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_rab_rinci
#

DROP TABLE IF EXISTS `keuangan_ta_rab_rinci`;

CREATE TABLE `keuangan_ta_rab_rinci` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Kd_SubRinci` varchar(100) NOT NULL,
  `No_Urut` varchar(100) NOT NULL,
  `SumberDana` varchar(100) NOT NULL,
  `Uraian` varchar(100) NOT NULL,
  `Satuan` varchar(100) NOT NULL,
  `JmlSatuan` varchar(100) NOT NULL,
  `HrgSatuan` varchar(100) NOT NULL,
  `Anggaran` varchar(100) NOT NULL,
  `JmlSatuanPAK` varchar(100) NOT NULL,
  `HrgSatuanPAK` varchar(100) NOT NULL,
  `AnggaranStlhPAK` varchar(100) NOT NULL,
  `AnggaranPAK` varchar(100) NOT NULL,
  `Kode_SBU` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_rab_rinci_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_rab_rinci_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_rab_sub
#

DROP TABLE IF EXISTS `keuangan_ta_rab_sub`;

CREATE TABLE `keuangan_ta_rab_sub` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Kd_SubRinci` varchar(100) NOT NULL,
  `Nama_SubRinci` varchar(100) NOT NULL,
  `Anggaran` varchar(100) NOT NULL,
  `AnggaranPAK` varchar(100) NOT NULL,
  `AnggaranStlhPAK` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_rab_sub_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_rab_sub_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_rpjm_bidang
#

DROP TABLE IF EXISTS `keuangan_ta_rpjm_bidang`;

CREATE TABLE `keuangan_ta_rpjm_bidang` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Kd_Bid` varchar(100) NOT NULL,
  `Nama_Bidang` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_rpjm_bidang_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_rpjm_bidang_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_rpjm_kegiatan
#

DROP TABLE IF EXISTS `keuangan_ta_rpjm_kegiatan`;

CREATE TABLE `keuangan_ta_rpjm_kegiatan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Kd_Bid` varchar(100) DEFAULT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `ID_Keg` varchar(100) NOT NULL,
  `Nama_Kegiatan` varchar(100) NOT NULL,
  `Lokasi` varchar(100) NOT NULL,
  `Keluaran` varchar(100) NOT NULL,
  `Kd_Sas` varchar(100) NOT NULL,
  `Sasaran` varchar(100) NOT NULL,
  `Tahun1` varchar(100) NOT NULL,
  `Tahun2` varchar(100) NOT NULL,
  `Tahun3` varchar(100) NOT NULL,
  `Tahun4` varchar(100) NOT NULL,
  `Tahun5` varchar(100) NOT NULL,
  `Tahun6` varchar(100) NOT NULL,
  `Swakelola` varchar(100) NOT NULL,
  `Kerjasama` varchar(100) NOT NULL,
  `Pihak_Ketiga` varchar(100) NOT NULL,
  `Sumberdana` varchar(100) NOT NULL,
  `Kd_Sub` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_rpjm_kegiatan_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_rpjm_kegiatan_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_rpjm_misi
#

DROP TABLE IF EXISTS `keuangan_ta_rpjm_misi`;

CREATE TABLE `keuangan_ta_rpjm_misi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `ID_Misi` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `ID_Visi` varchar(100) NOT NULL,
  `No_Misi` varchar(100) NOT NULL,
  `Uraian_Misi` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_rpjm_misi_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_rpjm_misi_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_rpjm_pagu_indikatif
#

DROP TABLE IF EXISTS `keuangan_ta_rpjm_pagu_indikatif`;

CREATE TABLE `keuangan_ta_rpjm_pagu_indikatif` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `Kd_Sumber` varchar(100) NOT NULL,
  `Tahun1` varchar(100) NOT NULL,
  `Tahun2` varchar(100) NOT NULL,
  `Tahun3` varchar(100) NOT NULL,
  `Tahun4` varchar(100) NOT NULL,
  `Tahun5` varchar(100) NOT NULL,
  `Tahun6` varchar(100) NOT NULL,
  `Pola` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_rpjm_pagu_indikatif_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_rpjm_pagu_indikatif_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_rpjm_pagu_tahunan
#

DROP TABLE IF EXISTS `keuangan_ta_rpjm_pagu_tahunan`;

CREATE TABLE `keuangan_ta_rpjm_pagu_tahunan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `Kd_Tahun` varchar(100) NOT NULL,
  `Kd_Sumber` varchar(100) NOT NULL,
  `Biaya` varchar(100) NOT NULL,
  `Volume` varchar(100) NOT NULL,
  `Satuan` varchar(100) NOT NULL,
  `Lokasi_Spesifik` varchar(100) NOT NULL,
  `Jml_Sas_Pria` varchar(100) NOT NULL,
  `Jml_Sas_Wanita` varchar(100) NOT NULL,
  `Jml_Sas_ARTM` varchar(100) NOT NULL,
  `Waktu` varchar(100) NOT NULL,
  `Mulai` varchar(100) NOT NULL,
  `Selesai` varchar(100) NOT NULL,
  `Pola_Kegiatan` varchar(100) NOT NULL,
  `Pelaksana` varchar(100) NOT NULL,
  `No_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_rpjm_pagu_tahunan_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_rpjm_pagu_tahunan_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_rpjm_sasaran
#

DROP TABLE IF EXISTS `keuangan_ta_rpjm_sasaran`;

CREATE TABLE `keuangan_ta_rpjm_sasaran` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `ID_Sasaran` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `ID_Tujuan` varchar(100) NOT NULL,
  `No_Sasaran` varchar(100) NOT NULL,
  `Uraian_Sasaran` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_rpjm_sasaran_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_rpjm_sasaran_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_rpjm_tujuan
#

DROP TABLE IF EXISTS `keuangan_ta_rpjm_tujuan`;

CREATE TABLE `keuangan_ta_rpjm_tujuan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `ID_Tujuan` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `ID_Misi` varchar(100) NOT NULL,
  `No_Tujuan` varchar(100) NOT NULL,
  `Uraian_Tujuan` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_rpjm_tujuan_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_rpjm_tujuan_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_rpjm_visi
#

DROP TABLE IF EXISTS `keuangan_ta_rpjm_visi`;

CREATE TABLE `keuangan_ta_rpjm_visi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `ID_Visi` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `No_Visi` varchar(100) NOT NULL,
  `Uraian_Visi` varchar(250) DEFAULT NULL,
  `TahunA` varchar(100) NOT NULL,
  `TahunN` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_rpjm_visi_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_rpjm_visi_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_saldo_awal
#

DROP TABLE IF EXISTS `keuangan_ta_saldo_awal`;

CREATE TABLE `keuangan_ta_saldo_awal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Jenis` varchar(100) NOT NULL,
  `Anggaran` varchar(100) NOT NULL,
  `Debet` varchar(100) NOT NULL,
  `Kredit` varchar(100) NOT NULL,
  `Tgl_Bukti` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_saldo_awal_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_saldo_awal_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_spj
#

DROP TABLE IF EXISTS `keuangan_ta_spj`;

CREATE TABLE `keuangan_ta_spj` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `No_SPJ` varchar(100) NOT NULL,
  `Tgl_SPJ` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `No_SPP` varchar(100) NOT NULL,
  `Keterangan` varchar(100) NOT NULL,
  `Jumlah` varchar(100) NOT NULL,
  `Potongan` varchar(100) NOT NULL,
  `Status` varchar(100) NOT NULL,
  `Kunci` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_spj_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_spj_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_spj_bukti
#

DROP TABLE IF EXISTS `keuangan_ta_spj_bukti`;

CREATE TABLE `keuangan_ta_spj_bukti` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `No_SPJ` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `No_Bukti` varchar(100) NOT NULL,
  `Tgl_Bukti` varchar(100) NOT NULL,
  `Sumberdana` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Nm_Penerima` varchar(100) NOT NULL,
  `Alamat` varchar(100) NOT NULL,
  `Rek_Bank` varchar(100) NOT NULL,
  `Nm_Bank` varchar(100) NOT NULL,
  `NPWP` varchar(100) NOT NULL,
  `Keterangan` varchar(250) DEFAULT NULL,
  `Nilai` varchar(100) NOT NULL,
  `Kd_SubRinci` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_spj_bukti_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_spj_bukti_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_spj_rinci
#

DROP TABLE IF EXISTS `keuangan_ta_spj_rinci`;

CREATE TABLE `keuangan_ta_spj_rinci` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `No_SPJ` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Sumberdana` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `No_SPP` varchar(100) NOT NULL,
  `JmlCair` varchar(100) NOT NULL,
  `Nilai` varchar(100) NOT NULL,
  `Alamat` varchar(100) DEFAULT NULL,
  `Sisa` varchar(100) NOT NULL,
  `Kd_SubRinci` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_spj_rinci_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_spj_rinci_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_spj_sisa
#

DROP TABLE IF EXISTS `keuangan_ta_spj_sisa`;

CREATE TABLE `keuangan_ta_spj_sisa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `No_Bukti` varchar(100) NOT NULL,
  `Tgl_Bukti` varchar(100) NOT NULL,
  `No_SPJ` varchar(100) NOT NULL,
  `Tgl_SPJ` varchar(100) NOT NULL,
  `No_SPP` varchar(100) NOT NULL,
  `Tgl_SPP` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `Keterangan` varchar(100) NOT NULL,
  `Nilai` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_spj_sisa_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_spj_sisa_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_spjpot
#

DROP TABLE IF EXISTS `keuangan_ta_spjpot`;

CREATE TABLE `keuangan_ta_spjpot` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `No_SPJ` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `No_Bukti` varchar(100) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Nilai` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_spjpot_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_spjpot_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_spp
#

DROP TABLE IF EXISTS `keuangan_ta_spp`;

CREATE TABLE `keuangan_ta_spp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `No_SPP` varchar(100) NOT NULL,
  `Tgl_SPP` varchar(100) NOT NULL,
  `Jn_SPP` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Keterangan` varchar(250) DEFAULT NULL,
  `Jumlah` varchar(100) NOT NULL,
  `Potongan` varchar(100) NOT NULL,
  `Status` varchar(100) NOT NULL,
  `F10` varchar(10) DEFAULT NULL,
  `F11` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_spp_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_spp_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_spp_rinci
#

DROP TABLE IF EXISTS `keuangan_ta_spp_rinci`;

CREATE TABLE `keuangan_ta_spp_rinci` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `No_SPP` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Sumberdana` varchar(100) NOT NULL,
  `Nilai` varchar(100) NOT NULL,
  `Kd_SubRinci` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_spp_rinci_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_spp_rinci_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_sppbukti
#

DROP TABLE IF EXISTS `keuangan_ta_sppbukti`;

CREATE TABLE `keuangan_ta_sppbukti` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `No_SPP` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Sumberdana` varchar(100) NOT NULL,
  `No_Bukti` varchar(100) NOT NULL,
  `Tgl_Bukti` varchar(100) NOT NULL,
  `Nm_Penerima` varchar(100) NOT NULL,
  `Alamat` varchar(100) NOT NULL,
  `Rek_Bank` varchar(100) NOT NULL,
  `Nm_Bank` varchar(100) NOT NULL,
  `NPWP` varchar(100) NOT NULL,
  `Keterangan` varchar(200) DEFAULT NULL,
  `Nilai` varchar(100) NOT NULL,
  `Kd_SubRinci` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_sppbukti_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_sppbukti_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_spppot
#

DROP TABLE IF EXISTS `keuangan_ta_spppot`;

CREATE TABLE `keuangan_ta_spppot` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `No_SPP` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `No_Bukti` varchar(100) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Nilai` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_spppot_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_spppot_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_sts
#

DROP TABLE IF EXISTS `keuangan_ta_sts`;

CREATE TABLE `keuangan_ta_sts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `No_Bukti` varchar(100) NOT NULL,
  `Tgl_Bukti` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Uraian` varchar(100) NOT NULL,
  `NoRek_Bank` varchar(100) NOT NULL,
  `Nama_Bank` varchar(100) NOT NULL,
  `Jumlah` varchar(100) NOT NULL,
  `Nm_Bendahara` varchar(100) NOT NULL,
  `Jbt_Bendahara` varchar(100) NOT NULL,
  `ID_Bank` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_sts_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_sts_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_sts_rinci
#

DROP TABLE IF EXISTS `keuangan_ta_sts_rinci`;

CREATE TABLE `keuangan_ta_sts_rinci` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `No_Bukti` varchar(100) NOT NULL,
  `No_TBP` varchar(100) NOT NULL,
  `Uraian` varchar(100) NOT NULL,
  `Nilai` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_sts_rinci_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_sts_rinci_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_tbp
#

DROP TABLE IF EXISTS `keuangan_ta_tbp`;

CREATE TABLE `keuangan_ta_tbp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `No_Bukti` varchar(100) NOT NULL,
  `Tgl_Bukti` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Uraian` varchar(250) DEFAULT NULL,
  `Nm_Penyetor` varchar(100) NOT NULL,
  `Alamat_Penyetor` varchar(100) NOT NULL,
  `TTD_Penyetor` varchar(100) NOT NULL,
  `NoRek_Bank` varchar(100) NOT NULL,
  `Nama_Bank` varchar(100) NOT NULL,
  `Jumlah` varchar(100) NOT NULL,
  `Nm_Bendahara` varchar(100) NOT NULL,
  `Jbt_Bendahara` varchar(100) NOT NULL,
  `Status` varchar(100) NOT NULL,
  `KdBayar` varchar(100) NOT NULL,
  `Ref_Bayar` varchar(100) NOT NULL,
  `ID_Bank` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_tbp_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_tbp_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_tbp_rinci
#

DROP TABLE IF EXISTS `keuangan_ta_tbp_rinci`;

CREATE TABLE `keuangan_ta_tbp_rinci` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `No_Bukti` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `RincianSD` varchar(100) NOT NULL,
  `SumberDana` varchar(100) NOT NULL,
  `nilai` varchar(100) NOT NULL,
  `Kd_SubRinci` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_tbp_rinci_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_tbp_rinci_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_triwulan
#

DROP TABLE IF EXISTS `keuangan_ta_triwulan`;

CREATE TABLE `keuangan_ta_triwulan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `KURincianSD` varchar(100) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Sifat` varchar(100) NOT NULL,
  `SumberDana` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Anggaran` varchar(100) NOT NULL,
  `AnggaranPAK` varchar(100) NOT NULL,
  `Tw1Rinci` varchar(100) DEFAULT NULL,
  `Tw2Rinci` varchar(100) DEFAULT NULL,
  `Tw3Rinci` varchar(100) DEFAULT NULL,
  `Tw4Rinci` varchar(100) DEFAULT NULL,
  `KunciData` varchar(100) NOT NULL,
  `Jan` varchar(100) DEFAULT NULL,
  `Peb` varchar(100) DEFAULT NULL,
  `Mar` varchar(100) DEFAULT NULL,
  `Apr` varchar(100) DEFAULT NULL,
  `Mei` varchar(100) DEFAULT NULL,
  `Jun` varchar(100) DEFAULT NULL,
  `Jul` varchar(100) DEFAULT NULL,
  `Agt` varchar(100) DEFAULT NULL,
  `Sep` varchar(100) DEFAULT NULL,
  `Okt` varchar(100) DEFAULT NULL,
  `Nop` varchar(100) DEFAULT NULL,
  `Des` varchar(100) DEFAULT NULL,
  `Kd_SubRinci` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_triwulan_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_triwulan_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: keuangan_ta_triwulan_rinci
#

DROP TABLE IF EXISTS `keuangan_ta_triwulan_rinci`;

CREATE TABLE `keuangan_ta_triwulan_rinci` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keuangan_master` int(11) NOT NULL,
  `KdPosting` varchar(100) NOT NULL,
  `KURincianSD` varchar(100) NOT NULL,
  `Tahun` varchar(100) NOT NULL,
  `Sifat` varchar(100) NOT NULL,
  `SumberDana` varchar(100) NOT NULL,
  `Kd_Desa` varchar(100) NOT NULL,
  `Kd_Keg` varchar(100) NOT NULL,
  `Kd_Rincian` varchar(100) NOT NULL,
  `Anggaran` varchar(100) NOT NULL,
  `AnggaranPAK` varchar(100) NOT NULL,
  `Tw1Rinci` varchar(100) DEFAULT NULL,
  `Tw2Rinci` varchar(100) DEFAULT NULL,
  `Tw3Rinci` varchar(100) DEFAULT NULL,
  `Tw4Rinci` varchar(100) DEFAULT NULL,
  `KunciData` varchar(100) NOT NULL,
  `Jan` varchar(100) DEFAULT NULL,
  `Peb` varchar(100) DEFAULT NULL,
  `Mar` varchar(100) DEFAULT NULL,
  `Apr` varchar(100) DEFAULT NULL,
  `Mei` varchar(100) DEFAULT NULL,
  `Jun` varchar(100) DEFAULT NULL,
  `Jul` varchar(100) DEFAULT NULL,
  `Agt` varchar(100) DEFAULT NULL,
  `Sep` varchar(100) DEFAULT NULL,
  `Okt` varchar(100) DEFAULT NULL,
  `Nop` varchar(100) DEFAULT NULL,
  `Des` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_keuangan_ta_triwulan_rinci_master_fk` (`id_keuangan_master`),
  CONSTRAINT `id_keuangan_ta_triwulan_rinci_master_fk` FOREIGN KEY (`id_keuangan_master`) REFERENCES `keuangan_master` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: klasifikasi_analisis_keluarga
#

DROP TABLE IF EXISTS `klasifikasi_analisis_keluarga`;

CREATE TABLE `klasifikasi_analisis_keluarga` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(20) NOT NULL,
  `jenis` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: klasifikasi_surat
#

DROP TABLE IF EXISTS `klasifikasi_surat`;

CREATE TABLE `klasifikasi_surat` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `kode` varchar(50) NOT NULL,
  `nama` varchar(250) NOT NULL,
  `uraian` mediumtext NOT NULL,
  `enabled` int(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2335 DEFAULT CHARSET=latin1;

INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1, '000', 'UMUM', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2, '001', 'Lambang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (3, '001.1', 'Garuda', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (4, '001.2', 'Bendera Kebangsaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (5, '001.3', 'Lagu Kebangsaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (6, '001.4', 'Daerah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (7, '001.31', 'Provinsi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (8, '001.32', 'Kabupaten/Kota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (9, '002', 'Tanda Kehormatan/Penghargaan untuk pegawai ', 'lihat 861.1', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (10, '002.1', 'Bintang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (11, '002.2', 'Satyalencana', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (12, '002.3', 'Samkarya Nugraha', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (13, '002.4', 'Monumen', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (14, '002.5', 'Penghargaan Secara Adat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (15, '002.6', 'Penghargaan lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (16, '003', 'Hari Raya/Besar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (17, '003.1', 'Nasional 17 Agustus, Hari Pahlawan, dan sebagainya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (18, '003.2', 'Hari Raya Keagamaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (19, '003.3', 'Hari Ulang Tahun', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (20, '003.4', 'Hari-hari Besar Internasional', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (21, '004', 'Ucapan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (22, '004.1', 'Ucapan Terima Kasih', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (23, '004.2', 'Ucapan Selamat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (24, '004.3', 'Ucapan Belasungkawa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (25, '004.4', 'Ucapan Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (26, '005', 'Undangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (27, '006', 'Tanda Jabatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (28, '006.1', 'Pamong Praja', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (29, '006.2', 'Tanda Pengenal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (30, '006.3', 'Pejabat lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (31, '007', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (32, '008', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (33, '009', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (34, '010', 'URUSAN DALAM ', 'Gedung Kantor/Termasuk Instalasi Prasarana Fisik Pamong', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (35, '011', 'Kantor Dinas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (36, '012', 'Rumah Dinas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (37, '012.1', 'Tanah Untuk Rumah Dinas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (38, '012.2', 'Perabot Rumah Dinas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (39, '012.3', 'Rumah Dinas Golongan 1', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (40, '012.4', 'Rumah Dinas Golongan 2', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (41, '012.5', 'Rumah Dinas Golongan 3', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (42, '012.6', 'Rumah/Bangunan Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (43, '012.7', 'Rumah Pejabat Negara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (44, '013', 'Mess/Guest House', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (45, '014', 'Rumah Susun/Apartemen', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (46, '015', 'Penerangan Listrik/Jasa Listrik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (47, '016', 'Telepon/Faximile/Internet', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (48, '017', 'Keamanan/Ketertiban Kantor', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (49, '018', 'Kebersihan Kantor', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (50, '019', 'Protokol', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (51, '019.1', 'Upacara Bendera', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (52, '019.2', 'Tata Tempat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (53, '019.21', 'Pemasangan Gambar Presiden/Wakil Presiden', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (54, '019.3', 'Audiensi / Menghadap Pimpinan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (55, '019.4', 'Alamat-Alamat Kantor Pejabat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (56, '019.5', 'Bandir/Umbul-Umbul/Spanduk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (57, '020', 'PERALATAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (58, '020.1', 'Penawaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (59, '021', 'Alat Tulis', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (60, '022', 'Mesin Kantor', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (61, '023', 'Perabot Kantor', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (62, '024', 'Alat Angkutan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (63, '025', 'Pakaian Dinas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (64, '026', 'Senjata', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (65, '027', 'Pengadaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (66, '028', 'Inventaris', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (67, '029', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (68, '030', 'KEKAYAAN DAERAH', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (69, '031', 'Sumber Daya Alam', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (70, '032', 'Asset Daerah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (71, '033', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (72, '034', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (73, '035', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (74, '036', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (75, '040', 'PERPUSTAKAAN DOKUMENTASI / KEARSIPAN / SANDI', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (76, '041', 'Perpustakaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (77, '041.1', 'Umum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (78, '041.2', 'Khusus', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (79, '041.3', 'Perguruan Tinggi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (80, '041.4', 'Sekolah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (81, '041.5', 'Keliling', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (82, '042', 'Dokumentasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (83, '043', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (84, '044', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (85, '045', 'Kearsipan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (86, '045.1', 'Pola Klasifikasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (87, '045.2', 'Penataan Berkas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (88, '045.3', 'Penyusutan Arsip', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (89, '045.31', 'Jadwal Retensi Arsip', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (90, '045.32', 'Pemindahan Arsip', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (91, '045.33', 'Penilaian Arsip', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (92, '045.34', 'Pemusnahan Arsip', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (93, '045.35', 'Penyerahan Arsip', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (94, '045.36', 'Berita Acara Penyusutan Arsip', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (95, '045.37', 'Daftar Pencarian Arsip', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (96, '045.4', 'Pembinaan Kearsipan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (97, '045.41', 'Bimbingan Teknis', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (98, '045.5', 'Pemeliharaan /Perawatan Arsip', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (99, '045.6', 'Pengawetan/Fumigasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (100, '046', 'Sandi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (101, '047', 'Website', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (102, '048', 'Pengelolaan Data', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (103, '049', 'Jaringan Komunikasi Data', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (104, '050', 'PERENCANAAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (105, '050.1', 'Repelita/8 Sukses', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (106, '050.11', 'Pelita Daerah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (107, '050.12', 'Bantuan Pembangunan Daerah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (108, '050.13', 'Bappeda', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (109, '051', 'Proyek Bidang Pemerintahan, ', 'Klasifikasikan Disini : Proyek Prasaran Fisik Pemerintahan, Tambahkan Perincian 100 Pada 051 Contoh: Proyek Kepenjaraan 051.86', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (110, '052', 'Bidang Politik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (111, '053', 'Bidang Keamanan Dan Ketertiban', 'Tambahkan Perincian 300 Pada 053 Contoh: Proyek Ketataprajaan 053.311 ', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (112, '054', 'Bidang Kesejahteraan Rakyat ', 'Tambahkan Peincian 400 pada 054 Contoh: Proyek Resettlement Desa 054.671', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (113, '055', 'Bidang Perekonomian ', 'Tambahkan Perincian 500 Pada 055 Contoh: Proyek Pasar 055.112', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (114, '056', 'Bidang Pekerjaan Umum ', 'Tambahkan Perincian 600 pada 056 Contoh: Proyek Jembatan 056.3', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (115, '057', 'Bidang Pengawasan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (116, '058', 'Bidang Kepegawaian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (117, '059', 'Bidang Keuangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (118, '060', 'ORGANISASI / KETATALAKSANAAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (119, '060.1', 'Program Kerja', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (120, '061', 'Organisasi Instansi Pemerintah (struktur organisasi)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (121, '061.1', 'Susunan dan Tata Kerja', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (122, '061.2', 'Tata Tertib Kantor, Jam Kerja di Bulan Puasa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (123, '062', 'Organisasi Badan Non Pemerintah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (124, '063', 'Organisasi Badan Internasional', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (125, '064', 'Organisasi Semi Pemerintah, BKS-AKSI', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (126, '065', 'Ketatalaksanaan / Tata Naskah / Sistem', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (127, '066', 'Stempel Dinas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (128, '067', 'Pelayanan Umum / Pelayanan Publik / Analisis', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (129, '068', 'Komputerisasi / Siskomdagri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (130, '069', 'Standar Pelayanan Minimal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (131, '070', 'PENELITIAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (132, '071', 'Riset', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (133, '072', 'Survey', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (134, '073', 'Kajian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (135, '074', 'Kerjasama Penelitian Dengan Perguruan Tinggi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (136, '075', 'Kementerian Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (137, '076', 'Non Kementerian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (138, '077', 'Provinsi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (139, '078', 'Kabupaten/Kota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (140, '079', 'Kecamatan /Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (141, '080', 'KONFERENSI / RAPAT / SEMINAR', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (142, '081', 'Gubernur', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (143, '082', 'Bupati / Walikota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (144, '083', 'Komponen, Eselon Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (145, '084', 'Instansi Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (146, '085', 'Internasional Di Dalam Negeri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (147, '086', 'Internasional Di Luar Negeri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (148, '087', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (149, '088', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (150, '089', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (151, '090', 'PERJALANAN DINAS', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (152, '091', 'Perjalanan Presiden/Wakil Presiden Ke Daerah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (153, '092', 'Perjalanan Menteri Ke Daerah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (154, '093', 'Perjalanan Pejabat Tinggi (Pejabat Eselon 1)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (155, '094', 'Perjalanan Pegawai Termasuk Pemanggilan Pegawai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (156, '095', 'Perjalanan Tamu Asing Ke Daerah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (157, '096', 'Perjalanan Presiden/Wakil Presiden Ke Luar Negeri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (158, '097', 'Perjalanan Menteri Ke Luar Negeri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (159, '098', 'Perjalanan Pejabat Tinggi Ke Luar Negeri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (160, '099', 'Perjalanan Pegawai ke Luar Negeri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (161, '100', 'PEMERINTAHAN', 'Meliputi: Tata Praja, Legislatif, Yudikatif, Hubungan luar', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (162, '101', 'negeri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (163, '102', 'GDN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (164, '103', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (165, '104', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (166, '105', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (167, '110', 'PEMERINTAHAN PUSAT', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (168, '111', 'Presiden', 'Meliputi: pencalonan, pengangkatan, pelantikan, sumpah, dan serah jabatan', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (169, '111.1', 'Pertanggung jawaban presiden kpd MPR', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (170, '111.2', 'Amanat Presiden/Amanat Kenegaraan/Pidato', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (171, '112', 'Wakil Presiden', 'Meliputi: pencalonan, pengangkatan, pelantikan, sumpah, dan serah jabatan', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (172, '112.1', 'Pertanggung jawaban wakil presiden kepada MPR', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (173, '112.2', 'Amanat Wakil Presiden/Amanat Kenegaraan/Pidato', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (174, '113', 'Susunan Kabinet', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (175, '113.1', 'Reshuffle', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (176, '113.2', 'Penunjukan Menteri ad interim', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (177, '113.3', 'Sidang Kabinet', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (178, '114', 'Kementerian Dalam Negeri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (179, '114.1', 'Amanat Menteri Dalam Negeri/Sambutan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (180, '115', 'Kementerian lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (181, '116', 'Lembaga Tinggi Negara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (182, '117', 'Lembaga Non Kementerian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (183, '118', 'Otonomi/Desentralisasi/Dekonsentrasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (184, '119', 'Kerjasama Antar Kementerian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (185, '120', 'PEMERINTAH PROVINSI', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (186, '120.04', 'Laporan daerah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (187, '120.42', 'Monografi tambahkan kode wilayah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (188, '120.1', 'Koordinasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (189, '120.2', 'Instansi Tingkat Provinsi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (190, '120.21', 'Dinas Otonomi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (191, '120.22', 'Instansi Vertikal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (192, '120.23', 'Kerjasama antar Provinsi/Daerah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (193, '121', 'Gubernur tambahkan kode wilayah, ', 'Meliputi: Pencalonan, Pengangkatan, Meninggal, Pelantikan, Pemberhentian, Serah Terima Jabatan dan sebagainya.', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (194, '122', 'Wakil Gubernur tambahkan kode wilayah, ', 'Meliputi: Pencalonan, Pengangkatan, Meninggal, Pelantikan, Pemberhentian, Serah Terima Jabatan  dan sebagainya.', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (195, '123', 'Sekretaris Wilayah tambahkan kode wilayah, ', 'Meliputi: Pencalonan, Pengangkatan, Meninggal, Pelantikan, Pemberhentian, Serah Terima Jabatan dan sebagainya.', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (196, '124', 'Pembentukan/Pemekaran Wilayah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (197, '124.1', 'Pembinaan/Perubahan Nama kepada: Daerah, Kota,Benda, Geografis, Gunung, Sungai, Pulau, Selat, Batas laut, dan sebagainya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (198, '124.2', 'Pemekaran  Wilayah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (199, '124.3', 'Forum Koordinasi lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (200, '125', 'Pembentukan Pemekaran Wilayah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (201, '125.1', 'Pembinaan/Perubahan Nama Kepada: Daerah, Kota, Benda, Geografis, Gunung, Sungai, Pulau, Selat, Batas Laut, dan sebagainya.', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (202, '125.2', 'Pembentukan Wialayah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (203, '125.3', 'Pemindahan Ibukota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (204, '125.4', 'Perubahan batas Wilayah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (205, '125.5', 'Pemekaran Wialayah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (206, '126', 'Pembagian Wilayah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (207, '127', 'Penyerahan Urusan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (208, '128', 'Swaparaja/Penataan Wilayah/Daerah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (209, '129', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (210, '130', 'PEMERINTAH KABUPATEN / KOTA', 'Bupati /Walikota, Tambahkan Kode Wilayah, Meliputi: Pencalonan,Pengangkatan, Meninggal, Pelantikan,', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (211, '131', 'Pemberhentian, Serah Terima Jabatan, dsb', 'Sambutan / Pengarahan / Amanat Wakil Bupati /Walikota, Tambahkan Kode Wilayah, Meliputi: Pencalonan, Pengangkatan, Meninggal, Pelantikan,', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (212, '132', 'Pemberhentian, Serah Terima Jabatan, Sekretaris Daerah Kabupaten/Kota, Tambahkan Kode Wilayah, ', 'Meliputi: Pencalonan, Pengangkatan, Meninggal,', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (213, '133', 'Pelantikan, Pemberhentian, Serah Terima Jabatan,.', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (214, '134', 'Forum Koordinasi Pemerintah Di Daerah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (215, '134.1', 'Muspida', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (216, '134.2', 'Forum PAN (Panitian Anggaran Nasional)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (217, '134.3', 'Forum Koordinasi Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (218, '134.4', 'Kerjasama antar Kabupaten/Kota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (219, '135', 'Pembentukan / Pemekaran Wilayah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (220, '135.1', 'Pemindahan Ibukota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (221, '135.2', 'Pembentukan Wilayah Pembantu Bupati/Walikota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (222, '135.3', 'Pemabagian Wilayah Kabupaten/Kota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (223, '135.4', 'Perubahan Batas Wilayah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (224, '135.5', 'Pemekaran Wilayah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (225, '135.6', 'Permasalahan Batas Wilayah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (226, '135.7', 'Pembentukan Ibukota Kabupaten/Kota Pemberian dan Penggantian Nama Kabupaten/Kota, Daerah,', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (227, '135.8', 'Jalan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (228, '136', 'Pembagian Wilayah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (229, '137', 'Penyerahan Urusan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (230, '138', 'Pemerintah Wilayah Kecamatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (231, '138.1', 'Sambutan / Pengarahan / Amanat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (232, '138.2', 'Pembentukan Kecamatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (233, '138.3', 'Pemekaran Kecamatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (234, '138.4', 'Perluasan/Perubahan Batas Wilayah Kecamatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (235, '138.5', 'Pembentukan Perwakilan Kecamatan/Kemantren', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (236, '138.6', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (237, '138.7', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (238, '139', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (239, '140', 'PEMERINTAHAN DESA / KELURAHAN', 'Pamong Desa, Meliputi: Pencalonan, Pemilihan, Meninggal,', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (240, '141', 'Pengangkatan, Pemberhenian, dan sebagainya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (241, '142', 'Penghasilan Pamong Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (242, '143', 'Kekayaan Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (243, '144', 'Dewan Tingkat Desa, Dewan Marga, Rembug Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (244, '145', 'Administrasi Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (245, '146', 'Kewilayahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (246, '146.1', 'Pembentukan Desa/Kelurahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (247, '146.2', 'Pemekaran Desa/Kelurahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (248, '146.3', 'Perubahan Batas Wilayah / Perluasan Desa / Kelurahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (249, '146.4', 'Perubahan Nama Desa / Kelurahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (250, '146.5', 'Kerjasama Antar Desa / Kelurahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (251, '147', 'Lembaga-lembaga Tingkat Desa', 'Jangan Klasifikasikan Disini, Lihat 410 Dengan Perinciannya', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (252, '148', 'Perangkat Kelurahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (253, '148.1', 'Kepala Kelurahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (254, '148.2', 'Sekretaris Kelurahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (255, '148.3', 'Staf Kelurahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (256, '149.1', 'Dewan Kelurahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (257, '149.2', 'Rukun Tetangga', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (258, '149.3', 'Rukun Warga', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (259, '149.4', 'Rukun Kampung', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (260, '150', 'LEGISLATIF MPR / DPR / DPD', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (261, '151', 'Keanggotaan MPR', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (262, '151.1', 'Pencalonan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (263, '151.2', 'Pemberhentian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (264, '151.3', 'Recall', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (265, '151.4', 'Pelanggaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (266, '152', 'Persidangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (267, '153', 'Kesejahteraan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (268, '153.1', 'Keuangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (269, '153.2', 'Penghargaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (270, '154', 'Hak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (271, '155', 'Keanggotaan DPR ', 'Pencalonan Pengangkatan Persidangan Sidang Pleno Dengar Pendapat/Rapat Komisi', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (272, '156', 'Reses', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (273, '157', 'Kesejahteraan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (274, '157.1', 'Keuangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (275, '157.2', 'Penghargaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (276, '158', 'Jawaban Pemerintah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (277, '159', 'Hak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (278, '160', 'DPRD PROVINSI TAMBAHKAN KODE WILAYAH', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (279, '161', 'Keanggotaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (280, '161.1', 'Pencalonan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (281, '161.2', 'Pengangkatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (282, '161.3', 'Pemberhentian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (283, '161.4', 'Recall', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (284, '161.5', 'Meninggal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (285, '161.6', 'Pelanggaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (286, '162', 'Persidangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (287, '162.1', 'Reses', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (288, '163', 'Kesejahteraan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (289, '163.1', 'Keuangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (290, '163.2', 'Penghargaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (291, '164', 'Hak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (292, '165', 'Sekretaris DPRD Provinsi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (293, '166', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (294, '167', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (295, '168', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (296, '169', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (297, '170', 'DPRD KABUPATEN TAMBAHKAN KODE WILAYAH', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (298, '171', 'Keanggotaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (299, '171.1', 'Pencalonan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (300, '171.2', 'Pengangkatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (301, '171.3', 'Pemberhentian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (302, '171.4', 'Recall', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (303, '171.5', 'Pelanggaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (304, '172', 'Persidangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (305, '173', 'Kesejahteraan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (306, '173.1', 'Keuangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (307, '173.2', 'Penghargaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (308, '174', 'Hak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (309, '175', 'Sekretaris DPRD Kabupaten/Kota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (310, '176', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (311, '177', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (312, '178', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (313, '180', 'HUKUM', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (314, '180.1', 'Kontitusi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (315, '180.11', 'Dasar Hukum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (316, '180.12', 'Undang-Undang Dasar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (317, '180.2', 'GBHN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (318, '180.3', 'Amnesti, Abolisi dan Grasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (319, '181', 'Perdata', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (320, '181.1', 'Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (321, '181.2', 'Rumah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (322, '181.3', 'Utang/Piutang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (323, '181.31', 'Gadai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (324, '181.32', 'Hipotik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (325, '181.4', 'Notariat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (326, '182', 'Pidana', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (327, '182.1', 'Penyidik Pegawai Negeri Sipil (PPNS)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (328, '183', 'Peradilan', 'Peradilan Agama Islam 451.6, Peradilan Perkara Tanah 593.71', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (329, '183.1', 'Bantuan Hukum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (330, '184', 'Hukum Internasional', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (331, '185', 'Imigrasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (332, '185.1', 'Visa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (333, '185.2', 'Pasport', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (334, '185.3', 'Exit', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (335, '185.4', 'Reentry', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (336, '185.5', 'Lintas Batas/Batas Antar Negara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (337, '186', 'Kepenjaraan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (338, '187', 'Kejaksaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (339, '188', 'Peraturan Perundang-Undangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (340, '188.1', 'TAP MPR', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (341, '188.2', 'Undang-Undang Dasar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (342, '188.3', 'Peraturan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (343, '188.31', 'Peraturan Pemerintah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (344, '188.32', 'Peraturan Menteri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (345, '188.33', 'Peraturan Lembaga Non Departemen', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (346, '188.34', 'Peraturan Daerah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (347, '188.341', 'Peraturan Provinsi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (348, '188.342', 'Peraturan Kabupaten/Kota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (349, '188.4', 'Keputusan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (350, '188.41', 'Presiden', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (351, '188.42', 'Menteri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (352, '188.43', 'Lembaga Non Departemen', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (353, '188.44', 'Gubernur', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (354, '188.45', 'Bupati/Walikota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (355, '188.5', 'Instruksi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (356, '188.51', 'Presiden', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (357, '188.52', 'Menteri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (358, '188.53', 'Lembaga Non Departemen', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (359, '188.54', 'Gubernur', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (360, '188.55', 'Bupati/Walikota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (361, '189', 'Hukum Adat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (362, '189.1', 'Tokoh Adat/Masyarakat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (363, '190', 'HUBUNGAN LUAR NEGERI', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (364, '191', 'Perwakilan Asing', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (365, '192', 'Tamu Negara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (366, '193', 'Kerjasama Dengan Negara Asing', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (367, '193.1', 'Asean', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (368, '193.2', 'Bantuan Luar Negeri/Hibah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (369, '194', 'Perwakilan RI Di Luar Negeri/Hibah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (370, '195', 'PBB', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (371, '196', 'Laporan Luar Negeri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (372, '197', 'Hutang Luar Negeri PHLN/LOAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (373, '198', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (374, '199', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (375, '200', 'POLITIK', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (376, '201', 'Kebijaksanaan umum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (377, '202', 'Orde baru', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (378, '203', 'Reformasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (379, '204', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (380, '205', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (381, '206', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (382, '210', 'KEPARTAIAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (383, '211', 'Lambang partai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (384, '212', 'Kartu tanda anggota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (385, '213', 'Bantuan keuangan parpol', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (386, '214', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (387, '215', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (388, '216', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (389, '220', 'ORGANISASI KEMASYARAKATAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (390, '221', 'Berdasarkan perjuangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (391, '221.1', 'Perintis kemerdekaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (392, '221.2', 'angkatan 45', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (393, '221.3', 'Veteran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (394, '222', 'Berdasarkan Kekaryaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (395, '222.1', 'PEPABRI', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (396, '222.2', 'Wredatama', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (397, '223', 'Berdasarkan kerohanian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (398, '224', 'Lembaga adat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (399, '225', 'Lembaga Swadaya Masyarakat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (400, '226', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (401, '230', 'ORGANISASI PROFESI DAN FUNGSIONAL', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (402, '231', 'Ikatan Dokter Indonesia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (403, '232', 'Persatuan Guru Republik Indonesia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (404, '233', 'PERSATUAN SARJANA HUKUM INDONESIA', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (405, '234', 'Persatuan Advokat Indonesia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (406, '235', 'Lembaga Bantuan Hukum Indonesia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (407, '236', 'Korps Pegawai Republik Indonesia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (408, '237', 'Persatuan Wartawan Indonesia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (409, '238', 'Ikatan Cendikiawan Muslim Indonesia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (410, '239', 'Organisasi Profesi Dan Fungsional Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (411, '240', 'ORGANISASI PEMUDA', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (412, '241', 'Komite Nasional Pemuda Indonesia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (413, '242', 'Organisasi Mahasiswa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (414, '243', 'Organisasi Pelajar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (415, '244', 'Gerakan Pemuda Ansor', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (416, '245', 'Gerakan Pemuda Islam Indonesia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (417, '246', 'Gerakan Pemuda Marhaenis', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (418, '247', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (419, '248', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (420, '250', 'ORGANISASI BURUH, TANI, NELAYAN DAN ANGKUTAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (421, '251', 'Federasi Buruh Seluruh Indonesia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (422, '252', 'Organisasi Buruh Internasional', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (423, '253', 'Himpunan Kerukunan Tani', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (424, '254', 'Himpunan Nelayan Seluruh Indonesia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (425, '255', 'Keluarga Sopir Proporsional Indonesia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (426, '256', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (427, '257', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (428, '258', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (429, '260', 'ORGANISASI WANITA', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (430, '261', 'Dharma Wanita', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (431, '262', 'Persatuan Wanita Indonesia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (432, '263', 'Pemberdayaan Perempuan (wanita)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (433, '264', 'Kongres Wanita', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (434, '265', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (435, '266', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (436, '267', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (437, '268', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (438, '269', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (439, '270', 'PEMILIHAN UMUM', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (440, '271', 'Pencalonan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (441, '272', 'Nomor Urut Partai / Tanda Gambar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (442, '273', 'Kampanye', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (443, '274', 'Petugas Pemilu', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (444, '275', 'Pemilih / Daftar Pemilih', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (445, '276', 'Sarana', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (446, '276.1', 'TPS', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (447, '276.2', 'Kendaraan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (448, '276.3', 'Surat Suara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (449, '276.4', 'Kotak Suara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (450, '276.5', 'Dana', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (451, '277', 'Pemungutan Suara / Perhitungan Suara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (452, '278', 'Penetapan Hasil Pemilu', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (453, '279', 'Penetapan Perolehan Jumlah Kursi Dan Calon Terpilih', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (454, '280', 'Pengucapan Sumpah Janji MPR,DPR,DPD', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (455, '281', '', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (456, '282', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (457, '283', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (458, '284', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (459, '300', 'KEAMANAN / KETERTIBAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (460, '301', 'Keamanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (461, '302', 'Ketertiban', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (462, '303', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (463, '310', 'PERTAHANAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (464, '311', 'Darat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (465, '312', 'Laut', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (466, '313', 'Udara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (467, '314', 'Perbatasan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (468, '315', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (469, '316', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (470, '317', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (471, '320', 'KEMILITERAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (472, '321', 'Latihan Militer', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (473, '322', 'Wajib Militer', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (474, '323', 'Operasi Militer', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (475, '324', 'Kekaryaan TNI Pejabat Sipil dari TNI', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (476, '324.1', 'TMD', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (477, '325', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (478, '326', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (479, '327', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (480, '328', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (481, '330', 'KEAMANAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (482, '331', 'Kepolisian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (483, '331.1', 'Polisi Pamong Praja', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (484, '331.2', 'Kamra', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (485, '331.3', 'Kamling', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (486, '331.4', 'Jaga Wana', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (487, '332', 'Huru-Hara / Demonstrasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (488, '333', 'Senjata Api Tajam', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (489, '334', 'Bahan Peledak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (490, '335', 'Perjudian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (491, '336', 'Surat-Surat Kaleng', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (492, '337', 'Pengaduan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (493, '338', 'Himbauan / Larangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (494, '339', 'Teroris', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (495, '340', 'PERTAHANAN SIPIL', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (496, '341', 'Perlindungan Sipil', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (497, '342', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (498, '343', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (499, '344', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (500, '350', 'KEJAHATAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (501, '351', 'Makar / Pemberontak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (502, '352', 'Pembunuhan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (503, '353', 'Penganiayaan, Pencurian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (504, '354', 'Subversi / Penyelundupan / Narkotika', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (505, '355', 'Pemalsuan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (506, '356', 'Korupsi / Penyelewengan / Penyalahgunaan Jabatan / KKN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (507, '357', 'Pemerkosaan / Perbuatan Cabul', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (508, '358', 'Kenakalan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (509, '359', 'Kejahatan Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (510, '360', 'BENCANA', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (511, '361', 'Gunung Berapi / Gempa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (512, '362', 'Banjir / Tanah Longsor', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (513, '363', 'Angin Topan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (514, '364', 'Kebakaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (515, '364.1', 'Pemadam Kebakaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (516, '365', 'Kekeringan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (517, '366', 'Tsunami', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (518, '367', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (519, '368', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (520, '370', 'KECELAKAAN / SAR', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (521, '371', 'Darat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (522, '372', 'Udara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (523, '373', 'Laut', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (524, '374', 'Sungai / Danau', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (525, '375', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (526, '376', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (527, '377', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (528, '380', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (529, '381', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (530, '382', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (531, '383', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (532, '390', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (533, '391', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (534, '392', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (535, '393', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (536, '400', 'KESEJAHTERAAN RAKYAT', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (537, '401', 'Keluarga Miskin', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (538, '402', 'PNPM Mandiri Pedesaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (539, '403', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (540, '404', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (541, '410', 'PEMBANGUNAN DESA', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (542, '411', 'Pembinaan Usaha Gotong Royong', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (543, '411.1', 'Swadaya Gotong Royong', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (544, '411.11', 'Penataan Gotong Royong', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (545, '411.12', 'Gotong Royong Dinamis', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (546, '411.13', 'Gotong Royong Statis', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (547, '411.14', 'Pungutan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (548, '411.2', 'Lembaga Sosial Desa (LSD)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (549, '411.21', 'Pembinaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (550, '411.22', 'Klasifikasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (551, '411.23', 'Proyek', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (552, '411.24', 'Musyawarah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (553, '411.3', 'Latihan Kerja Masyarakat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (554, '411.31', 'Kader Masyarakat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (555, '411.32', 'Kuliah Kerja Nyata (KKN)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (556, '411.33', 'Pusat Latihan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (557, '411.34', 'Kursus-Kursus', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (558, '411.35', 'Kurikulum / Sylabus', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (559, '411.36', 'Ketrampilan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (560, '411.37', 'Pramuka', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (561, '411.4', 'Pembinaan Kesejahteraan Keluarga (PKK)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (562, '411.41', 'Program', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (563, '411.42', 'Pembinaan Organisasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (564, '411.43', 'Kegiatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (565, '411.5', 'Penyuluhan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (566, '411.51', 'Publikasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (567, '411.52', 'Peragaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (568, '411.53', 'Sosio Drama', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (569, '411.54', 'Siaran Pedesaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (570, '411.55', 'Penyuluhan Lapangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (571, '411.6', 'Kelembagaan Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (572, '411.61', 'Kelompok Tani', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (573, '411.62', 'Rukun Tani', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (574, '411.63', 'Subak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (575, '411.64', 'Dharma Tirta', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (576, '412', 'Perekonomian Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (577, '412.1', 'Produksi Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (578, '412.11', 'Pengolahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (579, '412.12', 'Pemasaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (580, '412.2', 'Keuangan Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (581, '412.21', 'Perkreditan Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (582, '412.22', 'Inventarisasi Data', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (583, '412.23', 'Perkembangan / Pelaksanaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (584, '412.24', 'Bantuan / Stimulans', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (585, '412.25', 'Petunjuk / Pembinaan Pelaksanaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (586, '412.3', 'Koperasi Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (587, '412.31', 'Badan Usaha Unit Desa (BUUD)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (588, '412.32', 'Koperasi Usaha Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (589, '412.4', 'Penataan Bantuan Pembangunan Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (590, '412.41', 'Jumlah Desa Yang Diberi Bantuan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (591, '412.42', 'Pengarahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (592, '412.43', 'Pusat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (593, '412.44', 'Daerah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (594, '412.5', 'Alokasi Bantuan Pembangunan Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (595, '412.51', 'Pusat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (596, '412.52', 'Daerah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (597, '412.6', 'Pelaksanaan Bantuan Pembangunan Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (598, '412.61', 'Bantuan Langsung', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (599, '412.62', 'Bantuan Keserasian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (600, '412.63', 'Bantuan Juara Lomba Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (601, '413', 'Prasarana Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (602, '413.1', 'Prasarana Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (603, '413.11', 'Pembinaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (604, '413.12', 'Bimbingan Teknis', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (605, '413.2', 'Pemukiman Kembali Penduduk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (606, '413.21', 'Lokasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (607, '413.22', 'Diskusi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (608, '413.23', 'Pelaksanaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (609, '413.3', 'Masyarakat Pradesa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (610, '413.31', 'Pembinaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (611, '413.32', 'Penyuluhan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (612, '413.4', 'Pemugaran Perumahan Dan Lingkungan Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (613, '413.41', 'Rumah Sehat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (614, '413.42', 'Proyek Perintis', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (615, '413.43', 'Pelaksanaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (616, '413.44', 'Pengembangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (617, '413.45', 'Perbaikan Kampung', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (618, '414', 'Pengembangan Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (619, '414.1', 'Tingkat Perkembangan Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (620, '414.11', 'Jumlah Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (621, '414.12', 'Pemekaran Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (622, '414.13', 'Pembentukan Desa Baru', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (623, '414.14', 'Evaluasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (624, '414.15', 'Bagan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (625, '414.2', 'Unit Desa Kerja Pembangunan (UDKP)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (626, '414.21', 'Penyuluhan Program', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (627, '414.22', 'Lokasi UDKP', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (628, '414.23', 'Pelaksanaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (629, '414.24', 'Bimbingan/Pembinaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (630, '414.25', 'Evaluasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (631, '414.3', 'Tata Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (632, '414.31', 'Inventarisasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (633, '414.32', 'Penyusunan Pola Tata Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (634, '414.33', 'Aplikasi Tata Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (635, '414.34', 'Pemetaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (636, '414.35', 'Pedoman Pelaksanaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (637, '414.36', 'Evaluasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (638, '414.4', 'Perlombaan Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (639, '414.41', 'Pedoman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (640, '414.42', 'Penilaian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (641, '414.43', 'Kejuaraan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (642, '414.44', 'Piagam', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (643, '415', 'Koordinasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (644, '415.1', 'Sektor Khusus', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (645, '415.2', 'Rapat Koordinasi Horizontal (RKH)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (646, '415.3', 'Tim Koordinasi Pusat (TKP)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (647, '415.4', 'Kerjasama', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (648, '415.41', 'Luar Negeri (UNICEF)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (649, '415.42', 'Perguruan Tinggi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (650, '415.43', 'Kementerian / Lembaga Non Kementerian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (651, '416', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (652, '417', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (653, '418', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (654, '420', 'PENDIDIKAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (655, '420.1', 'Pendidikan Khusus Klasifikasi Disini Pendidikan Putra/I Irja', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (656, '421', 'Sekolah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (657, '421.1', 'Pra Sekolah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (658, '421.2', 'Sekolah Dasar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (659, '421.3', 'Sekolah Menengah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (660, '421.4', 'Sekolah Tinggi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (661, '421.5', 'Sekolah Kejuruan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (662, '421.6', 'Kegiatan Sekolah, Dies Natalis Lustrum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (663, '421.7', 'Kegiatan Pelajar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (664, '421.71', 'Reuni Darmawisata', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (665, '421.72', 'Pelajar Teladan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (666, '421.73', 'Resimen Mahasiswa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (667, '421.8', 'Sekolah Pendidikan Luar Biasa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (668, '421.9', 'Pendidikan Luar Sekolah / Pemberantasan Buta Huruf', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (669, '422', 'Administrasi Sekolah', 'Persyaratan Masuk Sekolah, Testing, Ujian, Pendaftaran,', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (670, '422.1', 'Mapras, Perpeloncoan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (671, '422.2', 'Tahun Pelajaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (672, '422.3', 'Hari Libur', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (673, '422.4', 'Uang Sekolah, Klasifikasi Disini SPP', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (674, '422.5', 'Beasiswa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (675, '423', 'Metode Belajar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (676, '423.1', 'Kuliah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (677, '423.2', 'Ceramah, Simposium', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (678, '423.3', 'Diskusi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (679, '423.4', 'Kuliah Lapangan, Widyawisata, KKN, Studi Tur', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (680, '423.5', 'Kurikulum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (681, '423.6', 'Karya Tulis', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (682, '423.7', 'Ujian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (683, '424', 'Tenaga Pengajar, Guru, Dosen, Dekan, Rektor', 'Klasifikasi Disini: Guru Teladan', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (684, '425', 'Sarana Pendidikan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (685, '425.1', 'Gedung', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (686, '425.11', 'Gedung Sekolah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (687, '425.12', 'Kampus', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (688, '425.13', 'Pusat Kegiatan Mahasiswa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (689, '425.2', 'Buku', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (690, '425.3', 'Perlengkapan Sekolah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (691, '426', 'Keolahragaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (692, '426.1', 'Cabang Olah Raga', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (693, '426.2', 'Sarana', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (694, '426.21', 'Gedung Olah Raga', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (695, '426.22', 'Stadion', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (696, '426.23', 'Lapangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (697, '426.24', 'Kolam renang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (698, '426.3', 'Pesta Olah Raga, ', 'Klasifikasi Disini: PON, Porsade, Olimpiade, dsb', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (699, '426.4', 'KONI', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (700, '427', 'Kepramukaan Meliputi: Organisasi Dan Kegiatan Remaja', 'Klasifikasi Disini: Gelanggang Remaja', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (701, '428', 'Kepramukaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (702, '429', 'Pendidikan  Kedinasan Untuk Depdagri, Lihat 890', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (703, '430', 'KEBUDAYAAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (704, '431', 'Kesenian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (705, '431.1', 'Cabang Kesenian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (706, '431.2', 'Sarana', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (707, '431.21', 'Gedung Kesenian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (708, '432', 'Kepurbakalaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (709, '432.1', 'Museum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (710, '432.2', 'Peninggalan Kuno', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (711, '432.21', 'Candi Termasuk Pemugaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (712, '432.22', 'Benda', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (713, '433', 'Sejarah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (714, '434', 'Bahasa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (715, '435', 'Usaha Pertunjukan, Hiburan, Kesenangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (716, '436', 'Kepercayaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (717, '437', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (718, '438', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (719, '439', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (720, '440', 'KESEHATAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (721, '441', 'Pembinaan Kesehatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (722, '441.1', 'Gizi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (723, '441.2', 'Mata', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (724, '441.3', 'Jiwa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (725, '441.4', 'Kanker', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (726, '441.5', 'Usaha Kegiatan Sekolah (UKS)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (727, '441.6', 'Perawatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (728, '441.7', 'Penyuluhan Kesehatan Masyarakat (PKM)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (729, '441.8', 'Pekan Imunisasi Nasional', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (730, '442', 'Obat-obatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (731, '442.1', 'Pengadaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (732, '442.2', 'Penyimpanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (733, '443', 'Penyakit Menular', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (734, '443.1', 'Pencegahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (735, '443.2', 'Pemberantasan dan Pencegahan Penyakit Menular Langsung (P2ML)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (736, '443.21', 'Kusta', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (737, '443.22', 'Kelamin', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (738, '443.23', 'Frambosia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (739, '443.24', 'TBC / AIDS / HIV', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (740, '443.3', 'Epidemiologi dan Karantina (Epidka)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (741, '443.31', 'Kholera', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (742, '443.32', 'Imunisasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (743, '443.33', 'Survailense', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (744, '443.34', 'Rabies (Anjing Gila) Antraks', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (745, '443.4', 'Pemberantasan & Pencegahan Penyakit Menular Sumber Binatang (P2B)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (746, '443.41', 'Malaria', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (747, '443.42', 'Dengue Faemorrhagic Fever (Demam Berdarah HDF)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (748, '443.43', 'Filaria', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (749, '443.44', 'Serangga', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (750, '443.5', 'Hygiene Sanitasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (751, '443.51', 'Tempat-tempat Pembuatan Dan Penjualan Makanan dan Minuman (TPPMM)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (752, '443.52', 'Sarana Air Minum Dan Jamban Keluarga (Samijaga)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (753, '443.53', 'Pestisida', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (754, '444', 'Gizi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (755, '444.1', ' Kekurangan Makanan Bahaya Kelaparan, Busung Lapar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (756, '444.2', 'Keracunan Makanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (757, '444.3', 'Menu Makanan Rakyat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (758, '444.4', 'Badan Perbaikan Gizi Daerah (BPGD)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (759, '444.5', 'Program Makanan Tambahn Anak Sekolah (PMT-AS)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (760, '445', 'Rumah Sakit, Balai Kesehatan, PUSKESMAS, PUSKESMAS, Keliling, Poliklinik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (761, '446', 'Tenaga Medis', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (762, '448', 'Pengobatan Tadisional', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (763, '448.1', 'Pijat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (764, '448.2', 'Tusuk Jarum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (765, '448.3', 'Jamu Tradisional', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (766, '448.4', 'Dukun / Paranormal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (767, '450', 'AGAMA', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (768, '451', 'Islam', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (769, '451.1', 'Peribadatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (770, '451.11', 'Sholat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (771, '451.12', 'Zakat Fitrah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (772, '451.13', 'Puasa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (773, '451.14', 'MTQ', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (774, '451.2', 'Rumah Ibadah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (775, '451.3', 'Tokoh Agama', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (776, '451.4', 'Pendidikan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (777, '451.41', 'Tinggi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (778, '451.42', 'Menengah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (779, '451.43', 'Dasar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (780, '451.44', 'Pondok Pesantren', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (781, '451.45', 'Gedung Sekolah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (782, '451.46', 'Tenaga Pengajar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (783, '451.47', 'Buku', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (784, '451.48', 'Dakwah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (785, '451.49', 'Organisasi / Lembaga Pendidikan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (786, '451.5', 'Harta Agama Wakaf, Baitulmal, dsb', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (787, '451.6', 'Peradilan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (788, '451.7', 'Organisasi Keagamaan Bukan Politik Majelis Ulama', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (789, '451.8', 'Mazhab', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (790, '452', 'Protestan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (791, '452.1', 'Peribadatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (792, '452.2', 'Rumah Ibadah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (793, '452.3', 'Tokoh Agama, Rohaniawan, Pendeta, Domine', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (794, '452.4', 'Mazhab', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (795, '452.5', 'Organisasi Gerejani', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (796, '453', 'Katolik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (797, '453.1', 'Peribadatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (798, '453.2', 'Rumah Ibadah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (799, '453.3', 'Tokoh Agama, Rohaniawan, Pendeta, Pastor', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (800, '453.4', 'Mazhab', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (801, '453.5', 'Organisasi Gerejani', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (802, '454', 'Hindu', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (803, '454.1', 'Peribadatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (804, '454.2', 'Rumah Ibadah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (805, '454.3', 'Tokoh Agama, Rohaniawan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (806, '454.4', 'Mazhab', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (807, '454.5', 'Organisasi Keagamaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (808, '455', 'Budha', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (809, '455.1', 'Peribadatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (810, '455.2', 'Rumah Ibadah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (811, '455.3', 'Tokoh Agama, Rohaniawan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (812, '455.4', 'Mazhab', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (813, '455.5', 'Organisasi Keagamaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (814, '456', 'Urusan Haji', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (815, '456.1', 'ONH', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (816, '456.2', 'Manasik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (817, '457', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (818, '458', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (819, '458', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (820, '460', 'SOSIAL', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (821, '461', 'Rehabilitasi Penderita Cacat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (822, '461.1', 'Cacat Maat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (823, '461.2', 'Cacat Tubuh', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (824, '461.3', 'Cacat Mental', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (825, '461.4', 'Bisul/Tuli', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (826, '462', 'Tuna Sosial', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (827, '462.1', 'Gelandangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (828, '462.2', 'Pengemis', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (829, '462.3', 'Tuna Susila', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (830, '462.4', 'Anak Nakal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (831, '463', 'Kesejahteraan Anak / Keluarga', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (832, '463.1', 'Anak Putus Sekolah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (833, '463.2', 'Ibu Teladan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (834, '463.3', 'Anak Asuh', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (835, '464', 'Pembinaan Pahlawan', 'Pahlawan Meliputi: Penghargaan Kepada Pahlawan,', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (836, '464.1', 'Tunjangan Kepada Pahlawan Dan Jandanya', 'Perintis Kemerdekaan Meliputi: Pembinaan, Penghargaan', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (837, '464.2', 'Dan Tunjangan Kepada Perintis', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (838, '464.3', 'Cacat Veteran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (839, '465', 'Kesejahteraan Sosial', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (840, '465.1', 'Lanjut Usia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (841, '465.2', 'Korban Kekacauan, Pengungsi, Repatriasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (842, '466', 'Sumbangan Sosial', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (843, '466.1', 'Korban Bencana', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (844, '466.2', 'Pencarian Dana Untuk Sumbangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (845, '466.3', 'Meliputi: Penyelenggaraan Undian, Ketangkasan, Bazar, dsb', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (846, '466.4', 'Panti Asuhan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (847, '466.5', 'Panti Jompo', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (848, '467', ' Bimbingan Sosial', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (849, '467.1', 'Masyarakat Suku Terasing Meliputi: Bimbingan, Pendidikan, Kesehatan, Pemukiman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (850, '468', 'PMI', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (851, '469', 'Makam', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (852, '469.1', 'Umum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (853, '469.2', 'Pahlawan Meliputi: Penghargaan Kepada Pahlawan, Tunjangan Kpd Pahlawan Dan Jandanya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (854, '469.3', 'Khusus Keluarga Raja', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (855, '469.4', 'Krematorium', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (856, '470', 'KEPENDUDUKAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (857, '471', 'Pendaftaran Penduduk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (858, '471.1', 'Identitas Penduduk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (859, '471.11', 'Biodata', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (860, '471.12', 'Nomor Induk Kependudukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (861, '471.13', 'Kartu Tanda Penduduk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (862, '471.14', 'Kartu Keluarga', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (863, '471.15', 'Advokasi Indentitas Penduduk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (864, '471.2', 'Perpindahan Penduduk Dalam Wilayah Indonesia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (865, '471.21', 'Perpindahan Penduduk WNI', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (866, '471.22', 'Perpindahan Penduduk WNA Dalam Wilayah Indonesia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (867, '471.23', 'Perpindahan Penduduk WNA dan WNI Tinggal Sementara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (868, '471.24', 'Daerah Terbelakan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (869, '471.25', 'Bedol Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (870, '471.3', 'Perpindahan Penduduk Antar Negara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (871, '471.31', 'Penduduk Indonesia Ke Luar Negeri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (872, '471.32', 'Orang Asing Tinggal Sementara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (873, '471.33', 'Orang Asing Tinggal Tetap', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (874, '471.34', 'Perpindahan Penduduk Antar Negara Di Wilayah Pembatasan Antar Negara (Pelintas Batas Tradisional)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (875, '471.4', 'Pendaftaran Pengungsi Dan Penduduk Rentan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (876, '471.41', 'Akibat Bencana Alam', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (877, '471.42', 'Akibat Kerusuhan Sosial', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (878, '471.43', 'Pendaftaran Penduduk Daerah Terbelakang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (879, '471.44', 'Pendaftaran Penduduk Rentan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (880, '472', 'Pencatatan Sipil', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (881, '472.1', 'Kelahiran, Kematian Dan Advokasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (882, '472.11', 'Kelahiran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (883, '472.12', 'Kematian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (884, '472.13', 'Advokasi Kelahiran Dan Kematian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (885, '472.2', 'Perkawinan, Peceraian Dan Advokasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (886, '472.3', 'Perkawinan Agama Islam', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (887, '472.4', 'Perkawinan Agama Non Islam', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (888, '472.5', 'Perceraian Agama Islam', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (889, '472.6', 'Perceraian Agama Non Islam', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (890, '472.7', 'Advokasi Perkawinan Dan Perceraian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (891, '472.3', 'Pengangkatan, Pengakuan, Dan Pengesahan Anak Serta Perubahan Dan Pembatalan Akta Dan Advokasi Pengangkatan Anak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (892, '472.31', 'Pengangkatan Anak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (893, '472.32', 'Pengakuan Anak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (894, '472.33', 'Pengesahan Anak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (895, '472.34', 'Perubahan Anak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (896, '472.35', 'Pembatalan Anak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (897, '472.36', 'Advokasi Pengurusan Pengangkatan, Pengakuan Dan Pengesahan Anak Serta Perubahan Dan Pembatalan Akta', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (898, '472.4', 'Pencatatan Kewarganegaraan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (899, '472.41', 'Akibat Perkawinan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (900, '472.42', 'Akibat Kelahiran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (901, '472.43', 'Non Perkawinan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (902, '472.44', 'Non Kelahiran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (903, '472.45', 'Perubahan WNI ke WNA', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (904, '473', 'Informasi Kependudukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (905, '473.1', 'Teknologi Informasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (906, '473.11', 'Perangkat Keras', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (907, '473.12', 'Perangkat Lunak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (908, '473.13', 'Jaringan Komunikasi Data', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (909, '473.2', 'Kelembagaan Dan Sumber Daya Informasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (910, '473.21', 'Daerah Maju', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (911, '473.22', 'Daerah Berkembang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (912, '473.23', 'Daerah Terbelakang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (913, '473.3', 'Pengolahan Data Kependudukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (914, '473.31', 'Pendaftaran Penduduk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (915, '473.32', 'Kejadian Vital Penduduk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (916, '473.33', 'Penduduk Non Registrasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (917, '473.4', 'Pelayanan Informasi Kependudukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (918, '473.41', 'Media Elektronik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (919, '473.42', 'Media Cetak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (920, '473.43', 'Outlet', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (921, '474', 'Perkembangan Penduduk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (922, '474.1', 'Pengarahan Kuantitas Penduduk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (923, '474.11', 'Struktur Jumlah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (924, '474.12', 'Komposisi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (925, '474.13', 'Fertilitas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (926, '474.14', 'Kesehatan Reproduksi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (927, '474.15', 'Morbiditas Penduduk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (928, '474.16', 'Mortalitas Penduduk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (929, '474.2', 'Pengembangan Kuantitas Penduduk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (930, '474.21', 'Anak dan Remaja', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (931, '474.22', 'Penduduk Usia Produktif', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (932, '474.23', 'Penduduk Lanjut Usia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (933, '474.24', 'Gender', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (934, '474.3', 'Penataan Persebaran Penduduk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (935, '474.31', 'Migrasi Antar Wilayah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (936, '474.32', 'Migrasi Internasional', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (937, '474.33', 'Urbanisasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (938, '474.34', 'Sementara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (939, '474.35', 'Migrasi Non Permanen', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (940, '474.4', 'Perlindungan Pemberdayaan Penduduk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (941, '474.41', 'Pengembangan Sistem Pelindungan Penduduk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (942, '474.42', 'Pelayanan Kelembagaan Ekonomi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (943, '474.43', 'Pelayanan Kelembagaan Sosial Budaya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (944, '474.44', 'Partisipasi Masyarakat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (945, '474.5', 'Pengembangan Wawasan Kependudukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (946, '474.51', 'Pendidikan Jalur Sekolah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (947, '474.52', 'Pendidikan Jalur Luar Sekolah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (948, '474.53', 'Pendidikan Jalur Masyarakat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (949, '474.54', 'Pembangunan Berwawasan Kependudukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (950, '475', 'Proyeksi Dan Penyerasian Kebijakan Kependudukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (951, '475.1', 'Indikator Kependudukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (952, '475.11', 'Perumusan Penetapan Dan Pengembangan Indikator Kependudukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (953, '475.12', 'Pemanfaatan Indikator Kependudukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (954, '475.13', 'Sosialisasi Indikator Kependudukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (955, '475.2', 'Proyeksi Kependudukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (956, '475.21', 'Penyusunan Dan Pengembangan Proyeksi Kependudukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (957, '475.22', 'Pemanfaatan Proyeksi Kependudukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (958, '475.3', 'Analisis Dampak Kependudukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (959, '475.31', 'Penyusunan Dan Pengembangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (960, '475.32', 'Pemanfaatan Analisis Dampak Kependudukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (961, '475.4', 'Penyerasian Kebijakan Lembaga Non Pemerintah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (962, '475.41', 'Lembaga Internasioanal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (963, '475.42', 'Lembaga Masyarakat Dan Nirlaba', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (964, '475.43', 'Lembaga Usaha Swasta', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (965, '475.5', 'Penyerasian Kebijakan Lembaga Pemerintah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (966, '475.51', 'Lembaga Pemerintah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (967, '475.52', 'Pemerintah Provinsidan Kota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (968, '475.53', 'Pemerintah Kabupaten', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (969, '475.6', 'Analisis', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (970, '476', 'Monitoring', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (971, '477', 'Evaluasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (972, '478', 'Dokumentasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (973, '479', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (974, '480', 'MEDIA MASSA', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (975, '481', 'Penerbitan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (976, '481.1', 'Surat Kabar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (977, '481.2', 'Majalah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (978, '481.3', 'Buku', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (979, '481.4', 'Penerjemahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (980, '482', 'Radio', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (981, '482.1', 'RRI', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (982, '482.11', 'Siaran Pedesaan Jgn Diklasifikasikan Disini', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (983, '482.2', 'Non RRI', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (984, '482.3', 'Luar Negeri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (985, '483', 'Televisi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (986, '484', 'Film', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (987, '485', 'Pers', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (988, '485.1', 'Kewartawanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (989, '485.2', 'Wawancara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (990, '485.3', 'Informasi Nasional', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (991, '486', 'Grafika', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (992, '487', 'Penerangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (993, '487.1', 'Pameran Non Komersil', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (994, '488', 'Operation Room', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (995, '489', 'Hubungan Masyarakat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (996, '490', 'Pengaduan Masyarakat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (997, '491', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (998, '492', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (999, '500', 'PEREKONOMIAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1000, '500.1', 'Dewan Stabilisasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1001, '501', 'Pengadaan Pangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1002, '502', 'Pengadaan Sandang Perizinan Pada Umumnya Untuk Perizinan Suatu Bidang,', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1003, '503', 'Kalsifikasikan Masalahnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1004, '504', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1005, '505', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1006, '506', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1007, '510', 'PERDAGANGAN', 'Klasifikasikan Disini: Tata Niaga', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1008, '510.1', 'Promosi Perdagangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1009, '510.11', 'Pekan Raya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1010, '510.12', 'Iklan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1011, '510.13', 'Pameran Non Komersil', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1012, '510.2', 'Pelelangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1013, '510.3', 'Tera', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1014, '511', 'Pemasaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1015, '511.1', 'Sembilan Bahan Pokok, Tambahkan Kode Wilayah : Beras, Garam, Tanah, Minyak Goreng', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1016, '511.2', 'Pasar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1017, '511.3', 'Pertokoan, Kaki Lima, Kios', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1018, '512', 'Ekspor', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1019, '513', 'Impor', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1020, '514', 'Perdagangan Antar Pulau', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1021, '515', 'Perdagangan Luar Negeri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1022, '516', 'Pergudangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1023, '517', 'Aneka Usaha Perdagangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1024, '518', 'Koperasi untuk BUUD, KUD lihat ( 412.31-412.32)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1025, '519', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1026, '520', 'PERTANIAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1027, '521', 'Tanaman Pangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1028, '521.1', 'Program', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1029, '521.11', 'Bimas / Inmas Termasuk Kredit', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1030, '521.12', 'Penyuluhan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1031, '521.2', 'Produksi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1032, '521.21', 'Padi / Panen', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1033, '521.22', 'Palawija', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1034, '521.23', 'Jagung', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1035, '521.24', 'Ketela Pohon / Ubi-Ubian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1036, '521.25', 'Hortikultura', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1037, '521.26', 'Sayuran / Buah-Buahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1038, '521.27', 'Tanaman Hias', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1039, '521.28', 'Pembudidayaan Rumput Laut', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1040, '521.3', 'Saran Usaha Pertanian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1041, '521.31', 'Peralatan Meliputi: Traktor Dan Peralatan Lainya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1042, '521.32', 'Pembibitan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1043, '521.33', 'Pupuk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1044, '521.4', 'Perlindungan Tanaman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1045, '521.41', 'Penyakit, Penyakit Daun, Penyakit Batang Hama, Serangga, Wereng, Walang Sangit, Tungru, Tikus Dan Sejenisnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1046, '521.42', 'Pemberantasan Hama Meliputi: Penyemprotan, Penyiangan, Geropyokan, Sparayer,', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1047, '521.43', 'Pemberantasan Melalui Udara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1048, '521.44', 'Pestisida', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1049, '521.5', 'Tanah Pertanian Pangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1050, '521.51', 'Persawahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1051, '521.52', 'Perladangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1052, '521.53', 'Kebun', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1053, '521.54', 'Rumpun Ikan Laut', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1054, '521.55', 'KTA/Lahan Kritis', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1055, '521.6', 'Pengusaha Petani', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1056, '521.7', 'Bina Usaha', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1057, '521.71', 'Pasca Panen', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1058, '521.72', 'Pemasaran Hasil', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1059, '522', 'Kehutanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1060, '522.1', 'Program', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1061, '522.11', 'Hak Pengusahaan Hutan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1062, '522.12', 'Tata Guna Hutan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1063, '522.13', 'Perpetaan Hutan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1064, '522.14', 'Tumpangsari', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1065, '522.2', 'Produksi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1066, '522.21', 'Kayu', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1067, '522.22', 'Non Kayu', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1068, '522.3', 'Sarana  Usaha  Kehutanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1069, '522.4', 'Penghijauan, Reboisasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1070, '522.5', 'Kelestarian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1071, '522.51', 'Cagar Alam, Marga Satwa, Suaka Marga Satwa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1072, '522.52', 'Berburu Meliputi Larangan Dan Ijin Berburu', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1073, '522.53', 'Kebun Binatang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1074, '522.54', 'Konservasi Lahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1075, '522.6', 'Penyakit/Hama', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1076, '522.7', 'Jenis-jenis Hutan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1077, '522.71', 'Hutan Hidup', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1078, '522.72', 'Hutan Wisata', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1079, '522.73', 'Hutan Produksi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1080, '522.74', 'Hutan Lindung', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1081, '523', 'Perikanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1082, '523.1', 'Program', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1083, '523.11', 'Penyuluhan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1084, '523.12', 'Teknologi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1085, '523.2', 'Produksi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1086, '523.21', 'Pelelangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1087, '523.3', 'Usaha Perikanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1088, '523.31', 'Pembibitan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1089, '523.32', 'Daerah Penagkapan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1090, '523.33', 'Pertambakan Meliputi: ( Tambak Ikan Air Deras, Tambak Udang dll )', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1091, '523.34', 'Jaring Terapung', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1092, '523.4', 'Sarana', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1093, '523.41', 'Peralatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1094, '523.42', 'Kapal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1095, '523.43', 'Pelabuhan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1096, '523.5', 'Pengusaha', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1097, '523.6', 'Nelayan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1098, '524', 'Peternakan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1099, '524.1', 'Produksi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1100, '524.11', 'Susu Ternak Rakyat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1101, '524.12', 'Telur', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1102, '524.13', 'Daging', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1103, '524.14', 'Kulit', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1104, '524.2', 'Sarana Usaha Ternak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1105, '524.21', 'Pembibitan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1106, '524.22', 'Kandang Ternak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1107, '524.3', 'Kesehatan Hewan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1108, '524.31', 'Penyakit Hewan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1109, '524.32', 'Pos Kesehatan Hewan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1110, '524.33', 'Tesi Pullorum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1111, '524.34', 'Karantina', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1112, '524.35', 'Pemberantasan Penyakit Hewan Termasuk Usaha Pencegahannya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1113, '524.4', 'Perunggasan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1114, '524.5', 'Pengembangan Ternak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1115, '524.51', 'Inseminasi Buatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1116, '524.52', 'Pembibitan / Bibit Unggul', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1117, '524.53', 'Penyebaran Ternak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1118, '524.6', 'Makanan Ternak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1119, '524.7', 'Tempat Pemotongan Hewan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1120, '524.8', 'Data Peternakan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1121, '525', 'Perkebunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1122, '525.1', 'Program', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1123, '525.2', 'Produksi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1124, '525.21', 'Karet', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1125, '525.22', 'The', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1126, '525.23', 'Tembakau', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1127, '525.24', 'Tebu', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1128, '525.25', 'Cengkeh', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1129, '525.26', 'Kopra', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1130, '525.27', 'Kopi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1131, '525.28', 'Coklat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1132, '525.29', 'Aneka Tanaman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1133, '526', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1134, '527', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1135, '528', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1136, '530', 'PERINDUSTRIAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1137, '530.08', 'Undang-Undang Gangguan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1138, '531', 'Industri Logam', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1139, '532', 'Industri Mesin/Elektronik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1140, '533', 'Industri Kimia/Farmasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1141, '534', 'Industri Tekstil', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1142, '535', 'Industri Makanan / Minuman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1143, '536', 'Aneka Industri / Perusahaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1144, '537', 'Aneka Kerajinan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1145, '538', 'Usaha Negara / BUMN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1146, '538.1', 'Perjan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1147, '538.2', 'Perum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1148, '538.3', 'Persero / PT, CV', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1149, '539', 'Perusahaan Daerah / BUMD/BULD', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1150, '540', 'PERTAMBANGAN / KESAMUDRAAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1151, '541', 'Minyak Bumi / Bensin', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1152, '541.1', 'Pengusahaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1153, '542', 'Gas bumi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1154, '542.1', 'Eksploitasi / Pengeboran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1155, '542.11', 'Kontrak Kerja', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1156, '542.2', 'Penogolahan,', 'Meliputi :Tangki, Pompa, Tanker', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1157, '543', 'Aneka Tambang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1158, '543.1', 'Timah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1159, '543.2', 'Alumunium, Boxit', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1160, '543.3', 'Besi Termasuk Besi Tua', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1161, '543.4', 'Tembaga', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1162, '543.5', 'Batu Bara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1163, '544', 'Logam Mulia,Emas,Intan,Perak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1164, '545', 'Logam', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1165, '546', 'Geologi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1166, '546.1', 'Vulkanologi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1167, '546.11', 'Pengawasan Gunung Berapi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1168, '546.2', 'Sumur Artesis, Air Bawah Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1169, '547', 'Hidrologi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1170, '548', 'Kesamudraan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1171, '549', 'Pesisir Pantai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1172, '550', 'PERHUBUNGAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1173, '551', 'Perhubungan Darat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1174, '551.1', 'Lalu Lintas Jalan Raya, Sungai, Danau', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1175, '551.11', 'Keamanan Lalu Lintas, Rambu-Rambu', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1176, '551.2', 'Angkutan Jalan Raya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1177, '551.21', 'Perizinan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1178, '551.22', 'Terminal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1179, '551.23', 'Alat Angkutan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1180, '551.3', 'Angkutan Sungai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1181, '551.31', 'Perizinan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1182, '551.32', 'Terminal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1183, '551.33', 'Pelabuhan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1184, '551.4', 'Angkutan Danau', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1185, '551.41', 'Perizinan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1186, '551.42', 'Terminal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1187, '551.43', 'Pelabuhan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1188, '551.5', 'Feri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1189, '551.51', 'Perizinan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1190, '551.52', 'Terminal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1191, '551.53', 'Pelabuhan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1192, '551.6', 'Perkereta-Apian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1193, '552', 'Perhubungan Laut', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1194, '552.1', 'Lalu Lintas Angkutan Laut, Pelayanan Umum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1195, '552.11', 'Keamanan Lalu Lintas, Rambu-Rambu', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1196, '552.12', 'Pelayaran Dalam Negeri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1197, '552.13', 'Pelayaran Luar Negeri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1198, '552.2', 'Perkapalan Alat Angkutan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1199, '552.3', 'Pelabuhan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1200, '552.4', 'Pengerukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1201, '552.5', 'Penjagaan Pantai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1202, '553', 'Perhubungan Udara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1203, '553.1', 'Lalu Lintas Udara / Keamanan Lalu Lintas Udara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1204, '553.2', 'Pelabuhan Udara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1205, '553.3', 'Alat Angkutan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1206, '554', 'Pos', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1207, '555', 'Telekomunikasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1208, '555.1', 'Telepon', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1209, '555.2', 'Telegram', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1210, '555.3', 'Telex / SSB, Faximile', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1211, '555.4', 'Satelit, Internet', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1212, '555.5', 'Stasiun Bumi, Parabola', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1213, '556', 'Pariwisata dan Rekreasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1214, '556.1', 'Obyek Kepariwisataan Taman Mini Indonesia Indah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1215, '556.2', 'Perhotelan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1216, '556.3', 'Travel service', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1217, '556.4', 'Tempat Rekreasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1218, '557', 'Meteorologi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1219, '557.1', 'Ramalan Cuaca', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1220, '557.2', 'Curah Hujan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1221, '557.3', 'Kemarau Panjang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1222, '558', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1223, '559', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1224, '560', 'TENAGA KERJA', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1225, '560.1', 'Pengangguran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1226, '561', 'Upah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1227, '562', 'Penempatan Tenaga Kerja, TKI', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1228, '563', 'Latihan Kerja', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1229, '564', 'Tenaga Kerja', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1230, '564.1', 'Butsi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1231, '564.2', 'Padat Karya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1232, '565', 'Perselisihan Perburuhan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1233, '566', 'Keselamatan Kerja', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1234, '567', 'Pemutusan Hubungan Kerja', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1235, '568', 'kesejahteraan Buruh', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1236, '569', 'Tenaga Orang Asing', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1237, '570', 'PERMODALAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1238, '571', 'Modal Domestik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1239, '572', 'Modal Asing', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1240, '573', 'Modal Patungan (Joint Venture) / Penyertaan Modal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1241, '574', 'Pasar Uang Dan Modal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1242, '575', 'Saham', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1243, '576', 'Belanja Modal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1244, '577', 'Modal Daerah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1245, '580', 'PERBANKAN / MONETER', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1246, '581', 'Kredit', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1247, '582', 'Investasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1248, '583', 'Pembukaan ,Perubahan,Penutupan Rekening, Deposito', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1249, '584', 'Bank Pembangunan Daerah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1250, '585', 'Asuransi Dana Kecelakaan Lalu Lintas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1251, '586', 'Alat Pembayaran, Cek, Giro, Wesel, Transfer', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1252, '587', 'Fiskal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1253, '588', 'Hutang Negara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1254, '589', 'Moneter', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1255, '590', 'AGRARIA', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1256, '591', 'Tataguna Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1257, '591.1', 'Pemetaan dan Pengukuran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1258, '591.2', 'Perpetaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1259, '591.3', 'penyediaan Data', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1260, '591.4', 'Fatwa Tata Guna Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1261, '591.5', 'Tanah Kritis', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1262, '592', 'Landreform', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1263, '592.1', 'Redistribusi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1264, '592.11', 'Pendaftaran Pemilikan Dan Pengurusan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1265, '592.12', 'Penentuan Tanah Obyek Landreform', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1266, '592.13', 'Pembagian Tanah Obyek Landreform', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1267, '592.14', 'Sengketa Redistribusi Tanah Obyek Landreform', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1268, '592.2', 'Ganti Rugi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1269, '592.21', 'Ganti Rugi Tanah Kelebihan', 'Meliputi : Sengketa Ganti Rugi Tanah Kelebihan Tanah', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1270, '592.22', 'Ganti Rugi Tanah Absentee', 'Meliputi : Sengketa Ganti Rugi Tanah Absentee', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1271, '592.23', 'Ganti Rugi Tanah Partikelir', 'Meliputi : Sengketa Ganti Rugi Tanah Partikelir', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1272, '592.3', 'Bagi Hasil', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1273, '592.31', 'Penetapan Imbangan Bagi Hasil', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1274, '592.32', 'Pelaksanaan Perjanjian Bagi Hasil', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1275, '592.33', 'Sengketa Perjanjian Bagi Hasil', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1276, '592.4', 'Gadai Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1277, '592.41', 'Pendaftaran Pemilikan Dan Pengurusan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1278, '592.42', 'Pelaksanaan Gadai Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1279, '592.43', 'Sengketa Gadai Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1280, '592.5', 'Bimbingan dan Penyuluhan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1281, '592.6', 'Pengembangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1282, '592.7', 'Yayasan Dana Landreform', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1283, '593', 'Pengurusan Hak-Hak Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1284, '593.01', 'Penyusunan Program Dan Bimbingan Teknis', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1285, '593.1', 'Sewa Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1286, '593.11', 'Sewa Tanah Untuk Tanaman Tertentu, Tebu, Tembakau, Rosela, Chorcorus', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1287, '593.2', 'Hak Milik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1288, '593.21', 'Perorangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1289, '593.22', 'Badan Hukum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1290, '593.3', 'Hak Pakai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1291, '593.31', 'Perorangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1292, '593.311', 'Warga Negara Indonesia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1293, '593.312', 'Warga Negara Asing', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1294, '593.32', 'Badan Hukum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1295, '593.321', 'Badan Hukum Indonesia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1296, '593.322', 'Badan Hukum Asing, Kedutaan, Konsulat Kantor Dagang Asing', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1297, '593.33', 'Tanah Gedung-Gedung Negara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1298, '593.4', 'Guna Usaha', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1299, '593.41', 'Perkebunan Besar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1300, '593.42', 'Perkebunan Rakyat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1301, '593.43', 'Peternakan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1302, '593.44', 'Perikanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1303, '593.45', 'Kehutanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1304, '593.5', 'Hak Guna Bangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1305, '593.51', 'Perorangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1306, '593.52', 'Badan Hukum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1307, '593.53', 'P3MB (Panitia Pelaksana Penguasaan Milik Belanda)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1308, '593.54', 'Badan Hukum Asing Belanda-Prrk No 5165', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1309, '593.55', 'Pemulihan Hak (Pen Pres 4/1960)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1310, '593.6', 'Hak Pengelolaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1311, '593.61', 'PN Perumnas, Bonded Ware House, Industrial Estate, Real Estate', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1312, '593.62', 'Perusahaan Daerah Pembangunan Perumahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1313, '593.7', 'Sengketa Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1314, '593.71', 'Peradilan Perkara Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1315, '593.8', 'Pencabutan dan Pembebasan Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1316, '593.81', 'Pencabutan Hak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1317, '593.82', 'Pembebasan Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1318, '593.83', 'Ganti Rugi Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1319, '594', 'Pendaftaran Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1320, '594.1', 'Pengukuran / Pemetaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1321, '594.11', 'Fotogrametri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1322, '594.12', 'Terristris', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1323, '594.13', 'Triangulasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1324, '594.14', 'Peralatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1325, '594.2', 'Dana Pengukuran (Permen Agraria No. 61/1965)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1326, '594.3', 'Sertifikat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1327, '594.4', 'Pejabat Pembuat Akta Tanah (PPAT)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1328, '595', 'Lahan Transmigrasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1329, '595.1', 'Tataguna Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1330, '595.2', 'Landreform', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1331, '595.3', 'Pengurusan Hak-Hak Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1332, '595.4', 'Pendaftaran Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1333, '596', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1334, '597', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1335, '598', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1336, '599', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1337, '600', 'PEKERJAAN UMUM DAN KETENAGAKERJAAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1338, '601', 'Tata Bangunan Konstruksi Dan Industri Konstruksi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1339, '602', 'Kontraktor Pemborong', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1340, '602.1', 'Tender', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1341, '602.2', 'Pennunjukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1342, '602.3', 'Prakualifikasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1343, '602.31', 'Daftar Rekanan Mampu (DRM)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1344, '602.32', 'Tanda Daftar Rekanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1345, '603', 'Arsitektur', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1346, '604', 'Bahan Bangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1347, '604.1', 'Tanah Dan Batu Seperti: Batu Belah, Steen Slaag, Split dsb', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1348, '604.2', 'Aspal, Aspal Buatan, Aspal Alam (butas)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1349, '604.3', 'Besi Dan Logam Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1350, '604.31', 'Besi Beton', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1351, '604.32', 'Besi Profil', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1352, '604.33', 'Paku', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1353, '604.34', 'Alumunium, Profil', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1354, '604.4', 'Bahan-Bahan Pelindung Dan Pengawet ', '(Cat, Tech Til, Pengawet Kayu)', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1355, '604.5', 'Semen', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1356, '604.6', 'Kayu', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1357, '604.7', 'Bahan Penutup Atap ', '(Genting, Asbes Gelombang, Seng Dan Sebagainya)', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1358, '604.8', 'Alat-Alat Penggantung Dan Pengunci', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1359, '604.9', 'Bahan-Bahan Bangunan Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1360, '605', 'Instalasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1361, '605.1', 'Instalasi Bangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1362, '605.2', 'Instalasi Listrik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1363, '605.3', 'Instalasi Air Sanitasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1364, '605.4', 'Instalasi Pengatur Udara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1365, '605.5', 'Instalasi Akustik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1366, '605.6', 'Instalasi Cahaya / Penerangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1367, '606', 'Konstruksi Pencegahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1368, '606.1', 'Konstruksi Pencegahan Terhadap Kebakaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1369, '606.2', 'Konstruksi Pencegahan Terhadap Gempa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1370, '606.3', 'Konstruksi Penegahan Terhadap Angin Udara/Panas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1371, '606.4', 'Konstruksi Pencegahan Terhadap Kegaduhan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1372, '606.5', 'Konstruksi Pencegahan Terhadap Gas/Explosive', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1373, '606.6', 'Konstruksi Pencegahan Terhadap Serangga', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1374, '606.7', 'Konstruksi Pencegahan Terhadap Radiasi Atom', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1375, '607', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1376, '608', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1377, '609', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1378, '610', 'PENGAIRAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1379, '611', 'Irigasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1380, '611.1', 'Bangunan Waduk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1381, '611.11', 'Bendungan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1382, '611.12', 'Tanggul', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1383, '611.13', 'Pelimpahan Banjir', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1384, '611.14', 'Menara Pengambilan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1385, '611.2', 'Bangunan Pengambilan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1386, '611.21', 'Bendungan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1387, '611.22', 'Bendungan Dengan Pintu Bilas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1388, '611.23', 'Bendungan Dengan Pompa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1389, '611.24', 'Pengambilan Bebas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1390, '611.25', 'Pengambilan Bebas Dengan Pompa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1391, '611.26', 'Sumur Dengan Pompa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1392, '611.27', 'Kantung Lumpur', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1393, '611.28', 'Slit Ekstrator', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1394, '611.29', 'Escope Channel', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1395, '611.3', 'Bangunan Pembawa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1396, '611.31', 'Saluran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1397, '611.311', 'Saluran Induk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1398, '611.312', 'Saluran Sekunder', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1399, '611.313', 'Suplesi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1400, '611.314', 'Tersier', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1401, '611.315', 'Saluran Kwarter', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1402, '611.316', 'Saluran Pasangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1403, '611.317', 'Saluran Tertutup / Terowongan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1404, '611.32', 'Bangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1405, '611.321', 'Bangunan Bagi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1406, '611.322', 'Bangunan Bagi Dan Sadap', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1407, '611.323', 'Bangunan Sadap', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1408, '611.324', 'Bangunan Check', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1409, '611.325', 'Bangunan Terjun', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1410, '611.33', 'Box Tersier', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1411, '611.34', 'Got Miring', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1412, '611.35', 'Talang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1413, '611.36', 'Syphon', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1414, '611.37', 'Gorong-Gorong', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1415, '611.38', 'Pelimpah Samping', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1416, '611.4', 'Bangunan Pembuang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1417, '611.41', 'Saluran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1418, '611.411', 'Saluran Pembuang Induk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1419, '611.412', 'Saluran Pembuang Sekunder', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1420, '611.413', 'Saluran Tersier', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1421, '611.42', 'Bangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1422, '611.421', 'Bangunan Outlet', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1423, '611.422', 'Bangunan Terjun', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1424, '611.423', 'Bangunan Penahan Banjir', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1425, '611.43', 'Gorong-Gorong Pembuang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1426, '611.44', 'Talang Pembuang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1427, '611.45', 'Syphon Pembuang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1428, '611.5', 'Bangunan Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1429, '611.51', 'Jalan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1430, '611.511', 'Jalan Inspeksi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1431, '611.512', 'Jalan Logistik Waduk Lapangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1432, '611.52', 'Jembatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1433, '611.521', 'Jembatan Inspeksi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1434, '611.522', 'Jembatan Hewan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1435, '611.53', 'Tangga Cuci', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1436, '611.54', 'Kubangan Kerbau', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1437, '611.55', 'Waduk Lapangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1438, '611.56', 'Bangunan Penunjang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1439, '611.57', 'Jaringan Telepon', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1440, '611.58', 'Stasiun Agro', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1441, '612', 'Folder', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1442, '612.1', 'Tanggul Keliling', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1443, '612.11', 'Tanggul', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1444, '612.12', 'Bangunan Penutup Sungai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1445, '612.13', 'Jembatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1446, '612.2', 'Bangunan Pembawa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1447, '612.21', 'Saluran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1448, '612.211', 'Saluran Muka', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1449, '612.212', 'Saluran Pembawa Waduk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1450, '612.213', 'Saluran Pembawa Sekunder', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1451, '612.22', 'Stasiun Pompa Pemasukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1452, '612.23', 'Bangunan Bagi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1453, '612.24', 'Gorong-Gorong', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1454, '612.25', 'Syphon', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1455, '612.3', 'Bangunan Pembuang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1456, '612.31', 'Stasiun Pompa Pembuang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1457, '612.32', 'Saluran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1458, '612.321', 'Saluran Pembuang Induk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1459, '612.322', 'Saluran Pembuang Sekunder', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1460, '612.33', 'Pintu Air Pembuangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1461, '612.34', 'Gorong-Gorong Pembuangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1462, '612.35', 'Syphon Pembuangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1463, '612.4', 'Bangunan Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1464, '612.41', 'Bangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1465, '612.411', 'Bangunan Pengukur Air', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1466, '612.412', 'Bangunan Pengukur Curah Hujan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1467, '612.413', 'Bangunan Gudang Stasiun Pompa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1468, '612.414', 'Bangunan Listrik Stasiun Pompa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1469, '612.42', 'Rumah Petugas Aksploitasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1470, '613', 'Pasang Surut', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1471, '613.1', 'Bangunan Pembawa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1472, '613.11', 'Saluran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1473, '613.111', 'Saluran Pembawa Induk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1474, '613.112', 'Saluran Pembawa Sekunder', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1475, '613.113', 'Saluran Pembawa Tersier', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1476, '613.114', 'Saluran penyimpanan air', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1477, '613.12', 'Bangunan Pintu Pemasukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1478, '613.2', 'Bangunan Pembuang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1479, '613.21', 'Saluran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1480, '613.211', 'Saluran Pembuang Induk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1481, '613.212', 'Saluran Pembuang Sekunder', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1482, '613.213', 'Saluran Pembuang Tersier', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1483, '613.214', 'Saluran Pengumpul Air', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1484, '613.22', 'Bangunan Pintu Pembuang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1485, '613.3', 'Bangunan Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1486, '613.31', 'Kolam Pasang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1487, '613.32', 'Saluran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1488, '613.321', 'Saluran Lalu Lintas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1489, '613.322', 'Saluran Muka', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1490, '613.33', 'Bangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1491, '613.331', 'Bangunan Penangkis Kotoran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1492, '613.332', 'Bangunan Pengukur Muka Air', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1493, '613.333', 'Bangunan Pengukur Curah Hujan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1494, '613.34', 'Jalan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1495, '613.35', 'Jembatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1496, '614', 'Pengendalian Sungai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1497, '614.1', 'Bangunan Pengaman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1498, '614.11', 'Tanggul Banjir', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1499, '614.12', 'Pintu Pengatur Banjir', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1500, '614.13', 'Klep Pengatur Banjir', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1501, '614.14', 'Tembok Pengaman Talud', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1502, '614.15', 'Krib', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1503, '614.16', 'Kantung Lumpur', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1504, '614.17', 'Check-Dam', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1505, '614.18', 'Syphon', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1506, '614.2', 'Saluran Pengaman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1507, '614.21', 'Saluran Banjir', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1508, '614.22', 'Saluran Drainage', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1509, '614.23', 'Corepure', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1510, '614.3', 'Bangunan Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1511, '614.31', 'Warning System', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1512, '614.32', 'Stasiun', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1513, '614.321', 'Stasiun Pengukur Curah Hujan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1514, '614.322', 'Stasiun Pengukur Air', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1515, '614.323', 'Stasiun Pengukur Cuaca', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1516, '614.324', 'Stasiun Pos Penjagaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1517, '615', 'Pengamanan Pantai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1518, '615.1', 'Tanggul', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1519, '615.2', 'Krib', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1520, '615.3', 'Bangunan Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1521, '616', 'Air Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1522, '616.1', 'Stasiun Pompa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1523, '616.2', 'Bangunan Pembawa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1524, '616.3', 'Bangunan Pembuang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1525, '616.4', 'Bangunan Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1526, '617', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1527, '618', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1528, '619', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1529, '620', 'JALAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1530, '621', 'Jalan Kota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1531, '621.1', 'Daerah Penguasaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1532, '621.11', 'Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1533, '621.12', 'Tanaman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1534, '621.13', 'Bangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1535, '621.2', 'Bangunan Sementara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1536, '621.21', 'Jalan Sementara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1537, '621.22', 'Jembatan Sementara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1538, '621.23', 'Kantor Proyek', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1539, '621.24', 'Gedung Proyek', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1540, '621.25', 'Barak Kerja', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1541, '621.26', 'Laboratorium Lapangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1542, '621.27', 'Rumah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1543, '621.3', 'Badan Jalan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1544, '621.31', 'Pekerjaan Tanah (Earth Work)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1545, '621.32', 'Stabilisasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1546, '621.4', 'Perkerasan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1547, '621.41', 'Lapis Pondasi Bawah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1548, '621.42', 'Lapis Pondasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1549, '621.43', 'Lapis Permukaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1550, '621.5', 'Drainage', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1551, '621.51', 'Parit Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1552, '621.52', 'Gorong-Gorong (Culvert)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1553, '621.6', 'Buku Trotuir', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1554, '621.61', 'Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1555, '621.62', 'Perkerasan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1556, '621.63', 'Pasangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1557, '621.7', 'Median', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1558, '621.71', 'Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1559, '621.72', 'Tanaman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1560, '621.73', 'Perkerasan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1561, '621.74', 'Pasangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1562, '621.8', 'Daerah Samping', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1563, '621.81', 'Tanaman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1564, '621.82', 'Pagar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1565, '621.9', 'Bangunan Pelengkap Dan Pengamanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1566, '621.91', 'Rambu-Rambu/Tanda-Tanda Lalu Lintas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1567, '621.92', 'Lampu Penerangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1568, '621.93', 'Lampu Pengatur Lalu Lintas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1569, '621.94', 'Patok-Patok KM', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1570, '621.95', 'Patok-Patok ROW (Sempadan)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1571, '621.96', 'Rel Pengamanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1572, '621.97', 'Pagar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1573, '621.98', 'Turap Penahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1574, '621.99', 'Bronjong', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1575, '622', 'Jalan Luar Kota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1576, '622.1', 'Daerah Penguasaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1577, '622.11', 'Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1578, '622.12', 'Tanaman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1579, '622.13', 'Bangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1580, '622.2', 'Bangunan Sementara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1581, '622.21', 'Jalan Sementara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1582, '622.22', 'Jembatan Sementara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1583, '622.23', 'Kantor Proyek', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1584, '622.24', 'Gudang Proyek', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1585, '622.25', 'Barak Kerja', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1586, '622.26', 'Laboratorium Lapangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1587, '622.27', 'Rumah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1588, '622.3', 'Badan Jalan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1589, '622.31', 'Pekerjaan Tanah (Earth Work)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1590, '622.32', 'Stabilisasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1591, '622.4', 'Perkerasan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1592, '622.41', 'Lapis Pondasi Bawah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1593, '622.42', 'Lapis Pondasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1594, '622.43', 'Lapis Permukaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1595, '622.5', 'Drainage', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1596, '622.51', 'Parit', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1597, '622.52', 'Gorong-Gorong (Culvert)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1598, '622.53', 'Sub Drainage', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1599, '622.6', 'Trotoar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1600, '622.61', 'Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1601, '622.62', 'Perkerasan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1602, '622.7', 'Median', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1603, '622.71', 'Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1604, '622.72', 'Tanaman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1605, '622.73', 'Perkerasan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1606, '622.74', 'Pasangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1607, '622.8', 'Daerah Samping', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1608, '622.81', 'Tanaman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1609, '622.82', 'Pagar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1610, '622.9', 'Bangunan Pelengkap Dan Pengamanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1611, '622.91', 'Rambu-Rambu/Tanda-Tanda Lalu Lintas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1612, '622.92', 'Lampu Penerangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1613, '622.93', 'Lampu Pengatur Lalu Lintas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1614, '622.94', 'Patok-Patok KM', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1615, '622.95', 'Patok-Patok ROW (Sempadan)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1616, '622.96', 'Rel Pengamanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1617, '622.97', 'Pagar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1618, '622.98', 'Turap Penahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1619, '622.99', 'Bronjong', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1620, '623', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1621, '623', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1622, '623', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1623, '630', 'JEMBATAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1624, '631', 'Jembatan Pada Jalan Kota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1625, '631.1', 'Daerah Penguasaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1626, '631.11', 'Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1627, '631.12', 'Tanaman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1628, '631.13', 'Bangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1629, '631.2', 'Bangunan Sementara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1630, '631.21', 'Jalan Sementara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1631, '631.22', 'Jembatan Sementara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1632, '631.23', 'Kantor Proyek', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1633, '631.24', 'Gudang Proyek', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1634, '631.25', 'Barak Kerja', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1635, '631.26', 'Laboratorium Lapangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1636, '631.27', 'Rumah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1637, '631.3', 'Pekerjaan Tanah (Earth Work)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1638, '631.31', 'Galian Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1639, '631.32', 'Timbunan Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1640, '631.4', 'Pondasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1641, '631.41', 'Pondasi Kepala Jalan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1642, '631.42', 'Pondasi Pilar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1643, '631.43', 'Angker', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1644, '631.5', 'Bangunan Bawah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1645, '631.51', 'Kepala Jembatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1646, '631.52', 'Pilar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1647, '631.53', 'Piloon', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1648, '631.54', 'Landasan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1649, '631.6', 'Bangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1650, '631.61', 'Gelagar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1651, '631.62', 'Lantai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1652, '631.63', 'Perkerasan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1653, '631.64', 'Jalan Orang / Trotoar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1654, '631.65', 'Sandaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1655, '631.66', 'Talang air', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1656, '631.7', 'Bangunan / Pengaman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1657, '631.71', 'Turap Penahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1658, '631.72', 'Bronjong', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1659, '631.73', '', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1660, '631.74', 'Kist Dam', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1661, '631.75', 'Corepure', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1662, '631.76', 'Krib', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1663, '631.8', 'Bangunan Pelengkap', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1664, '631.81', 'Rambu-Rambu/Tanda-Tanda Lalu Lintas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1665, '631.82', 'Lampu Penerangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1666, '631.83', 'Lampu Pengatur Lalu Lintas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1667, '631.84', 'Patok Pengaman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1668, '631.85', 'Patok ROW (Sempadan)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1669, '631.86', 'Pagar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1670, '631.9', 'Oprit', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1671, '631.91', 'Badan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1672, '631.92', 'Perkerasan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1673, '631.93', 'Drainage', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1674, '631.94', 'Baku', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1675, '631.95', 'Median', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1676, '632', 'Jembatan Pada Jalan Luar Kota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1677, '632.1', 'Daerah Penguasaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1678, '632.11', 'Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1679, '632.12', 'Tanaman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1680, '632.13', 'Bangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1681, '632.2', 'Bangunan Sementara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1682, '632.21', 'Jalan Sementara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1683, '632.22', 'Jembatan Sementara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1684, '632.23', 'Kantor Proyek', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1685, '632.24', 'Gudang Proyek', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1686, '632.25', 'Barak Kerja', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1687, '632.26', 'Laboratorium Lapangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1688, '632.27', 'Rumah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1689, '632.3', 'Pekerjaan Tanah (Earth Work)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1690, '632.31', 'Galian Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1691, '632.32', 'Timnunan Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1692, '632.4', 'Pondasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1693, '632.41', 'Pondasi Kepala Jembatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1694, '632.42', 'Pondasi Pilar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1695, '632.43', 'Pondasi Angker', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1696, '632.5', 'Bangunan Bawah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1697, '632.51', 'Kepala Jembatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1698, '632.52', 'Pilar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1699, '632.53', 'Piloon', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1700, '632.54', 'Landasan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1701, '632.6', 'Bangunan Atas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1702, '632.61', 'Gelagar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1703, '632.62', 'Lantai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1704, '632.63', 'Perkerasan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1705, '632.64', 'Jalan Orang / Trotoar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1706, '632.65', 'Sandaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1707, '632.66', 'Talang Air', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1708, '632.7', 'Bangunan Pengaman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1709, '632.71', 'Turap / Penahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1710, '632.72', 'Bronjong', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1711, '632.73', 'Stek Dam', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1712, '632.74', 'Kist Dam', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1713, '632.75', 'Corepure', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1714, '632.76', 'Krib', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1715, '632.8', 'Bangunan Pelengkap', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1716, '632.81', 'Rambu-Rambu/Tanda-Tanda Lalu Lintas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1717, '632.82', 'Lampu Penerangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1718, '632.83', 'Lampu Pengatur Lalu Lintas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1719, '632.84', 'Patok Pengaman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1720, '632.85', 'Patok ROW (Sempadan)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1721, '632.86', 'Pagar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1722, '632.9', 'Oprit', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1723, '632.91', 'Badan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1724, '632.92', 'Perkerasan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1725, '632.93', 'Drainage', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1726, '632.94', 'Baku', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1727, '632.95', 'Median', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1728, '633', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1729, '634', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1730, '635', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1731, '640', 'BANGUNAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1732, '640.1', 'Gedung Pengadilan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1733, '640.2', 'Rumah Pejabat Negara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1734, '640.3', 'Gedung DPR', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1735, '640.4', 'Gedung Balai Kota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1736, '640.5', 'Penjara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1737, '640.6', 'Perkantoran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1738, '642', 'Bangunan Pendidikan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1739, '642.1', 'Taman Kanak-Kanak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1740, '642.2', 'SD & SEKOLAH MENENGAH', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1741, '642.3', 'Perguruan Tinggi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1742, '643', 'Bangunan Rekreasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1743, '643.1', 'BANGUNAN OLAH RAGA', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1744, '643.2', 'Gedung Kesenian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1745, '643.3', 'Gedung Pemancar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1746, '644', 'Bangunan Perdagangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1747, '644.1', 'Pusat Perbelanjaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1748, '644.2', 'Gedung Perdagangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1749, '644.3', 'Bank', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1750, '644.4', 'Pekantoran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1751, '645', 'Bangunan Pelayanan Umum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1752, '645.1', 'MCK', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1753, '645.2', 'Gedung Parkir', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1754, '645.3', 'Rumah Sakit', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1755, '645.4', 'Gedung Telkom', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1756, '645.5', 'Terminal Angkutan udara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1757, '645.6', 'Terminal Angkutan udara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1758, '645.7', 'Terminal Angkutan Darat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1759, '645.8', 'Bangunan Keagamaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1760, '646', 'Bangunan Peninggalan Sejarah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1761, '646.1', 'Monumen', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1762, '646.2', 'Candi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1763, '646.3', 'Keraton', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1764, '646.4', 'Rumah Tradisional', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1765, '647', 'Bangunan Industri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1766, '648', 'Bangunan Tempat Tinggal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1767, '648.1', 'Rumah Perkotaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1768, '648.11', 'Inti / Sederhana', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1769, '648.12', 'Sedang / Mewah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1770, '648.2', 'Rumah Pedesaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1771, '648.21', 'Rumah Contoh', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1772, '648.3', 'Real Estate', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1773, '648.4', 'Bapetarum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1774, '649', 'Elemen Bangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1775, '649.1', 'Pondasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1776, '649.11', 'Di Atas Tiang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1777, '649.2', 'Dinding', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1778, '649.21', 'Penahan Beban', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1779, '649.22', 'Tidak Menahan Beban', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1780, '649.3', 'Atap', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1781, '649.4', 'Lantai / Langit-Langit', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1782, '649.41', 'Supended', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1783, '649.42', 'Solit', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1784, '649.5', 'Pintu / Jendela', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1785, '649.51', 'Pintu Harmonik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1786, '649.52', 'Pintu Biasa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1787, '649.53', 'Pintu Sorong', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1788, '649.54', 'Pintu Kayu', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1789, '649.55', 'Jendela Sorong', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1790, '649.56', 'Jendela Vertikal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1791, '650', 'TATA KOTA', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1792, '651', 'Daerah Perdagangan / Pelabuhan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1793, '651.1', 'Daerah Pusat Perbelanjaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1794, '651.2', 'Daerah Perkotaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1795, '652', 'Daerah Pemerintah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1796, '653', 'Daerah Perumahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1797, '653.1', 'Kepadatan Rendah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1798, '653.2', 'Kepadatan Tinggi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1799, '654', 'Daerah Industri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1800, '654.1', 'Industri Berat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1801, '654.2', 'Industri Ringan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1802, '654.3', 'Industri Ringan (Home Industry)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1803, '655', 'Daerah Rekreasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1804, '655.1', 'Public Garden', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1805, '655.2', 'Sport & Playing Fields', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1806, '655.3', 'Open Space', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1807, '656', 'Transportasi (Tata Letak)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1808, '656.1', 'Jaringan Jalan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1809, '656.11', 'Penerangan Jalan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1810, '656.2', 'Jaringan Kereta Api', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1811, '656.3', 'Jaringan Sungai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1812, '657', 'Assaineering', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1813, '657.1', 'Saluran Pengumpulan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1814, '657.2', 'Instalasi Pengolahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1815, '657.21', 'Bangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1816, '657.211', 'Bangunan Penyaringan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1817, '657.212', 'Bangunan Penghancur Kotoran / Sampah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1818, '657.213', 'Bangunan Pengendap', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1819, '657.214', 'Bangunan Pengering Lumpur', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1820, '657.22', 'Unit Densifektan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1821, '657.23', 'Unit Perpompaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1822, '658', 'Kesehatan Lingkungan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1823, '658.1', 'Persampahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1824, '658.11', 'Bangunan Pengumpul', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1825, '658.12', 'Bangunan Pemusnahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1826, '658.2', 'Pengotoran Udara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1827, '658.3', 'pengotoran Air', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1828, '658.31', 'Air Buangan Industri Limbah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1829, '658.4', 'Kegaduhan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1830, '658.5', 'Kebersihan Kota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1831, '659', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1832, '660', 'TATA LINGKUNGAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1833, '660.1', 'Persampahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1834, '660.2', 'Kebersihan Lingkungan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1835, '660.3', 'Pencemaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1836, '660.31', 'Pecemaran Air', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1837, '660.32', 'Pencemaran Udara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1838, '661', 'Daerah Hutan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1839, '662', 'Daerah Pertanian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1840, '663', 'Daerah Pemikiman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1841, '664', 'Pusat Pertumbuhan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1842, '665', 'Transportasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1843, '665.1', 'Jaringan Jalan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1844, '665.2', 'Jaringan Kereta Api', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1845, '665.3', 'Jaringan Sungai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1846, '666', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1847, '667', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1848, '668', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1849, '670', 'KETENAGAAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1850, '671', 'Listrik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1851, '671.1', 'Kelistrikan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1852, '671.11', 'Kelisrikan PLN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1853, '671.12', 'Kelistrikan Non PLN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1854, '671.2', 'Pembangkit Tenaga Listrik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1855, '671.21', 'PLTA  ( Pembangkit  Listrik Tenaga Air )', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1856, '671.22', 'PLTD  ( Pembangkit Listrik Tenaga Diesel )', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1857, '671.23', 'PLTG P ( Pembangkit Listrik Tenaga Gas )', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1858, '671.24', 'PLTM ( Pembangkit  Listrik Tenaga Matahari )', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1859, '671.25', 'PLTN ( Pembangkit Listrik Tenaga Nuklir )', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1860, '671.26', 'PLTPB ( Pembangkit Listrik Tenaga Uap )', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1861, '671.3', 'Transmisi Tenaga Listrik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1862, '671.31', 'Gardu Induk/Gardu Penghubung/Gardu Trafo', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1863, '671.32', 'Saluran Udara Tegangan Tinggi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1864, '671.33', 'Kabel Bawah Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1865, '671.4', 'Distribusi Tenaga Listrik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1866, '671.41', 'Gardu Distribusi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1867, '671.42', 'Tegangan Rendah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1868, '671.43', 'Tegangan Menengah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1869, '671.44', 'Jaringan Bawah Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1870, '671.5', 'Pengusahaan Listrik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1871, '671.51', 'Sambungan Listrik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1872, '671.52', 'Penjualan Tenaga Listrik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1873, '671.53', 'Tarif Listrik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1874, '672', 'Tenaga Air', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1875, '673', 'Tenaga Minyak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1876, '674', 'Tenaga Gas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1877, '675', 'Tenaga Matahari', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1878, '676', 'Tenaga Nuklir', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1879, '677', 'Tenaga Panas Bumi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1880, '678', 'Tenaga Uap', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1881, '679', 'Tenaga Lainya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1882, '680', 'PERALATAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1883, '681', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1884, '682', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1885, '683', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1886, '690', 'AIR MINUM', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1887, '691', 'Intake', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1888, '691.1', 'Broncaptering', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1889, '691.2', 'Sumur', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1890, '691.3', 'Bendungan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1891, '691.4', 'Saringan (screen)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1892, '691.5', 'Pintu air', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1893, '691.6', 'Saluran Pembawa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1894, '691.7', 'Alat Ukur', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1895, '691.8', 'Perpompaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1896, '692', 'Transmisi Air Baku', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1897, '692.1', 'Perpipaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1898, '692.2', 'Katup Udara (Air Relief)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1899, '692.3', 'Katup Penguras (Blow Off)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1900, '692.4', 'Bak Pelepas Tekanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1901, '692.5', 'Jembatan Pipa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1902, '692.6', 'Syphon', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1903, '693', 'Instalasi Pengelolaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1904, '693.1', 'Bangunan Ukur', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1905, '693.2', 'Bangunan Aerasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1906, '693.3', 'Bangunan Pengendapan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1907, '693.4', 'Bangunan Pembubuh Bahan Kimia', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1908, '693.5', 'Bangunan Pengaduk', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1909, '693.6', 'Bangunan Saringan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1910, '693.7', 'Perpompaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1911, '693.8', 'Clear Hell', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1912, '694', 'Distribusi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1913, '694.1', 'Reservoir Menara Bawah Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1914, '694.11', 'Menara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1915, '694.12', 'reservoir di Bawah Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1916, '694.2', 'Perpipaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1917, '694.3', 'Perpompaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1918, '694.4', 'Jembatan Pipa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1919, '694.5', 'Syphon', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1920, '694.6', 'Hydran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1921, '694.61', 'Hydran Umum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1922, '694.62', 'Hydran Kebakaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1923, '694.7', 'Katup', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1924, '694.71', 'Katup Udara (Air Relief)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1925, '694.72', 'Katup Pelepas (Blow Off)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1926, '694.8', 'Bak Pelepas Tekanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1927, '695', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1928, '696', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1929, '697', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1930, '698', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1931, '699', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1932, '700', 'PENGAWASAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1933, '701', 'Bidang Urusan Dalam', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1934, '702', 'Bidang Peralatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1935, '703', 'Bidang Kekayaan Daerah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1936, '704', 'Bidang Perpustakaan / Dokumentasi / Kearsipan Sandi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1937, '705', 'Bidang Perencanaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1938, '706', 'Bidang Organisasi / Ketatalaksanaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1939, '707', 'Bidang Penelitian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1940, '708', 'Bidang Konferensi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1941, '709', 'Bidang Perjalanan Dinas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1942, '710', 'BIDANG PEMERINTAHAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1943, '711', 'Bidang Pemerintahan Pusat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1944, '712', 'Bidang Pemerintahan Provinsi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1945, '713', 'Bidang Pemerintahan Kabupaten / Kota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1946, '714', 'Bidang Pemerintahan Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1947, '715', 'Bidang MPR / DPR', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1948, '716', 'Bidang DPRD Provinsi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1949, '717', 'Bidang DPRD Kabupaten / Kota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1950, '718', 'Bidang Hukum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1951, '719', 'Bidang Hubungan Luar Negeri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1952, '720', 'BIDANG POLITIK', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1953, '721', 'Bidang Kepartaian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1954, '722', 'Bidang Organisasi Kemasyarakatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1955, '723', 'Bidang Organisasi Profesi Dan Fungsional', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1956, '724', 'Bidang Organisasi Pemuda', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1957, '725', 'Bidang Organisasi Buruh, Tani, Dan Nelayan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1958, '726', 'Bidang Organisasi Wanita', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1959, '727', 'Bidang Pemilihan Umum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1960, '730', 'BIDANG KEAMANAN/KETERTIBAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1961, '731', 'Bidang Pertahanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1962, '732', 'Bidang Kemiliteran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1963, '733', 'Bidang Perlindungan Masyarakat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1964, '734', 'Bidang Kemanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1965, '735', 'bidang Kejahatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1966, '736', 'Bidang Bencana', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1967, '737', 'Bidang Kecelakaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1968, '738', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1969, '739', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1970, '740', 'BIDANG KESEJAHTERAAN RAKYAT', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1971, '741', 'Bidang Pembagunan Desa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1972, '742', 'Bidang Pendidikan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1973, '743', 'Bidang Kebudayaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1974, '744', 'Bidang Kesehatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1975, '745', 'Bidang Agama', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1976, '746', 'Bidang Sosial', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1977, '747', 'Bidang Kependudukan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1978, '748', 'Bidang Media Massa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1979, '749', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1980, '750', 'BIDANG PEREKONOMIAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1981, '751', 'Bidang Perdagangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1982, '752', 'Bidang Pertanian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1983, '753', 'Bidang Perindustrian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1984, '754', 'Bidang Pertambangan / Kesamudraan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1985, '755', 'Bidang Perhubungan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1986, '756', 'Bidang Tenaga Kerja', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1987, '757', 'Bidang Permodalan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1988, '758', 'Bidang Perbankan / Moneter', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1989, '759', 'Bidang Agraria', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1990, '760', 'BIDANG PEKERJAAN UMUM', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1991, '761', 'Bidang Pengairan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1992, '762', 'Bidang Jalan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1993, '763', 'Bidang Jembatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1994, '764', 'Bidang Bangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1995, '765', 'Bidang Tata Kota', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1996, '766', 'Bidang Lingkungan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1997, '767', 'Bidang Ketenagaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1998, '768', 'Bidang Peralatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (1999, '769', 'Bidang Air Minum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2000, '770', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2001, '771', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2002, '772', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2003, '780', 'BIDANG KEPEGAWAIAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2004, '781', 'Bidang Pengadaan Pegawai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2005, '782', 'Bidang Mutasi Pegawai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2006, '783', 'Bidang Kedudukan Pegawai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2007, '784', 'Bidang Kesejahteran Pegawai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2008, '785', 'Bidang Cuti', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2009, '786', 'Bidang Penilaian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2010, '787', 'Bidang Tata Usaha Kepegawaian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2011, '788', 'Bidang Pemberhentian Pegawai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2012, '789', 'Bidang Pendidikan Pegawai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2013, '790', 'BIDANG KEUANGAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2014, '791', 'Bidang Anggaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2015, '792', 'Bidang Otorisasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2016, '793', 'Bidang Verifikasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2017, '794', 'Bidang Pembukuan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2018, '795', 'Bidang Perbendaharaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2019, '796', 'Bidang Pembina Kebendaharaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2020, '797', 'Bidang Pendapatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2021, '798', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2022, '799', 'Bidang Bendaharaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2023, '800', 'KEPEGAWAIAN', 'Klasifikasi Disini: Kebijaksanaan Kepegawaian', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2024, '800.1', 'Perencanaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2025, '800.2', 'Penelitian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2026, '800.043', 'Pengaduan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2027, '800.05', 'Tim', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2028, '800.07', 'Statistik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2029, '800.08', 'Peraturan Perundang-Undangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2030, '810', 'PENGADAAN', 'Meliputi: Lamaran, Pengujian Kesehatan, Dan Pengangkatan Calon Pegawai', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2031, '811', 'Lamaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2032, '811.1', 'Testing', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2033, '811.2', 'Screening', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2034, '811.3', 'Panggilan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2035, '812', 'Pengujian Kesehatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2036, '813', 'Pengangkatan Calon Pegawai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2037, '813.1', 'Pengangkatan Calon Pegawai Golongan 1', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2038, '813.2', 'Pengangkatan Calon Pegawai Golongan II', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2039, '813.3', 'Pengangkatan Calon Pegawai Golongan III', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2040, '813.4', 'Pengangkatan Calon Pegawai Golongan IV', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2041, '813.5', 'Pengangkatan Calon Guru Inpres', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2042, '814', 'Pengangkatan Tenaga Lepas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2043, '814.1', 'Pengangkatan Tenaga Bulanan / Tenaga Kontrak', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2044, '814.2', 'Pengangkatan Tenaga Harian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2045, '814.3', 'Pengangkatan Tenaga Pensiunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2046, '815', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2047, '816', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2048, '817', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2049, '820', 'MUTASI', 'Meliputi: Pengangkatan, Kenaikan Gaji Berkala, Kenaikan Pangkat, Pemindahan, Pelimpahan Datasering, Tugas Belajar Dan Wajib Militer', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2050, '821', 'Pengangkatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2051, '821.1', 'Pengangkatan Menjadi Pegawai Negeri Tetap', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2052, '821.11', 'Pengangkatan Menjadi Pegawai Negeri Golongan 1', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2053, '821.12', 'Pengangkatan Menjadi Pegawai Negeri Golongan 2', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2054, '821.13', 'Pengangkatan Menjadi Pegawai Negeri Golongan 3', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2055, '821.14', 'Pengangkatan Menjadi Pegawai Negeri Golongan 4', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2056, '821.15', 'Pengangkatan Menjadi Pegawai Negeri Sipil Yang Cuti Di Luar Tanggungan Negara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2057, '821.2', 'Pengangkatan Dalam Jabatan, Pembebasan Dari Jabatan, Berita Acara Serah Terima Jabatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2058, '821.21', 'Sekjen/Dirjen/Irjen/Kabag', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2059, '821.22', 'Kepala Biro/Direktur/Inspektur/Kepala Pusat/Sekretaris/Kepala Dinas/Asisten Sekwilda', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2060, '821.23', 'Kepala Bagian/Kepala Sub Direktorat/Kepala Bidang/Inspektur Pembantu', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2061, '821.24', 'Kepala Subbagian/Kepala Seksi/Kepala Sub Bidang/Pemeriksa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2062, '821.25', 'Residen/Pembantu Gubernur', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2063, '821.26', 'Wedana/Pembantu Bupati', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2064, '821.27', 'Camat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2065, '821.28', 'Lurah Administratif (Lurah Desa)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2066, '821.29', 'Jabatan Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2067, '822', 'Kenaikan Gaji Berkala', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2068, '822.1', 'Pegawai Golongan 1', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2069, '822.2', 'Pegawai Golongan 2', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2070, '822.3', 'Pegawai Golongan 3', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2071, '822.4', 'Pegawai Golongan 4', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2072, '823', 'Kenaikan Pangkat / Pengangkatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2073, '823.1', 'Pegawai Golongan 1', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2074, '823.2', 'Pegawai Golongan 2', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2075, '823.3', 'Pegawai Golongan 3', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2076, '823.4', 'Pegawai Golongan 4', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2077, '824', 'Pemindahan / Pelimpahan / Perbantuan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2078, '824.1', 'Pegawai Golongan 1', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2079, '824.2', 'Pegawai Golongan 2', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2080, '824.3', 'Pegawai Golongan 3', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2081, '824.4', 'Pegawai Golongan 4', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2082, '824.5', 'Lolos Butuh', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2083, '824.6', 'Kurikulum dan Silabi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2084, '824.7', 'Proposal (TOR)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2085, '825', 'Datasering dan Penempatan Kembali', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2086, '826', 'Penunjukan Tugas Belajar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2087, '826.1', 'Dalam Negeri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2088, '826.2', 'Luar Negeri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2089, '826.3', 'Tunjangan Belajar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2090, '826.4', 'Penempatan Kembali', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2091, '827', 'Wajib Militer', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2092, '828', 'Mutasi Dengan Instansi Lain', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2093, '829', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2094, '830', 'KEDUDUKAN', 'Meliputi: Perhitungan Masa Kerja, Penyesuaian Pangkat/Gaji, Penghargaan Ijasah, Dan Jenjang Pangkat', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2095, '831', 'Perhitungan Masa Kerja', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2096, '832', 'Penyesuaian Pangkat / Gaji', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2097, '832.1', 'Pegawai Golongan 1', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2098, '832.2', 'Pegawai Golongan 2', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2099, '832.3', 'Pegawai Golongan 3', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2100, '832.4', 'Pegawai Golongan 4', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2101, '833', 'Penghargaan Ijazah / Penyesuaian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2102, '834', 'Jenjang Pangkat / Eselonering', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2103, '835', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2104, '836', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2105, '837', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2106, '840', 'KESEJAHTERAAN PEGAWAI', 'Meliputi: Tunjangan, Dana, Perawatan Kesehatan, Koperasi, Distribusi, Permahan/Tanah, Bantuan Sosial, Rekreasi Dan Dispensasi.', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2107, '841', 'Tunjangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2108, '841.1', 'Jabatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2109, '841.2', 'Kehormatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2110, '841.3', 'Kematian/Uang Duka', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2111, '841.4', 'Tunjangan Hari Raya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2112, '841.5', 'Perjalanan Dinas Tetap/Cuti/Pindah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2113, '841.6', 'Keluarga', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2114, '841.7', 'Sandang, Pangan, Papan (Bapertarum)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2115, '842', 'Dana', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2116, '842.1', 'Taspen', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2117, '842.2', 'Kesehatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2118, '842.3', 'Asuransi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2119, '843', 'Perawatan Kesehatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2120, '843.1', 'Poliklinik', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2121, '843.2', 'Perawatan Dokter', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2122, '843.3', 'Obat-Obatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2123, '843.4', 'Keluarga Berencana', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2124, '844', 'Koperasi / Distribusi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2125, '844.1', 'Distribusi Pangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2126, '844.2', 'Distribusi Sandang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2127, '844.3', 'Distribusi Papan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2128, '845', 'Perumahan/Tanah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2129, '845.1', 'Perumahan Pegawai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2130, '845.2', 'Tanah Kapling', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2131, '845.3', 'Losmen/Hotel', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2132, '846', 'Bantuan Sosial', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2133, '846.1', 'Bantuan Kebakaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2134, '846.2', 'Bantuan Kebanjiran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2135, '847', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2136, '848', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2137, '849', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2138, '850', 'CUTI ', 'Meliputi Cuti Tahunan, Cuti Besar, Cuti Sakit, Cuti Hamil, Cuti Naik Haji, Cuti Diluar Tanggungan Negara Dan Cuti Alasan Lain', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2139, '851', 'Cuti Tahunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2140, '852', 'Cuti Besar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2141, '853', 'Cuti Sakit', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2142, '854', 'Cuti Hamil', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2143, '855', 'Cuti Naik Haji/Umroh', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2144, '856', 'Cuti Di Luar Tangungan Neagara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2145, '857', 'Cuti Alasan Lain/Alasan Penting', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2146, '858', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2147, '859', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2148, '860', 'PENILAIAN', 'Meliputi: Penghargaan, Hukuman, Konduite, Ujian Dinas,Penilaian Kakayaan Pribadi Dan Rehabilitasi', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2149, '861', 'Penghargaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2150, '861.1', 'Bintang/Satyalencana', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2151, '861.2', 'Kenaikan Pangkat Anumerta', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2152, '861.3', 'Kenaikan Gaji Istimewa', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2153, '861.4', 'Hadiah Berupa Uang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2154, '861.5', 'Pegawai Teladan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2155, '862', 'Hukuman', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2156, '862.1', 'Teguran Peringatan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2157, '862.2', 'Penundaan Kenaikan Gaji', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2158, '862.3', 'Penurunan Pangkat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2159, '862.4', 'Pemindahan', 'Catatan: Pemberhentian Untuk Sementara Waktu Dan Pemberhentian Tidak Dengan Hormat Lihat 887 Dan 888', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2160, '863', 'Konduite, DP3, Disiplin Pegawai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2161, '864', 'Ujian Dinas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2162, '864.1', 'Tingkat 1', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2163, '864.2', 'Tingkat 2', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2164, '864.3', 'Tingkat 3', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2165, '865', 'Penilaian Kehidupan Pegawai Negeri', 'Meliputi: Petunjuk Pelaksanaan Hidup Sederhana, Penilaian Kekayaan Pribadi ( LP2P )', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2166, '866', 'Rehabilitasi / Pengaktifan Kembali', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2167, '867', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2168, '868', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2169, '869', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2170, '870', 'TATA USAHA KEPEGAWAIAN', 'Meliputi: Formasi, Bezetting, Registrasi,Daftar, Riwayat Hidup, Hak, Penggajian, Sumpah,/Janji Dan Korps Pegawai', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2171, '871', 'Formasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2172, '872', 'Bezetting/Daftar Urut Kepegawaian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2173, '873', 'Registrasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2174, '873.1', 'NIP', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2175, '873.2', 'KARPEG', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2176, '873.3', 'Legitiminasi/Tanda Pengenal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2177, '873.4', 'Daftar Keluarga, Perkawinan, Perceraian, Karis, Karsu', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2178, '874', 'Daftar Riwayat Pekerjaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2179, '874.1', 'Tanggal Lahir', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2180, '874.2', 'Penggantian Nama', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2181, '874.3', 'Izin kepartaian Organisasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2182, '875', 'Kewenangan Mutasi Pegawai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2183, '875.1', 'Pelimpahan Wewenang', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2184, '875.2', 'Specimen Tanda Tangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2185, '876', 'Penggajian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2186, '876.1', 'SKPP', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2187, '877', 'Sumpah/Janji', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2188, '878', 'Korps Pegawai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2189, '879', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2190, '880', 'PEMBERHENTIAN PEGAWAI', 'Meliputi Atas  Pemberhentian,Permintaan Sendiri, Dengan Hak Pensiun, Karena Meninggal Dunia, Alasan Lain, Dengan Diberi Uang Pesangon, Uang Tnggu Untuk Sementara Waktu Dan Pemberhentian Tidak Dengan  Hormat', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2191, '881', 'Permintaan Sendiri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2192, '882', 'Dengan Hak Pensiun', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2193, '882.1', 'Pemberhentian Dengan Hak Pensiun Pegawai Negeri Golongan 1', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2194, '882.2', 'Pemberhentian Dengan Hak Pensiun Pegawai Negeri Golongan 2', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2195, '882.3', 'Pemberhentian Dengan Hak Pensiun Pegawai Negeri Golongan 3', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2196, '882.4', 'Pemberhentian Dengan Hak Pensiun Pegawai Negeri Golongan 4', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2197, '882.5', 'Pensiun Janda / Duda', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2198, '882.6', 'Pensiun Yatim Piatu', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2199, '882.7', 'Uang Muka Pensiun', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2200, '883', 'Karena Meninggal', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2201, '883.1', 'Karena Meninggal Dalam Tugas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2202, '884', 'Alasan Lain', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2203, '885', 'Uang Pesangon', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2204, '886', 'Uang Tunggu', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2205, '887', 'Untuk Sementara Waktu', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2206, '888', 'Tidak Dengan Hormat', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2207, '889', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2208, '890', 'PENDIDIKAN PEGAWAI', 'Meliputi: Perencanaan, Pendidikan Reguler, Pendidikan Non-Reguler, Pendidikan Ke Luar Negeri, Metode, Tenaga Pengajar, Administrasi Pendidikan, Fasilitas Sarana Pendidikan', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2209, '891', 'Perencanaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2210, '891.1', 'Program', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2211, '891.2', 'Kurikulum dan Silabi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2212, '891.3', 'Proposal ( TOR )', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2213, '892', 'Pendidikan _Egular / Kader', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2214, '892.1', 'IPDN / APDN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2215, '892.2', 'Kursus-Kursus Reguler', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2216, '893', 'Pendidikan dan Pelatihan / Non Reguler', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2217, '893.1', 'LEMHANAS', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2218, '893.2', 'Pendidikan dan Pelatihan Struktural, SPATI, SPAMEN, SPAMA, ADUMLA, ADUM', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2219, '893.3', 'Kursus-Kursus / Penataran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2220, '893.4', 'Diklat Tehnik, Fungsional Dan Manajemen Pemerintahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2221, '893.5', 'Diklat Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2222, '894', 'Pendidikan Luar Negeri', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2223, '894.1', 'Berkesinambungan / Berkala / Bergelar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2224, '894.2', 'Non Gelar / Diploma', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2225, '895', 'Metode', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2226, '895.1', 'Kuliah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2227, '895.2', 'Ceramah, Simposium', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2228, '895.3', 'Diskusi, Raker, Seminar, Lokakarya, Orientasi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2229, '895.4', 'Studi Lapangan, Kkn, Widyawisata', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2230, '895.5', 'Tanya Jawab / Sylabi / Modul / Kursil', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2231, '895.7', 'Penugasan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2232, '895.8', 'Gladi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2233, '896', 'Tenaga Pengajar / Widyaiswara/Narasumber', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2234, '896.1', 'Moderator', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2235, '897', 'Administrasi Pendidikan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2236, '897.1', 'Tahun Pelajaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2237, '897.2', 'Persyaratan, Pendaftaran, Testing, Ujian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2238, '897.3', 'STTP', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2239, '897.4', 'Penilaian Angka Kredit', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2240, '897.5', 'Laporan Pendidikan Dan Pelatihan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2241, '898', 'Fasilitas Belajar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2242, '898.1', 'Tunjangan Belajar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2243, '898.2', 'Asrama', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2244, '898.3', 'Uang Makan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2245, '898.4', 'Uang Transport', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2246, '898.5', 'Uang Buku', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2247, '898.6', 'Uang Ujian', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2248, '898.7', 'Uang Semester / Uang Kuliah', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2249, '898.8', 'Uang Saku', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2250, '899', 'Sarana', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2251, '899.1', 'Bantuan Sarana Belajar', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2252, '899.2', 'Bantuan Alat-Alat Tulis', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2253, '899.3', 'Bantuan Sarana Belajar Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2254, '900', 'KEUANGAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2255, '901', 'Nota Keuangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2256, '902', 'APBN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2257, '903', 'APBD', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2258, '904', 'APBN-P', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2259, '905', 'Dana Alokasi Umum', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2260, '906', 'Dana Alokasi Khusus', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2261, '907', 'Dekonsentrasi (Pelimpahan Dana Dari Pusat Ke Daerah)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2262, '907', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2263, '908', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2264, '910', 'ANGGARAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2265, '911', 'Rutin', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2266, '912', 'Pembangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2267, '913', 'Anggaran Belanja Tambahan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2268, '914', 'Daftar Isian Kegiatan (DIK)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2269, '914.1', 'Daftar Usulan Kegiatan (DUK)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2270, '915', 'Daftar Isian Poyek (DIP)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2271, '915.1', 'Daftar Usulan Proyek (DUP)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2272, '915.2', 'Daftar Isian Pengguna Anggaran (DIPA)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2273, '916', 'Revisi Anggaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2274, '917', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2275, '918', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2276, '920', 'OTORISASI / SKO', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2277, '921', 'Rutin', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2278, '922', 'Pembangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2279, '923', 'SIAP', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2280, '924', 'Ralat SKO', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2281, '925', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2282, '926', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2283, '927', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2284, '930', 'VERIFIKASI', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2285, '931', 'SPM Rutin (daftar p8)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2286, '932', 'SPM Pembangunan (daftar p8)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2287, '933', 'Penerimaan (daftar p6. p7)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2288, '934', 'SPJ Rutin', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2289, '935', 'SPJ Pembangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2290, '936', 'Nota Pemeriksaan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2291, '937', 'SP Pemindahan Pembukuan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2292, '938', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2293, '939', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2294, '940', 'PEMBUKUAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2295, '941', 'Penyusunan Perhitungan Anggaran', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2296, '942', 'Permintaan  Data Anggaran Laporan Fisik Pembangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2297, '943', 'Laporan Fisik Pembangunan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2298, '944', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2299, '945', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2300, '950', 'PERBENDAHARAAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2301, '951', 'Tuntutan Ganti Rugi (ICW Pasal 74)', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2302, '952', 'Tuntutan Bendaharawan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2303, '953', 'Penghapusan Kekayaan Negara', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2304, '954', 'Pengangkatan/Penggantian Pemimpin Proyak Dan Pengangkatan/Pemberhentian Bendaharawan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2305, '955', 'Spesimen Tanda Tangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2306, '956', 'Surat Tagihan Piutang, Ikhtisar Bulanan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2307, '957', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2308, '958', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2309, '959', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2310, '960', 'PEMBINAAN KEBENDAHARAAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2311, '961', 'Pemeriksaan Kas Dan Hasil Pemeriksaan Kas', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2312, '962', 'Pemeriksaan Administrasi Bendaharawan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2313, '963', 'Laporan Keuangan Bendaharawan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2314, '964', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2315, '965', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2316, '966', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2317, '970', 'PENDAPATAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2318, '971', 'Perimbangan Keuangan', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2319, '972', 'Subsidi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2320, '973', 'Pajak,Ipeda, IHH,IHPH', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2321, '974', 'Retribusi', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2322, '975', 'Bea', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2323, '976', 'Cukai', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2324, '977', 'Pungutan / PNBP', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2325, '978', 'Bantuan Presiden, Menteri Dan Bantuan Lainnya', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2326, '979', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2327, '980', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2328, '981', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2329, '990', 'BENDAHARAWAN', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2330, '991', 'SKPP / SPP', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2331, '992', 'Teguran SPJ', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2332, '993', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2333, '994', '-', '-', 1);
INSERT INTO `klasifikasi_surat` (`id`, `kode`, `nama`, `uraian`, `enabled`) VALUES (2334, '995', '-', '-', 1);


#
# TABLE STRUCTURE FOR: komentar
#

DROP TABLE IF EXISTS `komentar`;

CREATE TABLE `komentar` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `id_artikel` int(7) NOT NULL,
  `owner` varchar(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `subjek` tinytext,
  `komentar` text NOT NULL,
  `tgl_upload` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` tinyint(1) DEFAULT NULL,
  `tipe` tinyint(1) DEFAULT NULL,
  `no_hp` varchar(15) DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `is_archived` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO `komentar` (`id`, `id_artikel`, `owner`, `email`, `subjek`, `komentar`, `tgl_upload`, `status`, `tipe`, `no_hp`, `updated_at`, `is_archived`) VALUES (8, 95, 'Penduduk Biasa', 'penduduk@desaku.desa.id', NULL, 'Selamat atas keberhasilan Senggigi merayakan Hari Kemerdeakaan 2016!', '2016-09-14 06:09:16', 1, NULL, NULL, '2019-09-30 21:47:42', 0);
INSERT INTO `komentar` (`id`, `id_artikel`, `owner`, `email`, `subjek`, `komentar`, `tgl_upload`, `status`, `tipe`, `no_hp`, `updated_at`, `is_archived`) VALUES (9, 775, 'AHMAD ALLIF RIZKI', '5201140706966997', 'Tidak ada subjek pesan', 'Harap alamat keluarga kami diperbaik menjadi RT 002 Dusun Mangsit. \n\nTerima kasih.', '2016-09-14 07:44:59', 1, 1, NULL, '2019-09-30 21:47:42', 0);
INSERT INTO `komentar` (`id`, `id_artikel`, `owner`, `email`, `subjek`, `komentar`, `tgl_upload`, `status`, `tipe`, `no_hp`, `updated_at`, `is_archived`) VALUES (10, 775, 'DENATUL SUARTINI', '3275014601977005', 'Tidak ada subjek pesan', 'Saya ke kantor desa kemarin jam 12:30 siang, tetapi tidak ada orang. Anak kami akan pergi ke Yogyakarta untuk kuliah selama 4 tahun. Apakah perlu kami laporkan?', '2016-09-14 10:49:34', 2, 1, NULL, '2019-09-30 21:47:42', 0);
INSERT INTO `komentar` (`id`, `id_artikel`, `owner`, `email`, `subjek`, `komentar`, `tgl_upload`, `status`, `tipe`, `no_hp`, `updated_at`, `is_archived`) VALUES (11, 775, 'DENATUL SUARTINI', '3275014601977005', 'Tidak ada subjek pesan', 'Laporan ini tidak relevan. Hanya berisi komentar saja.', '2016-09-14 11:05:02', 2, 1, NULL, '2019-09-30 21:47:42', 0);


#
# TABLE STRUCTURE FOR: kontak_grup
#

DROP TABLE IF EXISTS `kontak_grup`;

CREATE TABLE `kontak_grup` (
  `id_grup` int(11) NOT NULL AUTO_INCREMENT,
  `nama_grup` varchar(30) NOT NULL,
  PRIMARY KEY (`id_grup`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: line
#

DROP TABLE IF EXISTS `line`;

CREATE TABLE `line` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `nama` varchar(50) NOT NULL,
  `simbol` varchar(50) DEFAULT NULL,
  `color` varchar(10) NOT NULL DEFAULT 'ff0000',
  `tipe` int(4) DEFAULT '0',
  `parrent` int(4) DEFAULT '1',
  `enabled` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `parrent` (`parrent`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

INSERT INTO `line` (`id`, `nama`, `simbol`, `color`, `tipe`, `parrent`, `enabled`) VALUES (1, 'Jalan', '', '#FFCD42', 0, 1, 1);
INSERT INTO `line` (`id`, `nama`, `simbol`, `color`, `tipe`, `parrent`, `enabled`) VALUES (2, 'Jalan Raya', '', '#FFCD42', 2, 1, 1);
INSERT INTO `line` (`id`, `nama`, `simbol`, `color`, `tipe`, `parrent`, `enabled`) VALUES (3, 'Jalan Kampung', '', '', 2, 1, 1);
INSERT INTO `line` (`id`, `nama`, `simbol`, `color`, `tipe`, `parrent`, `enabled`) VALUES (4, 'Ring Road', '', '', 2, 1, 1);
INSERT INTO `line` (`id`, `nama`, `simbol`, `color`, `tipe`, `parrent`, `enabled`) VALUES (5, 'Sungai', '', '#FFFFFF', 0, 1, 1);
INSERT INTO `line` (`id`, `nama`, `simbol`, `color`, `tipe`, `parrent`, `enabled`) VALUES (6, 'Selokan', '', '', 2, 5, 1);
INSERT INTO `line` (`id`, `nama`, `simbol`, `color`, `tipe`, `parrent`, `enabled`) VALUES (7, 'Jalan setapak', '', '#d45dd6', 0, 1, 1);
INSERT INTO `line` (`id`, `nama`, `simbol`, `color`, `tipe`, `parrent`, `enabled`) VALUES (8, 'Kali', '', '#16d958', 2, 5, 1);


#
# TABLE STRUCTURE FOR: log_bulanan
#

DROP TABLE IF EXISTS `log_bulanan`;

CREATE TABLE `log_bulanan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pend` int(11) NOT NULL,
  `wni_lk` int(11) DEFAULT NULL,
  `wni_pr` int(11) DEFAULT NULL,
  `kk` int(11) NOT NULL,
  `tgl` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `kk_lk` int(11) DEFAULT NULL,
  `kk_pr` int(11) DEFAULT NULL,
  `wna_lk` int(11) DEFAULT NULL,
  `wna_pr` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1611 DEFAULT CHARSET=latin1;

INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1, 97, 46, 51, 37, '2019-11-30 22:04:42', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (983, 97, 46, 51, 37, '2019-12-31 20:11:58', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (984, 97, 46, 51, 37, '2019-12-31 20:11:58', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (985, 97, 46, 51, 37, '2019-12-31 20:11:58', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (986, 97, 46, 51, 37, '2019-12-31 20:11:58', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (987, 97, 46, 51, 37, '2019-12-31 20:11:58', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (988, 97, 46, 51, 37, '2019-12-31 20:11:58', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (989, 97, 46, 51, 37, '2019-12-31 20:11:58', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (990, 97, 46, 51, 37, '2019-12-31 20:11:59', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (991, 97, 46, 51, 37, '2019-12-31 20:11:59', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (992, 97, 46, 51, 37, '2019-12-31 20:12:00', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (993, 97, 46, 51, 37, '2019-12-31 20:12:01', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (994, 97, 46, 51, 37, '2019-12-31 20:12:01', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (995, 97, 46, 51, 37, '2019-12-31 20:12:01', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (996, 97, 46, 51, 37, '2019-12-31 20:12:01', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (997, 97, 46, 51, 37, '2019-12-31 20:12:02', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (998, 97, 46, 51, 37, '2019-12-31 20:12:03', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (999, 97, 46, 51, 37, '2019-12-31 20:12:03', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1000, 97, 46, 51, 37, '2019-12-31 20:12:03', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1001, 97, 46, 51, 37, '2019-12-31 20:12:04', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1002, 97, 46, 51, 37, '2019-12-31 20:12:05', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1003, 97, 46, 51, 37, '2019-12-31 20:12:05', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1004, 97, 46, 51, 37, '2019-12-31 20:12:05', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1005, 97, 46, 51, 37, '2019-12-31 20:12:05', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1006, 97, 46, 51, 37, '2019-12-31 20:12:06', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1007, 97, 46, 51, 37, '2020-01-31 10:33:46', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1008, 97, 46, 51, 37, '2020-02-29 09:27:27', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1009, 97, 46, 51, 37, '2020-02-29 22:55:22', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1010, 97, 46, 51, 37, '2020-02-29 22:55:22', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1011, 97, 46, 51, 37, '2020-02-29 22:55:22', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1012, 97, 46, 51, 37, '2020-02-29 22:55:23', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1013, 97, 46, 51, 37, '2020-02-29 22:55:23', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1014, 97, 46, 51, 37, '2020-02-29 22:55:26', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1015, 97, 46, 51, 37, '2020-02-29 22:55:26', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1016, 97, 46, 51, 37, '2020-02-29 22:55:29', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1017, 97, 46, 51, 37, '2020-02-29 22:55:29', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1018, 97, 46, 51, 37, '2020-02-29 22:55:32', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1019, 97, 46, 51, 37, '2020-02-29 22:55:32', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1020, 97, 46, 51, 37, '2020-02-29 22:55:35', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1021, 97, 46, 51, 37, '2020-02-29 22:55:35', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1022, 97, 46, 51, 37, '2020-02-29 22:55:38', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1023, 97, 46, 51, 37, '2020-02-29 22:55:38', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1024, 97, 46, 51, 37, '2020-02-29 22:55:41', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1025, 97, 46, 51, 37, '2020-02-29 22:55:41', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1026, 97, 46, 51, 37, '2020-02-29 22:55:44', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1027, 97, 46, 51, 37, '2020-02-29 22:55:44', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1028, 97, 46, 51, 37, '2020-02-29 22:55:47', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1029, 97, 46, 51, 37, '2020-02-29 22:55:47', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1030, 97, 46, 51, 37, '2020-02-29 22:55:50', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1031, 97, 46, 51, 37, '2020-02-29 22:55:50', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1032, 97, 46, 51, 37, '2020-02-29 22:55:53', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1033, 97, 46, 51, 37, '2020-02-29 22:55:53', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1034, 97, 46, 51, 37, '2020-02-29 22:55:56', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1035, 97, 46, 51, 37, '2020-02-29 22:55:56', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1036, 97, 46, 51, 37, '2020-02-29 22:55:59', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1037, 97, 46, 51, 37, '2020-02-29 22:55:59', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1038, 97, 46, 51, 37, '2020-02-29 22:56:02', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1039, 97, 46, 51, 37, '2020-02-29 22:56:02', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1040, 97, 46, 51, 37, '2020-02-29 22:56:05', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1041, 97, 46, 51, 37, '2020-02-29 22:56:05', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1042, 97, 46, 51, 37, '2020-02-29 22:56:08', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1043, 97, 46, 51, 37, '2020-02-29 22:56:08', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1044, 97, 46, 51, 37, '2020-02-29 22:56:11', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1045, 97, 46, 51, 37, '2020-02-29 22:56:11', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1046, 97, 46, 51, 37, '2020-02-29 22:56:14', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1047, 97, 46, 51, 37, '2020-02-29 22:56:14', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1048, 97, 46, 51, 37, '2020-02-29 22:56:17', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1049, 97, 46, 51, 37, '2020-02-29 22:56:17', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1050, 97, 46, 51, 37, '2020-02-29 22:56:20', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1051, 97, 46, 51, 37, '2020-02-29 22:56:20', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1052, 97, 46, 51, 37, '2020-02-29 22:56:23', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1053, 97, 46, 51, 37, '2020-02-29 22:56:23', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1054, 97, 46, 51, 37, '2020-02-29 22:56:26', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1055, 97, 46, 51, 37, '2020-02-29 22:56:26', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1056, 97, 46, 51, 37, '2020-02-29 22:56:29', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1057, 97, 46, 51, 37, '2020-02-29 22:56:29', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1058, 97, 46, 51, 37, '2020-02-29 22:56:32', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1059, 97, 46, 51, 37, '2020-02-29 22:56:32', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1060, 97, 46, 51, 37, '2020-02-29 22:56:35', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1061, 97, 46, 51, 37, '2020-02-29 22:56:35', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1062, 97, 46, 51, 37, '2020-02-29 22:56:38', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1063, 97, 46, 51, 37, '2020-02-29 22:56:38', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1064, 97, 46, 51, 37, '2020-02-29 22:56:41', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1065, 97, 46, 51, 37, '2020-02-29 22:56:41', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1066, 97, 46, 51, 37, '2020-02-29 22:56:41', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1067, 97, 46, 51, 37, '2020-02-29 22:56:41', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1068, 97, 46, 51, 37, '2020-02-29 22:56:42', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1069, 97, 46, 51, 37, '2020-02-29 22:56:42', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1070, 97, 46, 51, 37, '2020-02-29 22:56:45', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1071, 97, 46, 51, 37, '2020-02-29 22:56:45', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1072, 97, 46, 51, 37, '2020-02-29 22:56:48', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1073, 97, 46, 51, 37, '2020-02-29 22:56:48', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1074, 97, 46, 51, 37, '2020-02-29 22:56:51', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1075, 97, 46, 51, 37, '2020-02-29 22:56:51', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1076, 97, 46, 51, 37, '2020-02-29 22:56:52', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1077, 97, 46, 51, 37, '2020-02-29 22:56:53', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1078, 97, 46, 51, 37, '2020-02-29 22:56:53', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1079, 97, 46, 51, 37, '2020-02-29 22:56:53', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1080, 97, 46, 51, 37, '2020-02-29 22:56:56', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1081, 97, 46, 51, 37, '2020-02-29 22:56:56', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1082, 97, 46, 51, 37, '2020-02-29 22:56:57', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1083, 97, 46, 51, 37, '2020-02-29 22:56:57', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1084, 97, 46, 51, 37, '2020-02-29 22:56:57', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1085, 97, 46, 51, 37, '2020-02-29 22:56:57', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1086, 97, 46, 51, 37, '2020-02-29 22:57:00', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1087, 97, 46, 51, 37, '2020-02-29 22:57:00', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1088, 97, 46, 51, 37, '2020-02-29 22:57:02', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1089, 97, 46, 51, 37, '2020-02-29 22:57:02', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1090, 97, 46, 51, 37, '2020-02-29 22:57:02', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1091, 97, 46, 51, 37, '2020-02-29 22:57:02', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1092, 97, 46, 51, 37, '2020-02-29 22:57:05', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1093, 97, 46, 51, 37, '2020-02-29 22:57:05', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1094, 97, 46, 51, 37, '2020-02-29 22:57:08', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1095, 97, 46, 51, 37, '2020-02-29 22:57:08', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1096, 97, 46, 51, 37, '2020-02-29 22:57:08', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1097, 97, 46, 51, 37, '2020-02-29 22:57:09', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1098, 97, 46, 51, 37, '2020-02-29 22:57:09', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1099, 97, 46, 51, 37, '2020-02-29 22:57:09', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1100, 97, 46, 51, 37, '2020-02-29 22:57:12', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1101, 97, 46, 51, 37, '2020-02-29 22:57:12', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1102, 97, 46, 51, 37, '2020-02-29 22:57:15', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1103, 97, 46, 51, 37, '2020-02-29 22:57:15', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1104, 97, 46, 51, 37, '2020-02-29 22:57:18', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1105, 97, 46, 51, 37, '2020-02-29 22:57:18', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1106, 97, 46, 51, 37, '2020-02-29 22:57:21', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1107, 97, 46, 51, 37, '2020-02-29 22:57:21', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1108, 97, 46, 51, 37, '2020-02-29 22:57:24', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1109, 97, 46, 51, 37, '2020-02-29 22:57:24', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1110, 97, 46, 51, 37, '2020-02-29 22:57:27', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1111, 97, 46, 51, 37, '2020-02-29 22:57:27', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1112, 97, 46, 51, 37, '2020-02-29 22:57:30', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1113, 97, 46, 51, 37, '2020-02-29 22:57:30', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1114, 97, 46, 51, 37, '2020-02-29 22:57:33', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1115, 97, 46, 51, 37, '2020-02-29 22:57:33', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1116, 97, 46, 51, 37, '2020-02-29 22:57:36', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1117, 97, 46, 51, 37, '2020-02-29 22:57:36', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1118, 97, 46, 51, 37, '2020-02-29 22:57:39', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1119, 97, 46, 51, 37, '2020-02-29 22:57:39', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1120, 97, 46, 51, 37, '2020-02-29 22:57:42', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1121, 97, 46, 51, 37, '2020-02-29 22:57:42', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1122, 97, 46, 51, 37, '2020-02-29 22:57:45', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1123, 97, 46, 51, 37, '2020-02-29 22:57:45', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1124, 97, 46, 51, 37, '2020-02-29 22:57:48', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1125, 97, 46, 51, 37, '2020-02-29 22:57:48', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1126, 97, 46, 51, 37, '2020-02-29 22:57:49', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1127, 97, 46, 51, 37, '2020-02-29 22:57:49', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1128, 97, 46, 51, 37, '2020-02-29 22:57:50', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1129, 97, 46, 51, 37, '2020-02-29 22:57:50', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1130, 97, 46, 51, 37, '2020-02-29 22:57:53', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1131, 97, 46, 51, 37, '2020-02-29 22:57:53', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1132, 97, 46, 51, 37, '2020-02-29 22:57:54', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1133, 97, 46, 51, 37, '2020-02-29 22:57:54', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1134, 97, 46, 51, 37, '2020-02-29 22:57:55', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1135, 97, 46, 51, 37, '2020-02-29 22:57:55', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1136, 97, 46, 51, 37, '2020-02-29 22:57:57', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1137, 97, 46, 51, 37, '2020-02-29 22:57:58', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1138, 97, 46, 51, 37, '2020-02-29 22:57:58', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1139, 97, 46, 51, 37, '2020-02-29 22:58:01', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1140, 97, 46, 51, 37, '2020-02-29 22:58:01', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1141, 97, 46, 51, 37, '2020-02-29 22:58:04', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1142, 97, 46, 51, 37, '2020-02-29 22:58:04', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1143, 97, 46, 51, 37, '2020-02-29 22:58:06', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1144, 97, 46, 51, 37, '2020-02-29 22:58:06', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1145, 97, 46, 51, 37, '2020-02-29 22:58:07', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1146, 97, 46, 51, 37, '2020-02-29 22:58:07', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1147, 97, 46, 51, 37, '2020-02-29 22:58:10', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1148, 97, 46, 51, 37, '2020-02-29 22:58:10', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1149, 97, 46, 51, 37, '2020-02-29 22:58:13', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1150, 97, 46, 51, 37, '2020-02-29 22:58:13', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1151, 97, 46, 51, 37, '2020-02-29 22:58:16', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1152, 97, 46, 51, 37, '2020-02-29 22:58:16', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1153, 97, 46, 51, 37, '2020-02-29 22:58:19', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1154, 97, 46, 51, 37, '2020-02-29 22:58:19', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1155, 97, 46, 51, 37, '2020-02-29 22:58:22', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1156, 97, 46, 51, 37, '2020-02-29 22:58:22', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1157, 97, 46, 51, 37, '2020-02-29 22:58:25', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1158, 97, 46, 51, 37, '2020-02-29 22:58:25', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1159, 97, 46, 51, 37, '2020-02-29 22:58:28', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1160, 97, 46, 51, 37, '2020-02-29 22:58:28', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1161, 97, 46, 51, 37, '2020-02-29 22:58:31', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1162, 97, 46, 51, 37, '2020-02-29 22:58:31', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1163, 97, 46, 51, 37, '2020-02-29 22:58:34', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1164, 97, 46, 51, 37, '2020-02-29 22:58:34', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1165, 97, 46, 51, 37, '2020-02-29 22:58:37', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1166, 97, 46, 51, 37, '2020-02-29 22:58:37', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1167, 97, 46, 51, 37, '2020-02-29 22:58:37', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1168, 97, 46, 51, 37, '2020-02-29 22:58:37', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1169, 97, 46, 51, 37, '2020-02-29 22:58:40', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1170, 97, 46, 51, 37, '2020-02-29 22:58:40', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1171, 97, 46, 51, 37, '2020-02-29 22:58:40', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1172, 97, 46, 51, 37, '2020-02-29 22:58:42', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1173, 97, 46, 51, 37, '2020-02-29 22:58:43', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1174, 97, 46, 51, 37, '2020-02-29 22:58:43', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1175, 97, 46, 51, 37, '2020-02-29 22:58:46', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1176, 97, 46, 51, 37, '2020-02-29 22:58:46', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1177, 97, 46, 51, 37, '2020-02-29 22:58:49', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1178, 97, 46, 51, 37, '2020-02-29 22:58:49', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1179, 97, 46, 51, 37, '2020-02-29 22:58:52', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1180, 97, 46, 51, 37, '2020-02-29 22:58:52', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1181, 97, 46, 51, 37, '2020-02-29 22:58:55', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1182, 97, 46, 51, 37, '2020-02-29 22:58:55', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1183, 97, 46, 51, 37, '2020-02-29 22:58:58', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1184, 97, 46, 51, 37, '2020-02-29 22:58:58', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1185, 97, 46, 51, 37, '2020-02-29 22:59:01', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1186, 97, 46, 51, 37, '2020-02-29 22:59:01', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1187, 97, 46, 51, 37, '2020-02-29 22:59:04', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1188, 97, 46, 51, 37, '2020-02-29 22:59:04', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1189, 97, 46, 51, 37, '2020-02-29 22:59:07', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1190, 97, 46, 51, 37, '2020-02-29 22:59:07', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1191, 97, 46, 51, 37, '2020-02-29 22:59:09', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1192, 97, 46, 51, 37, '2020-02-29 22:59:10', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1193, 97, 46, 51, 37, '2020-02-29 22:59:10', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1194, 97, 46, 51, 37, '2020-02-29 22:59:10', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1195, 97, 46, 51, 37, '2020-02-29 22:59:13', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1196, 97, 46, 51, 37, '2020-02-29 22:59:13', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1197, 97, 46, 51, 37, '2020-02-29 22:59:14', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1198, 97, 46, 51, 37, '2020-02-29 22:59:14', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1199, 97, 46, 51, 37, '2020-02-29 22:59:14', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1200, 97, 46, 51, 37, '2020-02-29 22:59:17', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1201, 97, 46, 51, 37, '2020-02-29 22:59:17', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1202, 97, 46, 51, 37, '2020-02-29 22:59:18', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1203, 97, 46, 51, 37, '2020-02-29 22:59:19', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1204, 97, 46, 51, 37, '2020-02-29 22:59:19', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1205, 97, 46, 51, 37, '2020-02-29 22:59:22', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1206, 97, 46, 51, 37, '2020-02-29 22:59:22', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1207, 97, 46, 51, 37, '2020-02-29 22:59:25', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1208, 97, 46, 51, 37, '2020-02-29 22:59:25', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1209, 97, 46, 51, 37, '2020-02-29 22:59:28', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1210, 97, 46, 51, 37, '2020-02-29 22:59:28', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1211, 97, 46, 51, 37, '2020-02-29 22:59:31', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1212, 97, 46, 51, 37, '2020-02-29 22:59:31', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1213, 97, 46, 51, 37, '2020-02-29 22:59:34', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1214, 97, 46, 51, 37, '2020-02-29 22:59:34', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1215, 97, 46, 51, 37, '2020-02-29 22:59:37', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1216, 97, 46, 51, 37, '2020-02-29 22:59:37', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1217, 97, 46, 51, 37, '2020-02-29 22:59:40', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1218, 97, 46, 51, 37, '2020-02-29 22:59:40', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1219, 97, 46, 51, 37, '2020-02-29 22:59:43', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1220, 97, 46, 51, 37, '2020-02-29 22:59:43', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1221, 97, 46, 51, 37, '2020-02-29 22:59:46', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1222, 97, 46, 51, 37, '2020-02-29 22:59:46', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1223, 97, 46, 51, 37, '2020-02-29 22:59:49', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1224, 97, 46, 51, 37, '2020-02-29 22:59:49', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1225, 97, 46, 51, 37, '2020-02-29 22:59:52', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1226, 97, 46, 51, 37, '2020-02-29 22:59:52', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1227, 97, 46, 51, 37, '2020-02-29 22:59:55', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1228, 97, 46, 51, 37, '2020-02-29 22:59:55', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1229, 97, 46, 51, 37, '2020-02-29 22:59:58', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1230, 97, 46, 51, 37, '2020-02-29 22:59:58', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1231, 97, 46, 51, 37, '2020-02-29 23:00:01', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1232, 97, 46, 51, 37, '2020-02-29 23:00:01', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1233, 97, 46, 51, 37, '2020-02-29 23:00:04', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1234, 97, 46, 51, 37, '2020-02-29 23:00:04', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1235, 97, 46, 51, 37, '2020-02-29 23:00:07', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1236, 97, 46, 51, 37, '2020-02-29 23:00:07', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1237, 97, 46, 51, 37, '2020-02-29 23:00:07', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1238, 97, 46, 51, 37, '2020-02-29 23:00:07', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1239, 97, 46, 51, 37, '2020-02-29 23:00:08', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1240, 97, 46, 51, 37, '2020-02-29 23:00:08', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1241, 97, 46, 51, 37, '2020-02-29 23:00:11', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1242, 97, 46, 51, 37, '2020-02-29 23:00:11', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1243, 97, 46, 51, 37, '2020-02-29 23:00:14', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1244, 97, 46, 51, 37, '2020-02-29 23:00:14', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1245, 97, 46, 51, 37, '2020-02-29 23:00:17', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1246, 97, 46, 51, 37, '2020-02-29 23:00:17', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1247, 97, 46, 51, 37, '2020-02-29 23:00:20', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1248, 97, 46, 51, 37, '2020-02-29 23:00:20', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1249, 97, 46, 51, 37, '2020-02-29 23:00:23', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1250, 97, 46, 51, 37, '2020-02-29 23:00:23', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1251, 97, 46, 51, 37, '2020-02-29 23:00:26', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1252, 97, 46, 51, 37, '2020-02-29 23:00:26', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1253, 97, 46, 51, 37, '2020-02-29 23:00:29', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1254, 97, 46, 51, 37, '2020-02-29 23:00:29', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1255, 97, 46, 51, 37, '2020-02-29 23:00:32', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1256, 97, 46, 51, 37, '2020-02-29 23:00:32', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1257, 97, 46, 51, 37, '2020-02-29 23:00:35', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1258, 97, 46, 51, 37, '2020-02-29 23:00:35', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1259, 97, 46, 51, 37, '2020-02-29 23:00:38', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1260, 97, 46, 51, 37, '2020-02-29 23:00:38', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1261, 97, 46, 51, 37, '2020-02-29 23:00:41', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1262, 97, 46, 51, 37, '2020-02-29 23:00:41', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1263, 97, 46, 51, 37, '2020-02-29 23:00:44', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1264, 97, 46, 51, 37, '2020-02-29 23:00:44', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1265, 97, 46, 51, 37, '2020-02-29 23:00:47', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1266, 97, 46, 51, 37, '2020-02-29 23:00:47', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1267, 97, 46, 51, 37, '2020-02-29 23:00:50', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1268, 97, 46, 51, 37, '2020-02-29 23:00:50', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1269, 97, 46, 51, 37, '2020-02-29 23:00:53', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1270, 97, 46, 51, 37, '2020-02-29 23:00:53', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1271, 97, 46, 51, 37, '2020-02-29 23:00:56', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1272, 97, 46, 51, 37, '2020-02-29 23:00:56', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1273, 97, 46, 51, 37, '2020-02-29 23:00:59', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1274, 97, 46, 51, 37, '2020-02-29 23:00:59', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1275, 97, 46, 51, 37, '2020-02-29 23:01:02', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1276, 97, 46, 51, 37, '2020-02-29 23:01:02', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1277, 97, 46, 51, 37, '2020-02-29 23:01:05', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1278, 97, 46, 51, 37, '2020-02-29 23:01:05', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1279, 97, 46, 51, 37, '2020-02-29 23:01:08', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1280, 97, 46, 51, 37, '2020-02-29 23:01:08', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1281, 97, 46, 51, 37, '2020-02-29 23:01:11', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1282, 97, 46, 51, 37, '2020-02-29 23:01:11', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1283, 97, 46, 51, 37, '2020-02-29 23:01:14', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1284, 97, 46, 51, 37, '2020-02-29 23:01:14', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1285, 97, 46, 51, 37, '2020-02-29 23:01:17', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1286, 97, 46, 51, 37, '2020-02-29 23:01:17', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1287, 97, 46, 51, 37, '2020-02-29 23:01:20', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1288, 97, 46, 51, 37, '2020-02-29 23:01:20', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1289, 97, 46, 51, 37, '2020-02-29 23:01:23', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1290, 97, 46, 51, 37, '2020-02-29 23:01:23', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1291, 97, 46, 51, 37, '2020-02-29 23:01:26', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1292, 97, 46, 51, 37, '2020-02-29 23:01:26', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1293, 97, 46, 51, 37, '2020-02-29 23:01:29', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1294, 97, 46, 51, 37, '2020-02-29 23:01:29', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1295, 97, 46, 51, 37, '2020-02-29 23:01:32', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1296, 97, 46, 51, 37, '2020-02-29 23:01:32', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1297, 97, 46, 51, 37, '2020-02-29 23:01:35', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1298, 97, 46, 51, 37, '2020-02-29 23:01:35', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1299, 97, 46, 51, 37, '2020-02-29 23:01:38', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1300, 97, 46, 51, 37, '2020-02-29 23:01:38', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1301, 97, 46, 51, 37, '2020-02-29 23:01:41', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1302, 97, 46, 51, 37, '2020-02-29 23:01:41', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1303, 97, 46, 51, 37, '2020-02-29 23:01:44', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1304, 97, 46, 51, 37, '2020-02-29 23:01:44', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1305, 97, 46, 51, 37, '2020-02-29 23:01:47', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1306, 97, 46, 51, 37, '2020-02-29 23:01:47', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1307, 97, 46, 51, 37, '2020-02-29 23:01:50', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1308, 97, 46, 51, 37, '2020-02-29 23:01:50', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1309, 97, 46, 51, 37, '2020-02-29 23:01:53', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1310, 97, 46, 51, 37, '2020-02-29 23:01:53', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1311, 97, 46, 51, 37, '2020-02-29 23:01:56', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1312, 97, 46, 51, 37, '2020-02-29 23:01:56', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1313, 97, 46, 51, 37, '2020-02-29 23:01:59', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1314, 97, 46, 51, 37, '2020-02-29 23:01:59', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1315, 97, 46, 51, 37, '2020-02-29 23:02:02', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1316, 97, 46, 51, 37, '2020-02-29 23:02:02', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1317, 97, 46, 51, 37, '2020-02-29 23:02:05', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1318, 97, 46, 51, 37, '2020-02-29 23:02:05', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1319, 97, 46, 51, 37, '2020-02-29 23:02:09', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1320, 97, 46, 51, 37, '2020-02-29 23:02:09', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1321, 97, 46, 51, 37, '2020-02-29 23:02:12', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1322, 97, 46, 51, 37, '2020-02-29 23:02:12', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1323, 97, 46, 51, 37, '2020-02-29 23:02:15', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1324, 97, 46, 51, 37, '2020-02-29 23:02:15', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1325, 97, 46, 51, 37, '2020-02-29 23:02:17', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1326, 97, 46, 51, 37, '2020-02-29 23:02:17', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1327, 97, 46, 51, 37, '2020-02-29 23:02:21', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1328, 97, 46, 51, 37, '2020-02-29 23:02:21', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1329, 97, 46, 51, 37, '2020-02-29 23:02:23', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1330, 97, 46, 51, 37, '2020-02-29 23:02:24', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1331, 97, 46, 51, 37, '2020-02-29 23:02:27', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1332, 97, 46, 51, 37, '2020-02-29 23:02:27', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1333, 97, 46, 51, 37, '2020-02-29 23:02:29', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1334, 97, 46, 51, 37, '2020-02-29 23:02:30', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1335, 97, 46, 51, 37, '2020-02-29 23:02:33', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1336, 97, 46, 51, 37, '2020-02-29 23:02:33', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1337, 97, 46, 51, 37, '2020-02-29 23:02:36', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1338, 97, 46, 51, 37, '2020-02-29 23:02:36', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1339, 97, 46, 51, 37, '2020-02-29 23:02:39', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1340, 97, 46, 51, 37, '2020-02-29 23:02:39', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1341, 97, 46, 51, 37, '2020-02-29 23:02:42', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1342, 97, 46, 51, 37, '2020-02-29 23:02:42', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1343, 97, 46, 51, 37, '2020-02-29 23:02:44', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1344, 97, 46, 51, 37, '2020-02-29 23:02:45', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1345, 97, 46, 51, 37, '2020-02-29 23:02:48', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1346, 97, 46, 51, 37, '2020-02-29 23:02:48', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1347, 97, 46, 51, 37, '2020-02-29 23:02:51', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1348, 97, 46, 51, 37, '2020-02-29 23:02:51', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1349, 97, 46, 51, 37, '2020-02-29 23:02:53', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1350, 97, 46, 51, 37, '2020-02-29 23:02:53', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1351, 97, 46, 51, 37, '2020-02-29 23:02:57', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1352, 97, 46, 51, 37, '2020-02-29 23:02:57', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1353, 97, 46, 51, 37, '2020-02-29 23:02:59', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1354, 97, 46, 51, 37, '2020-02-29 23:03:00', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1355, 97, 46, 51, 37, '2020-02-29 23:03:03', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1356, 97, 46, 51, 37, '2020-02-29 23:03:03', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1357, 97, 46, 51, 37, '2020-02-29 23:03:05', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1358, 97, 46, 51, 37, '2020-02-29 23:03:06', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1359, 97, 46, 51, 37, '2020-02-29 23:03:08', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1360, 97, 46, 51, 37, '2020-02-29 23:03:09', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1361, 97, 46, 51, 37, '2020-02-29 23:03:12', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1362, 97, 46, 51, 37, '2020-02-29 23:03:12', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1363, 97, 46, 51, 37, '2020-02-29 23:03:15', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1364, 97, 46, 51, 37, '2020-02-29 23:03:15', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1365, 97, 46, 51, 37, '2020-02-29 23:03:18', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1366, 97, 46, 51, 37, '2020-02-29 23:03:18', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1367, 97, 46, 51, 37, '2020-02-29 23:03:21', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1368, 97, 46, 51, 37, '2020-02-29 23:03:21', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1369, 97, 46, 51, 37, '2020-02-29 23:03:24', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1370, 97, 46, 51, 37, '2020-02-29 23:03:24', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1371, 97, 46, 51, 37, '2020-02-29 23:03:27', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1372, 97, 46, 51, 37, '2020-02-29 23:03:27', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1373, 97, 46, 51, 37, '2020-02-29 23:03:30', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1374, 97, 46, 51, 37, '2020-02-29 23:03:30', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1375, 97, 46, 51, 37, '2020-02-29 23:03:33', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1376, 97, 46, 51, 37, '2020-02-29 23:03:33', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1377, 97, 46, 51, 37, '2020-02-29 23:03:36', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1378, 97, 46, 51, 37, '2020-02-29 23:03:36', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1379, 97, 46, 51, 37, '2020-02-29 23:03:38', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1380, 97, 46, 51, 37, '2020-02-29 23:03:38', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1381, 97, 46, 51, 37, '2020-02-29 23:03:42', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1382, 97, 46, 51, 37, '2020-02-29 23:03:42', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1383, 97, 46, 51, 37, '2020-02-29 23:03:45', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1384, 97, 46, 51, 37, '2020-02-29 23:03:45', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1385, 97, 46, 51, 37, '2020-02-29 23:03:47', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1386, 97, 46, 51, 37, '2020-02-29 23:03:47', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1387, 97, 46, 51, 37, '2020-02-29 23:03:51', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1388, 97, 46, 51, 37, '2020-02-29 23:03:51', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1389, 97, 46, 51, 37, '2020-02-29 23:03:53', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1390, 97, 46, 51, 37, '2020-02-29 23:03:53', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1391, 97, 46, 51, 37, '2020-02-29 23:03:57', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1392, 97, 46, 51, 37, '2020-02-29 23:03:57', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1393, 97, 46, 51, 37, '2020-02-29 23:03:59', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1394, 97, 46, 51, 37, '2020-02-29 23:03:59', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1395, 97, 46, 51, 37, '2020-02-29 23:04:02', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1396, 97, 46, 51, 37, '2020-02-29 23:04:03', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1397, 97, 46, 51, 37, '2020-02-29 23:04:06', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1398, 97, 46, 51, 37, '2020-02-29 23:04:06', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1399, 97, 46, 51, 37, '2020-02-29 23:04:09', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1400, 97, 46, 51, 37, '2020-02-29 23:04:09', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1401, 97, 46, 51, 37, '2020-02-29 23:04:11', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1402, 97, 46, 51, 37, '2020-02-29 23:04:11', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1403, 97, 46, 51, 37, '2020-02-29 23:04:15', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1404, 97, 46, 51, 37, '2020-02-29 23:04:15', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1405, 97, 46, 51, 37, '2020-02-29 23:04:17', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1406, 97, 46, 51, 37, '2020-02-29 23:04:17', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1407, 97, 46, 51, 37, '2020-02-29 23:04:21', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1408, 97, 46, 51, 37, '2020-02-29 23:04:21', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1409, 97, 46, 51, 37, '2020-02-29 23:04:23', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1410, 97, 46, 51, 37, '2020-02-29 23:04:23', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1411, 97, 46, 51, 37, '2020-02-29 23:04:26', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1412, 97, 46, 51, 37, '2020-02-29 23:04:26', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1413, 97, 46, 51, 37, '2020-02-29 23:04:29', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1414, 97, 46, 51, 37, '2020-02-29 23:04:29', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1415, 97, 46, 51, 37, '2020-02-29 23:04:32', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1416, 97, 46, 51, 37, '2020-02-29 23:04:32', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1417, 97, 46, 51, 37, '2020-02-29 23:04:33', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1418, 97, 46, 51, 37, '2020-02-29 23:04:34', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1419, 97, 46, 51, 37, '2020-02-29 23:04:34', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1420, 97, 46, 51, 37, '2020-02-29 23:04:37', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1421, 97, 46, 51, 37, '2020-02-29 23:04:37', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1422, 97, 46, 51, 37, '2020-02-29 23:04:40', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1423, 97, 46, 51, 37, '2020-02-29 23:04:40', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1424, 97, 46, 51, 37, '2020-02-29 23:04:43', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1425, 97, 46, 51, 37, '2020-02-29 23:04:43', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1426, 97, 46, 51, 37, '2020-02-29 23:04:45', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1427, 97, 46, 51, 37, '2020-02-29 23:04:45', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1428, 97, 46, 51, 37, '2020-02-29 23:04:45', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1429, 97, 46, 51, 37, '2020-02-29 23:04:48', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1430, 97, 46, 51, 37, '2020-02-29 23:04:48', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1431, 97, 46, 51, 37, '2020-02-29 23:04:48', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1432, 97, 46, 51, 37, '2020-03-01 11:22:18', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1433, 97, 46, 51, 37, '2020-03-31 23:13:31', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1434, 97, 46, 51, 37, '2020-03-31 23:13:31', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1435, 97, 46, 51, 37, '2020-03-31 23:13:31', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1436, 97, 46, 51, 37, '2020-03-31 23:13:31', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1437, 97, 46, 51, 37, '2020-03-31 23:13:31', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1438, 97, 46, 51, 37, '2020-03-31 23:13:31', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1439, 97, 46, 51, 37, '2020-03-31 23:13:32', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1440, 97, 46, 51, 37, '2020-03-31 23:13:32', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1441, 97, 46, 51, 37, '2020-03-31 23:13:32', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1442, 97, 46, 51, 37, '2020-03-31 23:13:35', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1443, 97, 46, 51, 37, '2020-03-31 23:13:35', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1444, 97, 46, 51, 37, '2020-03-31 23:13:35', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1445, 97, 46, 51, 37, '2020-03-31 23:13:38', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1446, 97, 46, 51, 37, '2020-03-31 23:13:38', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1447, 97, 46, 51, 37, '2020-03-31 23:13:38', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1448, 97, 46, 51, 37, '2020-03-31 23:13:41', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1449, 97, 46, 51, 37, '2020-03-31 23:13:41', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1450, 97, 46, 51, 37, '2020-03-31 23:13:41', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1451, 97, 46, 51, 37, '2020-03-31 23:13:42', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1452, 97, 46, 51, 37, '2020-03-31 23:13:42', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1453, 97, 46, 51, 37, '2020-03-31 23:13:43', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1454, 97, 46, 51, 37, '2020-03-31 23:13:43', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1455, 97, 46, 51, 37, '2020-03-31 23:13:43', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1456, 97, 46, 51, 37, '2020-03-31 23:13:46', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1457, 97, 46, 51, 37, '2020-03-31 23:13:46', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1458, 97, 46, 51, 37, '2020-03-31 23:13:46', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1459, 97, 46, 51, 37, '2020-03-31 23:13:49', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1460, 97, 46, 51, 37, '2020-03-31 23:13:49', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1461, 97, 46, 51, 37, '2020-03-31 23:13:49', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1462, 97, 46, 51, 37, '2020-03-31 23:13:52', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1463, 97, 46, 51, 37, '2020-03-31 23:13:52', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1464, 97, 46, 51, 37, '2020-03-31 23:13:52', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1465, 97, 46, 51, 37, '2020-03-31 23:13:55', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1466, 97, 46, 51, 37, '2020-03-31 23:13:55', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1467, 97, 46, 51, 37, '2020-03-31 23:13:55', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1468, 97, 46, 51, 37, '2020-03-31 23:13:58', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1469, 97, 46, 51, 37, '2020-03-31 23:13:58', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1470, 97, 46, 51, 37, '2020-03-31 23:13:58', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1471, 97, 46, 51, 37, '2020-03-31 23:14:01', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1472, 97, 46, 51, 37, '2020-03-31 23:14:01', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1473, 97, 46, 51, 37, '2020-03-31 23:14:01', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1474, 97, 46, 51, 37, '2020-03-31 23:14:04', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1475, 97, 46, 51, 37, '2020-03-31 23:14:04', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1476, 97, 46, 51, 37, '2020-03-31 23:14:04', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1477, 97, 46, 51, 37, '2020-03-31 23:14:07', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1478, 97, 46, 51, 37, '2020-03-31 23:14:07', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1479, 97, 46, 51, 37, '2020-03-31 23:14:07', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1480, 97, 46, 51, 37, '2020-03-31 23:14:10', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1481, 97, 46, 51, 37, '2020-03-31 23:14:10', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1482, 97, 46, 51, 37, '2020-03-31 23:14:10', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1483, 97, 46, 51, 37, '2020-03-31 23:14:13', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1484, 97, 46, 51, 37, '2020-03-31 23:14:13', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1485, 97, 46, 51, 37, '2020-03-31 23:14:13', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1486, 97, 46, 51, 37, '2020-03-31 23:14:16', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1487, 97, 46, 51, 37, '2020-03-31 23:14:16', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1488, 97, 46, 51, 37, '2020-03-31 23:14:16', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1489, 97, 46, 51, 37, '2020-03-31 23:14:19', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1490, 97, 46, 51, 37, '2020-03-31 23:14:19', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1491, 97, 46, 51, 37, '2020-03-31 23:14:19', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1492, 97, 46, 51, 37, '2020-03-31 23:14:20', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1493, 97, 46, 51, 37, '2020-03-31 23:14:21', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1494, 97, 46, 51, 37, '2020-03-31 23:14:21', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1495, 97, 46, 51, 37, '2020-03-31 23:14:21', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1496, 97, 46, 51, 37, '2020-03-31 23:14:24', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1497, 97, 46, 51, 37, '2020-03-31 23:14:24', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1498, 97, 46, 51, 37, '2020-03-31 23:14:24', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1499, 97, 46, 51, 37, '2020-03-31 23:14:27', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1500, 97, 46, 51, 37, '2020-03-31 23:14:27', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1501, 97, 46, 51, 37, '2020-03-31 23:14:27', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1502, 97, 46, 51, 37, '2020-03-31 23:14:30', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1503, 97, 46, 51, 37, '2020-03-31 23:14:30', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1504, 97, 46, 51, 37, '2020-03-31 23:14:30', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1505, 97, 46, 51, 37, '2020-03-31 23:14:33', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1506, 97, 46, 51, 37, '2020-03-31 23:14:33', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1507, 97, 46, 51, 37, '2020-03-31 23:14:33', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1508, 97, 46, 51, 37, '2020-03-31 23:14:36', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1509, 97, 46, 51, 37, '2020-03-31 23:14:36', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1510, 97, 46, 51, 37, '2020-03-31 23:14:36', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1511, 97, 46, 51, 37, '2020-03-31 23:14:39', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1512, 97, 46, 51, 37, '2020-03-31 23:14:39', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1513, 97, 46, 51, 37, '2020-03-31 23:14:39', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1514, 97, 46, 51, 37, '2020-03-31 23:14:42', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1515, 97, 46, 51, 37, '2020-03-31 23:14:42', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1516, 97, 46, 51, 37, '2020-03-31 23:14:42', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1517, 97, 46, 51, 37, '2020-03-31 23:14:45', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1518, 97, 46, 51, 37, '2020-03-31 23:14:45', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1519, 97, 46, 51, 37, '2020-03-31 23:14:45', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1520, 97, 46, 51, 37, '2020-03-31 23:14:48', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1521, 97, 46, 51, 37, '2020-03-31 23:14:48', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1522, 97, 46, 51, 37, '2020-03-31 23:14:48', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1523, 97, 46, 51, 37, '2020-03-31 23:14:51', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1524, 97, 46, 51, 37, '2020-03-31 23:14:51', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1525, 97, 46, 51, 37, '2020-03-31 23:14:51', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1526, 97, 46, 51, 37, '2020-03-31 23:14:54', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1527, 97, 46, 51, 37, '2020-03-31 23:14:54', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1528, 97, 46, 51, 37, '2020-03-31 23:14:54', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1529, 97, 46, 51, 37, '2020-03-31 23:14:57', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1530, 97, 46, 51, 37, '2020-03-31 23:14:57', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1531, 97, 46, 51, 37, '2020-03-31 23:14:57', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1532, 97, 46, 51, 37, '2020-03-31 23:15:00', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1533, 97, 46, 51, 37, '2020-03-31 23:15:00', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1534, 97, 46, 51, 37, '2020-03-31 23:15:00', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1535, 97, 46, 51, 37, '2020-03-31 23:15:03', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1536, 97, 46, 51, 37, '2020-03-31 23:15:03', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1537, 97, 46, 51, 37, '2020-03-31 23:15:03', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1538, 97, 46, 51, 37, '2020-03-31 23:15:06', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1539, 97, 46, 51, 37, '2020-03-31 23:15:06', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1540, 97, 46, 51, 37, '2020-03-31 23:15:06', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1541, 97, 46, 51, 37, '2020-03-31 23:15:09', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1542, 97, 46, 51, 37, '2020-03-31 23:15:09', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1543, 97, 46, 51, 37, '2020-03-31 23:15:09', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1544, 97, 46, 51, 37, '2020-03-31 23:15:12', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1545, 97, 46, 51, 37, '2020-03-31 23:15:12', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1546, 97, 46, 51, 37, '2020-03-31 23:15:12', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1547, 97, 46, 51, 37, '2020-03-31 23:15:15', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1548, 97, 46, 51, 37, '2020-03-31 23:15:15', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1549, 97, 46, 51, 37, '2020-03-31 23:15:15', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1550, 97, 46, 51, 37, '2020-03-31 23:15:18', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1551, 97, 46, 51, 37, '2020-03-31 23:15:18', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1552, 97, 46, 51, 37, '2020-03-31 23:15:18', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1553, 97, 46, 51, 37, '2020-03-31 23:15:21', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1554, 97, 46, 51, 37, '2020-03-31 23:15:21', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1555, 97, 46, 51, 37, '2020-03-31 23:15:21', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1556, 97, 46, 51, 37, '2020-03-31 23:15:24', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1557, 97, 46, 51, 37, '2020-03-31 23:15:24', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1558, 97, 46, 51, 37, '2020-03-31 23:15:24', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1559, 97, 46, 51, 37, '2020-03-31 23:15:27', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1560, 97, 46, 51, 37, '2020-03-31 23:15:27', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1561, 97, 46, 51, 37, '2020-03-31 23:15:27', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1562, 97, 46, 51, 37, '2020-03-31 23:15:30', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1563, 97, 46, 51, 37, '2020-03-31 23:15:30', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1564, 97, 46, 51, 37, '2020-03-31 23:15:30', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1565, 97, 46, 51, 37, '2020-03-31 23:15:33', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1566, 97, 46, 51, 37, '2020-03-31 23:15:33', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1567, 97, 46, 51, 37, '2020-03-31 23:15:33', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1568, 97, 46, 51, 37, '2020-03-31 23:15:36', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1569, 97, 46, 51, 37, '2020-03-31 23:15:36', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1570, 97, 46, 51, 37, '2020-03-31 23:15:36', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1571, 97, 46, 51, 37, '2020-03-31 23:15:39', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1572, 97, 46, 51, 37, '2020-03-31 23:15:39', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1573, 97, 46, 51, 37, '2020-03-31 23:15:39', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1574, 97, 46, 51, 37, '2020-03-31 23:15:42', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1575, 97, 46, 51, 37, '2020-03-31 23:15:42', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1576, 97, 46, 51, 37, '2020-03-31 23:15:42', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1577, 97, 46, 51, 37, '2020-03-31 23:15:45', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1578, 97, 46, 51, 37, '2020-03-31 23:15:45', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1579, 97, 46, 51, 37, '2020-03-31 23:15:45', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1580, 97, 46, 51, 37, '2020-03-31 23:15:48', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1581, 97, 46, 51, 37, '2020-03-31 23:15:48', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1582, 97, 46, 51, 37, '2020-03-31 23:15:48', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1583, 97, 46, 51, 37, '2020-03-31 23:15:51', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1584, 97, 46, 51, 37, '2020-03-31 23:15:51', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1585, 97, 46, 51, 37, '2020-03-31 23:15:51', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1586, 97, 46, 51, 37, '2020-03-31 23:15:54', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1587, 97, 46, 51, 37, '2020-03-31 23:15:54', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1588, 97, 46, 51, 37, '2020-03-31 23:15:54', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1589, 97, 46, 51, 37, '2020-03-31 23:15:57', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1590, 97, 46, 51, 37, '2020-03-31 23:15:57', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1591, 97, 46, 51, 37, '2020-03-31 23:15:57', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1592, 97, 46, 51, 37, '2020-03-31 23:15:57', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1593, 97, 46, 51, 37, '2020-03-31 23:15:58', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1594, 97, 46, 51, 37, '2020-03-31 23:15:58', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1595, 97, 46, 51, 37, '2020-03-31 23:15:58', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1596, 97, 46, 51, 37, '2020-03-31 23:16:01', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1597, 97, 46, 51, 37, '2020-04-30 22:07:25', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1598, 97, 46, 51, 37, '2020-04-30 22:07:25', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1599, 97, 46, 51, 37, '2020-04-30 22:07:25', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1600, 97, 46, 51, 37, '2020-04-30 22:07:25', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1601, 97, 46, 51, 37, '2020-04-30 22:07:26', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1602, 97, 46, 51, 37, '2020-04-30 22:07:26', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1603, 97, 46, 51, 37, '2020-04-30 22:07:26', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1604, 97, 46, 51, 37, '2020-04-30 22:07:32', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1605, 97, 46, 51, 37, '2020-06-01 00:14:43', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1606, 97, 46, 51, 37, '2020-07-01 00:59:28', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1607, 97, 46, 51, 37, '2020-08-01 00:09:12', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1608, 97, 46, 51, 37, '2020-09-01 00:33:33', 28, 9, 0, 0);
INSERT INTO `log_bulanan` (`id`, `pend`, `wni_lk`, `wni_pr`, `kk`, `tgl`, `kk_lk`, `kk_pr`, `wna_lk`, `wna_pr`) VALUES (1610, 97, 46, 51, 37, '2020-11-29 08:33:41', 28, 9, 0, 0);


#
# TABLE STRUCTURE FOR: log_ekspor
#

DROP TABLE IF EXISTS `log_ekspor`;

CREATE TABLE `log_ekspor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tgl_ekspor` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `kode_ekspor` varchar(100) NOT NULL,
  `semua` int(1) NOT NULL DEFAULT '1',
  `dari_tgl` date DEFAULT NULL,
  `total` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: log_keluarga
#

DROP TABLE IF EXISTS `log_keluarga`;

CREATE TABLE `log_keluarga` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `id_kk` int(11) NOT NULL,
  `kk_sex` tinyint(2) DEFAULT NULL,
  `id_peristiwa` int(4) NOT NULL,
  `tgl_peristiwa` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_kk` (`id_kk`,`id_peristiwa`,`tgl_peristiwa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: log_perubahan_penduduk
#

DROP TABLE IF EXISTS `log_perubahan_penduduk`;

CREATE TABLE `log_perubahan_penduduk` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_pend` int(11) NOT NULL,
  `id_cluster` varchar(200) NOT NULL,
  `tanggal` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: log_surat
#

DROP TABLE IF EXISTS `log_surat`;

CREATE TABLE `log_surat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_format_surat` int(3) NOT NULL,
  `id_pend` int(11) DEFAULT NULL,
  `id_pamong` int(4) NOT NULL,
  `id_user` int(4) NOT NULL,
  `tanggal` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `bulan` varchar(2) DEFAULT NULL,
  `tahun` varchar(4) DEFAULT NULL,
  `no_surat` varchar(20) DEFAULT NULL,
  `nama_surat` varchar(100) DEFAULT NULL,
  `lampiran` varchar(100) DEFAULT NULL,
  `nik_non_warga` decimal(16,0) DEFAULT NULL,
  `nama_non_warga` varchar(100) DEFAULT NULL,
  `keterangan` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `log_surat` (`id`, `id_format_surat`, `id_pend`, `id_pamong`, `id_user`, `tanggal`, `bulan`, `tahun`, `no_surat`, `nama_surat`, `lampiran`, `nik_non_warga`, `nama_non_warga`, `keterangan`) VALUES (7, 2, 1, 14, 1, '2019-03-30 10:36:04', '03', '2019', '1', 'surat_ket_penduduk_5201142005716996_2019-03-30_1.rtf', '', NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: lokasi
#

DROP TABLE IF EXISTS `lokasi`;

CREATE TABLE `lokasi` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `desk` text NOT NULL,
  `nama` varchar(50) NOT NULL,
  `enabled` int(11) NOT NULL DEFAULT '1',
  `lat` varchar(30) DEFAULT NULL,
  `lng` varchar(30) DEFAULT NULL,
  `ref_point` int(9) NOT NULL,
  `foto` varchar(100) DEFAULT NULL,
  `id_cluster` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ref_point` (`ref_point`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO `lokasi` (`id`, `desk`, `nama`, `enabled`, `lat`, `lng`, `ref_point`, `foto`, `id_cluster`) VALUES (1, 'Sekolah Menengah Pertama', 'SMP', 1, '-8.49563254042209', '116.04755401611328', 5, '', 0);
INSERT INTO `lokasi` (`id`, `desk`, `nama`, `enabled`, `lat`, `lng`, `ref_point`, `foto`, `id_cluster`) VALUES (2, 'Sekolah Menengah Atas', 'SMA', 1, '-8.485106175017545', '116.04549407958986', 4, '', 0);
INSERT INTO `lokasi` (`id`, `desk`, `nama`, `enabled`, `lat`, `lng`, `ref_point`, `foto`, `id_cluster`) VALUES (3, 'Sarana Pendidikan', 'Puskesmas Husada', 1, '-8.478145032940077', '116.0394859313965', 9, '', 0);


#
# TABLE STRUCTURE FOR: media_sosial
#

DROP TABLE IF EXISTS `media_sosial`;

CREATE TABLE `media_sosial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gambar` text NOT NULL,
  `link` text,
  `nama` varchar(100) NOT NULL,
  `tipe` tinyint(1) DEFAULT '1',
  `enabled` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `media_sosial` (`id`, `gambar`, `link`, `nama`, `tipe`, `enabled`) VALUES (1, 'fb.png', 'https://www.facebook.com/groups/OpenSID/', 'Facebook', 1, 1);
INSERT INTO `media_sosial` (`id`, `gambar`, `link`, `nama`, `tipe`, `enabled`) VALUES (2, 'twt.png', '', 'Twitter', 1, 1);
INSERT INTO `media_sosial` (`id`, `gambar`, `link`, `nama`, `tipe`, `enabled`) VALUES (4, 'yb.png', '', 'YouTube', 1, 1);
INSERT INTO `media_sosial` (`id`, `gambar`, `link`, `nama`, `tipe`, `enabled`) VALUES (5, 'ins.png', '', 'Instagram', 1, 1);
INSERT INTO `media_sosial` (`id`, `gambar`, `link`, `nama`, `tipe`, `enabled`) VALUES (6, 'wa.png', '', 'WhatsApp', 1, 1);
INSERT INTO `media_sosial` (`id`, `gambar`, `link`, `nama`, `tipe`, `enabled`) VALUES (7, 'tg.png', NULL, 'Telegram', 1, 2);


#
# TABLE STRUCTURE FOR: menu
#

DROP TABLE IF EXISTS `menu`;

CREATE TABLE `menu` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `nama` varchar(50) NOT NULL,
  `link` varchar(500) NOT NULL,
  `tipe` int(4) NOT NULL,
  `parrent` int(4) NOT NULL DEFAULT '1',
  `link_tipe` tinyint(1) NOT NULL DEFAULT '0',
  `enabled` int(11) NOT NULL DEFAULT '1',
  `urut` int(5) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=117 DEFAULT CHARSET=utf8;

INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (16, 'Profil Desa', 'artikel/32', 1, 1, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (17, 'Pemerintahan Desa', 'artikel/85', 1, 1, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (19, 'Lembaga Masyarakat', 'artikel/38', 1, 1, 1, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (23, 'Teras Desa', '', 2, 1, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (24, 'Data Desa', 'artikel/97', 1, 1, 0, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (31, 'Data Wilayah Administratif', 'wilayah', 3, 24, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (32, 'Data Pendidikan dalam KK', 'statistik/0', 3, 24, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (33, 'Data Pendidikan Ditempuh', 'statistik/14', 3, 24, 0, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (34, 'Data Pekerjaan', 'statistik/1', 3, 24, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (35, 'Data Agama', 'statistik/3', 3, 24, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (36, 'Data Jenis Kelamin', 'statistik/4', 3, 24, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (40, 'Data Golongan Darah', 'statistik/7', 3, 24, 1, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (51, 'Data Kelompok Umur', 'statistik/12', 3, 24, 1, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (52, 'Data Penerima Raskin', 'statistik_k/2', 3, 24, 1, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (53, 'Data Penerima Jamkesmas', 'statistik_k/3', 3, 24, 1, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (55, 'Profil Wilayah Desa', 'artikel/33', 3, 16, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (56, 'Profil Masyarakat Desa', 'artikel/34', 3, 16, 1, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (57, 'Visi dan Misi', 'artikel/93', 3, 17, 0, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (58, 'Pemerintah Desa', 'artikel/92', 3, 17, 0, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (59, 'Badan Permusyawaratan Desa', 'artikel/37', 3, 17, 0, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (62, 'Berita Desa', '', 2, 1, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (63, 'Agenda Desa', 'artikel/41', 2, 1, 1, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (64, 'Peraturan Desa', 'peraturan', 2, 1, 1, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (65, 'Panduan Layanan Desa', '#', 2, 1, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (66, 'Produk Desa', 'produk', 2, 1, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (68, 'Undang undang', 'artikel/42', 3, 64, 1, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (69, 'Peraturan Pemerintah', 'artikel/43', 3, 64, 1, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (70, 'Peraturan Daerah', '', 3, 64, 1, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (71, 'Peraturan Bupati', '', 3, 64, 1, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (72, 'Peraturan Bersama KaDes', '', 3, 64, 1, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (73, 'Informasi Publik', '#', 2, 1, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (75, 'Rencana Kerja Anggaran', '', 3, 73, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (76, 'RAPB Desa', '', 3, 73, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (77, 'APB Desa', '', 3, 73, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (78, 'DPA', '', 3, 73, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (80, 'Profil Potensi Desa', 'artikel/59', 3, 16, 1, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (84, 'LKMD', 'artikel/62', 3, 18, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (85, 'PKK', 'artikel/63', 3, 18, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (86, 'Karang Taruna', 'artikel/64', 3, 18, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (87, 'RT RW', 'artikel/65', 3, 18, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (88, 'Linmas', 'artikel/70', 3, 18, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (89, 'TKP2KDes', 'artikel/66', 3, 18, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (90, 'KPAD', 'artikel/67', 3, 18, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (91, 'Kelompok Ternak', 'artikel/68', 3, 18, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (92, 'Kelompok Tani', 'artikel/69', 3, 18, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (93, 'Kelompok Ekonomi Lainya', 'artikel/71', 3, 18, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (98, 'LKPJ', '', 3, 73, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (99, 'LPPD', '', 3, 73, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (100, 'ILPPD', '', 3, 73, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (101, 'Peraturan Desa', 'artikel/44', 3, 64, 1, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (102, 'Peraturan Kepala Desa', 'artikel/45', 3, 64, 1, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (103, 'Keputusan Kepala Desa', 'artikel/46', 3, 64, 1, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (104, 'PBB', '', 3, 73, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (106, 'Data Warga Negara', 'statistik/13', 3, 24, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (108, 'Data Kelas Sosial', 'statistik_k/1', 3, 24, 1, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (109, 'Kontak', 'artikel/36', 1, 1, 1, 2, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (110, 'Peraturan Desa', 'peraturan', 3, 66, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (112, 'Coba', 'coba', 2, 1, 1, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (113, '', '', 3, 109, 0, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (114, 'Sejarah Desa', 'artikel/99', 3, 16, 0, 1, NULL);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (115, 'Produk Hukum', 'peraturan_desa', 1, 1, 5, 1, 1);
INSERT INTO `menu` (`id`, `nama`, `link`, `tipe`, `parrent`, `link_tipe`, `enabled`, `urut`) VALUES (116, 'Informasi Publik', 'informasi_publik', 1, 1, 5, 1, 2);


#
# TABLE STRUCTURE FOR: migrasi
#

DROP TABLE IF EXISTS `migrasi`;

CREATE TABLE `migrasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `versi_database` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `migrasi` (`id`, `versi_database`) VALUES (1, '2020040102');
INSERT INTO `migrasi` (`id`, `versi_database`) VALUES (2, '2020050101');
INSERT INTO `migrasi` (`id`, `versi_database`) VALUES (3, '2020060101');
INSERT INTO `migrasi` (`id`, `versi_database`) VALUES (4, '2020070101');
INSERT INTO `migrasi` (`id`, `versi_database`) VALUES (5, '2020070106');
INSERT INTO `migrasi` (`id`, `versi_database`) VALUES (6, '2020080101');
INSERT INTO `migrasi` (`id`, `versi_database`) VALUES (7, '2020090101');
INSERT INTO `migrasi` (`id`, `versi_database`) VALUES (8, '2020090102');
INSERT INTO `migrasi` (`id`, `versi_database`) VALUES (9, '2020100103');
INSERT INTO `migrasi` (`id`, `versi_database`) VALUES (10, '2020110101');
INSERT INTO `migrasi` (`id`, `versi_database`) VALUES (11, '2020110103');
INSERT INTO `migrasi` (`id`, `versi_database`) VALUES (12, '2020120101');


#
# TABLE STRUCTURE FOR: mutasi_cdesa
#

DROP TABLE IF EXISTS `mutasi_cdesa`;

CREATE TABLE `mutasi_cdesa` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_cdesa_masuk` int(5) unsigned DEFAULT NULL,
  `cdesa_keluar` int(5) unsigned DEFAULT NULL,
  `jenis_mutasi` tinyint(2) DEFAULT NULL,
  `tanggal_mutasi` date DEFAULT NULL,
  `keterangan` text,
  `id_persil` int(11) NOT NULL,
  `no_bidang_persil` tinyint(3) DEFAULT NULL,
  `luas` decimal(7,0) DEFAULT NULL,
  `no_objek_pajak` varchar(30) DEFAULT NULL,
  `path` text,
  PRIMARY KEY (`id`),
  KEY `cdesa_mutasi_fk` (`id_cdesa_masuk`),
  CONSTRAINT `cdesa_mutasi_fk` FOREIGN KEY (`id_cdesa_masuk`) REFERENCES `cdesa` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: notifikasi
#

DROP TABLE IF EXISTS `notifikasi`;

CREATE TABLE `notifikasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kode` varchar(100) NOT NULL,
  `judul` varchar(100) NOT NULL,
  `jenis` varchar(50) NOT NULL,
  `isi` text NOT NULL,
  `server` varchar(20) NOT NULL,
  `tgl_berikutnya` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_by` int(11) NOT NULL,
  `frekuensi` smallint(6) NOT NULL,
  `aksi` varchar(100) NOT NULL,
  `aktif` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `kode` (`kode`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

INSERT INTO `notifikasi` (`id`, `kode`, `judul`, `jenis`, `isi`, `server`, `tgl_berikutnya`, `updated_at`, `updated_by`, `frekuensi`, `aksi`, `aktif`) VALUES (1, 'persetujuan_penggunaan', '<i class=\"fa fa-file-text-o text-black\"></i> &nbsp;Persetujuan Penggunaan OpenSID', 'persetujuan', '<p><b>Untuk menggunakan OpenSID, anda dan desa anda perlu menyetujui ketentuan berikut:</b>\n					<ol>\n						<li>Pengguna telah membaca dan menyetujui <a href=\"https://www.gnu.org/licenses/gpl-3.0.en.html\" target=\"_blank\">Lisensi GPL V3</a>.</li>\n						<li>OpenSID gratis dan disediakan \"SEBAGAIMANA ADANYA\", di mana segala tanggung jawab termasuk keamanan data desa ada pada pengguna.</li>\n						<li>Pengguna paham bahwa setiap ubahan OpenSID juga berlisensi GPL V3 yang tidak dapat dimusnahkan, dan aplikasi ubahan itu juga sumber terbuka yang bebas disebarkan oleh pihak yang menerima.</li>\n						<li>Pengguna mengetahui, paham dan menyetujui bahwa OpenSID akan mengirim data penggunaan ke server OpenDesa secara berkala untuk tujuan menyempurnakan OpenSID, dengan pengertian bahwa data yang dikirim sama sekali tidak berisi data identitas penduduk atau data sensitif desa lainnya.</li>\n					</ol></p>\n					<b>Apakah anda dan desa anda setuju dengan ketentuan di atas?</b>', 'client', '2021-02-27 08:34:43', '2020-11-29 08:34:43', 1, 90, 'notif/update_pengumuman,siteman', 1);
INSERT INTO `notifikasi` (`id`, `kode`, `judul`, `jenis`, `isi`, `server`, `tgl_berikutnya`, `updated_at`, `updated_by`, `frekuensi`, `aksi`, `aktif`) VALUES (2, 'tracking_off', '<i class=\"fa fa-exclamation-triangle text-red\"></i> &nbsp;Peringatan Tracking Off', 'peringatan', '<p>Kami mendeteksi bahwa anda telah mematikan fitur tracking. Bila dimatikan, penggunaan website desa anda tidak akan tercatat di server OpenDesa dan tidak akan menerima informasi penting yang sesekali dikirim OpenDesa.</p>\n					<br><b>Hidupkan kembali tracking untuk mendapatkan informasi dari OpenDesa?</b>', 'client', '2020-07-30 03:37:42', '2020-07-30 10:37:03', 1, 90, 'setting/aktifkan_tracking,notif/update_pengumuman', 0);


#
# TABLE STRUCTURE FOR: outbox
#

DROP TABLE IF EXISTS `outbox`;

CREATE TABLE `outbox` (
  `UpdatedInDB` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `InsertIntoDB` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `SendingDateTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `SendBefore` time NOT NULL DEFAULT '23:59:59',
  `SendAfter` time NOT NULL DEFAULT '00:00:00',
  `Text` text,
  `DestinationNumber` varchar(20) NOT NULL DEFAULT '',
  `Coding` enum('Default_No_Compression','Unicode_No_Compression','8bit','Default_Compression','Unicode_Compression') NOT NULL DEFAULT 'Default_No_Compression',
  `UDH` text,
  `Class` int(11) DEFAULT '-1',
  `TextDecoded` text NOT NULL,
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `MultiPart` enum('false','true') DEFAULT 'false',
  `RelativeValidity` int(11) DEFAULT '-1',
  `SenderID` varchar(255) DEFAULT NULL,
  `SendingTimeOut` timestamp NULL DEFAULT NULL,
  `DeliveryReport` enum('default','yes','no') DEFAULT 'default',
  `CreatorID` text,
  PRIMARY KEY (`ID`),
  KEY `outbox_date` (`SendingDateTime`,`SendingTimeOut`),
  KEY `outbox_sender` (`SenderID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: permohonan_surat
#

DROP TABLE IF EXISTS `permohonan_surat`;

CREATE TABLE `permohonan_surat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_pemohon` int(11) NOT NULL,
  `id_surat` int(11) NOT NULL,
  `isian_form` text NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `keterangan` text,
  `no_hp_aktif` varchar(50) NOT NULL,
  `syarat` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: persil
#

DROP TABLE IF EXISTS `persil`;

CREATE TABLE `persil` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `nomor` varchar(20) NOT NULL,
  `nomor_urut_bidang` tinyint(3) NOT NULL DEFAULT '1',
  `kelas` int(5) NOT NULL,
  `luas_persil` decimal(7,0) DEFAULT NULL,
  `id_wilayah` int(11) DEFAULT NULL,
  `lokasi` text,
  `path` text,
  `cdesa_awal` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `nomor_nomor_urut_bidang` (`nomor`,`nomor_urut_bidang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: pertanyaan
#

DROP TABLE IF EXISTS `pertanyaan`;

CREATE TABLE `pertanyaan` (
  `1` int(2) DEFAULT NULL,
  `Pendapatan perkapita perbulan` varchar(87) DEFAULT NULL,
  `36` int(2) DEFAULT NULL,
  `15` int(2) DEFAULT NULL,
  `24` int(2) DEFAULT NULL,
  `23` int(2) DEFAULT NULL,
  `26` int(2) DEFAULT NULL,
  `28` int(2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: point
#

DROP TABLE IF EXISTS `point`;

CREATE TABLE `point` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `nama` varchar(50) NOT NULL,
  `simbol` varchar(50) DEFAULT NULL,
  `tipe` int(4) DEFAULT '0',
  `parrent` int(4) NOT NULL DEFAULT '1',
  `enabled` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `parrent` (`parrent`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO `point` (`id`, `nama`, `simbol`, `tipe`, `parrent`, `enabled`) VALUES (1, 'Sarana Pendidikan', 'face-embarrassed.png', 0, 1, 1);
INSERT INTO `point` (`id`, `nama`, `simbol`, `tipe`, `parrent`, `enabled`) VALUES (2, 'Sarana Transportasi', 'face-devilish.png', 0, 1, 1);
INSERT INTO `point` (`id`, `nama`, `simbol`, `tipe`, `parrent`, `enabled`) VALUES (3, 'Sarana Kesehatan', 'emblem-photos.png', 0, 1, 1);
INSERT INTO `point` (`id`, `nama`, `simbol`, `tipe`, `parrent`, `enabled`) VALUES (4, 'SMA', 'gateswalls.png', 2, 1, 1);
INSERT INTO `point` (`id`, `nama`, `simbol`, `tipe`, `parrent`, `enabled`) VALUES (5, 'SMP (Sekolah Menengah Pertama)', 'arch.png', 2, 1, 1);
INSERT INTO `point` (`id`, `nama`, `simbol`, `tipe`, `parrent`, `enabled`) VALUES (6, 'Masjid', 'mosque.png', 2, 7, 1);
INSERT INTO `point` (`id`, `nama`, `simbol`, `tipe`, `parrent`, `enabled`) VALUES (7, 'Tempat Ibadah', 'emblem-art.png', 0, 1, 1);
INSERT INTO `point` (`id`, `nama`, `simbol`, `tipe`, `parrent`, `enabled`) VALUES (8, 'Kuil', 'moderntower.png', 2, 7, 1);
INSERT INTO `point` (`id`, `nama`, `simbol`, `tipe`, `parrent`, `enabled`) VALUES (9, 'RS', 'accerciser.png', 2, 3, 1);


#
# TABLE STRUCTURE FOR: polygon
#

DROP TABLE IF EXISTS `polygon`;

CREATE TABLE `polygon` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `nama` varchar(50) NOT NULL,
  `simbol` varchar(50) DEFAULT NULL,
  `color` varchar(10) NOT NULL DEFAULT 'ff0000',
  `tipe` int(4) DEFAULT '0',
  `parrent` int(4) DEFAULT '1',
  `enabled` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `parrent` (`parrent`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO `polygon` (`id`, `nama`, `simbol`, `color`, `tipe`, `parrent`, `enabled`) VALUES (1, 'rawan topan', '', '#7C78FF', 0, 1, 1);
INSERT INTO `polygon` (`id`, `nama`, `simbol`, `color`, `tipe`, `parrent`, `enabled`) VALUES (2, 'jalur selokan', '', '#F4FF59', 0, 1, 1);
INSERT INTO `polygon` (`id`, `nama`, `simbol`, `color`, `tipe`, `parrent`, `enabled`) VALUES (3, 'Pemukiman rawan topan', '', '#db2121', 2, 1, 1);


#
# TABLE STRUCTURE FOR: program
#

DROP TABLE IF EXISTS `program`;

CREATE TABLE `program` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `sasaran` tinyint(4) DEFAULT NULL,
  `ndesc` varchar(500) DEFAULT NULL,
  `sdate` date NOT NULL,
  `edate` date NOT NULL,
  `userid` mediumint(9) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `asaldana` char(30) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO `program` (`id`, `nama`, `sasaran`, `ndesc`, `sdate`, `edate`, `userid`, `status`, `asaldana`) VALUES (1, 'BPNT', 2, 'Program KESOS memberi bantuan sosial pangan dalam bentuk non tunai dari pemerintah yang diberikan kepada KPM setiap bulannya melalui mekanisme akun elektronik yang digunakan hanya untuk membeli bahan pangan di pedagang bahan pangan/e-warong yang bekerjasama dengan bank.', '2015-12-13', '2021-12-13', 0, 1, 'Pusat');
INSERT INTO `program` (`id`, `nama`, `sasaran`, `ndesc`, `sdate`, `edate`, `userid`, `status`, `asaldana`) VALUES (2, 'BLSM', 2, 'Bantuan Langsung Sementara Masyarakat atau BLSM (kadang disebut juga balsem) adalah bantuan yang diberikan Pemerintah Indonesia menyambut kenaikan harga BBM yang terjadi pada 22 Juni 2013 pada jam 00.00', '2015-12-13', '2017-12-13', 0, 0, 'Pusat');
INSERT INTO `program` (`id`, `nama`, `sasaran`, `ndesc`, `sdate`, `edate`, `userid`, `status`, `asaldana`) VALUES (3, 'PKH', 2, 'Program Keluarga Harapan yang selanjutnya disebut PKH adalah program pemberian bantuan sosial bersyarat kepada Keluarga Miskin (KM) yang ditetapkan sebagai keluarga penerima manfaat PKH.\r\n\r\nSebagai sebuah program bantuan sosial bersyarat, PKH membuka akses keluarga miskin terutama ibu hamil dan anak untuk memanfaatkan berbagai fasilitas layanan kesehatan (faskes) dan fasilitas layanan pendidikan (fasdik) yang tersedia di sekitar mereka.', '2015-12-13', '2022-12-13', 0, 1, 'Pusat');
INSERT INTO `program` (`id`, `nama`, `sasaran`, `ndesc`, `sdate`, `edate`, `userid`, `status`, `asaldana`) VALUES (4, 'Bedah Rumah', 2, 'Bantuan Stimulan Perumahan Swadaya (BSPS). Program ini lebih dikenal sebagai program Bedah Rumah.\r\n\r\nKementrian Pekerjaan Umum dan Perumahan Rakyat (KemenPUPR) menjalankan BSPS untuk membantu Masyarakat Berpenghasilan Rendah (MBR), agar dapat memiliki rumah yang layak huni.', '2015-12-13', '2021-12-13', 0, 1, 'Pusat');
INSERT INTO `program` (`id`, `nama`, `sasaran`, `ndesc`, `sdate`, `edate`, `userid`, `status`, `asaldana`) VALUES (5, 'JAMKESMAS', 1, 'Jamkesmas ( akronim dari Jaminan Kesehatan Masyarakat ) adalah sebuah program jaminan kesehatan untuk warga Indonesia yang memberikan perlindungan sosial dibidang kesehatan untuk menjamin masyarakat miskin dan tidak mampu yang iurannya dibayar oleh pemerintah agar kebutuhan dasar kesehatannya yang layak dapat terpenuhi.Program ini dijalankan oleh Departemen Kesehatan sejak 2008.', '2008-12-13', '2010-12-13', 0, 0, 'Pusat');


#
# TABLE STRUCTURE FOR: program_peserta
#

DROP TABLE IF EXISTS `program_peserta`;

CREATE TABLE `program_peserta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `peserta` varchar(30) NOT NULL,
  `program_id` int(11) NOT NULL,
  `no_id_kartu` varchar(30) DEFAULT NULL,
  `kartu_nik` varchar(30) DEFAULT NULL,
  `kartu_nama` varchar(100) DEFAULT NULL,
  `kartu_tempat_lahir` varchar(100) DEFAULT NULL,
  `kartu_tanggal_lahir` date DEFAULT NULL,
  `kartu_alamat` varchar(200) DEFAULT NULL,
  `kartu_peserta` varchar(100) DEFAULT NULL,
  `kartu_id_pend` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

INSERT INTO `program_peserta` (`id`, `peserta`, `program_id`, `no_id_kartu`, `kartu_nik`, `kartu_nama`, `kartu_tempat_lahir`, `kartu_tanggal_lahir`, `kartu_alamat`, `kartu_peserta`, `kartu_id_pend`) VALUES (2, '5201140104126994', 1, NULL, '', NULL, NULL, NULL, NULL, '', NULL);
INSERT INTO `program_peserta` (`id`, `peserta`, `program_id`, `no_id_kartu`, `kartu_nik`, `kartu_nama`, `kartu_tempat_lahir`, `kartu_tanggal_lahir`, `kartu_alamat`, `kartu_peserta`, `kartu_id_pend`) VALUES (3, '5201140105136997', 1, NULL, '', NULL, NULL, NULL, NULL, '', NULL);
INSERT INTO `program_peserta` (`id`, `peserta`, `program_id`, `no_id_kartu`, `kartu_nik`, `kartu_nama`, `kartu_tempat_lahir`, `kartu_tanggal_lahir`, `kartu_alamat`, `kartu_peserta`, `kartu_id_pend`) VALUES (4, '5201140104126995', 2, NULL, '', NULL, NULL, NULL, NULL, '', NULL);
INSERT INTO `program_peserta` (`id`, `peserta`, `program_id`, `no_id_kartu`, `kartu_nik`, `kartu_nama`, `kartu_tempat_lahir`, `kartu_tanggal_lahir`, `kartu_alamat`, `kartu_peserta`, `kartu_id_pend`) VALUES (5, '5201140105136997', 2, NULL, '', NULL, NULL, NULL, NULL, '', NULL);
INSERT INTO `program_peserta` (`id`, `peserta`, `program_id`, `no_id_kartu`, `kartu_nik`, `kartu_nama`, `kartu_tempat_lahir`, `kartu_tanggal_lahir`, `kartu_alamat`, `kartu_peserta`, `kartu_id_pend`) VALUES (6, '5201140104126995', 3, NULL, '', NULL, NULL, NULL, NULL, '', NULL);
INSERT INTO `program_peserta` (`id`, `peserta`, `program_id`, `no_id_kartu`, `kartu_nik`, `kartu_nama`, `kartu_tempat_lahir`, `kartu_tanggal_lahir`, `kartu_alamat`, `kartu_peserta`, `kartu_id_pend`) VALUES (7, '5201140105136997', 3, NULL, '', NULL, NULL, NULL, NULL, '', NULL);
INSERT INTO `program_peserta` (`id`, `peserta`, `program_id`, `no_id_kartu`, `kartu_nik`, `kartu_nama`, `kartu_tempat_lahir`, `kartu_tanggal_lahir`, `kartu_alamat`, `kartu_peserta`, `kartu_id_pend`) VALUES (8, '5201140104166999', 4, NULL, '', NULL, NULL, NULL, NULL, '', NULL);
INSERT INTO `program_peserta` (`id`, `peserta`, `program_id`, `no_id_kartu`, `kartu_nik`, `kartu_nama`, `kartu_tempat_lahir`, `kartu_tanggal_lahir`, `kartu_alamat`, `kartu_peserta`, `kartu_id_pend`) VALUES (9, '5201140105136997', 4, NULL, '', NULL, NULL, NULL, NULL, '', NULL);
INSERT INTO `program_peserta` (`id`, `peserta`, `program_id`, `no_id_kartu`, `kartu_nik`, `kartu_nama`, `kartu_tempat_lahir`, `kartu_tanggal_lahir`, `kartu_alamat`, `kartu_peserta`, `kartu_id_pend`) VALUES (10, '5201142005716996', 5, NULL, '', NULL, NULL, NULL, NULL, '', NULL);
INSERT INTO `program_peserta` (`id`, `peserta`, `program_id`, `no_id_kartu`, `kartu_nik`, `kartu_nama`, `kartu_tempat_lahir`, `kartu_tanggal_lahir`, `kartu_alamat`, `kartu_peserta`, `kartu_id_pend`) VALUES (11, '5201140706966997', 5, NULL, '', NULL, NULL, NULL, NULL, '', NULL);


#
# TABLE STRUCTURE FOR: provinsi
#

DROP TABLE IF EXISTS `provinsi`;

CREATE TABLE `provinsi` (
  `kode` tinyint(2) NOT NULL DEFAULT '0',
  `nama` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`kode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `provinsi` (`kode`, `nama`) VALUES (11, 'Aceh');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (12, 'Sumatera Utara');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (13, 'Sumatera Barat');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (14, 'Riau');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (15, 'Jambi');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (16, 'Sumatera Selatan');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (17, 'Bengkulu');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (18, 'Lampung');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (19, 'Kepulauan Bangka Belitung');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (21, 'Kepulauan Riau');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (31, 'DKI Jakarta');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (32, 'Jawa Barat');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (33, 'Jawa Tengah');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (34, 'DI Yogyakarta');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (35, 'Jawa Timur');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (36, 'Banten');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (51, 'Bali');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (52, 'Nusa Tenggara Barat');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (53, 'Nusa Tenggara Timur');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (61, 'Kalimantan Barat');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (62, 'Kalimantan Tengah');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (63, 'Kalimantan Selatan');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (64, 'Kalimantan Timur');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (65, 'Kalimantan Utara');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (71, 'Sulawesi Utara');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (72, 'Sulawesi Tengah');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (73, 'Sulawesi Selatan');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (74, 'Sulawesi Tenggara');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (75, 'Gorontalo');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (76, 'Sulawesi Barat');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (81, 'Maluku');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (82, 'Maluku Utara');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (91, 'Papua');
INSERT INTO `provinsi` (`kode`, `nama`) VALUES (92, 'Papua Barat');


#
# TABLE STRUCTURE FOR: ref_dokumen
#

DROP TABLE IF EXISTS `ref_dokumen`;

CREATE TABLE `ref_dokumen` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `ref_dokumen` (`id`, `nama`) VALUES (1, 'Informasi Publik');
INSERT INTO `ref_dokumen` (`id`, `nama`) VALUES (2, 'SK Kades');
INSERT INTO `ref_dokumen` (`id`, `nama`) VALUES (3, 'Perdes');


#
# TABLE STRUCTURE FOR: ref_persil_kelas
#

DROP TABLE IF EXISTS `ref_persil_kelas`;

CREATE TABLE `ref_persil_kelas` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `tipe` varchar(20) NOT NULL,
  `kode` varchar(20) NOT NULL,
  `ndesc` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `ref_persil_kelas` (`id`, `tipe`, `kode`, `ndesc`) VALUES (1, 'BASAH', 'S-I', 'Persawahan Dekat dengan Pemukiman');
INSERT INTO `ref_persil_kelas` (`id`, `tipe`, `kode`, `ndesc`) VALUES (2, 'BASAH', 'S-II', 'Persawahan Agak Dekat dengan Pemukiman');
INSERT INTO `ref_persil_kelas` (`id`, `tipe`, `kode`, `ndesc`) VALUES (3, 'BASAH', 'S-III', 'Persawahan Jauh dengan Pemukiman');
INSERT INTO `ref_persil_kelas` (`id`, `tipe`, `kode`, `ndesc`) VALUES (4, 'BASAH', 'S-IV', 'Persawahan Sangat Jauh dengan Pemukiman');
INSERT INTO `ref_persil_kelas` (`id`, `tipe`, `kode`, `ndesc`) VALUES (5, 'KERING', 'D-I', 'Lahan Kering Dekat dengan Pemukiman');
INSERT INTO `ref_persil_kelas` (`id`, `tipe`, `kode`, `ndesc`) VALUES (6, 'KERING', 'D-II', 'Lahan Kering Agak Dekat dengan Pemukiman');
INSERT INTO `ref_persil_kelas` (`id`, `tipe`, `kode`, `ndesc`) VALUES (7, 'KERING', 'D-III', 'Lahan Kering Jauh dengan Pemukiman');
INSERT INTO `ref_persil_kelas` (`id`, `tipe`, `kode`, `ndesc`) VALUES (8, 'KERING', 'D-IV', 'Lahan Kering Sanga Jauh dengan Pemukiman');


#
# TABLE STRUCTURE FOR: ref_persil_mutasi
#

DROP TABLE IF EXISTS `ref_persil_mutasi`;

CREATE TABLE `ref_persil_mutasi` (
  `id` tinyint(5) unsigned NOT NULL AUTO_INCREMENT,
  `nama` varchar(20) NOT NULL,
  `ndesc` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `ref_persil_mutasi` (`id`, `nama`, `ndesc`) VALUES (1, 'Jual Beli', 'Didapat dari proses Jual Beli');
INSERT INTO `ref_persil_mutasi` (`id`, `nama`, `ndesc`) VALUES (2, 'Hibah', 'Didapat dari proses Hibah');
INSERT INTO `ref_persil_mutasi` (`id`, `nama`, `ndesc`) VALUES (3, 'Waris', 'Didapat dari proses Waris');


#
# TABLE STRUCTURE FOR: ref_pindah
#

DROP TABLE IF EXISTS `ref_pindah`;

CREATE TABLE `ref_pindah` (
  `id` tinyint(4) NOT NULL,
  `nama` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `ref_pindah` (`id`, `nama`) VALUES (1, 'Pindah keluar Desa/Kelurahan');
INSERT INTO `ref_pindah` (`id`, `nama`) VALUES (2, 'Pindah keluar Kecamatan');
INSERT INTO `ref_pindah` (`id`, `nama`) VALUES (3, 'Pindah keluar Kabupaten/Kota');
INSERT INTO `ref_pindah` (`id`, `nama`) VALUES (4, 'Pindah keluar Provinsi');


#
# TABLE STRUCTURE FOR: ref_status_covid
#

DROP TABLE IF EXISTS `ref_status_covid`;

CREATE TABLE `ref_status_covid` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `ref_status_covid` (`id`, `nama`) VALUES (1, 'ODP');
INSERT INTO `ref_status_covid` (`id`, `nama`) VALUES (2, 'PDP');
INSERT INTO `ref_status_covid` (`id`, `nama`) VALUES (3, 'ODR');
INSERT INTO `ref_status_covid` (`id`, `nama`) VALUES (4, 'OTG');
INSERT INTO `ref_status_covid` (`id`, `nama`) VALUES (5, 'POSITIF');
INSERT INTO `ref_status_covid` (`id`, `nama`) VALUES (6, 'DLL');


#
# TABLE STRUCTURE FOR: ref_syarat_surat
#

DROP TABLE IF EXISTS `ref_syarat_surat`;

CREATE TABLE `ref_syarat_surat` (
  `ref_syarat_id` int(1) unsigned NOT NULL AUTO_INCREMENT,
  `ref_syarat_nama` varchar(255) NOT NULL,
  PRIMARY KEY (`ref_syarat_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `ref_syarat_surat` (`ref_syarat_id`, `ref_syarat_nama`) VALUES (1, 'Surat Pengantar RT/RW');
INSERT INTO `ref_syarat_surat` (`ref_syarat_id`, `ref_syarat_nama`) VALUES (2, 'Fotokopi KK');
INSERT INTO `ref_syarat_surat` (`ref_syarat_id`, `ref_syarat_nama`) VALUES (3, 'Fotokopi KTP');
INSERT INTO `ref_syarat_surat` (`ref_syarat_id`, `ref_syarat_nama`) VALUES (4, 'Fotokopi Surat Nikah/Akta Nikah/Kutipan Akta Perkawinan');
INSERT INTO `ref_syarat_surat` (`ref_syarat_id`, `ref_syarat_nama`) VALUES (5, 'Fotokopi Akta Kelahiran/Surat Kelahiran bagi keluarga yang mempunyai anak');
INSERT INTO `ref_syarat_surat` (`ref_syarat_id`, `ref_syarat_nama`) VALUES (6, 'Surat Pindah Datang dari tempat asal');
INSERT INTO `ref_syarat_surat` (`ref_syarat_id`, `ref_syarat_nama`) VALUES (7, 'Surat Keterangan Kematian dari Rumah Sakit, Rumah Bersalin Puskesmas, atau visum Dokter');
INSERT INTO `ref_syarat_surat` (`ref_syarat_id`, `ref_syarat_nama`) VALUES (8, 'Surat Keterangan Cerai');
INSERT INTO `ref_syarat_surat` (`ref_syarat_id`, `ref_syarat_nama`) VALUES (9, 'Fotokopi Ijasah Terakhir');
INSERT INTO `ref_syarat_surat` (`ref_syarat_id`, `ref_syarat_nama`) VALUES (10, 'SK. PNS/KARIP/SK. TNI – POLRI');
INSERT INTO `ref_syarat_surat` (`ref_syarat_id`, `ref_syarat_nama`) VALUES (11, 'Surat Keterangan Kematian dari Kepala Desa/Kelurahan');
INSERT INTO `ref_syarat_surat` (`ref_syarat_id`, `ref_syarat_nama`) VALUES (12, 'Surat imigrasi / STMD (Surat Tanda Melapor Diri)');


#
# TABLE STRUCTURE FOR: sentitems
#

DROP TABLE IF EXISTS `sentitems`;

CREATE TABLE `sentitems` (
  `UpdatedInDB` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `InsertIntoDB` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `SendingDateTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `DeliveryDateTime` timestamp NULL DEFAULT NULL,
  `Text` text NOT NULL,
  `DestinationNumber` varchar(20) NOT NULL DEFAULT '',
  `Coding` enum('Default_No_Compression','Unicode_No_Compression','8bit','Default_Compression','Unicode_Compression') NOT NULL DEFAULT 'Default_No_Compression',
  `UDH` text NOT NULL,
  `SMSCNumber` varchar(20) NOT NULL DEFAULT '',
  `Class` int(11) NOT NULL DEFAULT '-1',
  `TextDecoded` text NOT NULL,
  `ID` int(10) unsigned NOT NULL DEFAULT '0',
  `SenderID` varchar(255) NOT NULL,
  `SequencePosition` int(11) NOT NULL DEFAULT '1',
  `Status` enum('SendingOK','SendingOKNoReport','SendingError','DeliveryOK','DeliveryFailed','DeliveryPending','DeliveryUnknown','Error') NOT NULL DEFAULT 'SendingOK',
  `StatusError` int(11) NOT NULL DEFAULT '-1',
  `TPMR` int(11) NOT NULL DEFAULT '-1',
  `RelativeValidity` int(11) NOT NULL DEFAULT '-1',
  `CreatorID` text NOT NULL,
  PRIMARY KEY (`ID`,`SequencePosition`),
  KEY `sentitems_date` (`DeliveryDateTime`),
  KEY `sentitems_tpmr` (`TPMR`),
  KEY `sentitems_dest` (`DestinationNumber`),
  KEY `sentitems_sender` (`SenderID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: setting_aplikasi
#

DROP TABLE IF EXISTS `setting_aplikasi`;

CREATE TABLE `setting_aplikasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(50) DEFAULT NULL,
  `value` varchar(200) DEFAULT NULL,
  `keterangan` varchar(200) DEFAULT NULL,
  `jenis` varchar(30) DEFAULT NULL,
  `kategori` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=latin1;

INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (1, 'sebutan_kabupaten', 'kabupaten', 'Pengganti sebutan wilayah kabupaten', '', '');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (2, 'sebutan_kabupaten_singkat', 'kab.', 'Pengganti sebutan singkatan wilayah kabupaten', '', '');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (3, 'sebutan_kecamatan', 'kecamatan', 'Pengganti sebutan wilayah kecamatan', '', '');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (4, 'sebutan_kecamatan_singkat', 'kec.', 'Pengganti sebutan singkatan wilayah kecamatan', '', '');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (5, 'sebutan_desa', 'desa', 'Pengganti sebutan wilayah desa', '', '');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (6, 'sebutan_dusun', 'dusun', 'Pengganti sebutan wilayah dusun', '', '');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (7, 'sebutan_camat', 'camat', 'Pengganti sebutan jabatan camat', '', '');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (8, 'website_title', 'Website Resmi', 'Judul tab browser modul web', '', 'web');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (9, 'login_title', 'OpenSID', 'Judul tab browser halaman login modul administrasi', '', '');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (10, 'admin_title', 'Sistem Informasi Desa', 'Judul tab browser modul administrasi', '', '');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (11, 'web_theme', 'klasik', 'Tema penampilan modul web', '', 'web');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (12, 'offline_mode', '0', 'Apakah modul web akan ditampilkan atau tidak', 'option-kode', '');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (13, 'enable_track', '1', 'Apakah akan mengirimkan data statistik ke tracker', 'boolean', '');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (14, 'dev_tracker', '', 'Host untuk tracker pada development', '', 'development');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (16, 'google_key', '', 'Google API Key untuk Google Maps', '', 'web');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (17, 'libreoffice_path', '', 'Path tempat instal libreoffice di server SID', '', '');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (18, 'sumber_gambar_slider', '1', 'Sumber gambar slider besar', NULL, NULL);
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (19, 'sebutan_singkatan_kadus', 'kawil', 'Sebutan singkatan jabatan kepala dusun', NULL, NULL);
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (20, 'current_version', '20.12', 'Versi sekarang untuk migrasi', NULL, 'readonly');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (21, 'timezone', 'Asia/Jakarta', 'Zona waktu perekaman waktu dan tanggal', NULL, NULL);
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (23, 'web_artikel_per_page', '8', 'Jumlah artikel dalam satu halaman', 'int', 'web_theme');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (24, 'penomoran_surat', '2', 'Penomoran surat mulai dari satu (1) setiap tahun', 'option', NULL);
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (25, 'dashboard_program_bantuan', '1', 'ID program bantuan yang ditampilkan di dashboard', 'int', 'dashboard');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (26, 'panjang_nomor_surat', '', 'Nomor akan diisi \'0\' di sebelah kiri, kalau perlu', 'int', 'surat');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (27, 'warna_tema_admin', 'skin-purple', 'Warna dasar tema komponen Admin', 'option-value', NULL);
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (28, 'format_nomor_surat', '[kode_surat]/[nomor_surat, 3]/[kode_desa]/[bulan_romawi]/[tahun]', 'Fomat penomoran surat', NULL, NULL);
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (30, 'penggunaan_server', '1	', 'Setting penggunaan server', 'int', 'sistem');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (31, 'daftar_penerima_bantuan', '1', 'Apakah akan tampilkan daftar penerima bantuan di statistik halaman muka', 'boolean', 'conf_web');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (32, 'apbdes_footer', '1', 'Apakah akan tampilkan grafik APBDes di halaman muka', 'boolean', 'conf_web');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (33, 'apbdes_footer_all', '1', 'Apakah akan tampilkan grafik APBDes di semua halaman', 'boolean', 'conf_web');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (34, 'apbdes_manual_input', '0', 'Apakah akan tampilkan grafik APBDes yang diinput secara manual', 'boolean', 'conf_web');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (35, 'covid_data', '1', 'Apakah akan tampilkan status Covid-19 Provinsi di halaman muka', 'boolean', 'conf_web');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (36, 'covid_desa', '1', 'Apakah akan tampilkan status Covid-19 Desa di halaman muka', 'boolean', 'conf_web');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (37, 'covid_rss', '0', 'Apakah akan tampilkan RSS Covid-19 di halaman muka', 'boolean', 'conf_web');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (38, 'provinsi_covid', '52', 'Kode provinsi status Covid-19 ', 'int', 'conf_web');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (39, 'statistik_chart_3d', '1', 'Apakah akan tampilkan Statistik Chart 3D', 'boolean', 'conf_web');
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (40, 'sebutan_nip_desa', 'NIPD', 'Pengganti sebutan label niap/nipd', NULL, NULL);
INSERT INTO `setting_aplikasi` (`id`, `key`, `value`, `keterangan`, `jenis`, `kategori`) VALUES (43, 'token_opensid', '', 'Token OpenSID', '', 'sistem');


#
# TABLE STRUCTURE FOR: setting_modul
#

DROP TABLE IF EXISTS `setting_modul`;

CREATE TABLE `setting_modul` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `modul` varchar(50) NOT NULL,
  `url` varchar(50) NOT NULL,
  `aktif` tinyint(1) NOT NULL DEFAULT '0',
  `ikon` varchar(50) NOT NULL,
  `urut` tinyint(4) NOT NULL,
  `level` tinyint(1) NOT NULL DEFAULT '2',
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  `ikon_kecil` varchar(50) NOT NULL,
  `parent` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=214 DEFAULT CHARSET=utf8;

INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (1, 'Home', 'hom_sid', 1, 'fa-home', 1, 2, 1, 'fa fa-home', 0);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (2, 'Kependudukan', '', 1, 'fa-users', 3, 2, 0, 'fa fa-users', 0);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (3, 'Statistik', 'statistik', 1, 'fa-line-chart', 4, 2, 0, 'fa fa-line-chart', 0);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (4, 'Layanan Surat', 'surat', 1, 'fa-book', 5, 2, 0, 'fa fa-book', 0);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (5, 'Analisis', 'analisis_master/clear', 1, '   fa-check-square-o', 6, 2, 0, 'fa fa-check-square-o', 0);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (6, 'Bantuan', 'program_bantuan/clear', 1, 'fa-heart', 7, 2, 0, 'fa fa-heart', 0);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (7, 'Pertanahan', 'cdesa/clear', 1, 'fa-map-signs', 8, 2, 0, 'fa fa-map-signs', 0);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (8, 'Pengaturan Peta', 'plan', 1, 'fa-location-arrow', 9, 2, 0, 'fa fa-location-arrow', 9);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (9, 'Pemetaan', 'gis', 1, 'fa-globe', 10, 2, 0, 'fa fa-globe', 0);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (10, 'SMS', 'sms', 1, 'fa-envelope', 11, 2, 0, 'fa fa-envelope', 0);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (11, 'Pengaturan', 'man_user/clear', 1, 'fa-users', 12, 1, 1, 'fa-users', 0);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (13, 'Admin Web', 'web', 1, 'fa-desktop', 14, 4, 0, 'fa fa-desktop', 0);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (14, 'Layanan Mandiri', '', 1, 'fa-inbox', 15, 2, 0, 'fa fa-inbox', 0);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (15, 'Sekretariat', 'surat_keluar/clear', 1, 'fa-archive', 5, 2, 0, 'fa fa-archive', 0);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (17, 'Identitas [Desa]', 'identitas_desa', 1, 'fa-id-card', 2, 2, 0, '', 200);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (18, 'Pemerintahan [Desa]', 'pengurus/clear', 1, 'fa-sitemap', 3, 2, 0, '', 200);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (20, 'Wilayah Administratif', 'sid_core/clear', 1, 'fa-map', 2, 2, 0, '', 200);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (21, 'Penduduk', 'penduduk/clear', 1, 'fa-user', 2, 2, 0, '', 2);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (22, 'Keluarga', 'keluarga/clear', 1, 'fa-users', 3, 2, 0, '', 2);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (23, 'Rumah Tangga', 'rtm/clear', 1, 'fa-venus-mars', 4, 2, 0, '', 2);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (24, 'Kelompok', 'kelompok/clear', 1, 'fa-sitemap', 5, 2, 0, '', 2);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (25, 'Data Suplemen', 'suplemen', 1, 'fa-slideshare', 6, 2, 0, '', 2);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (26, 'Calon Pemilih', 'dpt/clear', 1, 'fa-podcast', 7, 2, 0, '', 2);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (27, 'Statistik Kependudukan', 'statistik/clear', 1, 'fa-bar-chart', 1, 2, 0, '', 3);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (28, 'Laporan Bulanan', 'laporan/clear', 1, 'fa-file-text', 2, 2, 0, '', 3);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (29, 'Laporan Kelompok Rentan', 'laporan_rentan/clear', 1, 'fa-wheelchair', 3, 2, 0, '', 3);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (30, 'Pengaturan Surat', 'surat_master/clear', 1, 'fa-cog', 1, 2, 0, '', 4);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (31, 'Cetak Surat', 'surat', 1, 'fa-files-o', 2, 2, 0, '', 4);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (32, 'Arsip Layanan', 'keluar/clear', 1, 'fa-folder-open', 3, 2, 0, '', 4);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (33, 'Panduan', 'surat/panduan', 1, 'fa fa-book', 4, 2, 0, '', 4);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (39, 'SMS', 'sms', 1, 'fa-envelope-open-o', 1, 2, 0, '', 10);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (40, 'Daftar Kontak', 'sms/kontak', 1, 'fa-id-card-o', 2, 2, 0, '', 10);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (41, 'Pengaturan SMS', 'sms/setting', 1, 'fa-gear', 3, 2, 0, '', 10);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (42, 'Modul', 'modul/clear', 1, 'fa-tags', 1, 1, 0, '', 11);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (43, 'Aplikasi', 'setting', 1, 'fa-codepen', 2, 1, 0, '', 11);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (44, 'Pengguna', 'man_user', 1, 'fa-users', 3, 1, 0, '', 11);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (45, 'Database', 'database', 1, 'fa-database', 4, 1, 0, '', 11);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (46, 'Info Sistem', 'setting/info_sistem', 1, 'fa-server', 5, 1, 0, '', 11);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (47, 'Artikel', 'web/clear', 1, 'fa-file-movie-o', 1, 4, 0, '', 13);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (48, 'Widget', 'web_widget/clear', 1, 'fa-windows', 2, 4, 0, '', 13);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (49, 'Menu', 'menu/clear', 1, 'fa-bars', 3, 4, 0, '', 13);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (50, 'Komentar', 'komentar/clear', 1, 'fa-comments', 4, 4, 0, '', 13);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (51, 'Galeri', 'gallery/clear', 1, 'fa-image', 5, 5, 0, '', 13);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (52, 'Informasi Publik', 'dokumen/clear', 1, 'fa-file-text', 4, 4, 0, '', 15);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (53, 'Media Sosial', 'sosmed', 1, 'fa-facebook', 7, 4, 0, '', 13);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (54, 'Slider', 'web/slider', 1, 'fa-film', 8, 4, 0, '', 13);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (55, 'Kotak Pesan', 'mailbox/clear', 1, 'fa-wechat', 1, 2, 0, '', 14);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (56, 'Pendaftar Layanan Mandiri', 'mandiri/clear', 1, 'fa-500px', 2, 2, 0, '', 14);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (57, 'Surat Masuk', 'surat_masuk/clear', 1, 'fa-sign-in', 1, 2, 0, '', 15);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (58, 'Surat Keluar', 'surat_keluar/clear', 1, 'fa-sign-out', 2, 2, 0, '', 15);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (61, 'Inventaris', 'inventaris_tanah', 1, 'fa-cubes', 5, 2, 0, '', 15);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (62, 'Peta', 'gis/clear', 1, 'fa-globe', 1, 2, 0, 'fa fa-globe', 9);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (63, 'Klasfikasi Surat', 'klasifikasi/clear', 1, 'fa-code', 10, 2, 0, 'fa-code', 15);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (64, 'Teks Berjalan', 'teks_berjalan', 1, 'fa-ellipsis-h', 9, 2, 0, 'fa-ellipsis-h', 13);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (65, 'Kategori', 'kategori', 1, '', 0, 0, 2, '', 49);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (66, 'Log Penduduk', 'penduduk_log', 1, '', 0, 0, 2, '', 21);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (67, 'analisis_kategori', 'analisis_kategori', 1, '', 0, 0, 2, '', 5);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (68, 'analisis_indikator', 'analisis_indikator', 1, '', 0, 0, 2, '', 5);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (69, 'analisis_klasifikasi', 'analisis_klasifikasi', 1, '', 0, 0, 2, '', 5);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (70, 'analisis_periode', 'analisis_periode', 1, '', 0, 0, 2, '', 5);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (71, 'analisis_respon', 'analisis_respon', 1, '', 0, 0, 2, '', 5);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (72, 'analisis_laporan', 'analisis_laporan', 1, '', 0, 0, 2, '', 5);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (73, 'analisis_statistik_jawaban', 'analisis_statistik_jawaban', 1, '', 0, 0, 2, '', 5);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (74, 'Wilayah', 'wilayah', 1, '', 0, 0, 2, '', 21);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (75, 'api_inventaris_asset', 'api_inventaris_asset', 1, '', 0, 0, 2, '', 61);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (76, 'api_inventaris_gedung', 'api_inventaris_gedung', 1, '', 0, 0, 2, '', 61);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (77, 'api_inventaris_gedung', 'api_inventaris_gedung', 1, '', 0, 0, 2, '', 61);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (78, 'api_inventaris_jalan', 'api_inventaris_jalan', 1, '', 0, 0, 2, '', 61);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (79, 'api_inventaris_konstruksi', 'api_inventaris_kontruksi', 1, '', 0, 0, 2, '', 61);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (80, 'api_inventaris_peralatan', 'api_inventaris_peralatan', 1, '', 0, 0, 2, '', 61);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (81, 'api_inventaris_tanah', 'api_inventaris_tanah', 1, '', 0, 0, 2, '', 61);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (82, 'inventaris_asset', 'inventaris_asset', 1, '', 0, 0, 2, '', 61);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (83, 'inventaris_gedung', 'inventaris_gedung', 1, '', 0, 0, 2, '', 61);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (84, 'inventaris_jalan', 'inventaris_jalan', 1, '', 0, 0, 2, '', 61);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (85, 'inventaris_kontruksi', 'inventaris_kontruksi', 1, '', 0, 0, 2, '', 61);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (86, 'inventaris_peralatan', 'inventaris_peralatan', 1, '', 0, 0, 2, '', 61);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (87, 'laporan_inventaris', 'laporan_inventaris', 1, '', 0, 0, 2, '', 61);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (88, 'plan', 'plan', 1, '', 0, 0, 2, '', 8);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (89, 'point', 'point', 1, '', 0, 0, 2, '', 8);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (90, 'garis', 'garis', 1, '', 0, 0, 2, '', 8);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (91, 'line', 'line', 1, '', 0, 0, 2, '', 8);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (92, 'area', 'area', 1, '', 0, 0, 2, '', 8);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (93, 'polygon', 'polygon', 1, '', 0, 0, 2, '', 8);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (94, 'Kategori Kelompok', 'kelompok_master', 1, '', 0, 0, 2, '', 24);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (95, 'Produk Hukum', 'dokumen_sekretariat/peraturan_desa', 1, 'fa-book', 3, 2, 0, '', 15);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (96, 'Informasi Publik', 'informasi_publik', 1, '', 0, 0, 2, '', 52);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (97, 'Daftar Persyaratan', 'surat_mohon', 1, 'fa fa-book', 5, 2, 0, '', 4);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (98, 'Permohonan Surat', 'permohonan_surat_admin/clear', 1, 'fa-files-o', 0, 0, 0, '', 14);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (200, 'Info [Desa]', 'identitas_desa', 1, 'fa-dashboard', 2, 2, 1, 'fa fa-home', 0);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (201, 'Keuangan', 'keuangan', 1, 'fa-balance-scale', 6, 2, 0, 'fa-balance-scale', 0);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (202, 'Impor Data', 'keuangan/impor_data', 1, 'fa-cloud-upload', 1, 2, 0, 'fa-cloud-upload', 201);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (203, 'Laporan', 'keuangan/laporan', 1, 'fa-bar-chart', 2, 2, 0, 'fa-bar-chart', 201);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (205, 'Pengunjung', 'pengunjung/clear', 1, 'fa-bar-chart', 10, 4, 0, '', 13);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (206, 'Siaga Covid-19', '', 1, 'fa-heartbeat', 0, 2, 0, 'fa fa-heartbeat', 0);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (207, 'Pendataan', 'covid19', 1, 'fa-list', 1, 2, 0, 'fa fa-list', 206);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (208, 'Pemantauan', 'covid19/pantau', 1, 'fa-check', 2, 2, 0, 'fa fa-check', 206);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (209, 'Input Data', 'keuangan_manual/manual_apbdes', 1, 'fa-keyboard-o', 3, 2, 0, 'fa-keyboard-o', 201);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (210, 'Laporan Manual', 'keuangan_manual/laporan_manual', 1, 'fa-bar-chart', 4, 2, 0, 'fa-bar-chart', 201);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (211, 'Pengaturan', 'setting/web', 1, 'fa-gear', 11, 4, 0, 'fa-gear', 13);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (212, 'QR Code', 'setting/qrcode/clear', 1, 'fa-qrcode', 6, 1, 0, 'fa-qrcode', 11);
INSERT INTO `setting_modul` (`id`, `modul`, `url`, `aktif`, `ikon`, `urut`, `level`, `hidden`, `ikon_kecil`, `parent`) VALUES (213, 'data_persil', 'data_persil', 1, '', 0, 2, 2, '', 7);


#
# TABLE STRUCTURE FOR: setting_sms
#

DROP TABLE IF EXISTS `setting_sms`;

CREATE TABLE `setting_sms` (
  `autoreply_text` varchar(160) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `setting_sms` (`autoreply_text`) VALUES ('Terima kasih pesan Anda telah kami terima.');


#
# TABLE STRUCTURE FOR: suplemen
#

DROP TABLE IF EXISTS `suplemen`;

CREATE TABLE `suplemen` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) DEFAULT NULL,
  `sasaran` tinyint(4) DEFAULT NULL,
  `keterangan` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: surat_keluar
#

DROP TABLE IF EXISTS `surat_keluar`;

CREATE TABLE `surat_keluar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nomor_urut` smallint(5) DEFAULT NULL,
  `nomor_surat` varchar(35) DEFAULT NULL,
  `kode_surat` varchar(10) DEFAULT NULL,
  `tanggal_surat` date NOT NULL,
  `tanggal_catat` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tujuan` varchar(100) DEFAULT NULL,
  `isi_singkat` varchar(200) DEFAULT NULL,
  `berkas_scan` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: surat_masuk
#

DROP TABLE IF EXISTS `surat_masuk`;

CREATE TABLE `surat_masuk` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nomor_urut` smallint(5) DEFAULT NULL,
  `tanggal_penerimaan` date NOT NULL,
  `nomor_surat` varchar(35) DEFAULT NULL,
  `kode_surat` varchar(10) DEFAULT NULL,
  `tanggal_surat` date NOT NULL,
  `pengirim` varchar(100) DEFAULT NULL,
  `isi_singkat` varchar(200) DEFAULT NULL,
  `isi_disposisi` varchar(200) DEFAULT NULL,
  `berkas_scan` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: sys_traffic
#

DROP TABLE IF EXISTS `sys_traffic`;

CREATE TABLE `sys_traffic` (
  `Tanggal` date NOT NULL,
  `ipAddress` text NOT NULL,
  `Jumlah` int(10) NOT NULL,
  PRIMARY KEY (`Tanggal`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2014-11-15', '::1{}', 1);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2014-11-16', '::1{}', 1);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2014-11-18', '', 3);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2014-11-21', '', 3);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2014-11-26', '::1{}', 1);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2014-12-03', '127.0.0.1{}', 1);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2014-12-04', '', 3);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2014-12-05', '', 5);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2014-12-06', '127.0.0.1{}', 1);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2014-12-08', '127.0.0.1{}', 1);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2014-12-09', '127.0.0.1{}', 1);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2014-12-10', '', 3);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-05-25', '', 2);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-05-26', '', 4);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-05-27', '', 2);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-05-28', '10.0.2.2{}', 1);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-05-29', '', 2);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-05-30', '10.0.2.2{}', 1);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-05-31', '', 3);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-06-01', '10.0.2.2{}', 1);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-08-23', '', 6);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-08-24', '', 7);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-08-26', '', 8);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-08-27', '192.168.1.66{}', 1);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-08-28', '', 3);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-08-29', '', 2);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-08-30', '', 3);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-08-31', '127.0.0.1{}', 1);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-09-02', '', 4);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-09-03', '', 2);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-09-04', '10.0.2.2{}', 1);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-09-05', '', 2);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-09-07', '', 2);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-09-08', '10.0.2.2{}', 1);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-09-09', '', 4);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-09-10', '', 4);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-09-11', '', 2);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-09-14', '', 4);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2016-12-02', '::1{}', 55);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2017-07-16', '10.0.2.2{}', 1);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2017-12-02', '::1{}', 61);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2018-05-28', '', 3);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2018-05-29', '10.0.2.2{}', 1);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2018-11-30', '192.168.33.1{}', 1);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2018-12-02', '::1{}', 79);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2019-01-02', '::1{}', 88);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2019-06-01', '::1{}', 76);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2019-12-01', '::1{}', 71);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-01-01', '::1{}', 102);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-01-08', '::1{}', 177);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-01-15', '::1{}', 154);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-01-31', '::1{}', 120);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-02', '::1{}', 67);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-03', '::1{}', 98);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-04', '::1{}', 201);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-05', '::1{}', 187);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-06', '::1{}', 177);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-07', '::1{}', 156);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-08', '::1{}', 145);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-09', '::1{}', 176);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-10', '::1{}', 101);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-11', '::1{}', 120);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-12', '::1{}', 123);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-13', '::1{}', 112);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-14', '::1{}', 113);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-15', '::1{}', 145);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-16', '::1{}', 122);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-17', '::1{}', 100);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-18', '::1{}', 237);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-19', '::1{}', 242);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-20', '::1{}', 210);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-21', '::1{}', 209);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-22', '::1{}', 201);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-23', '::1{}', 206);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-24', '::1{}', 190);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-25', '::1{}', 191);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-26', '::1{}', 154);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-27', '::1{}', 131);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-28', '::1{}', 98);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-02-29', '::1{}', 91);
INSERT INTO `sys_traffic` (`Tanggal`, `ipAddress`, `Jumlah`) VALUES ('2020-11-29', '::1{}', 1);


#
# TABLE STRUCTURE FOR: teks_berjalan
#

DROP TABLE IF EXISTS `teks_berjalan`;

CREATE TABLE `teks_berjalan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `teks` text,
  `urut` int(5) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int(11) NOT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_by` int(11) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  `tautan` varchar(150) DEFAULT NULL,
  `judul_tautan` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `teks_berjalan` (`id`, `teks`, `urut`, `created_at`, `created_by`, `updated_at`, `updated_by`, `status`, `tautan`, `judul_tautan`) VALUES (1, 'Ini contoh teks berjalan. Isi dengan tulisan yang menampilkan suatu ciri atau kegiatan penting di desa anda.', NULL, '2019-05-28 22:45:28', 1, '2019-05-28 22:45:28', NULL, 1, NULL, NULL);


#
# TABLE STRUCTURE FOR: tweb_aset
#

DROP TABLE IF EXISTS `tweb_aset`;

CREATE TABLE `tweb_aset` (
  `id_aset` int(11) NOT NULL,
  `golongan` varchar(11) NOT NULL,
  `bidang` varchar(11) NOT NULL,
  `kelompok` varchar(11) NOT NULL,
  `sub_kelompok` varchar(11) NOT NULL,
  `sub_sub_kelompok` varchar(11) NOT NULL,
  `nama` varchar(255) NOT NULL,
  PRIMARY KEY (`id_aset`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `tweb_aset` (`id_aset`, `golongan`, `bidang`, `kelompok`, `sub_kelompok`, `sub_sub_kelompok`, `nama`) VALUES (1, '1', '00', '00', '00', '000', 'TANAH');
INSERT INTO `tweb_aset` (`id_aset`, `golongan`, `bidang`, `kelompok`, `sub_kelompok`, `sub_sub_kelompok`, `nama`) VALUES (2, '1', '01', '00', '00', '000', 'TANAH DESA');
INSERT INTO `tweb_aset` (`id_aset`, `golongan`, `bidang`, `kelompok`, `sub_kelompok`, `sub_sub_kelompok`, `nama`) VALUES (3, '1', '01', '01', '00', '000', 'TANAH KAS DESA');
INSERT INTO `tweb_aset` (`id_aset`, `golongan`, `bidang`, `kelompok`, `sub_kelompok`, `sub_sub_kelompok`, `nama`) VALUES (4, '1', '01', '01', '01', '000', 'TANAH BENGKOK');
INSERT INTO `tweb_aset` (`id_aset`, `golongan`, `bidang`, `kelompok`, `sub_kelompok`, `sub_sub_kelompok`, `nama`) VALUES (5, '1', '01', '01', '01', '001', 'TANAH BENGKOK KEPALA DESA');
INSERT INTO `tweb_aset` (`id_aset`, `golongan`, `bidang`, `kelompok`, `sub_kelompok`, `sub_sub_kelompok`, `nama`) VALUES (6, '1', '01', '01', '01', '999', 'TANAH BENGKOK LAINNYA');
INSERT INTO `tweb_aset` (`id_aset`, `golongan`, `bidang`, `kelompok`, `sub_kelompok`, `sub_sub_kelompok`, `nama`) VALUES (7, '1', '01', '01', '02', '000', 'TANAH BONDO');
INSERT INTO `tweb_aset` (`id_aset`, `golongan`, `bidang`, `kelompok`, `sub_kelompok`, `sub_sub_kelompok`, `nama`) VALUES (8, '1', '01', '01', '03', '000', 'TANAH KALAKERAN NEGERI');
INSERT INTO `tweb_aset` (`id_aset`, `golongan`, `bidang`, `kelompok`, `sub_kelompok`, `sub_sub_kelompok`, `nama`) VALUES (9, '1', '01', '01', '04', '000', 'TANAH PECATU');
INSERT INTO `tweb_aset` (`id_aset`, `golongan`, `bidang`, `kelompok`, `sub_kelompok`, `sub_sub_kelompok`, `nama`) VALUES (10, '1', '01', '01', '05', '000', 'TANAH PENGAREM-AREM');
INSERT INTO `tweb_aset` (`id_aset`, `golongan`, `bidang`, `kelompok`, `sub_kelompok`, `sub_sub_kelompok`, `nama`) VALUES (11, '1', '01', '01', '06', '000', 'TANAH TITISARA');
INSERT INTO `tweb_aset` (`id_aset`, `golongan`, `bidang`, `kelompok`, `sub_kelompok`, `sub_sub_kelompok`, `nama`) VALUES (12, '1', '01', '02', '0